/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.service.impl;

import com.els.base.common.OrderCommandInvoker;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.plan.dao.DeliveryPlanMapper;
import com.els.base.plan.entity.DeliveryPlan;
import com.els.base.plan.entity.DeliveryPlanExample;
import com.els.base.plan.service.DeliveryPlanService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultDeliveryPlanService")
public class DeliveryPlanServiceImpl
implements DeliveryPlanService {
    @Resource
    protected DeliveryPlanMapper deliveryPlanMapper;
    @Resource
    private OrderCommandInvoker invoker;

    @CacheEvict(value={"deliveryPlan"}, allEntries=true)
    public void addObj(DeliveryPlan t) {
        this.deliveryPlanMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"deliveryPlan"}, allEntries=true)
    public void addAll(List<DeliveryPlan> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.deliveryPlanMapper.insertBatch(list);
    }

    @CacheEvict(value={"deliveryPlan"}, allEntries=true)
    public void deleteObjById(String id) {
        this.deliveryPlanMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"deliveryPlan"}, allEntries=true)
    public void modifyObj(DeliveryPlan t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.deliveryPlanMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"deliveryPlan"}, keyGenerator="redisKeyGenerator")
    public DeliveryPlan queryObjById(String id) {
        return this.deliveryPlanMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"deliveryPlan"}, keyGenerator="redisKeyGenerator")
    public List<DeliveryPlan> queryAllObjByExample(DeliveryPlanExample example) {
        return this.deliveryPlanMapper.selectByExample(example);
    }

    @Cacheable(value={"deliveryPlan"}, keyGenerator="redisKeyGenerator")
    public PageView<DeliveryPlan> queryObjByPage(DeliveryPlanExample example) {
        PageView<DeliveryPlan> pageView = example.getPageView();
        pageView.setQueryResult(this.deliveryPlanMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"deliveryPlan"}, allEntries=true)
    public void modifyByExample(DeliveryPlan plan, DeliveryPlanExample deliveryPlanExample) {
        this.deliveryPlanMapper.updateByExampleSelective(plan, deliveryPlanExample);
    }

    @Override
    public boolean isHasLockPlan(String factoryCode) {
        DeliveryPlanExample example = new DeliveryPlanExample();
        example.createCriteria().andFactoryCodeEqualTo(factoryCode).andIsLockEqualTo("F").andIsEnableEqualTo(Constant.YES_INT);
        List<DeliveryPlan> lists = this.deliveryPlanMapper.selectByExample(example);
        return lists.size() > 0;
    }

    @Override
    @CacheEvict(value={"deliveryPlan"}, allEntries=true)
    public PageView<DeliveryPlan> queryPlanAndItemByPage(DeliveryPlanExample example) {
        PageView<DeliveryPlan> pageView = example.getPageView();
        pageView.setQueryResult(this.deliveryPlanMapper.selectPlanAndItemByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"deliveryPlan"}, allEntries=true)
    public PageView<DeliveryPlan> queryAllPlanAndItem(DeliveryPlanExample example) {
        PageView<DeliveryPlan> pageView = example.getPageView();
        pageView.setQueryResult(this.deliveryPlanMapper.selectAllPlanAndItemByExample(example));
        return pageView;
    }

    @Override
    public void getDeliveryPlan() {
    }

    @Override
    public boolean isCanDistribute(String planId) {
        DeliveryPlanExample example = new DeliveryPlanExample();
        example.createCriteria().andIdEqualTo(planId);
        List<DeliveryPlan> lists = this.deliveryPlanMapper.selectAllPlanAndItemByExample(example);
        Assert.isNotEmpty(lists, (String)"\u4e0d\u5b58\u5728\u4ea4\u8d27\u8ba1\u5212");
        lists.stream().filter(deliveryPlan -> deliveryPlan.getDeliveryQuantity() != null);
        if (lists.size() == 0) {
            return true;
        }
        if (Constant.NO_INT.equals(lists.get(0).getStatus())) {
            return true;
        }
        BigDecimal quantityTotal = lists.stream().map(deliveryPlan -> deliveryPlan.getDeliveryQuantity()).reduce((x, y) -> x.add((BigDecimal)y)).get();
        return quantityTotal.compareTo(lists.get(0).getConsumeMunber()) < 0;
    }

    @CacheEvict(value={"deliveryPlan"}, allEntries=true)
    public void deleteByExample(DeliveryPlanExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.deliveryPlanMapper.deleteByExample(example);
    }
}

