/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.product.command;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.material.utils.ApproveStatusEnum;
import com.els.base.product.entity.PurchaseProduct;
import com.els.base.product.service.PurchaseProductService;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.comix.entity.QixinBaseGoodsInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class QixinToProductCmd
extends BaseCommand<String> {
    private GenerateCodeService generateCodeService = (GenerateCodeService)SpringContextHolder.getOneBean(GenerateCodeService.class);
    private PurchaseProductService purchaseProductService = (PurchaseProductService)SpringContextHolder.getOneBean(PurchaseProductService.class);
    List<QixinBaseGoodsInfo> qixinBaseGoodsInfoList;

    public QixinToProductCmd(List<QixinBaseGoodsInfo> qixinBaseGoodsInfoList) {
        this.qixinBaseGoodsInfoList = qixinBaseGoodsInfoList;
    }

    public List<QixinBaseGoodsInfo> getQixinBaseGoodsInfoList() {
        return this.qixinBaseGoodsInfoList;
    }

    public void setQixinBaseGoodsInfoList(List<QixinBaseGoodsInfo> qixinBaseGoodsInfoList) {
        this.qixinBaseGoodsInfoList = qixinBaseGoodsInfoList;
    }

    public String execute(ICommandInvoker iCommandInvoker) {
        this.check(this.qixinBaseGoodsInfoList);
        this.fill(this.qixinBaseGoodsInfoList);
        this.process(this.qixinBaseGoodsInfoList);
        return null;
    }

    private void process(List<QixinBaseGoodsInfo> qixinBaseGoodsInfoList) {
        ArrayList<PurchaseProduct> purchaseProducts = new ArrayList<PurchaseProduct>();
        for (QixinBaseGoodsInfo qixinBaseGoodsInfo : qixinBaseGoodsInfoList) {
            PurchaseProduct purchaseProduct = new PurchaseProduct();
            purchaseProduct.setProductImageList(Lists.newArrayList());
            purchaseProduct.setId(UUIDGenerator.generateUUID());
            purchaseProduct.setProductName(qixinBaseGoodsInfo.getProductName());
            purchaseProduct.setProductCode(qixinBaseGoodsInfo.getProductNo());
            purchaseProduct.setProductSummary(qixinBaseGoodsInfo.getProductName());
            purchaseProduct.setProductDesc(qixinBaseGoodsInfo.getProductName());
            purchaseProduct.setProductImage(qixinBaseGoodsInfo.getImagePath());
            purchaseProduct.setProductOrder(0);
            purchaseProduct.setProductPrice(qixinBaseGoodsInfo.getNakedPrice());
            purchaseProduct.setProductOriginPrice(qixinBaseGoodsInfo.getUnitPrice());
            purchaseProduct.setBasicUnit(qixinBaseGoodsInfo.getSaleUnit());
            purchaseProduct.setBrandName(qixinBaseGoodsInfo.getBrand());
            purchaseProduct.setProductStock(qixinBaseGoodsInfo.getStore());
            purchaseProduct.setCreateTime(new Date());
            purchaseProduct.setUpdateTime(new Date());
            purchaseProduct.setApproveStatus(ApproveStatusEnum.APPROVE_PASS.getValue());
            purchaseProduct.setPublicStatus(Constant.YES_INT);
            purchaseProduct.setPutwayStatus(Constant.NO_INT);
            purchaseProduct.setPutwayTime(new Date());
            purchaseProduct.setPublicTime(new Date());
            purchaseProducts.add(purchaseProduct);
        }
        this.purchaseProductService.addAll(purchaseProducts);
    }

    private void fill(List<QixinBaseGoodsInfo> qixinBaseGoodsInfoList) {
    }

    private void check(List<QixinBaseGoodsInfo> qixinBaseGoodsInfoList) {
        if (CollectionUtils.isEmpty(qixinBaseGoodsInfoList)) {
            throw new CommonException("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5546\u54c1");
        }
    }
}

