/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.product.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.catalogue.entity.PurchaseCatalogueHead;
import com.els.base.catalogue.entity.PurchaseCatalogueHeadExample;
import com.els.base.catalogue.entity.PurchaseCatalogueItem;
import com.els.base.catalogue.entity.PurchaseCatalogueItemExample;
import com.els.base.catalogue.service.PurchaseCatalogueHeadService;
import com.els.base.catalogue.service.PurchaseCatalogueItemService;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.material.entity.MaterialCategory;
import com.els.base.material.service.MaterialCategoryService;
import com.els.base.material.utils.ApproveStatusEnum;
import com.els.base.product.command.ProductApproveCmd;
import com.els.base.product.command.QixinToProductCmd;
import com.els.base.product.entity.PurchaseProduct;
import com.els.base.product.entity.PurchaseProductCatalog;
import com.els.base.product.entity.PurchaseProductCatalogExample;
import com.els.base.product.entity.PurchaseProductExample;
import com.els.base.product.entity.PurchaseProductImage;
import com.els.base.product.entity.PurchaseProductImageExample;
import com.els.base.product.service.PurchaseProductCatalogService;
import com.els.base.product.service.PurchaseProductImageService;
import com.els.base.product.service.PurchaseProductService;
import com.els.base.product.vo.AssignProduct;
import com.els.base.product.vo.ProductOriginEnum;
import com.els.base.product.vo.ProductVO;
import com.els.base.product.vo.PutwayVO;
import com.els.comix.entity.QixinBaseGoodsInfoExample;
import com.els.comix.service.QixinBaseGoodsInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u5546\u54c1\u7ba1\u7406"})
@Controller
@RequestMapping(value={"purchaseProduct"})
public class PurchaseProductController {
    @Resource
    protected PurchaseProductService purchaseProductService;
    @Resource
    protected ICommandInvoker invoker;
    @Resource
    protected GenerateCodeService generateCodeService;
    @Resource
    protected PurchaseCatalogueHeadService purchaseCatalogueHeadService;
    @Resource
    protected PurchaseProductCatalogService purchaseProductCatalogService;
    @Resource
    protected PurchaseCatalogueItemService purchaseCatalogueItemService;
    @Resource
    protected PurchaseProductImageService purchaseProductImageService;
    @Resource
    protected QixinBaseGoodsInfoService qixinBaseGoodsInfoService;
    @Resource
    protected MaterialCategoryService materialCategoryService;

    @ApiOperation(httpMethod="POST", value="\u7ed9\u7269\u6599\u6307\u5b9a\u7269\u6599\u5206\u7c7b")
    @RequestMapping(value={"service/assign"})
    @ResponseBody
    public ResponseResult<String> assign(@RequestBody(required=true) AssignProduct assignProduct) {
        String categoryId = assignProduct.getCategoryId();
        List<String> productIds = assignProduct.getProductIds();
        Assert.isNotBlank((String)categoryId, (String)"\u8bf7\u6307\u5b9a\u5206\u7c7b\uff01");
        Assert.isNotEmpty(productIds, (String)"\u8bf7\u6307\u5b9a\u4ea7\u54c1\uff01");
        MaterialCategory materialCategory = (MaterialCategory)this.materialCategoryService.queryObjById((Object)categoryId);
        Assert.isNotNull((Object)materialCategory, (String)"\u7269\u6599\u5206\u7c7b\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        PurchaseProduct product = new PurchaseProduct();
        product.setProductCategoryId(categoryId);
        product.setProductCategoryCode(materialCategory.getCategoryCode());
        product.setProductCategoryName(materialCategory.getCategoryName());
        PurchaseProductExample example = new PurchaseProductExample();
        example.createCriteria().andIdIn((List)productIds);
        this.purchaseProductService.updateByExampleSelective(product, example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u63d0\u4ea4\u5546\u54c1\u5ba1\u6279")
    @RequestMapping(value={"service/qixinToProduct"})
    @ResponseBody
    public ResponseResult<String> qixinToProduct(@RequestBody List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u8bf7\u9009\u62e9\u5bf9\u5e94\u7684\u5546\u54c1\uff0c\u8bf7\u68c0\u67e5\uff01");
        QixinBaseGoodsInfoExample example = new QixinBaseGoodsInfoExample();
        example.createCriteria().andIdIn(ids);
        List qixinBaseGoodsInfos = this.qixinBaseGoodsInfoService.queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)qixinBaseGoodsInfos, (String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5546\u54c1\uff0c\u8bf7\u68c0\u67e5\uff01");
        QixinToProductCmd cmd = new QixinToProductCmd(qixinBaseGoodsInfos);
        this.invoker.invoke((BaseCommand)cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u63d0\u4ea4\u5546\u54c1\u5ba1\u6279")
    @RequestMapping(value={"service/approves"})
    @ResponseBody
    public ResponseResult<String> approve(@RequestBody List<PurchaseProduct> purchaseProducts) {
        ProductApproveCmd cmd = new ProductApproveCmd();
        cmd.setPurchaseProducts(purchaseProducts);
        this.invoker.invoke((BaseCommand)cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u63d0\u4ea4\u5546\u54c1\u5ba1\u6279")
    @RequestMapping(value={"service/approve"})
    @ResponseBody
    public ResponseResult<String> approve(@RequestBody PurchaseProduct purchaseProduct) {
        ArrayList<PurchaseProduct> purchaseProducts = new ArrayList<PurchaseProduct>();
        purchaseProducts.add(purchaseProduct);
        ProductApproveCmd cmd = new ProductApproveCmd();
        cmd.setPurchaseProducts(purchaseProducts);
        this.invoker.invoke((BaseCommand)cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u53d1\u5e03\u5546\u54c1")
    @RequestMapping(value={"service/publicProduct"})
    @ResponseBody
    public ResponseResult<String> publicProduct(@RequestBody ProductVO productVO) {
        Assert.isNotNull((Object)productVO, (String)"\u53d1\u5e03\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Integer publicStarus = productVO.getPublicStatus();
        List<String> ids = productVO.getIds();
        Assert.isNotNull((Object)publicStarus, (String)"\u53d1\u5e03\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotEmpty(ids, (String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5546\u54c1\uff01");
        PurchaseProductExample example = new PurchaseProductExample();
        example.createCriteria().andIdIn((List)ids);
        PurchaseProduct purchaseProduct = new PurchaseProduct();
        purchaseProduct.setPublicStatus(productVO.getPublicStatus());
        purchaseProduct.setPublicTime(new Date());
        this.purchaseProductService.updateByExampleSelective(purchaseProduct, example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4e0a,\u4e0b\u67b6\u4f9b\u5e94\u5546\u4ea7\u54c1")
    @RequestMapping(value={"service/putway"})
    @ResponseBody
    public ResponseResult<String> putway(@RequestBody PutwayVO putwayVO) {
        Assert.isNotNull((Object)putwayVO, (String)"\u4e0a\u4e0b\u67b6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Integer putwayStarus = putwayVO.getPutwayStarus();
        List<String> ids = putwayVO.getIds();
        Assert.isNotNull((Object)putwayStarus, (String)"\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotEmpty(ids, (String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5546\u54c1\u4e0a\u67b6\u6216\u8005\u4e0b\u67b6\uff01");
        PurchaseProductExample example = new PurchaseProductExample();
        example.createCriteria().andIdIn((List)ids);
        PurchaseProduct purchaseProduct = new PurchaseProduct();
        purchaseProduct.setPutwayStatus(putwayVO.getPutwayStarus());
        purchaseProduct.setPutwayTime(new Date());
        this.purchaseProductService.updateByExampleSelective(purchaseProduct, example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u521b\u5efa\u5546\u54c1")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody PurchaseProduct purchaseProduct) {
        String nextCode = this.generateCodeService.getNextCode("PURCHASE_PRODUCT");
        purchaseProduct.setCreateTime(new Date());
        purchaseProduct.setProductCode(nextCode);
        purchaseProduct.setPutwayStatus(Constant.NO_INT);
        purchaseProduct.setApproveStatus(ApproveStatusEnum.NEW.getValue());
        purchaseProduct.setPublicStatus(Constant.NO_INT);
        purchaseProduct.setCreateUserId(SpringSecurityUtils.getLoginUserId());
        purchaseProduct.setCreateUserName(SpringSecurityUtils.getLoginUserName());
        Company company = CompanyUtils.currentCompany();
        purchaseProduct.setSupCompanyId(company.getId());
        purchaseProduct.setSupCompanyCode(company.getCompanyCode());
        purchaseProduct.setSupCompanyName(company.getCompanyFullName());
        purchaseProduct.setProductOrigin(ProductOriginEnum.SUP.getValue());
        if (purchaseProduct.getProductStock() == null) {
            purchaseProduct.setProductStock(BigDecimal.ZERO);
        }
        this.purchaseProductService.addObj(purchaseProduct);
        List<PurchaseProductImage> productImageList = purchaseProduct.getProductImageList();
        if (CollectionUtils.isNotEmpty(productImageList)) {
            for (PurchaseProductImage purchaseProductImage : productImageList) {
                purchaseProductImage.setCreateTime(new Date());
                purchaseProductImage.setProductId(purchaseProduct.getId());
            }
            this.purchaseProductImageService.addAll(productImageList);
        }
        return ResponseResult.success((Object)purchaseProduct.getId());
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u5546\u54c1\u8be6\u60c5")
    @RequestMapping(value={"service/findById"})
    @ResponseBody
    public ResponseResult<PurchaseProduct> findById(@RequestParam String id) {
        Assert.isNotBlank((String)id, (String)"id \u4e3a\u7a7a\uff0c\u67e5\u8be2\u5931\u8d25");
        PurchaseProduct purchaseProduct = (PurchaseProduct)this.purchaseProductService.queryObjById(id);
        PurchaseProductImageExample example = new PurchaseProductImageExample();
        example.createCriteria().andProductIdEqualTo(purchaseProduct.getId());
        List purchaseProductImages = this.purchaseProductImageService.queryAllObjByExample((IExample)example);
        purchaseProduct.setProductImageList(purchaseProductImages);
        return ResponseResult.success((Object)purchaseProduct);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u6dfb\u52a0\u5546\u54c1\u5e93\u5b58", notes="\u4f9b\u5e94\u5546\u6dfb\u52a0\u5546\u54c1\u5e93\u5b58\uff0c\u53ea\u6dfb\u52a0\u5e93\u5b58\uff0c\u5176\u4ed6\u4fe1\u606f\u4e0d\u6539\u53d8")
    @RequestMapping(value={"service/inventory/edit"})
    @ResponseBody
    public ResponseResult<String> editForInventory(@RequestBody PurchaseProduct purchaseProduct) {
        Assert.isNotBlank((String)purchaseProduct.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        BigDecimal productStock = purchaseProduct.getProductStock();
        Assert.isNotNull((Object)productStock, (String)"\u5e93\u5b58\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        double v = productStock.doubleValue();
        if (v <= 0.0) {
            throw new CommonException("\u5e93\u5b58\u4e0d\u80fd\u4e3a\u8d1f\u6570\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        PurchaseProduct old = (PurchaseProduct)this.purchaseProductService.queryObjById(purchaseProduct.getId());
        BigDecimal productStock1 = purchaseProduct.getProductStock();
        BigDecimal productStock2 = old.getProductStock();
        BigDecimal newProductStock = productStock1.add(productStock2);
        old.setProductStock(newProductStock);
        this.purchaseProductService.modifyObj(old);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u7f16\u8f91\u5546\u54c1")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody PurchaseProduct purchaseProduct) {
        Assert.isNotBlank((String)purchaseProduct.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        purchaseProduct.setUpdateTime(new Date());
        purchaseProduct.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
        purchaseProduct.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
        Company company = CompanyUtils.currentCompany();
        purchaseProduct.setSupCompanyId(company.getId());
        purchaseProduct.setSupCompanyCode(company.getCompanyCode());
        purchaseProduct.setSupCompanyName(company.getCompanyName());
        this.purchaseProductService.modifyObj(purchaseProduct);
        PurchaseProductImageExample example = new PurchaseProductImageExample();
        example.createCriteria().andProductIdEqualTo(purchaseProduct.getId());
        this.purchaseProductImageService.deleteByExample((IExample)example);
        List<PurchaseProductImage> productImageList = purchaseProduct.getProductImageList();
        if (CollectionUtils.isNotEmpty(productImageList)) {
            for (PurchaseProductImage purchaseProductImage : productImageList) {
                purchaseProductImage.setCreateTime(new Date());
                purchaseProductImage.setProductId(purchaseProduct.getId());
            }
            this.purchaseProductImageService.addAll(productImageList);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u5546\u54c1")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        PurchaseProductExample example = new PurchaseProductExample();
        example.createCriteria().andIdIn((List)ids);
        this.purchaseProductService.deleteByExample((IExample)example);
        PurchaseProductImageExample example1 = new PurchaseProductImageExample();
        example1.createCriteria().andProductIdIn((List)ids);
        this.purchaseProductImageService.deleteByExample((IExample)example1);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u8d85\u7ea7\u7ba1\u7406\u5458\u67e5\u8be2\u5206\u9875\u4f9b\u5e94\u5546\u4ea7\u54c1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseProduct", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseProduct>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PurchaseProductExample example = new PurchaseProductExample();
        example.setPageView((PageView<PurchaseProduct>)new PageView(pageNo, pageSize));
        PurchaseProductExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.purchaseProductService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u5546\u54c1\u76ee\u5f55\u5c97\u4f4d\u67e5\u8be2\u4f9b\u5e94\u5546\u4ea7\u54c1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseProduct", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/pur/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseProduct>> findByPageForPur(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PurchaseProductExample example = new PurchaseProductExample();
        example.setPageView((PageView<PurchaseProduct>)new PageView(pageNo, pageSize));
        PurchaseProductExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        criteria.andPublicStatusEqualTo(Constant.YES_INT);
        PageView pageData = this.purchaseProductService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u67e5\u8be2\u5546\u54c1\u9875\u9762")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseProduct", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/sup/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseProduct>> findByPageForSup(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PurchaseProductExample example = new PurchaseProductExample();
        example.setPageView((PageView<PurchaseProduct>)new PageView(pageNo, pageSize));
        example.setOrderByClause("PRODUCT_ORDER ASC,CREATE_TIME DESC");
        PurchaseProductExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        criteria.andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        PageView pageData = this.purchaseProductService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5168\u90e8\u4f9b\u5e94\u5546\u4ea7\u54c1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseProduct", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findAll"})
    @ResponseBody
    public ResponseResult<List<PurchaseProduct>> findAll(@RequestBody(required=false) QueryParamWapper wapper) {
        PurchaseProductExample example = new PurchaseProductExample();
        PurchaseProductExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        List pageData = this.purchaseProductService.queryAllObjByExample((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u767b\u9646\u4eba\u67e5\u8be2\u5230\uff0c\u5df2\u53d1\u5e03\uff0c\u5ba1\u6279\u901a\u8fc7\uff0c\u5df2\u4e0a\u67b6\u7684\u5546\u54c1\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseProduct", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/user/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseProduct>> findByUser(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PurchaseProductExample example = new PurchaseProductExample();
        example.setPageView((PageView<PurchaseProduct>)new PageView(pageNo, pageSize));
        PurchaseProductExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        criteria.andPublicStatusEqualTo(Constant.YES_INT);
        criteria.andApproveStatusEqualTo(ApproveStatusEnum.APPROVE_PASS.getValue());
        criteria.andPutwayStatusEqualTo(Constant.YES_INT);
        PageView pageData = this.purchaseProductService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u767b\u9646\u4eba\u67e5\u8be2\u5bf9\u5e94\u7684\u91c7\u8d2d\u76ee\u5f55\u80fd\u8d2d\u4e70\u5230\u7684\u5546\u54c1\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseProduct", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/user/findByProductCatalog"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseProduct>> findByProductCatalog(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PurchaseProductExample example = new PurchaseProductExample();
        PurchaseProductExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        List list = CompanyUtils.getDepartmentIds(null);
        ArrayList ids = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return ResponseResult.success((Object)new PageView(pageNo, pageSize));
        }
        list.forEach(dto -> ids.addAll(dto.getIds()));
        PurchaseCatalogueItemExample purchaseCatalogueItemExample = new PurchaseCatalogueItemExample();
        purchaseCatalogueItemExample.createCriteria().andDepartIdIn((List)ids);
        List purchaseCatalogueItems = this.purchaseCatalogueItemService.queryAllObjByExample((IExample)purchaseCatalogueItemExample);
        if (CollectionUtils.isEmpty((Collection)purchaseCatalogueItems)) {
            return ResponseResult.success((Object)new PageView(pageNo, pageSize));
        }
        List collect = purchaseCatalogueItems.stream().map(PurchaseCatalogueItem::getCatalogId).collect(Collectors.toList());
        PurchaseCatalogueHeadExample example1 = new PurchaseCatalogueHeadExample();
        PurchaseCatalogueHeadExample.Criteria criteria1 = example1.createCriteria().andPurchaseCatalogStatusEqualTo(Constant.YES_INT);
        criteria1.andIdIn(collect);
        List purchaseCatalogueHeads = this.purchaseCatalogueHeadService.queryAllObjByExample((IExample)example1);
        if (CollectionUtils.isEmpty((Collection)purchaseCatalogueHeads)) {
            return ResponseResult.success((Object)new PageView(pageNo, pageSize));
        }
        List purchaseCatalogueHeadIds = purchaseCatalogueHeads.stream().map(PurchaseCatalogueHead::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(purchaseCatalogueHeadIds)) {
            return ResponseResult.success((Object)new PageView(pageNo, pageSize));
        }
        PurchaseProductCatalogExample purchaseProductCatalogExample = new PurchaseProductCatalogExample();
        purchaseProductCatalogExample.createCriteria().andPurchaseCatalogIdIn(purchaseCatalogueHeadIds);
        List purchaseProductCatalogs = this.purchaseProductCatalogService.queryAllObjByExample((IExample)purchaseProductCatalogExample);
        if (CollectionUtils.isEmpty((Collection)purchaseProductCatalogs)) {
            return ResponseResult.success((Object)new PageView(pageNo, pageSize));
        }
        List productIds = purchaseProductCatalogs.stream().map(PurchaseProductCatalog::getProductId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(productIds)) {
            return ResponseResult.success((Object)new PageView(pageNo, pageSize));
        }
        criteria.andIdIn(productIds);
        PageView pageData = this.purchaseProductService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }
}

