/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.product.web.controller;

import com.els.base.auth.service.RoleService;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.product.command.UserCartToPurchaseRequestCmd;
import com.els.base.product.entity.PurchaseProductCatalogExample;
import com.els.base.product.entity.PurchaseUserCart;
import com.els.base.product.entity.PurchaseUserCartExample;
import com.els.base.product.service.PurchaseProductCatalogService;
import com.els.base.product.service.PurchaseProductService;
import com.els.base.product.service.PurchaseUserCartService;
import com.els.base.product.vo.UserShoppingCartVO;
import com.els.base.utils.SpringContextHolder;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u8d2d\u7269\u8f66"})
@Controller
@RequestMapping(value={"purchaseUserCart"})
public class PurchaseUserCartController {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    protected PurchaseUserCartService purchaseUserCartService;
    @Resource
    protected PurchaseProductService purchaseProductService;
    @Resource
    protected PurchaseProductCatalogService purchaseProductCatalogService;
    @Resource
    protected ICommandInvoker invoker;
    private static final String PURCHASE_CATALOG_TYPE = "summary_at_the_same_level";

    @ApiOperation(httpMethod="POST", value="\u8d2d\u7269\u8f66\u5546\u54c1\u8f6c\u6210\u91c7\u8d2d\u7533\u8bf7\u5355")
    @RequestMapping(value={"service/purchase/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody List<PurchaseUserCart> purchaseUserCarts) {
        UserCartToPurchaseRequestCmd cmd = new UserCartToPurchaseRequestCmd(purchaseUserCarts);
        this.invoker.invoke((BaseCommand)cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8d2d\u7269\u8f66")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody PurchaseUserCart purchaseUserCart) {
        Assert.isNotNull((Object)purchaseUserCart, (String)"\u8d2d\u7269\u8f66\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank((String)purchaseUserCart.getProductId(), (String)"\u8d2d\u7269\u8f66\u4ea7\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotNull((Object)purchaseUserCart.getProductCount(), (String)"\u8d2d\u7269\u8f66\u4ea7\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        RoleService roleService = (RoleService)SpringContextHolder.getOneBean(RoleService.class);
        List ownRoles = roleService.queryUserOwnRoles(SpringSecurityUtils.getLoginUserId());
        if (CollectionUtils.isEmpty((Collection)ownRoles) || ownRoles.stream().noneMatch(role -> role.getRoleCode().equals("CGJBR"))) {
            PurchaseProductCatalogExample catalogExample = new PurchaseProductCatalogExample();
            catalogExample.createCriteria().andProductIdEqualTo(purchaseUserCart.getProductId()).andPurchaseCatalogTypeEqualTo(PURCHASE_CATALOG_TYPE);
            List catalogList = this.purchaseProductCatalogService.queryAllObjByExample((IExample)catalogExample);
            Assert.isNotEmpty((Collection)catalogList, (String)"\u60a8\u4e0d\u662f\u91c7\u8d2d\u7ecf\u529e\u4eba,\u6ca1\u6709\u64cd\u4f5c\u6743\u9650");
        }
        purchaseUserCart.setCreateTime(new Date());
        purchaseUserCart.setIsEnable(Constant.YES_INT.toString());
        purchaseUserCart.setCreateUserId(SpringSecurityUtils.getLoginUserId());
        purchaseUserCart.setCreateUserName(SpringSecurityUtils.getLoginUserName());
        PurchaseUserCartExample example = new PurchaseUserCartExample();
        example.createCriteria().andProductIdEqualTo(purchaseUserCart.getProductId());
        int i = this.purchaseUserCartService.countByExample(example);
        if (i > 0) {
            List purchaseUserCarts = this.purchaseUserCartService.queryAllObjByExample((IExample)example);
            PurchaseUserCart purchaseUserCart1 = (PurchaseUserCart)purchaseUserCarts.get(0);
            Assert.isNotNull((Object)purchaseUserCart1, (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
            purchaseUserCart1.setProductCount(purchaseUserCart.getProductCount());
            this.purchaseUserCartService.modifyObj(purchaseUserCart1);
        }
        this.purchaseUserCartService.addObj(purchaseUserCart);
        return ResponseResult.success((Object)purchaseUserCart.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8d2d\u7269\u8f66")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody PurchaseUserCart purchaseUserCart) {
        Assert.isNotBlank((String)purchaseUserCart.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        purchaseUserCart.setUpdateTime(new Date());
        purchaseUserCart.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
        purchaseUserCart.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
        this.purchaseUserCartService.modifyObj(purchaseUserCart);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u8d2d\u7269\u8f66")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        PurchaseUserCartExample example = new PurchaseUserCartExample();
        example.createCriteria().andIdIn((List)ids).andCreateUserIdEqualTo(SpringSecurityUtils.getLoginUserId());
        this.purchaseUserCartService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7528\u6237\u5206\u9875\u67e5\u8be2\u8d2d\u7269\u8f66")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseUserCart", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseUserCart>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PurchaseUserCartExample example = new PurchaseUserCartExample();
        example.setPageView((PageView<PurchaseUserCart>)new PageView(pageNo, pageSize));
        PurchaseUserCartExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        criteria.andCreateUserIdEqualTo(SpringSecurityUtils.getLoginUserId()).andIsEnableEqualTo("1");
        PageView pageData = this.purchaseUserCartService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u7528\u6237\u67e5\u8be2\u8d2d\u7269\u8f66\u5168\u90e8\u5546\u54c1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseUserCart", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findAll"})
    @ResponseBody
    public ResponseResult<List<PurchaseUserCart>> findAll(@RequestBody(required=false) QueryParamWapper wapper) {
        PurchaseUserCartExample example = new PurchaseUserCartExample();
        PurchaseUserCartExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        criteria.andCreateUserIdEqualTo(SpringSecurityUtils.getLoginUserId()).andIsEnableEqualTo("1");
        List pageData = this.purchaseUserCartService.queryAllObjByExample((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u67e5\u8be2\u8d2d\u7269\u8f66\u5168\u90e8\u5546\u54c1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseUserCart", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/pur/findAll"})
    @ResponseBody
    public ResponseResult<List<PurchaseUserCart>> findAllForPur(@RequestBody(required=false) QueryParamWapper wapper) {
        PurchaseUserCartExample example = new PurchaseUserCartExample();
        PurchaseUserCartExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        criteria.andIsEnableEqualTo("1");
        List pageData = this.purchaseUserCartService.queryAllObjByExample((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u6839\u636e\u4f9b\u5e94\u5546\u5206\u597d\u7ec4\u7684\u8d2d\u7269\u8f66")
    @ApiImplicitParams(value={@ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseUserCart", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findBySupAll"})
    @ResponseBody
    public ResponseResult<List<UserShoppingCartVO>> findBySupAll(@RequestBody(required=false) QueryParamWapper wapper) {
        ArrayList list = new ArrayList();
        PurchaseUserCartExample example = new PurchaseUserCartExample();
        PurchaseUserCartExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        criteria.andCreateUserIdEqualTo(SpringSecurityUtils.getLoginUserId()).andIsEnableEqualTo("1");
        List purchaseUserCartList = this.purchaseUserCartService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)purchaseUserCartList)) {
            Map<String, List<PurchaseUserCart>> detailsMap01 = purchaseUserCartList.stream().collect(Collectors.groupingBy(PurchaseUserCart::getSupCompanyId));
            this.logger.info(detailsMap01.toString());
            for (String s : detailsMap01.keySet()) {
                this.logger.info("\u5206\u7ec4\u540e\u7684\u6570\u636e\uff1a" + s);
            }
        }
        return ResponseResult.success(list);
    }
}

