/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.change;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.utils.Assert;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderChange;
import com.els.base.purchase.entity.PurchaseOrderChangeExample;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.utils.PurchaseOrderChangeUtils;
import com.els.base.purchase.utils.PurchaseOrderSendStatusEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class CreateChangeCmd
extends AbstractCommand<List<PurchaseOrderChange>> {
    private static final long serialVersionUID = 1L;
    private PurchaseOrder order;

    public CreateChangeCmd(PurchaseOrder order) {
        this.order = order;
    }

    @Override
    public List<PurchaseOrderChange> execute(ICommandInvoker context) {
        Assert.isNotNull((Object)this.order, (String)"\u8ba2\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.order.getId(), (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        if (PurchaseOrderSendStatusEnum.NOTSEND.getValue().equals(this.order.getOrderSendStatus())) {
            return null;
        }
        List<SupplierOrderItem> supItemList = ContextUtils.getSupplierOrderItemService().queryByOrderIdList(Arrays.asList(this.order.getId()));
        if (CollectionUtils.isEmpty(supItemList)) {
            return null;
        }
        List<PurchaseOrderItem> purItemList = this.order.getItems();
        List<PurchaseOrderChange> changeList = this.compare(purItemList, supItemList);
        changeList = this.filter(changeList);
        ContextUtils.getPurchaseOrderChangeService().addAll(changeList);
        return changeList;
    }

    private List<PurchaseOrderChange> filter(List<PurchaseOrderChange> changeList) {
        return changeList.stream().filter((? super T item) -> !"\u53d8\u66f4\u542b\u7a0e\u603b\u4ef7".equals(item.getChangeField()) && !"\u53d8\u66f4\u542b\u7a0e\u5355\u4ef7".equals(item.getChangeField()) && !"\u53d8\u66f4\u53d1\u8d27\u7269\u6599\u540d\u79f0".equals(item.getChangeField())).collect(Collectors.toList());
    }

    private void deleteChange(String orderId) {
        PurchaseOrderChangeExample example = new PurchaseOrderChangeExample();
        example.createCriteria().andOrderIdEqualTo(orderId);
        ContextUtils.getPurchaseOrderChangeService().deleteByExample(example);
    }

    private List<PurchaseOrderChange> compare(List<PurchaseOrderItem> purItemList, List<SupplierOrderItem> supItemList) {
        ArrayList<PurchaseOrderChange> changeList = new ArrayList();
        for (PurchaseOrderItem purItem : purItemList) {
            List<PurchaseOrderChange> otherChangs;
            SupplierOrderItem supItem = this.findSupItem(purItem, supItemList);
            if (supItem == null) {
                PurchaseOrderChange change2 = PurchaseOrderChangeUtils.buildChangeByNewItem(purItem);
                changeList.add(change2);
                continue;
            }
            List<PurchaseOrderChange> changeListForItem = PurchaseOrderChangeUtils.compareItemForMainProperty(purItem, supItem);
            if (CollectionUtils.isNotEmpty(changeListForItem)) {
                changeList.addAll(changeListForItem);
            }
            if (!CollectionUtils.isNotEmpty(otherChangs = PurchaseOrderChangeUtils.compareItemForOtherProperty(purItem, supItem))) continue;
            changeList.addAll(otherChangs);
        }
        if (CollectionUtils.isEmpty(changeList = changeList.stream().filter((? super T change) -> change != null).collect(Collectors.toList()))) {
            return changeList;
        }
        Date changeDate = new Date();
        changeList.forEach(change -> change.setCreateTime(changeDate));
        return changeList;
    }

    private SupplierOrderItem findSupItem(PurchaseOrderItem purItem, List<SupplierOrderItem> supItemList) {
        return supItemList.stream().filter((? super T supItem) -> supItem.getOrderNo().equals(purItem.getOrderNo()) && supItem.getOrderItemNo().equals(purItem.getOrderItemNo())).findAny().orElse(null);
    }
}

