/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.order.pur;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.purchase.command.order.pur.CreateOrderItemCommand;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderSendStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderUtils;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class CreateOrderCommand
extends AbstractCommand<PurchaseOrder> {
    private static final long serialVersionUID = 1L;
    private PurchaseOrder order;

    public CreateOrderCommand(PurchaseOrder order) {
        this.order = order;
    }

    @Override
    public PurchaseOrder execute(ICommandInvoker context) {
        this.valid(this.order);
        this.initOrder(this.order);
        for (PurchaseOrderItem item : this.order.getItems()) {
            Assert.isNotBlank((String)this.order.getId(), (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
            CreateOrderItemCommand createOrderItemCommand = new CreateOrderItemCommand(item, this.order);
            createOrderItemCommand.copyProperties(this);
            context.invoke(createOrderItemCommand);
        }
        ContextUtils.getPurchaseOrderService().addObj(this.order);
        return this.order;
    }

    private void valid(PurchaseOrder order) {
        Assert.isNotBlank((String)order.getOrderNo(), (String)"\u91c7\u8d2d\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)order.getPurCompanyId(), (String)"\u91c7\u8d2d\u65b9id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)order.getPurCompanySrmCode(), (String)"\u91c7\u8d2d\u65b9SRM\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)order.getPurCompanyName(), (String)"\u91c7\u8d2d\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)order.getPurUserId(), (String)"\u91c7\u8d2d\u5546\u5458ID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)order.getSupCompanyId(), (String)"\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)order.getSupCompanyName(), (String)"\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)order.getSupCompanySrmCode(), (String)"\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)order.getPurchaseApplyNo(), (String)"\u91c7\u8d2d\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(order.getItems(), (String)"\u91c7\u8d2d\u8ba2\u5355\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)order.getPurPlanerId(), (String)"\u8ba1\u5212\u5458Id\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void initOrder(PurchaseOrder purchaseOrder) {
        boolean isFree;
        boolean isReturn;
        purchaseOrder.setId(UUIDGenerator.generateUUID());
        purchaseOrder.setOrderStatus(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue());
        purchaseOrder.setOrderSendStatus(PurchaseOrderSendStatusEnum.NOTSEND.getValue());
        purchaseOrder.setCreateTime(new Date());
        if (purchaseOrder.getAuditStatus() == null) {
            purchaseOrder.setAuditStatus(Constant.YES_INT);
        }
        if (StringUtils.isBlank((String)purchaseOrder.getIsAudit())) {
            purchaseOrder.setIsAudit("Y");
        }
        if (purchaseOrder.getDeliveryStatus() == null) {
            purchaseOrder.setDeliveryStatus(PurchaseOrderUtils.isAllItemFinish(purchaseOrder.getItems()));
        }
        if (purchaseOrder.getIsEnable() == null) {
            purchaseOrder.setIsEnable(PurchaseOrderUtils.isAllItemEnable(purchaseOrder.getItems()));
        }
        if (isReturn = purchaseOrder.getItems().stream().anyMatch(item -> "Y".equals(item.getReturnFlag()))) {
            purchaseOrder.setReturnFlag("Y");
        }
        if (isFree = purchaseOrder.getItems().stream().anyMatch(item -> "Y".equals(item.getFreeFlag()))) {
            purchaseOrder.setFreeFlag("Y");
        }
    }
}

