/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.order.pur;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.purchase.command.change.CreateChangeCmd;
import com.els.base.purchase.command.order.pur.CreateOrderCommand;
import com.els.base.purchase.command.order.pur.CreateOrderItemCommand;
import com.els.base.purchase.command.order.pur.DeleteOrderCommand;
import com.els.base.purchase.command.order.pur.ModifyOrderItemCommand;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.utils.ChangeTypeEnum;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderSendStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ModifyOrderCommand
extends AbstractCommand<PurchaseOrder> {
    private static final long serialVersionUID = 1L;
    private PurchaseOrder order;
    private String cause = "";

    public ModifyOrderCommand(PurchaseOrder order) {
        this.order = order;
    }

    @Override
    public PurchaseOrder execute(ICommandInvoker context) {
        this.valid(this.order);
        if (!this.isSendToSupCompany(this.order)) {
            DeleteOrderCommand deleteCmd = new DeleteOrderCommand(this.order.getId());
            deleteCmd.copyProperties(this);
            context.invoke(deleteCmd);
            CreateOrderCommand createCmd = new CreateOrderCommand(this.order);
            createCmd.copyProperties(this);
            return context.invoke(createCmd);
        }
        PurchaseOrder newOrder = this.modify(this.order);
        this.createOrderChange(newOrder);
        return newOrder;
    }

    private void createOrderChange(PurchaseOrder newOrder) {
        CreateChangeCmd createChangeCmd = new CreateChangeCmd(newOrder);
        createChangeCmd.copyProperties(this);
        this.context.invoke(createChangeCmd);
    }

    private boolean isSendToSupCompany(PurchaseOrder order) {
        SupplierOrder supOrder = (SupplierOrder)ContextUtils.getSupplierOrderService().queryObjById(order.getId());
        return supOrder != null;
    }

    private PurchaseOrder modify(PurchaseOrder order) {
        List<PurchaseOrderItem> newItems = this.createOrModifyItem(order);
        order.setItems(newItems);
        this.modifyOrder(order);
        return this.order;
    }

    private List<PurchaseOrderItem> createOrModifyItem(PurchaseOrder order) {
        if (CollectionUtils.isEmpty(order.getItems())) {
            return null;
        }
        ArrayList<PurchaseOrderItem> newItems = new ArrayList<PurchaseOrderItem>(order.getItems().size());
        for (PurchaseOrderItem item : order.getItems()) {
            item.setOrderId(order.getId());
            this.initItemId(item, order);
            PurchaseOrderItem newItem = null;
            if (StringUtils.isBlank((String)item.getId())) {
                CreateOrderItemCommand cmd = new CreateOrderItemCommand(item, order);
                cmd.copyProperties(this);
                newItem = this.context.invoke(cmd);
                newItems.add(newItem);
                continue;
            }
            SupplierOrderItem supItem = (SupplierOrderItem)ContextUtils.getSupplierOrderItemService().queryObjById(item.getId());
            ModifyOrderItemCommand cmd = new ModifyOrderItemCommand(item, supItem);
            cmd.copyProperties(this);
            newItem = this.context.invoke(cmd);
            newItems.add(newItem);
        }
        return newItems;
    }

    private void valid(PurchaseOrder order) {
        Assert.isNotNull((Object)order, (String)"\u8ba2\u5355\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)order.getId(), (String)"\u8ba2\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)order.getOrderNo(), (String)"\u8ba2\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        if (CollectionUtils.isEmpty(order.getItems())) {
            return;
        }
        for (PurchaseOrderItem orderItem : order.getItems()) {
            this.validOrderItem(orderItem);
        }
    }

    private void modifyOrder(PurchaseOrder purchaseOrder) {
        boolean isChange = purchaseOrder.getItems().stream().anyMatch(item -> !ChangeTypeEnum.OLD_ITEM.getValue().equals(item.getHaveChange()));
        if (isChange) {
            purchaseOrder.setOrderStatus(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue());
            purchaseOrder.setOrderSendStatus(PurchaseOrderSendStatusEnum.UPDATE_NOTSEND.getValue());
        }
        if (purchaseOrder.getDeliveryStatus() == null) {
            purchaseOrder.setDeliveryStatus(PurchaseOrderUtils.isAllItemFinish(purchaseOrder.getItems()));
        }
        if (purchaseOrder.getIsEnable() == null) {
            purchaseOrder.setIsEnable(PurchaseOrderUtils.isAllItemEnable(purchaseOrder.getItems()));
        }
        ContextUtils.getPurchaseOrderService().modifyObj(this.order);
    }

    private void validOrderItem(PurchaseOrderItem orderItem) {
        Assert.isNotBlank((String)orderItem.getOrderNo(), (String)"\u91c7\u8d2d\u5355\u884c\u8ba2\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)orderItem.getOrderItemNo(), (String)"\u91c7\u8d2d\u5355\u884c\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)orderItem.getMaterialCode(), (String)"\u91c7\u8d2d\u5355\u884c\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)orderItem.getQuantity(), (String)"\u8ba2\u5355\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)orderItem.getIsEnable(), (String)"\u8ba2\u5355\u884c\u662f\u5426\u53ef\u7528\u7684\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void clearOrder(PurchaseOrder order) {
        order.setProjectId(null);
        order.setOrderNo(null);
        order.setPurCompanyId(null);
        order.setPurCompanySrmCode(null);
        order.setPurCompanySapCode(null);
        order.setPurCompanyName(null);
        order.setSupCompanyId(null);
        order.setSupCompanyName(null);
        order.setSupCompanySapCode(null);
    }

    private boolean initItemId(PurchaseOrderItem item, PurchaseOrder order) {
        if (StringUtils.isNotBlank((String)item.getId())) {
            PurchaseOrderItem tmpItem = (PurchaseOrderItem)ContextUtils.getPurchaseOrderItemService().queryObjById(item.getId());
            if (StringUtils.isBlank((String)tmpItem.getId()) || !tmpItem.getOrderId().equals(order.getId())) {
                throw new CommonException(String.format("\u8ba2\u5355\u884c\u6570\u636e\u5f02\u5e38\uff0c\u8ba2\u5355\u884c[%s]", item.getId()));
            }
            return true;
        }
        PurchaseOrderItem tmpItem = ContextUtils.getPurchaseOrderItemService().queryByOrderItemNo(order.getOrderNo(), item.getOrderItemNo());
        if (tmpItem == null) {
            return false;
        }
        item.setId(tmpItem.getId());
        return true;
    }

    public String getCause() {
        return this.cause;
    }

    public void setCause(String cause) {
        this.cause = cause;
    }
}

