/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.material.service.SupplierMaterialService;
import com.els.base.purchase.dao.PurchaseOrderItemMapper;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.base.purchase.service.PurchaseOrderItemService;
import com.els.base.purchase.utils.PurchaseOrderIsEnableEnum;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="purchaseOrderItemService")
public class PurchaseOrderItemServiceImpl
implements PurchaseOrderItemService {
    @Resource
    protected SupplierMaterialService supplierMaterialService;
    @Resource
    protected PurchaseOrderItemMapper purchaseOrderItemMapper;

    @CacheEvict(value={"purchaseOrderItem"}, allEntries=true)
    public void addObj(PurchaseOrderItem t) {
        this.purchaseOrderItemMapper.insertSelective(t);
    }

    @CacheEvict(value={"purchaseOrderItem"}, allEntries=true)
    public void deleteObjById(String id) {
        PurchaseOrderItem item = new PurchaseOrderItem();
        item.setId(id);
        item.setIsEnable(PurchaseOrderIsEnableEnum.DELETED.getValue());
        this.purchaseOrderItemMapper.updateByPrimaryKeySelective(item);
    }

    @CacheEvict(value={"purchaseOrderItem"}, allEntries=true)
    public void modifyObj(PurchaseOrderItem t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        t.setUpdateTime(new Date());
        this.purchaseOrderItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"purchaseOrderItem"}, keyGenerator="redisKeyGenerator")
    public PurchaseOrderItem queryObjById(String id) {
        return this.purchaseOrderItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"purchaseOrderItem"}, keyGenerator="redisKeyGenerator")
    public List<PurchaseOrderItem> queryAllObjByExample(PurchaseOrderItemExample example) {
        return this.purchaseOrderItemMapper.selectByExample(example);
    }

    @Cacheable(value={"purchaseOrderItem"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseOrderItem> queryObjByPage(PurchaseOrderItemExample example) {
        PageView<PurchaseOrderItem> pageView = example.getPageView();
        List<PurchaseOrderItem> items = this.purchaseOrderItemMapper.selectByExampleByPage(example);
        pageView.setQueryResult(items);
        return pageView;
    }

    @Override
    @Cacheable(value={"purchaseOrderItem"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseOrderItem> queryHisAllObjByExample(PurchaseOrderItemExample example) {
        PageView<PurchaseOrderItem> pageView = example.getPageView();
        pageView.setQueryResult(this.purchaseOrderItemMapper.selectHisByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"purchaseOrderItem"}, allEntries=true)
    public void deleteByOrderId(String orderId) {
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.createCriteria().andOrderIdEqualTo(orderId);
        this.purchaseOrderItemMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"purchaseOrderItem"}, allEntries=true)
    @Transactional
    public void insertHisByOrderId(String orderHisId, String orderId, String cause) {
        this.purchaseOrderItemMapper.insertHisByOrderId(orderHisId, orderId, cause);
    }

    @Override
    @CacheEvict(value={"purchaseOrderItem"}, allEntries=true)
    public void modifyByExample(PurchaseOrderItem record, PurchaseOrderItemExample example) {
        this.purchaseOrderItemMapper.updateByExampleSelective(record, example);
    }

    @Override
    @Cacheable(value={"purchaseOrderItem"}, keyGenerator="redisKeyGenerator")
    public List<PurchaseOrderItem> queryByOrderIdList(List<String> orderIdList) {
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.createCriteria().andOrderIdIn((List)orderIdList);
        example.setOrderByClause("ORDER_NO DESC, ORDER_ITEM_NO ASC");
        return this.purchaseOrderItemMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"purchaseOrderItem"}, keyGenerator="redisKeyGenerator")
    public PurchaseOrderItem queryByOrderItemNo(String orderNo, String orderItemNo) {
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.createCriteria().andOrderNoEqualTo(orderNo).andOrderItemNoEqualTo(orderItemNo);
        List<PurchaseOrderItem> list = this.queryAllObjByExample(example);
        if (list != null && list.size() > 1) {
            throw new CommonException("\u51fa\u73b0\u91cd\u590d\u8ba2\u5355\u53f7\u7684\u95ee\u9898");
        }
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @CacheEvict(value={"purchaseOrderItem"}, allEntries=true)
    public void deleteByExample(PurchaseOrderItemExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.purchaseOrderItemMapper.deleteByExample(example);
    }

    @CacheEvict(value={"purchaseOrderItem"}, allEntries=true)
    public void addAll(List<PurchaseOrderItem> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> record.setId(UUIDGenerator.generateUUID()));
        this.purchaseOrderItemMapper.insertBatch(list);
    }

    @Override
    @Cacheable(value={"purchaseOrderItem"}, keyGenerator="redisKeyGenerator")
    public List<Map<String, String>> queryCompanySapCodeByMaterialCode(PurchaseOrderItemExample example) {
        return this.purchaseOrderItemMapper.selectByExampleGroupBySupCompanySapCode(example);
    }
}

