/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.service.impl;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.common.OrderCommandInvoker;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.DepartmentService;
import com.els.base.company.web.vo.DepartmentExcelVO;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.material.entity.Material;
import com.els.base.material.service.MaterialService;
import com.els.base.plan.command.nonejit.pur.NoneJitPlanCreateCmd;
import com.els.base.purchase.command.order.RemindOfPurchaseOrderCmd;
import com.els.base.purchase.dao.PurchaseOrderMapper;
import com.els.base.purchase.entity.PurOrderItemExt;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderExample;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.base.purchase.service.PurOrderItemExtService;
import com.els.base.purchase.service.PurchaseOrderItemService;
import com.els.base.purchase.service.PurchaseOrderService;
import com.els.base.purchase.utils.ChangeTypeEnum;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderDeliveryStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderIsEnableEnum;
import com.els.base.purchase.utils.PurchaseOrderSendStatusEnum;
import com.els.base.utils.uuid.UUIDGenerator;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="purchaseOrderService")
public class PurchaseOrderServiceImpl
implements PurchaseOrderService {
    private static Logger logger = LoggerFactory.getLogger(PurchaseOrderServiceImpl.class);
    @Resource
    protected PurchaseOrderMapper purchaseOrderMapper;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected ThreadPoolTaskExecutor defaultThreadPool;
    @Resource
    protected OrderCommandInvoker invoker;
    @Resource
    protected PurchaseOrderItemService purchaseOrderItemService;
    @Resource
    protected PurOrderItemExtService purOrderItemExtService;
    @Resource
    protected GenerateCodeService generateCodeService;
    @Resource
    protected DepartmentService departmentService;
    @Resource
    protected MaterialService materialService;

    @Transactional
    @CacheEvict(value={"purchaseOrder", "purchaseOrderItem"}, allEntries=true)
    public void addObj(PurchaseOrder purchaseOrder) {
        this.purchaseOrderMapper.insertSelective(purchaseOrder);
    }

    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public void deleteObjById(String id) {
        this.purchaseOrderMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public void modifyObj(PurchaseOrder t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        this.purchaseOrderMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"purchaseOrder"}, keyGenerator="redisKeyGenerator")
    public PurchaseOrder queryObjById(String id) {
        return this.purchaseOrderMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"purchaseOrder"}, keyGenerator="redisKeyGenerator")
    public List<PurchaseOrder> queryAllObjByExample(PurchaseOrderExample example) {
        return this.purchaseOrderMapper.selectByExample(example);
    }

    @Cacheable(value={"purchaseOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseOrder> queryObjByPage(PurchaseOrderExample example) {
        PageView<PurchaseOrder> pageView = example.getPageView();
        List<PurchaseOrder> list = this.purchaseOrderMapper.selectByExampleByPage(example);
        for (PurchaseOrder purchaseOrder : list) {
            Company company = (Company)this.companyService.queryObjById((Object)purchaseOrder.getSupCompanyId());
            if (company == null) continue;
            purchaseOrder.setSupCompanyShortName(company.getCompanyName());
        }
        pageView.setQueryResult(list);
        return pageView;
    }

    @Override
    @Cacheable(value={"purchaseOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseOrder> queryHisObjByPage(PurchaseOrderExample example) {
        PageView<PurchaseOrder> pageView = example.getPageView();
        pageView.setQueryResult(this.purchaseOrderMapper.selectHisByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public void updateByPurcahseOrder(PurchaseOrder record, PurchaseOrderExample example) {
        this.purchaseOrderMapper.updateByExampleSelective(record, example);
    }

    @Override
    @Cacheable(value={"purchaseOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseOrder> queryObjNoItemsByPage(PurchaseOrderExample example, String purUserId, String materialCode, String brand) {
        PageView<PurchaseOrder> pageView = example.getPageView();
        List<PurchaseOrder> list = this.purchaseOrderMapper.selectForPurUserByExampleByPage(example, pageView, purUserId, materialCode, brand);
        pageView.setQueryResult(list);
        return pageView;
    }

    @Override
    @Cacheable(value={"purchaseOrder"}, keyGenerator="redisKeyGenerator")
    public PurchaseOrder queryByOrderNo(String projectId, String orderNo) {
        PurchaseOrderExample example = new PurchaseOrderExample();
        example.createCriteria().andOrderNoEqualTo(orderNo);
        List<PurchaseOrder> list = this.queryAllObjByExample(example);
        if (list != null && list.size() > 1) {
            throw new CommonException("\u51fa\u73b0\u91cd\u590d\u8ba2\u5355\u53f7\u7684\u95ee\u9898");
        }
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Override
    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public String insertHis(String orderId, String cause) {
        String uuid = UUIDGenerator.generateUUID();
        this.purchaseOrderMapper.insertHis(uuid, orderId, cause, new Date());
        return uuid;
    }

    @Override
    public void overduePush() {
        RemindOfPurchaseOrderCmd command = new RemindOfPurchaseOrderCmd();
        this.invoker.invoke(command);
    }

    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public void deleteByExample(PurchaseOrderExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.purchaseOrderMapper.deleteByExample(example);
    }

    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public void addAll(List<PurchaseOrder> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> record.setId(UUIDGenerator.generateUUID()));
        this.purchaseOrderMapper.insertBatch(list);
    }

    @Override
    @Transactional
    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public String createPurOrder(PurchaseOrder purchaseOrder, Company purCompany, User purUser) {
        Assert.isNotBlank((String)purchaseOrder.getPurchaseApplyNo(), (String)"\u8f6c\u8ba2\u5355\u65f6\uff0c\u91c7\u8d2d\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(purchaseOrder.getItems(), (String)"\u8f6c\u8ba2\u5355\u65f6\uff0c\u8ba2\u5355\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)purchaseOrder.getExpensesApplyNo(), (String)"\u8f6c\u8ba2\u5355\u65f6\uff0cbep\u91c7\u8d2d\u7533\u8bf7\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)purchaseOrder.getBepVoucherNo(), (String)"\u8f6c\u8ba2\u5355\u65f6\uff0cbep\u91c7\u8d2d\u7533\u8bf7\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkSupplierData(purchaseOrder);
        this.setPurCompanyData(purchaseOrder, purCompany, purUser);
        this.initPurOrderInfo(purchaseOrder, purCompany, purUser);
        String purchaseOrderNo = this.generateCodeService.getNextCode("PURCHASE_ORDER_NO");
        purchaseOrder.setOrderNo(purchaseOrderNo);
        this.purchaseOrderMapper.insertSelective(purchaseOrder);
        for (PurchaseOrderItem item : purchaseOrder.getItems()) {
            this.checkItemSupplierData(item);
            this.init(item, purchaseOrder, purCompany);
            this.purchaseOrderItemService.addObj(item);
            this.addItemExt(item);
        }
        if (!"Y".equals(purchaseOrder.getReturnFlag())) {
            NoneJitPlanCreateCmd createDeliveryPlanCmd = new NoneJitPlanCreateCmd(purchaseOrder);
            createDeliveryPlanCmd.setPurCompany(purCompany);
            createDeliveryPlanCmd.setPurUser(purUser);
            this.invoker.invoke(createDeliveryPlanCmd);
        }
        return purchaseOrderNo;
    }

    private void initPurOrderInfo(PurchaseOrder purchaseOrder, Company purCompany, User purUser) {
        boolean isFree;
        purchaseOrder.setOrderStatus(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue());
        purchaseOrder.setOrderSendStatus(PurchaseOrderSendStatusEnum.NOTSEND.getValue());
        purchaseOrder.setCreateTime(new Date());
        purchaseOrder.setOrderDate(new Date());
        purchaseOrder.setCreateUser(purUser.getNickName());
        purchaseOrder.setAuditStatus(Constant.YES_INT);
        purchaseOrder.setIsAudit("Y");
        purchaseOrder.setDeliveryStatus(PurchaseOrderDeliveryStatusEnum.RECEVIED_NONE.getValue());
        purchaseOrder.setIsEnable(PurchaseOrderIsEnableEnum.ENABLE.getValue());
        boolean isReturn = purchaseOrder.getItems().stream().anyMatch(item -> "Y".equals(item.getReturnFlag()));
        if (isReturn) {
            purchaseOrder.setReturnFlag("Y");
        }
        if (isFree = purchaseOrder.getItems().stream().anyMatch(item -> "Y".equals(item.getFreeFlag()))) {
            purchaseOrder.setFreeFlag("Y");
        }
        BigDecimal taxTotalPrice = purchaseOrder.getItems().stream().map(PurchaseOrderItem::getTaxTotalPrice).filter(price -> price != null).reduce(BigDecimal::add).orElseGet(null);
        purchaseOrder.setTaxTotalPrice(taxTotalPrice);
        purchaseOrder.setOrderTotal(taxTotalPrice);
    }

    private void addItemExt(PurchaseOrderItem item) {
        PurOrderItemExt ext = new PurOrderItemExt();
        ext.setOrderId(item.getOrderId());
        ext.setOrderItemId(item.getId());
        ext.setOrderNo(item.getOrderNo());
        ext.setOrderItemNo(item.getOrderItemNo());
        ext.setDeliveredQuantity(BigDecimal.ZERO);
        ext.setOnwayQuantity(BigDecimal.ZERO);
        ext.setReceivedQuantity(BigDecimal.ZERO);
        ext.setReturnQuantity(BigDecimal.ZERO);
        this.purOrderItemExtService.addObj(ext);
    }

    private void init(PurchaseOrderItem item, PurchaseOrder order, Company purCompany) {
        item.setOrderId(order.getId());
        item.setOrderNo(order.getOrderNo());
        item.setOrderStatus(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue());
        item.setPurCompanyId(order.getPurCompanyId());
        item.setPurCompanyName(order.getPurCompanyName());
        item.setPurCompanySrmCode(order.getPurCompanySrmCode());
        item.setPurUserId(order.getPurUserId());
        item.setPurUserName(order.getPurUserName());
        item.setPurPlanerId(order.getPurPlanerId());
        item.setPurPlanerName(order.getPurPlanerName());
        item.setSupUserId(order.getSupUserId());
        item.setSupUserName(order.getSupUserName());
        item.setCurrency(order.getCurrency());
        item.setUpdateTime(new Date());
        item.setIsUpdated(Constant.NO_INT);
        item.setQuaWarehouseQuantity(BigDecimal.ZERO);
        item.setHaveChange(ChangeTypeEnum.ADD_ITEM.getValue());
        item.setOrderNoType(order.getOrderType());
        item.setPurReqNo(order.getPurchaseApplyNo());
        item.setIsJit(Constant.NO_INT);
        item.setTotalGroupId(order.getTotalGroupId());
        item.setTotalGroupName(order.getTotalGroupName());
        item.setAccountSetId(order.getAccountSetId());
        item.setAccountCode(order.getAccountCode());
        item.setAccountSetName(order.getAccountSetName());
        item.setInstitutionsId(order.getInstitutionsId());
        item.setInstitutionsName(order.getInstitutionsName());
        item.setInTheOrganizationId(order.getInTheOrganizationId());
        item.setInTheOrganizationName(order.getInTheOrganizationName());
        item.setDepartId(order.getDepartId());
        item.setDepartName(order.getDepartName());
        if (item.getOrderDate() == null) {
            item.setOrderDate(order.getOrderDate());
        }
        if (item.getFreezeQuantity() == null) {
            item.setFreezeQuantity(BigDecimal.ZERO);
        }
        if (item.getAlreadyApplyMoney() == null) {
            item.setAlreadyApplyMoney(BigDecimal.ZERO);
        }
        if (item.getTaxTotalPrice() == null) {
            item.setAvailableApplyMoney(BigDecimal.ZERO);
        } else {
            item.setAvailableApplyMoney(item.getTaxTotalPrice());
        }
        item.setIsCanDelivery(Constant.YES_INT);
        item.setIsEnable(Constant.YES_INT);
        item.setFinishFlag("N");
        item.setIsOfficialPrice(Constant.YES_INT);
        item.setReturnFlag("N");
    }

    private void checkItemSupplierData(PurchaseOrderItem item) {
        Assert.isNotBlank((String)item.getSupCompanyId(), (String)"\u8f6c\u8ba2\u5355\u884c\u65f6\uff0c\u4f9b\u5e94\u5546ID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)item.getSupCompanyName(), (String)"\u8f6c\u8ba2\u5355\u884c\u65f6\uff0c\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)item.getSupCompanySrmCode(), (String)"\u8f6c\u8ba2\u5355\u884c\u65f6\uff0c\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)item.getMaterialCode(), (String)"\u8f6c\u8ba2\u5355\u884c\u65f6\uff0c\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)item.getMaterialName(), (String)"\u8f6c\u8ba2\u5355\u884c\u65f6\uff0c\u7269\u6599\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)item.getDeliveryLocation(), (String)"\u8f6c\u8ba2\u5355\u884c\u65f6\uff0c\u9001\u8d27\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)item.getConsignee(), (String)"\u8f6c\u8ba2\u5355\u884c\u65f6\uff0c\u6536\u8d27\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)item.getPurchasePhone(), (String)"\u8f6c\u8ba2\u5355\u884c\u65f6\uff0c\u6536\u8d27\u4eba\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)item.getConsigneeId(), (String)"\u8f6c\u8ba2\u5355\u884c\u65f6\uff0c\u6536\u8d27\u4eba\u7684ID\u4e0d\u80fd\u4e3a\u7a7a");
        Material material = this.materialService.queryObjByCode(item.getMaterialCode());
        Assert.isNotNull((Object)material, (String)("\u6839\u636e\u91c7\u8d2d\u7533\u8bf7\u4f20\u7684\u7269\u6599\u7f16\u7801\uff1a" + item.getMaterialCode() + "\u67e5\u8be2\u7684\u7269\u6599\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8f6c\u8ba2\u5355\u5931\u8d25"));
        if (Constant.YES_INT.equals(material.getInventoryFlag())) {
            Assert.isNotBlank((String)item.getWarehouseCode(), (String)("\u7269\u6599\u7f16\u53f7\uff1a" + item.getMaterialCode() + "\u9700\u8981\u5165\u5e93\uff0c\u5e93\u5b58\u5730\u70b9\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8f6c\u8ba2\u5355\u5931\u8d25"));
        }
    }

    private void checkSupplierData(PurchaseOrder purchaseOrder) {
        Assert.isNotBlank((String)purchaseOrder.getSupCompanyId(), (String)"\u8f6c\u8ba2\u5355\u65f6\uff0c\u4f9b\u5e94\u5546\u516c\u53f8ID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)purchaseOrder.getSupCompanyName(), (String)"\u8f6c\u8ba2\u5355\u65f6\uff0c\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)purchaseOrder.getSupCompanySrmCode(), (String)"\u8f6c\u8ba2\u5355\u65f6\uff0c\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)purchaseOrder.getSupplierTel(), (String)"\u8f6c\u8ba2\u5355\u65f6\uff0c\u4f9b\u5e94\u5546\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)purchaseOrder.getSupplierPerson(), (String)"\u8f6c\u8ba2\u5355\u65f6\uff0c\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)purchaseOrder.getSupUserId(), (String)"\u8f6c\u8ba2\u5355\u65f6\uff0c\u4f9b\u5e94\u5546\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)purchaseOrder.getSupUserName(), (String)"\u8f6c\u8ba2\u5355\u65f6\uff0c\u4f9b\u5e94\u5546\u7528\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void setPurCompanyData(PurchaseOrder purchaseOrder, Company purCompany, User purUser) {
        purchaseOrder.setPurCompanyId(purCompany.getId());
        purchaseOrder.setPurPlanerWorkNum(purchaseOrder.getPurPlanerWorkNum());
        purchaseOrder.setPurUserId(purUser.getId());
        purchaseOrder.setPurUserName(purUser.getNickName());
        Assert.isNotBlank((String)purchaseOrder.getDepartId(), (String)"\u91c7\u8d2d\u7533\u8bf7\u8f6c\u91c7\u8d2d\u8ba2\u5355\u65f6\u6240\u4f20\u7684\u90e8\u95e8ID\u4e3a\u7a7a\uff0c\u8f6c\u8ba2\u5355\u5931\u8d25");
        DepartmentExcelVO excelVO = this.departmentService.getDepartmentExcelVO(purchaseOrder.getDepartId());
        if (null != excelVO) {
            purchaseOrder.setPurCompanyName(excelVO.getInTheOrganizationName());
            purchaseOrder.setPurCompanySrmCode(excelVO.getInTheOrganizationId());
            purchaseOrder.setAccountCode(excelVO.getAccountCode());
            purchaseOrder.setAccountSetId(excelVO.getAccountSetId());
            purchaseOrder.setAccountSetName(excelVO.getAccountSetName());
            purchaseOrder.setTotalGroupId(excelVO.getTotalGroupId());
            purchaseOrder.setTotalGroupName(excelVO.getTotalGroupName());
            purchaseOrder.setInstitutionsId(excelVO.getInstitutionsId());
            purchaseOrder.setInstitutionsName(excelVO.getInstitutionsName());
            purchaseOrder.setInTheOrganizationId(excelVO.getInTheOrganizationId());
            purchaseOrder.setInTheOrganizationName(excelVO.getInTheOrganizationName());
            purchaseOrder.setDepartId(excelVO.getDepartId());
            purchaseOrder.setDepartName(excelVO.getDepartName());
        }
    }

    public Map<String, Object> processResult(Map<String, Object> objectMap) throws Exception {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (objectMap.isEmpty()) {
            logger.debug("\u67e5\u8be2\u8ba2\u5355\u63a5\u53e3\u7684\u8f93\u5165\u53c2\u6570\u4e3a\u7a7a\uff0c\u67e5\u8be2\u5931\u8d25");
            throw new CommonException("\u67e5\u8be2\u8ba2\u5355\u63a5\u53e3\u7684\u8f93\u5165\u53c2\u6570\u4e3a\u7a7a\uff0c\u67e5\u8be2\u5931\u8d25");
        }
        String applyNo = (String)objectMap.get("expensesApplyNo");
        if (StringUtils.isBlank((CharSequence)applyNo)) {
            logger.debug("\u67e5\u8be2\u8ba2\u5355\u63a5\u53e3\u7684\u8f93\u5165\u53c2\u6570\u7533\u8bf7\u5355\u6d41\u6c34\u53f7\u4e3a\u7a7a\uff0c\u67e5\u8be2\u8ba2\u5355\u5931\u8d25");
            throw new CommonException("\u67e5\u8be2\u8ba2\u5355\u63a5\u53e3\u7684\u8f93\u5165\u53c2\u6570\u7533\u8bf7\u5355\u6d41\u6c34\u53f7\u4e3a\u7a7a\uff0c\u67e5\u8be2\u8ba2\u5355\u5931\u8d25");
        }
        PurchaseOrderExample orderExample = new PurchaseOrderExample();
        orderExample.createCriteria().andExpensesApplyNoEqualTo(applyNo);
        List<PurchaseOrder> orderList = this.queryAllObjByExample(orderExample);
        if (CollectionUtils.isEmpty(orderList)) {
            logger.debug("\u6839\u636e\u7533\u8bf7\u5355\u6d41\u6c34\u53f7\uff1a" + applyNo + "\u67e5\u8be2\u7684\u91c7\u8d2d\u8ba2\u5355\u5934\u4fe1\u606f\u4e3a\u7a7a");
            throw new CommonException("\u6839\u636e\u7533\u8bf7\u5355\u6d41\u6c34\u53f7\uff1a" + applyNo + "\u67e5\u8be2\u7684\u91c7\u8d2d\u8ba2\u5355\u5934\u4fe1\u606f\u4e3a\u7a7a");
        }
        ArrayList pcpOrderInfoList = new ArrayList();
        orderList.stream().forEach(order -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            this.setPurchaseOrderData((PurchaseOrder)order, (Map<String, Object>)map);
            PurchaseOrderItemExample itemExample = new PurchaseOrderItemExample();
            itemExample.createCriteria().andOrderIdEqualTo(order.getId());
            List itemList = this.purchaseOrderItemService.queryAllObjByExample((IExample)itemExample);
            this.setPurchaseOrderItemData(itemList, map);
            pcpOrderInfoList.add(map);
        });
        resultMap.put("pcpOrderInfoList", pcpOrderInfoList);
        return resultMap;
    }

    private void setPurchaseOrderItemData(List<PurchaseOrderItem> itemList, Map<String, Object> map) {
        ArrayList detailMapList = new ArrayList();
        itemList.stream().forEach(item -> {
            HashMap<String, Object> itemMap = new HashMap<String, Object>();
            itemMap.put("economicIssuesNo", item.getEconomicMatters());
            itemMap.put("budgetCenter", item.getBudgetCore());
            itemMap.put("branchId", item.getInstitutionsId());
            itemMap.put("ApplyDtlNo", item.getPurReqItemNo());
            itemMap.put("sumAmount", item.getAvailableApplyMoney());
            detailMapList.add(itemMap);
        });
        map.put("detailMapList", detailMapList);
    }

    private void setPurchaseOrderData(PurchaseOrder order, Map<String, Object> map) {
        map.put("bepVoucherNo", order.getBepVoucherNo());
        map.put("orderId", order.getOrderNo());
        map.put("payeeName", order.getSupCompanyName());
        map.put("payeeNo", order.getSupCompanySrmCode());
        map.put("placeOrderTime", order.getCreateTime());
        map.put("responsUserName", order.getPurPlanerName());
        map.put("sumAmount", order.getOrderTotal());
    }
}

