-- ----------------------------
-- 采购订单行
-- ----------------------------
CREATE TABLE "T_BASE_PUR_ORDER_ITEM" (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_USER_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_USER_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"ORDER_ID" VARCHAR2(32 BYTE) NULL ,
"ORDER_NO" VARCHAR2(255 BYTE) NULL ,
"ORDER_ITEM_NO" VARCHAR2(12 BYTE) NULL ,
"ORDER_DATE" DATE NULL ,
"MATERIAL_CATEGORY_ID" VARCHAR2(32 BYTE) NULL ,
"MATERIAL_CATEGORY_NAME" VARCHAR2(45 BYTE) NULL ,
"MATERIAL_ID" VARCHAR2(32 BYTE) NULL ,
"MATERIAL_NAME" VARCHAR2(255 BYTE) NULL ,
"MATERIAL_CODE" VARCHAR2(20 BYTE) NULL ,
"QUANTITY" NUMBER(16,3) DEFAULT NULL  NULL ,
"PRICE_UNIT" VARCHAR2(15 BYTE) NULL ,
"ORDER_UNIT" VARCHAR2(50 BYTE) NULL ,
"DELIVERED_DATE" DATE NULL ,
"WAREHOUSE_LOCATION" VARCHAR2(150 BYTE) NULL ,
"WAREHOUSE_NAME" VARCHAR2(255 BYTE) NULL ,
"QUA_WAREHOUSE_QUANTITY" NUMBER(16,3) DEFAULT 0  NULL ,
"IS_UPDATED" NUMBER(11) DEFAULT 0  NULL ,
"REMARK" NCLOB NULL ,
"UPDATE_TIME" DATE NULL ,
"CURRENCY" VARCHAR2(15 BYTE) NULL ,
"PRODUCT_NO" VARCHAR2(100 BYTE) NULL ,
"IS_ENABLE" NUMBER(11) DEFAULT NULL  NULL ,
"FINISH_FLAG" NCHAR(1) NULL ,
"VERSION" VARCHAR2(255 BYTE) DEFAULT 0  NULL ,
"DELIVERY_LOCATION" VARCHAR2(255 BYTE) NULL ,
"PURCHASE_GROUP" VARCHAR2(255 BYTE) NULL ,
"CHANGE_AMOUNT" NUMBER(12) DEFAULT 0  NULL ,
"SALE_ORDER_MODEL" VARCHAR2(255 BYTE) NULL ,
"SHORT_TXT" VARCHAR2(255 BYTE) NULL ,
"INDUSTRY_STANDARD" VARCHAR2(255 BYTE) NULL ,
"FACTORY" VARCHAR2(255 BYTE) NULL ,
"SUP_MATERIAL_CODE" VARCHAR2(255 BYTE) NULL ,
"BRAND" VARCHAR2(255 BYTE) NULL ,
"FACTORY_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) NULL ,
"ORDER_STATUS" NUMBER(11) DEFAULT 1  NULL ,
"PUR_REMARK" VARCHAR2(255 BYTE) DEFAULT NULL  NULL ,
"SUP_REMARK" VARCHAR2(255 BYTE) DEFAULT NULL  NULL ,
"SUP_MATERIAL_DESC" VARCHAR2(255 CHAR) NULL ,
"HAVE_CHANGE" NUMBER(2) NULL ,
"DELIVERY_MATERIAL_NAME" VARCHAR2(255 BYTE) NULL ,
"FREEZE_QUANTITY" NUMBER(11,3) DEFAULT 0  NULL ,
"SUP_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) NULL ,
"ALREADY_APPLY_MONEY" NUMBER(20,4) NULL ,
"AVAILABLE_APPLY_MONEY" NUMBER(20,4) NULL ,
"SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_REQ_NO" VARCHAR2(80 BYTE) NULL ,
"PUR_REQ_ITEM_NO" VARCHAR2(80 BYTE) NULL ,
"QUOTE_ORDER_NO" VARCHAR2(255 BYTE) NULL ,
"QUOTE_ORDER_ITEM_NO" VARCHAR2(255 BYTE) NULL ,
"IS_OFFICIAL_PRICE" NUMBER(1) NULL ,
"RETURN_FLAG" VARCHAR2(255 BYTE) NULL ,
"BOM_DESC" VARCHAR2(255 BYTE) NULL ,
"MASTER_ORDER_NO" VARCHAR2(255 BYTE) NULL ,
"MASTER_ORDER_ITEM_NO" VARCHAR2(255 BYTE) NULL ,
"ORDER_TYPE" VARCHAR2(11 BYTE) NULL ,
"FREEZE_FLAG" NUMBER(1) NULL ,
"IS_JIT" NUMBER(1) NULL ,
"IS_REFUSE_QUANTITY" NUMBER(1) NULL ,
"IS_REFUSE_PRICE" NUMBER(1) NULL ,
"IS_REFUSE_DELIVERED_DATE" NUMBER(1) NULL ,
"TAX_CODE" VARCHAR2(255 BYTE) NULL ,
"TAX_RATE" NUMBER(16,6) NULL ,
"TAX_UNIT_PRICE" NUMBER(16,3) DEFAULT 0  NULL ,
"UNTAX_UNIT_PRICE" NUMBER(16,3) DEFAULT 0  NULL ,
"UNTAX_TOTAL_PRICE" NUMBER(16,3) DEFAULT 0  NULL ,
"TAX_TOTAL_PRICE" NUMBER(16,3) NULL ,
"MATERIAL_UNIT_PRICE" NUMBER(16,3) NULL ,
"MATERIAL_TOTAL_PIRCE" NUMBER(16,3) NULL ,
"TOTAL_PRICE" NUMBER(16,3) NULL ,
"PUR_PLANER_ID" VARCHAR2(32 BYTE) NULL ,
"IS_CAN_DELIVERY" NUMBER(1) NULL ,
"FREE_FLAG" VARCHAR2(255 BYTE) NULL ,
"ORDER_NO_TYPE" VARCHAR2(255 BYTE) NULL ,
"PUR_PLANER_NAME" VARCHAR2(255 BYTE) NULL ,
"BUDGET_CORE" VARCHAR2(255) NULL,
"ECONOMIC_MATTERS" VARCHAR2(255) NULL,
"USES" VARCHAR2(255) NULL,
"WAREHOUSE_CODE" VARCHAR2(32) NULL,
"TOTAL_GROUP_ID" VARCHAR2(32) NULL,
"TOTAL_GROUP_NAME" VARCHAR2(255) NULL,
"ACCOUNT_SET_ID" VARCHAR2(32) NULL,
"ACCOUNT_SET_NAME" VARCHAR2(255) NULL,
"ACCOUNT_CODE" VARCHAR2(255) NULL,
"INSTITUTIONS_ID" VARCHAR2(32) NULL,
"INSTITUTIONS_NAME" VARCHAR2(255) NULL,
"IN_THE_ORGANIZATION_ID" VARCHAR2(32) NULL,
"IN_THE_ORGANIZATION_NAME" VARCHAR2(255) NULL,
"DEPART_ID" VARCHAR2(32) NULL,
"DEPART_NAME" VARCHAR2(255) NULL,
"BUDGET_CORE_DESC" VARCHAR2(255) NULL,
"ECONOMIC_MATTERS_DESC" VARCHAR2(255) NULL
);
COMMENT ON TABLE "T_BASE_PUR_ORDER_ITEM" IS '采购订单行';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."ID" IS 'ID';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."PUR_COMPANY_ID" IS '采购企业id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."PUR_COMPANY_NAME" IS '采购企业名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."PUR_USER_NAME" IS '采购员名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."PUR_USER_ID" IS '采购员id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."SUP_COMPANY_ID" IS '供应商id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."SUP_COMPANY_NAME" IS '供应企业名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."SUP_USER_ID" IS '供应员id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."SUP_USER_NAME" IS '供应员id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."ORDER_ID" IS '订单id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."ORDER_NO" IS '采购凭证号 ';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."ORDER_ITEM_NO" IS '采购凭证的项目编号 ';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."ORDER_DATE" IS '采购凭证日期';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."MATERIAL_CATEGORY_ID" IS '物料组id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."MATERIAL_CATEGORY_NAME" IS '物料组名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."MATERIAL_NAME" IS '物料名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."MATERIAL_CODE" IS '物料号 (客户端物料编码)';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."QUANTITY" IS '采购订单数量';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."PRICE_UNIT" IS '价格单位';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."ORDER_UNIT" IS '订单单位';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."DELIVERED_DATE" IS '交货日期';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."WAREHOUSE_LOCATION" IS '仓库地点';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."WAREHOUSE_NAME" IS '仓库名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."QUA_WAREHOUSE_QUANTITY" IS '待检入库数量';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."IS_UPDATED" IS '是否被修改过，0没有，1已修改';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."UPDATE_TIME" IS '更新日期';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."CURRENCY" IS '币别';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."PRODUCT_NO" IS '品号';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."IS_ENABLE" IS '是否删除或冻结，1未删除，0删除,2已经冻结';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."FINISH_FLAG" IS '交货已完成标识,Y完成';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."VERSION" IS '版本';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."DELIVERY_LOCATION" IS '交货地点';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."PURCHASE_GROUP" IS '采购组';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."CHANGE_AMOUNT" IS '变更数量（预留）';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."SALE_ORDER_MODEL" IS '销售单机型';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."SHORT_TXT" IS '短文本';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."INDUSTRY_STANDARD" IS '行业标准';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."FACTORY" IS '工厂';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."SUP_MATERIAL_CODE" IS '供应商物料号';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."BRAND" IS '品牌';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."FACTORY_NAME" IS '工厂名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."PUR_COMPANY_SRM_CODE" IS '采购公司编码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."PUR_COMPANY_SAP_CODE" IS 'sap公司代码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."ORDER_STATUS" IS '确认状态：1订单未确认，2已确认，3已退回';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."PUR_REMARK" IS '采购备注';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."SUP_REMARK" IS '供应商备注';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."SUP_MATERIAL_DESC" IS '供应商物料描述';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."HAVE_CHANGE" IS '订单是否有更改：0未更改，1更改';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."DELIVERY_MATERIAL_NAME" IS '发货物料名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."FREEZE_QUANTITY" IS '冻结数量';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."SUP_COMPANY_SAP_CODE" IS '供应商SAP编码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."ALREADY_APPLY_MONEY" IS '已申请金额';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."AVAILABLE_APPLY_MONEY" IS '可申请金额';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."SUP_COMPANY_SRM_CODE" IS '供应商srm编码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."PUR_REQ_NO" IS '采购申请单号';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."PUR_REQ_ITEM_NO" IS '采购申请单行号';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."IS_OFFICIAL_PRICE" IS '是否正式价格，1是，0否';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."RETURN_FLAG" IS '退货标识';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."BOM_DESC" IS 'BOM文本描述';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."MASTER_ORDER_NO" IS '总控订单号';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."MASTER_ORDER_ITEM_NO" IS '总控订单行号';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."ORDER_TYPE" IS '订单类型，L为委外订单行，空为正常订单行';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."FREEZE_FLAG" IS '冻结标识';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."IS_JIT" IS '是否jit物料1是，0否';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."IS_REFUSE_QUANTITY" IS '是否拒绝数量';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."IS_REFUSE_PRICE" IS '是否拒绝价格';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."IS_REFUSE_DELIVERED_DATE" IS '是否拒绝交期';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."TAX_CODE" IS '税码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."TAX_RATE" IS '税率';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."TAX_UNIT_PRICE" IS '含税单价';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."UNTAX_UNIT_PRICE" IS '不含税单价';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."UNTAX_TOTAL_PRICE" IS '不含税金额';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."TAX_TOTAL_PRICE" IS '价税合计';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."MATERIAL_UNIT_PRICE" IS '材料单价(含税)';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."MATERIAL_TOTAL_PIRCE" IS '材料金额(含税)';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."TOTAL_PRICE" IS '总价';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."PUR_PLANER_ID" IS '采购方计划员id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."IS_CAN_DELIVERY" IS '是否可发货，1可发货，0不可发货';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."FREE_FLAG" IS '免费标识，Y为免费，N为不免费';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."ORDER_NO_TYPE" IS '采购订单类型';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."PUR_PLANER_NAME" IS '采购方计划员名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."BUDGET_CORE" IS '预算中心';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."ECONOMIC_MATTERS" IS '经济事项';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."USES" IS '用途';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."WAREHOUSE_CODE" IS '仓库编码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."TOTAL_GROUP_ID" IS '总集团id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."TOTAL_GROUP_NAME" IS '总集团名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."ACCOUNT_SET_ID" IS '账套 id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."ACCOUNT_SET_NAME" IS '账套名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."ACCOUNT_CODE" IS '账套编码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."INSTITUTIONS_ID" IS '机构id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."INSTITUTIONS_NAME" IS '机构名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."IN_THE_ORGANIZATION_ID" IS '中支机构id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."IN_THE_ORGANIZATION_NAME" IS '中支机构名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."DEPART_ID" IS '部门id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."DEPART_NAME" IS '部门名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."BUDGET_CORE_DESC" IS '预算中心描述';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."ECONOMIC_MATTERS_DESC" IS '经济事项描述';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."MATERIAL_ID" IS '物料ID';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."QUOTE_ORDER_NO" IS '引用单号';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM"."QUOTE_ORDER_ITEM_NO" IS '引用单行号';
ALTER TABLE "T_BASE_PUR_ORDER_ITEM" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 采购方订单头
-- ----------------------------
CREATE TABLE "T_BASE_PUR_ORDER" (
"ID" VARCHAR2(50 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(50 BYTE) NULL ,
"PUR_COMPANY_ID" VARCHAR2(50 BYTE) NULL ,
"PUR_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_SAP_CODE" VARCHAR2(50 BYTE) NULL ,
"PUR_USER_ID" VARCHAR2(50 BYTE) NULL ,
"PUR_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"DEPARTMENT_ID" VARCHAR2(50 BYTE) NULL ,
"DEPARTMENT_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_ID" VARCHAR2(50 BYTE) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_SAP_CODE" VARCHAR2(60 BYTE) NULL ,
"SUP_USER_ID" VARCHAR2(50 BYTE) NULL ,
"SUP_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"ORDER_NO" VARCHAR2(255 BYTE) NOT NULL ,
"ORDER_TYPE" VARCHAR2(11 BYTE) NULL ,
"ORDER_STATUS" NUMBER(11) NULL ,
"ORDER_SEND_STATUS" NUMBER(11) NULL ,
"ORDER_DATE" DATE NULL ,
"DELIVERY_STATUS" NUMBER(11) NULL ,
"PUR_REMARK" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
"SUP_REMARK" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"CREATE_USER" VARCHAR2(50 BYTE) NULL ,
"LAST_UPDATE_TIME" DATE DEFAULT sysdate  NULL ,
"LAST_UPDATE_USER" VARCHAR2(50 BYTE) NULL ,
"SEND_TIME" DATE NULL ,
"TAX_RATE" NUMBER(11,6) NULL ,
"TAX_AMOUNT" NUMBER(11,3) NULL ,
"EXCHANGE_RATE" VARCHAR2(50 BYTE) NULL ,
"AUDIT_STATUS" NUMBER(11) NULL ,
"IS_AUDIT" NCHAR(1) NULL ,
"PAY_TERMS" VARCHAR2(50 BYTE) NULL ,
"PAY_TERMS_DESC" VARCHAR2(255 BYTE) NULL ,
"CURRENCY" VARCHAR2(255 BYTE) NULL ,
"TAX_TOTAL_PRICE" NUMBER(11,3) DEFAULT 0  NULL ,
"TOTAL_QUANTITY" NUMBER(11,3) DEFAULT 0  NULL ,
"IS_ENABLE" NUMBER(11) DEFAULT 1  NULL ,
"VERSION" VARCHAR2(255 BYTE) DEFAULT 0  NULL ,
"SUPPLIER_TEL" VARCHAR2(255 BYTE) NULL ,
"SUPPLIER_FAX" VARCHAR2(255 BYTE) NULL ,
"SUPPLIER_PERSON" VARCHAR2(255 BYTE) NULL ,
"PURCHASE_GROUP" VARCHAR2(255 BYTE) NULL ,
"BILL_NAME" VARCHAR2(255 BYTE) NULL ,
"ADDRESS_NO" VARCHAR2(255 BYTE) NULL ,
"SALE_PERSON" VARCHAR2(255 BYTE) NULL ,
"HEAD_TXT" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_SHORT_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"TAX_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_PLANER_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_PLANER_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_PLANER_WORK_NUM" VARCHAR2(255 BYTE) NULL ,
"IS_REFUSE_PRICE" NUMBER(1) NULL ,
"IS_REFUSE_QUANTITY" NUMBER(1) NULL ,
"IS_REFUSE_DELIVERED_DATE" NUMBER(1) NULL ,
"INTER_TRADE_CODE" VARCHAR2(255 BYTE) NULL ,
"INTER_TRADE_DESC" VARCHAR2(255 BYTE) NULL ,
"RETURN_FLAG" VARCHAR2(255 BYTE) NULL ,
"FREE_FLAG" VARCHAR2(255 BYTE) NULL ,
"REPLY_TIME" DATE NULL ,
"PURCHASE_APPLY_NO" VARCHAR2(255) NULL,
"CONTRACT_NUMBER" VARCHAR2(255) NULL,
"ORDER_TOTAL" NUMBER(20,3) NULL,
"TOTAL_GROUP_ID" VARCHAR2(32) NULL,
"TOTAL_GROUP_NAME" VARCHAR2(255) NULL,
"ACCOUNT_SET_ID" VARCHAR2(32) NULL,
"ACCOUNT_SET_NAME" VARCHAR2(255) NULL,
"ACCOUNT_CODE" VARCHAR2(255) NULL,
"INSTITUTIONS_ID" VARCHAR2(32) NULL,
"INSTITUTIONS_NAME" VARCHAR2(255) NULL,
"IN_THE_ORGANIZATION_ID" VARCHAR2(32) NULL,
"IN_THE_ORGANIZATION_NAME" VARCHAR2(255) NULL,
"DEPART_ID" VARCHAR2(32) NULL,
"DEPART_NAME" VARCHAR2(255) NULL
);
COMMENT ON TABLE "T_BASE_PUR_ORDER" IS '采购方订单头';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."PUR_COMPANY_ID" IS '采购企业id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."PUR_COMPANY_NAME" IS '采购企业名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."PUR_COMPANY_SAP_CODE" IS '采购方sap编码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."PUR_USER_ID" IS '采购员id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."PUR_USER_NAME" IS '采购员名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."DEPARTMENT_ID" IS '采购组织';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."DEPARTMENT_NAME" IS '采购组织名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."SUP_COMPANY_ID" IS '供应商id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."SUP_COMPANY_NAME" IS '供应企业名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."SUP_COMPANY_SAP_CODE" IS '供应商编码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."SUP_USER_ID" IS '供应商用户id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."SUP_USER_NAME" IS '供应商用户名';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."ORDER_NO" IS '采购订单号 ';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."ORDER_TYPE" IS '订单类型';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."ORDER_STATUS" IS '确认状态：1订单未确认，2已确认，3已退回';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."ORDER_SEND_STATUS" IS '发送状态：1未发送，2已发送，3变更未发送，4变更已发送';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."ORDER_DATE" IS '采购订单生成日期';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."DELIVERY_STATUS" IS '交收状态1:未交收，2：订单发货在途，3：部分交收，4：全部交收';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."PUR_REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."CREATE_USER" IS '创建人';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."LAST_UPDATE_TIME" IS '最后更新时间';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."LAST_UPDATE_USER" IS '最后修改人';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."SEND_TIME" IS '发送供应商时间';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."TAX_RATE" IS '税率';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."TAX_AMOUNT" IS '税额';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."EXCHANGE_RATE" IS '汇率';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."AUDIT_STATUS" IS '1-审批通过，2-未审批，3-审批中，4-审批拒绝';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."IS_AUDIT" IS '审批标识 Y 已审批';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."PAY_TERMS" IS '付款条件';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."PAY_TERMS_DESC" IS '付款条件描述';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."CURRENCY" IS '币别';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."TAX_TOTAL_PRICE" IS '含税总金额';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."TOTAL_QUANTITY" IS '总数量';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."IS_ENABLE" IS '是否删除，1未删除，0删除,2冻结';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."VERSION" IS '版本';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."SUPPLIER_TEL" IS '供应商电话';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."SUPPLIER_FAX" IS '供应商传真';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."SUPPLIER_PERSON" IS '供应商联系人';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."PURCHASE_GROUP" IS '采购组';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."BILL_NAME" IS '单据名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."ADDRESS_NO" IS '地址号码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."SALE_PERSON" IS '供应商办公室的责任销售员';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."HEAD_TXT" IS '抬头文本';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."SUP_COMPANY_SHORT_NAME" IS '供应商简称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."PUR_COMPANY_SRM_CODE" IS '采购企业srm编码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."TAX_CODE" IS '税码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."PUR_PLANER_ID" IS '采购方计划员id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."PUR_PLANER_NAME" IS '采购方计划员名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."PUR_PLANER_WORK_NUM" IS '计划员工号';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."IS_REFUSE_PRICE" IS '是否拒绝价格';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."IS_REFUSE_QUANTITY" IS '是否拒绝数量';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."IS_REFUSE_DELIVERED_DATE" IS '是否拒绝交期';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."INTER_TRADE_CODE" IS '国际贸易条款编码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."INTER_TRADE_DESC" IS '国际贸易条款描述';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."RETURN_FLAG" IS '退货标识,Y为退货';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."FREE_FLAG" IS '免费标识，Y为免费，N为不免费';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."REPLY_TIME" IS '供应商回复时间';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."PURCHASE_APPLY_NO" IS '采购申请号';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."CONTRACT_NUMBER" IS '合同编号';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."ORDER_TOTAL" IS '订单总额';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."TOTAL_GROUP_ID" IS '总集团id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."TOTAL_GROUP_NAME" IS '总集团名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."ACCOUNT_SET_ID" IS '账套 id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."ACCOUNT_SET_NAME" IS '账套名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."ACCOUNT_CODE" IS '账套编码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."INSTITUTIONS_ID" IS '机构id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."INSTITUTIONS_NAME" IS '机构名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."IN_THE_ORGANIZATION_ID" IS '中支机构id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."IN_THE_ORGANIZATION_NAME" IS '中支机构名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."DEPART_ID" IS '部门id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."DEPART_NAME" IS '部门名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."ID" IS '主键ID';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."SUP_REMARK" IS '供应商备注';
COMMENT ON COLUMN "T_BASE_PUR_ORDER"."SUP_COMPANY_SRM_CODE" IS '供应商srm编号';
ALTER TABLE "T_BASE_PUR_ORDER" ADD PRIMARY KEY ("ID");


-- ----------------------------
--供应商采购订单头
-- ----------------------------
CREATE TABLE "T_BASE_SUP_ORDER" (
"ID" VARCHAR2(50 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(50 BYTE) NULL ,
"PUR_COMPANY_ID" VARCHAR2(50 BYTE) NULL ,
"PUR_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_SAP_CODE" VARCHAR2(50 BYTE) NULL ,
"PUR_USER_ID" VARCHAR2(50 BYTE) NULL ,
"PUR_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"DEPARTMENT_ID" VARCHAR2(50 BYTE) NULL ,
"DEPARTMENT_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_ID" VARCHAR2(50 BYTE) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_SAP_CODE" VARCHAR2(60 BYTE) NULL ,
"SUP_USER_ID" VARCHAR2(50 BYTE) NULL ,
"SUP_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"ORDER_NO" VARCHAR2(255 BYTE) NOT NULL ,
"ORDER_TYPE" VARCHAR2(11 BYTE) NULL ,
"ORDER_STATUS" NUMBER(11) NULL ,
"ORDER_SEND_STATUS" NUMBER(11) NULL ,
"ORDER_DATE" DATE NULL ,
"DELIVERY_STATUS" NUMBER(11) NULL ,
"PUR_REMARK" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
"SUP_REMARK" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"CREATE_USER" VARCHAR2(50 BYTE) NULL ,
"LAST_UPDATE_TIME" DATE DEFAULT sysdate  NULL ,
"LAST_UPDATE_USER" VARCHAR2(50 BYTE) NULL ,
"SEND_TIME" DATE NULL ,
"TAX_RATE" NUMBER(11,6) NULL ,
"TAX_AMOUNT" NUMBER(11,3) NULL ,
"EXCHANGE_RATE" VARCHAR2(50 BYTE) NULL ,
"AUDIT_STATUS" NUMBER(11) NULL ,
"IS_AUDIT" NCHAR(1) NULL ,
"PAY_TERMS" VARCHAR2(50 BYTE) NULL ,
"PAY_TERMS_DESC" VARCHAR2(255 BYTE) NULL ,
"CURRENCY" VARCHAR2(255 BYTE) NULL ,
"TAX_TOTAL_PRICE" NUMBER(11,3) DEFAULT 0  NULL ,
"TOTAL_QUANTITY" NUMBER(11,3) DEFAULT 0  NULL ,
"IS_ENABLE" NUMBER(11) DEFAULT 1  NULL ,
"VERSION" VARCHAR2(255 BYTE) DEFAULT 0  NULL ,
"SUPPLIER_TEL" VARCHAR2(255 BYTE) NULL ,
"SUPPLIER_FAX" VARCHAR2(255 BYTE) NULL ,
"SUPPLIER_PERSON" VARCHAR2(255 BYTE) NULL ,
"PURCHASE_GROUP" VARCHAR2(255 BYTE) NULL ,
"BILL_NAME" VARCHAR2(255 BYTE) NULL ,
"ADDRESS_NO" VARCHAR2(255 BYTE) NULL ,
"SALE_PERSON" VARCHAR2(255 BYTE) NULL ,
"HEAD_TXT" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_SHORT_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"TAX_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_PLANER_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_PLANER_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_PLANER_WORK_NUM" VARCHAR2(255 BYTE) NULL ,
"IS_REFUSE_PRICE" NUMBER(1) NULL ,
"IS_REFUSE_QUANTITY" NUMBER(1) NULL ,
"IS_REFUSE_DELIVERED_DATE" NUMBER(1) NULL ,
"INTER_TRADE_CODE" VARCHAR2(255 BYTE) NULL ,
"INTER_TRADE_DESC" VARCHAR2(255 BYTE) NULL ,
"RETURN_FLAG" VARCHAR2(255 BYTE) NULL ,
"FREE_FLAG" VARCHAR2(255 BYTE) NULL ,
"REPLY_TIME" DATE NULL ,
"PURCHASE_APPLY_NO" VARCHAR2(255) NULL,
"CONTRACT_NUMBER" VARCHAR2(255) NULL,
"ORDER_TOTAL" NUMBER(20,3) NULL,
"TOTAL_GROUP_ID" VARCHAR2(32) NULL,
"TOTAL_GROUP_NAME" VARCHAR2(255) NULL,
"ACCOUNT_SET_ID" VARCHAR2(32) NULL,
"ACCOUNT_SET_NAME" VARCHAR2(255) NULL,
"ACCOUNT_CODE" VARCHAR2(255) NULL,
"INSTITUTIONS_ID" VARCHAR2(32) NULL,
"INSTITUTIONS_NAME" VARCHAR2(255) NULL,
"IN_THE_ORGANIZATION_ID" VARCHAR2(32) NULL,
"IN_THE_ORGANIZATION_NAME" VARCHAR2(255) NULL,
"DEPART_ID" VARCHAR2(32) NULL,
"DEPART_NAME" VARCHAR2(255) NULL
);
COMMENT ON TABLE "T_BASE_SUP_ORDER" IS '供应商采购订单头';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."PUR_COMPANY_ID" IS '采购企业id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."PUR_COMPANY_NAME" IS '采购企业名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."PUR_COMPANY_SAP_CODE" IS '采购方sap编码';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."PUR_USER_ID" IS '采购员id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."PUR_USER_NAME" IS '采购员名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."DEPARTMENT_ID" IS '采购组织';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."DEPARTMENT_NAME" IS '采购组织名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."SUP_COMPANY_ID" IS '供应商id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."SUP_COMPANY_NAME" IS '供应企业名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."SUP_COMPANY_SAP_CODE" IS '供应商编码';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."SUP_USER_ID" IS '供应商用户id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."SUP_USER_NAME" IS '供应商用户名';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."ORDER_NO" IS '采购订单号 ';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."ORDER_TYPE" IS '订单类型';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."ORDER_STATUS" IS '确认状态：1订单未确认，2已确认，3已退回';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."ORDER_SEND_STATUS" IS '发送状态：1未发送，2已发送，3变更未发送，4变更已发送';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."ORDER_DATE" IS '采购订单生成日期';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."DELIVERY_STATUS" IS '发送状态：1未发送，2已发送，3变更未发送，4变更已发送';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."PUR_REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."CREATE_USER" IS '创建人';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."LAST_UPDATE_TIME" IS '最后更新时间';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."LAST_UPDATE_USER" IS '最后修改人';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."SEND_TIME" IS '发送供应商时间';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."TAX_RATE" IS '税率';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."TAX_AMOUNT" IS '税额';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."EXCHANGE_RATE" IS '汇率';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."AUDIT_STATUS" IS '1-审批通过，2-未审批，3-审批中，4-审批拒绝';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."IS_AUDIT" IS '审批标识 Y 已审批';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."PAY_TERMS" IS '付款条件';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."PAY_TERMS_DESC" IS '付款条件描述';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."CURRENCY" IS '币别';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."TAX_TOTAL_PRICE" IS '含税总金额';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."TOTAL_QUANTITY" IS '总数量';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."IS_ENABLE" IS '是否删除，1未删除，0删除,2冻结';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."VERSION" IS '版本';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."SUPPLIER_TEL" IS '供应商电话';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."SUPPLIER_FAX" IS '供应商传真';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."SUPPLIER_PERSON" IS '供应商联系人';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."PURCHASE_GROUP" IS '采购组';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."BILL_NAME" IS '单据名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."ADDRESS_NO" IS '地址号码';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."SALE_PERSON" IS '供应商办公室的责任销售员';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."HEAD_TXT" IS '抬头文本';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."SUP_COMPANY_SHORT_NAME" IS '供应商简称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."PUR_COMPANY_SRM_CODE" IS '采购企业srm编码';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."TAX_CODE" IS '税码';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."PUR_PLANER_ID" IS '采购方计划员id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."PUR_PLANER_NAME" IS '采购方计划员名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."PUR_PLANER_WORK_NUM" IS '计划员工号';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."IS_REFUSE_PRICE" IS '是否拒绝价格';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."IS_REFUSE_QUANTITY" IS '是否拒绝数量';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."IS_REFUSE_DELIVERED_DATE" IS '是否拒绝交期';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."INTER_TRADE_CODE" IS '国际贸易条款编码';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."INTER_TRADE_DESC" IS '国际贸易条款描述';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."RETURN_FLAG" IS '退货标识,Y为退货';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."FREE_FLAG" IS '免费标识，Y为免费，N为不免费';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."REPLY_TIME" IS '供应商回复时间';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."PURCHASE_APPLY_NO" IS '采购申请号';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."CONTRACT_NUMBER" IS '合同编号';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."ORDER_TOTAL" IS '订单总额';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."TOTAL_GROUP_ID" IS '总集团id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."TOTAL_GROUP_NAME" IS '总集团名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."ACCOUNT_SET_ID" IS '账套 id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."ACCOUNT_SET_NAME" IS '账套名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."ACCOUNT_CODE" IS '账套编码';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."INSTITUTIONS_ID" IS '机构id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."INSTITUTIONS_NAME" IS '机构名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."IN_THE_ORGANIZATION_ID" IS '中支机构id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."IN_THE_ORGANIZATION_NAME" IS '中支机构名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."DEPART_ID" IS '部门id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."DEPART_NAME" IS '部门名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."ID" IS '主键ID';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."SUP_REMARK" IS '供应商备注';
COMMENT ON COLUMN "T_BASE_SUP_ORDER"."SUP_COMPANY_SRM_CODE" IS '供应商srm编码';
ALTER TABLE "T_BASE_SUP_ORDER" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 供应商采购订单行
-- ----------------------------
CREATE TABLE "T_BASE_SUP_ORDER_ITEM" (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_USER_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_USER_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"ORDER_ID" VARCHAR2(32 BYTE) NULL ,
"ORDER_NO" VARCHAR2(255 BYTE) NULL ,
"ORDER_ITEM_NO" VARCHAR2(12 BYTE) NULL ,
"ORDER_DATE" DATE NULL ,
"MATERIAL_CATEGORY_ID" VARCHAR2(32 BYTE) NULL ,
"MATERIAL_CATEGORY_NAME" VARCHAR2(45 BYTE) NULL ,
"MATERIAL_ID" VARCHAR2(32 BYTE) NULL ,
"MATERIAL_NAME" VARCHAR2(255 BYTE) NULL ,
"MATERIAL_CODE" VARCHAR2(20 BYTE) NULL ,
"QUANTITY" NUMBER(16,3) DEFAULT 0  NULL ,
"PRICE_UNIT" VARCHAR2(15 BYTE) NULL ,
"ORDER_UNIT" VARCHAR2(50 BYTE) NULL ,
"DELIVERED_DATE" DATE NULL ,
"WAREHOUSE_LOCATION" VARCHAR2(150 BYTE) NULL ,
"WAREHOUSE_NAME" VARCHAR2(150 BYTE) NULL ,
"QUA_WAREHOUSE_QUANTITY" NUMBER(16,3) DEFAULT 0  NULL ,
"IS_UPDATED" NUMBER(11) DEFAULT 0  NULL ,
"REMARK" NCLOB NULL ,
"UPDATE_TIME" DATE NULL ,
"CURRENCY" VARCHAR2(15 BYTE) NULL ,
"PRODUCT_NO" VARCHAR2(100 BYTE) NULL ,
"IS_ENABLE" NUMBER(11) DEFAULT 1  NULL ,
"FINISH_FLAG" NCHAR(1) NULL ,
"VERSION" VARCHAR2(255 BYTE) DEFAULT 0  NULL ,
"DELIVERY_LOCATION" VARCHAR2(255 BYTE) NULL ,
"PURCHASE_GROUP" VARCHAR2(255 BYTE) NULL ,
"CHANGE_AMOUNT" NUMBER(12) DEFAULT 0  NULL ,
"SALE_ORDER_MODEL" VARCHAR2(255 BYTE) NULL ,
"SHORT_TXT" VARCHAR2(255 BYTE) NULL ,
"INDUSTRY_STANDARD" VARCHAR2(255 BYTE) NULL ,
"FACTORY" VARCHAR2(255 BYTE) NULL ,
"SUP_MATERIAL_CODE" VARCHAR2(255 BYTE) NULL ,
"BRAND" VARCHAR2(255 BYTE) NULL ,
"FACTORY_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) NULL ,
"ORDER_STATUS" NUMBER(11) DEFAULT 1  NULL ,
"PUR_REMARK" VARCHAR2(255 BYTE) DEFAULT NULL  NULL ,
"SUP_REMARK" VARCHAR2(255 BYTE) DEFAULT NULL  NULL ,
"SUP_MATERIAL_DESC" VARCHAR2(255 CHAR) NULL ,
"HAVE_CHANGE" NUMBER(2) NULL ,
"DELIVERY_MATERIAL_NAME" VARCHAR2(255 BYTE) NULL ,
"FREEZE_QUANTITY" NUMBER(11,3) DEFAULT 0  NULL ,
"SUP_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) NULL ,
"ALREADY_APPLY_MONEY" NUMBER(20,4) NULL ,
"AVAILABLE_APPLY_MONEY" NUMBER(20,4) NULL ,
"SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_REQ_NO" VARCHAR2(80 BYTE) NULL ,
"PUR_REQ_ITEM_NO" VARCHAR2(80 BYTE) NULL ,
"QUOTE_ORDER_NO" VARCHAR2(255 BYTE) NULL ,
"QUOTE_ORDER_ITEM_NO" VARCHAR2(255 BYTE) NULL ,
"IS_OFFICIAL_PRICE" NUMBER(1) NULL ,
"RETURN_FLAG" VARCHAR2(255 BYTE) NULL ,
"BOM_DESC" VARCHAR2(255 BYTE) NULL ,
"MASTER_ORDER_NO" VARCHAR2(255 BYTE) NULL ,
"MASTER_ORDER_ITEM_NO" VARCHAR2(255 BYTE) NULL ,
"ORDER_TYPE" VARCHAR2(11 BYTE) NULL ,
"FREEZE_FLAG" NUMBER(1) NULL ,
"IS_JIT" NUMBER(1) NULL ,
"IS_REFUSE_QUANTITY" NUMBER(1) NULL ,
"IS_REFUSE_PRICE" NUMBER(1) NULL ,
"IS_REFUSE_DELIVERED_DATE" NUMBER(1) NULL ,
"TAX_CODE" VARCHAR2(255 BYTE) NULL ,
"TAX_RATE" NUMBER(16,6) NULL ,
"TAX_UNIT_PRICE" NUMBER(16,3) DEFAULT 0  NULL ,
"UNTAX_UNIT_PRICE" NUMBER(16,3) DEFAULT 0  NULL ,
"UNTAX_TOTAL_PRICE" NUMBER(16,3) DEFAULT 0  NULL ,
"TAX_TOTAL_PRICE" NUMBER(16,3) NULL ,
"MATERIAL_UNIT_PRICE" NUMBER(16,3) NULL ,
"MATERIAL_TOTAL_PIRCE" NUMBER(16,3) NULL ,
"TOTAL_PRICE" NUMBER(16,3) NULL ,
"PUR_PLANER_ID" VARCHAR2(32 BYTE) NULL ,
"IS_CAN_DELIVERY" NUMBER(1) NULL ,
"FREE_FLAG" VARCHAR2(255 BYTE) NULL ,
"ORDER_NO_TYPE" VARCHAR2(255 BYTE) NULL ,
"PUR_PLANER_NAME" VARCHAR2(255 BYTE) NULL ,
"BUDGET_CORE" VARCHAR2(255) NULL,
"ECONOMIC_MATTERS" VARCHAR2(255) NULL,
"USES" VARCHAR2(255) NULL,
"WAREHOUSE_CODE" VARCHAR2(32) NULL,
"TOTAL_GROUP_ID" VARCHAR2(32) NULL,
"TOTAL_GROUP_NAME" VARCHAR2(255) NULL,
"ACCOUNT_SET_ID" VARCHAR2(32) NULL,
"ACCOUNT_SET_NAME" VARCHAR2(255) NULL,
"ACCOUNT_CODE" VARCHAR2(255) NULL,
"INSTITUTIONS_ID" VARCHAR2(32) NULL,
"INSTITUTIONS_NAME" VARCHAR2(255) NULL,
"IN_THE_ORGANIZATION_ID" VARCHAR2(32) NULL,
"IN_THE_ORGANIZATION_NAME" VARCHAR2(255) NULL,
"DEPART_ID" VARCHAR2(32) NULL,
"DEPART_NAME" VARCHAR2(255) NULL
);
COMMENT ON TABLE "T_BASE_SUP_ORDER_ITEM" IS '供应商采购订单行';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."ID" IS 'ID';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."PUR_COMPANY_ID" IS '采购企业id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."PUR_COMPANY_NAME" IS '采购企业名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."PUR_USER_NAME" IS '采购员名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."PUR_USER_ID" IS '采购员id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."SUP_COMPANY_ID" IS '供应商id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."SUP_COMPANY_NAME" IS '供应企业名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."SUP_USER_ID" IS '供应员id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."SUP_USER_NAME" IS '供应员id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."ORDER_ID" IS '订单id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."ORDER_NO" IS '采购凭证号 ';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."ORDER_ITEM_NO" IS '采购凭证的项目编号 ';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."ORDER_DATE" IS '采购凭证日期';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."MATERIAL_CATEGORY_ID" IS '物料组id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."MATERIAL_CATEGORY_NAME" IS '物料组名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."MATERIAL_NAME" IS '物料名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."MATERIAL_CODE" IS '物料号 (客户端物料编码)';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."QUANTITY" IS '采购订单数量';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."PRICE_UNIT" IS '价格单位';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."ORDER_UNIT" IS '订单单位';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."DELIVERED_DATE" IS '交货日期';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."WAREHOUSE_LOCATION" IS '仓库地点';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."WAREHOUSE_NAME" IS '仓库名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."QUA_WAREHOUSE_QUANTITY" IS '待检入库数量';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."IS_UPDATED" IS '是否被修改过，0没有，1已修改';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."UPDATE_TIME" IS '更新日期';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."CURRENCY" IS '币别';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."PRODUCT_NO" IS '品号';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."IS_ENABLE" IS '是否删除或冻结，1未删除，0删除,2已经冻结';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."FINISH_FLAG" IS '交货已完成标识,Y完成';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."VERSION" IS '版本';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."DELIVERY_LOCATION" IS '交货地点';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."PURCHASE_GROUP" IS '采购组';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."CHANGE_AMOUNT" IS '变更数量（预留）';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."SALE_ORDER_MODEL" IS '销售单机型';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."SHORT_TXT" IS '短文本';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."INDUSTRY_STANDARD" IS '行业标准';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."FACTORY" IS '工厂';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."SUP_MATERIAL_CODE" IS '供应商物料号';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."BRAND" IS '品牌';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."FACTORY_NAME" IS '工厂名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."PUR_COMPANY_SRM_CODE" IS '采购公司编码';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."PUR_COMPANY_SAP_CODE" IS 'sap公司代码';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."ORDER_STATUS" IS '确认状态：1订单未确认，2已确认，3已退回';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."PUR_REMARK" IS '采购备注';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."SUP_REMARK" IS '供应商备注';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."SUP_MATERIAL_DESC" IS '供应商物料描述';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."HAVE_CHANGE" IS '订单是否有更改：0未更改，1更改';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."DELIVERY_MATERIAL_NAME" IS '发货物料名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."FREEZE_QUANTITY" IS '冻结数量';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."SUP_COMPANY_SAP_CODE" IS '供应商SAP编码';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."ALREADY_APPLY_MONEY" IS '已申请金额';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."AVAILABLE_APPLY_MONEY" IS '可申请金额';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."SUP_COMPANY_SRM_CODE" IS '供应商srm编码';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."PUR_REQ_NO" IS '采购申请单号';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."PUR_REQ_ITEM_NO" IS '采购申请单行号';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."IS_OFFICIAL_PRICE" IS '是否正式价格，1是，0否';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."RETURN_FLAG" IS '退货标识';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."BOM_DESC" IS 'BOM文本描述';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."MASTER_ORDER_NO" IS '总控订单号';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."MASTER_ORDER_ITEM_NO" IS '总控订单行号';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."ORDER_TYPE" IS '订单类型';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."FREEZE_FLAG" IS '冻结标识';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."IS_JIT" IS '是否jit物料1是，0否';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."IS_REFUSE_QUANTITY" IS '是否拒绝数量';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."IS_REFUSE_PRICE" IS '是否拒绝价格';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."IS_REFUSE_DELIVERED_DATE" IS '是否拒绝交期';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."TAX_CODE" IS '税码';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."TAX_RATE" IS '税率';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."TAX_UNIT_PRICE" IS '含税单价';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."UNTAX_UNIT_PRICE" IS '不含税单价';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."UNTAX_TOTAL_PRICE" IS '不含税金额';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."TAX_TOTAL_PRICE" IS '价税合计';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."MATERIAL_UNIT_PRICE" IS '材料单价(含税)';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."MATERIAL_TOTAL_PIRCE" IS '材料金额(含税)';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."TOTAL_PRICE" IS '总价';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."PUR_PLANER_ID" IS '采购方计划员id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."IS_CAN_DELIVERY" IS '是否可发货，1可发货，0不可发货';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."FREE_FLAG" IS '免费标识，Y为免费，N为不免费';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."ORDER_NO_TYPE" IS '采购订单类型';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."PUR_PLANER_NAME" IS '采购方计划员名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."BUDGET_CORE" IS '预算中心';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."ECONOMIC_MATTERS" IS '经济事项';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."USES" IS '用途';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."WAREHOUSE_CODE" IS '仓库编码';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."TOTAL_GROUP_ID" IS '总集团id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."TOTAL_GROUP_NAME" IS '总集团名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."ACCOUNT_SET_ID" IS '账套 id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."ACCOUNT_SET_NAME" IS '账套名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."ACCOUNT_CODE" IS '账套编码';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."INSTITUTIONS_ID" IS '机构id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."INSTITUTIONS_NAME" IS '机构名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."IN_THE_ORGANIZATION_ID" IS '中支机构id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."IN_THE_ORGANIZATION_NAME" IS '中支机构名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."DEPART_ID" IS '部门id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."DEPART_NAME" IS '部门名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."MATERIAL_ID" IS '物料ID';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."QUOTE_ORDER_NO" IS '引用单号';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM"."QUOTE_ORDER_ITEM_NO" IS '引用单行号';
ALTER TABLE "T_BASE_SUP_ORDER_ITEM" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 采购方订单头历史数据
-- ----------------------------
CREATE TABLE "T_BASE_PUR_ORDER_HIS" (
"ID" VARCHAR2(50 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(50 BYTE) NULL ,
"PUR_COMPANY_ID" VARCHAR2(50 BYTE) NULL ,
"PUR_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_SAP_CODE" VARCHAR2(50 BYTE) NULL ,
"PUR_USER_ID" VARCHAR2(50 BYTE) NULL ,
"PUR_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"DEPARTMENT_ID" VARCHAR2(50 BYTE) NULL ,
"DEPARTMENT_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_ID" VARCHAR2(50 BYTE) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_SAP_CODE" VARCHAR2(60 BYTE) NULL ,
"SUP_USER_ID" VARCHAR2(50 BYTE) NULL ,
"SUP_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"ORDER_NO" VARCHAR2(255 BYTE) NOT NULL ,
"ORDER_TYPE" VARCHAR2(11 BYTE) NULL ,
"ORDER_STATUS" NUMBER(11) NULL ,
"ORDER_SEND_STATUS" NUMBER(11) NULL ,
"ORDER_DATE" DATE NULL ,
"DELIVERY_STATUS" NUMBER(11) NULL ,
"PUR_REMARK" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
"SUP_REMARK" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"CREATE_USER" VARCHAR2(50 BYTE) NULL ,
"LAST_UPDATE_TIME" DATE DEFAULT sysdate  NULL ,
"LAST_UPDATE_USER" VARCHAR2(50 BYTE) NULL ,
"SEND_TIME" DATE NULL ,
"TAX_RATE" NUMBER(11,6) NULL ,
"TAX_AMOUNT" NUMBER(11,3) NULL ,
"EXCHANGE_RATE" VARCHAR2(50 BYTE) NULL ,
"AUDIT_STATUS" NUMBER(11) NULL ,
"IS_AUDIT" NCHAR(1) NULL ,
"PAY_TERMS" VARCHAR2(50 BYTE) NULL ,
"PAY_TERMS_DESC" VARCHAR2(255 BYTE) NULL ,
"CURRENCY" VARCHAR2(255 BYTE) NULL ,
"TAX_TOTAL_PRICE" NUMBER(11,3) DEFAULT 0  NULL ,
"TOTAL_QUANTITY" NUMBER(11,3) DEFAULT 0  NULL ,
"IS_ENABLE" NUMBER(11) DEFAULT 1  NULL ,
"VERSION" VARCHAR2(255 BYTE) DEFAULT 0  NULL ,
"SUPPLIER_TEL" VARCHAR2(255 BYTE) NULL ,
"SUPPLIER_FAX" VARCHAR2(255 BYTE) NULL ,
"SUPPLIER_PERSON" VARCHAR2(255 BYTE) NULL ,
"PURCHASE_GROUP" VARCHAR2(255 BYTE) NULL ,
"BILL_NAME" VARCHAR2(255 BYTE) NULL ,
"ADDRESS_NO" VARCHAR2(255 BYTE) NULL ,
"SALE_PERSON" VARCHAR2(255 BYTE) NULL ,
"HEAD_TXT" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_SHORT_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"TAX_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_PLANER_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_PLANER_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_PLANER_WORK_NUM" VARCHAR2(255 BYTE) NULL ,
"HIS_ID" VARCHAR2(32 BYTE) NOT NULL ,
"CAUSE" VARCHAR2(255 BYTE) NULL ,
"HIS_TIME" DATE NULL ,
"IS_REFUSE_PRICE" NUMBER(1) NULL ,
"IS_REFUSE_QUANTITY" NUMBER(1) NULL ,
"IS_REFUSE_DELIVERED_DATE" NUMBER(1) NULL ,
"INTER_TRADE_CODE" VARCHAR2(255 BYTE) NULL ,
"INTER_TRADE_DESC" VARCHAR2(255 BYTE) NULL ,
"RETURN_FLAG" VARCHAR2(255 BYTE) NULL ,
"FREE_FLAG" VARCHAR2(255 BYTE) NULL ,
"REPLY_TIME" DATE NULL ,
"PURCHASE_APPLY_NO" VARCHAR2(255) NULL,
"CONTRACT_NUMBER" VARCHAR2(255) NULL,
"ORDER_TOTAL" NUMBER(20,3) NULL,
"TOTAL_GROUP_ID" VARCHAR2(32) NULL,
"TOTAL_GROUP_NAME" VARCHAR2(255) NULL,
"ACCOUNT_SET_ID" VARCHAR2(32) NULL,
"ACCOUNT_SET_NAME" VARCHAR2(255) NULL,
"ACCOUNT_CODE" VARCHAR2(255) NULL,
"INSTITUTIONS_ID" VARCHAR2(32) NULL,
"INSTITUTIONS_NAME" VARCHAR2(255) NULL,
"IN_THE_ORGANIZATION_ID" VARCHAR2(32) NULL,
"IN_THE_ORGANIZATION_NAME" VARCHAR2(255) NULL,
"DEPART_ID" VARCHAR2(32) NULL,
"DEPART_NAME" VARCHAR2(255) NULL
);
COMMENT ON TABLE "T_BASE_PUR_ORDER_HIS" IS '采购方订单头';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."PUR_COMPANY_ID" IS '采购企业id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."PUR_COMPANY_NAME" IS '采购企业名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."PUR_COMPANY_SAP_CODE" IS '采购方sap编码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."PUR_USER_ID" IS '采购员id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."PUR_USER_NAME" IS '采购员名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."DEPARTMENT_ID" IS '采购组织';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."DEPARTMENT_NAME" IS '采购组织名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."SUP_COMPANY_ID" IS '供应商id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."SUP_COMPANY_NAME" IS '供应企业名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."SUP_COMPANY_SAP_CODE" IS '供应商编码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."SUP_USER_ID" IS '供应商用户id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."SUP_USER_NAME" IS '供应商用户名';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."ORDER_NO" IS '采购订单号 ';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."ORDER_TYPE" IS '订单类型';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."ORDER_STATUS" IS '确认状态：1订单未确认，2已确认，3已退回';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."ORDER_SEND_STATUS" IS '发送状态：1未发送，2已发送，3变更未发送，4变更已发送';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."ORDER_DATE" IS '采购订单生成日期';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."DELIVERY_STATUS" IS '发送状态：1未发送，2已发送，3变更未发送，4变更已发送';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."PUR_REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."CREATE_USER" IS '创建人';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."LAST_UPDATE_TIME" IS '最后更新时间';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."LAST_UPDATE_USER" IS '最后修改人';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."SEND_TIME" IS '发送供应商时间';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."TAX_RATE" IS '税率';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."TAX_AMOUNT" IS '税额';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."EXCHANGE_RATE" IS '汇率';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."AUDIT_STATUS" IS '1-审批通过，2-未审批，3-审批中，4-审批拒绝';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."IS_AUDIT" IS '审批标识 Y 已审批';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."PAY_TERMS" IS '付款条件';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."PAY_TERMS_DESC" IS '付款条件描述';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."CURRENCY" IS '币别';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."TAX_TOTAL_PRICE" IS '含税总金额';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."TOTAL_QUANTITY" IS '总数量';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."IS_ENABLE" IS '是否删除，1未删除，0删除,2冻结';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."VERSION" IS '版本';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."SUPPLIER_TEL" IS '供应商电话';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."SUPPLIER_FAX" IS '供应商传真';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."SUPPLIER_PERSON" IS '供应商联系人';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."PURCHASE_GROUP" IS '采购组';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."BILL_NAME" IS '单据名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."ADDRESS_NO" IS '地址号码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."SALE_PERSON" IS '供应商办公室的责任销售员';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."HEAD_TXT" IS '抬头文本';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."SUP_COMPANY_SHORT_NAME" IS '供应商简称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."PUR_COMPANY_SRM_CODE" IS '采购企业srm编码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."TAX_CODE" IS '税码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."PUR_PLANER_ID" IS '采购方计划员id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."PUR_PLANER_NAME" IS '采购方计划员名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."PUR_PLANER_WORK_NUM" IS '计划员工号';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."CAUSE" IS '操作原因';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."HIS_TIME" IS '备份时间';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."IS_REFUSE_PRICE" IS '是否拒绝价格';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."IS_REFUSE_QUANTITY" IS '是否拒绝数量';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."IS_REFUSE_DELIVERED_DATE" IS '是否拒绝交期';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."INTER_TRADE_CODE" IS '国际贸易条款编码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."INTER_TRADE_DESC" IS '国际贸易条款描述';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."RETURN_FLAG" IS '退货标识,Y为退货';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."FREE_FLAG" IS '免费标识，Y为免费，N为不免费';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."REPLY_TIME" IS '供应商回复时间';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."PURCHASE_APPLY_NO" IS '采购申请号';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."CONTRACT_NUMBER" IS '合同编号';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."ORDER_TOTAL" IS '订单总额';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."TOTAL_GROUP_ID" IS '总集团id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."TOTAL_GROUP_NAME" IS '总集团名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."ACCOUNT_SET_ID" IS '账套 id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."ACCOUNT_SET_NAME" IS '账套名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."ACCOUNT_CODE" IS '账套编码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."INSTITUTIONS_ID" IS '机构id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."INSTITUTIONS_NAME" IS '机构名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."IN_THE_ORGANIZATION_ID" IS '中支机构id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."IN_THE_ORGANIZATION_NAME" IS '中支机构名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."DEPART_ID" IS '部门id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."DEPART_NAME" IS '部门名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."ID" IS 'ID';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."SUP_REMARK" IS '供应商备注';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."SUP_COMPANY_SRM_CODE" IS '供应商srm编码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."HIS_ID" IS '历史数据ID';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."PURCHASE_APPLY_NO" IS '采购申请单号';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."CONTRACT_NUMBER" IS '合同编号';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_HIS"."ORDER_TOTAL" IS '订单数量';

ALTER TABLE "T_BASE_PUR_ORDER_HIS" ADD PRIMARY KEY ("HIS_ID");


-- ----------------------------
-- 采购订单行历史数据
-- ----------------------------
CREATE TABLE "T_BASE_PUR_ORDER_ITEM_HIS" (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_USER_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_USER_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"ORDER_ID" VARCHAR2(32 BYTE) NULL ,
"ORDER_NO" VARCHAR2(255 BYTE) NULL ,
"ORDER_ITEM_NO" VARCHAR2(12 BYTE) NULL ,
"ORDER_DATE" DATE NULL ,
"MATERIAL_CATEGORY_ID" VARCHAR2(32 BYTE) NULL ,
"MATERIAL_CATEGORY_NAME" VARCHAR2(45 BYTE) NULL ,
"MATERIAL_ID" VARCHAR2(32 BYTE) NULL ,
"MATERIAL_NAME" VARCHAR2(255 BYTE) NULL ,
"MATERIAL_CODE" VARCHAR2(20 BYTE) NULL ,
"QUANTITY" NUMBER(20,3) DEFAULT 0  NULL ,
"PRICE_UNIT" VARCHAR2(15 BYTE) NULL ,
"ORDER_UNIT" VARCHAR2(50 BYTE) NULL ,
"DELIVERED_DATE" DATE NULL ,
"WAREHOUSE_LOCATION" VARCHAR2(150 BYTE) NULL ,
"WAREHOUSE_NAME" VARCHAR2(150 BYTE) NULL ,
"QUA_WAREHOUSE_QUANTITY" NUMBER(20,3) DEFAULT 0  NULL ,
"IS_UPDATED" NUMBER(11) DEFAULT 0  NULL ,
"REMARK" NCLOB NULL ,
"UPDATE_TIME" DATE NULL ,
"CURRENCY" VARCHAR2(15 BYTE) NULL ,
"PRODUCT_NO" VARCHAR2(100 BYTE) NULL ,
"IS_ENABLE" NUMBER(11) DEFAULT 1  NULL ,
"FINISH_FLAG" NCHAR(1) NULL ,
"VERSION" VARCHAR2(255 BYTE) DEFAULT 0  NULL ,
"DELIVERY_LOCATION" VARCHAR2(255 BYTE) NULL ,
"PURCHASE_GROUP" VARCHAR2(255 BYTE) NULL ,
"CHANGE_AMOUNT" NUMBER(12) DEFAULT 0  NULL ,
"SALE_ORDER_MODEL" VARCHAR2(255 BYTE) NULL ,
"SHORT_TXT" VARCHAR2(255 BYTE) NULL ,
"INDUSTRY_STANDARD" VARCHAR2(255 BYTE) NULL ,
"FACTORY" VARCHAR2(255 BYTE) NULL ,
"SUP_MATERIAL_CODE" VARCHAR2(255 BYTE) NULL ,
"BRAND" VARCHAR2(255 BYTE) NULL ,
"FACTORY_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) NULL ,
"ORDER_STATUS" NUMBER(11) DEFAULT 1  NULL ,
"PUR_REMARK" VARCHAR2(255 BYTE) DEFAULT NULL  NULL ,
"SUP_REMARK" VARCHAR2(255 BYTE) DEFAULT NULL  NULL ,
"SUP_MATERIAL_DESC" VARCHAR2(255 CHAR) NULL ,
"HAVE_CHANGE" NUMBER(2) NULL ,
"DELIVERY_MATERIAL_NAME" VARCHAR2(255 BYTE) NULL ,
"FREEZE_QUANTITY" NUMBER(20,3) DEFAULT 0  NULL ,
"SUP_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) NULL ,
"ALREADY_APPLY_MONEY" NUMBER(20,4) NULL ,
"AVAILABLE_APPLY_MONEY" NUMBER(20,4) NULL ,
"SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_REQ_NO" VARCHAR2(80 BYTE) NULL ,
"PUR_REQ_ITEM_NO" VARCHAR2(80 BYTE) NULL ,
"QUOTE_ORDER_NO" VARCHAR2(255 BYTE) NULL ,
"QUOTE_ORDER_ITEM_NO" VARCHAR2(255 BYTE) NULL ,
"IS_OFFICIAL_PRICE" NUMBER(1) NULL ,
"RETURN_FLAG" VARCHAR2(255 BYTE) NULL ,
"BOM_DESC" VARCHAR2(255 BYTE) NULL ,
"MASTER_ORDER_NO" VARCHAR2(255 BYTE) NULL ,
"MASTER_ORDER_ITEM_NO" VARCHAR2(255 BYTE) NULL ,
"ORDER_TYPE" VARCHAR2(11 BYTE) NULL ,
"FREEZE_FLAG" NUMBER(1) NULL ,
"IS_JIT" NUMBER(1) NULL ,
"IS_REFUSE_QUANTITY" NUMBER(1) NULL ,
"IS_REFUSE_PRICE" NUMBER(1) NULL ,
"IS_REFUSE_DELIVERED_DATE" NUMBER(1) NULL ,
"TAX_CODE" VARCHAR2(255 BYTE) NULL ,
"TAX_RATE" NUMBER(20,6) NULL ,
"TAX_UNIT_PRICE" NUMBER(20,3) DEFAULT 0  NULL ,
"UNTAX_UNIT_PRICE" NUMBER(20,3) DEFAULT 0  NULL ,
"UNTAX_TOTAL_PRICE" NUMBER(20,3) DEFAULT 0  NULL ,
"TAX_TOTAL_PRICE" NUMBER(20,3) NULL ,
"MATERIAL_UNIT_PRICE" NUMBER(20,3) NULL ,
"MATERIAL_TOTAL_PIRCE" NUMBER(20,3) NULL ,
"TOTAL_PRICE" NUMBER(20,3) NULL ,
"PUR_PLANER_ID" VARCHAR2(32 BYTE) NULL ,
"IS_CAN_DELIVERY" NUMBER(1) NULL ,
"ORDER_HIS_ID" VARCHAR2(32 BYTE) NOT NULL ,
"CAUSE" VARCHAR2(255 BYTE) NULL ,
"HIS_TIME" DATE NULL ,
"FREE_FLAG" VARCHAR2(255 BYTE) NULL ,
"ORDER_NO_TYPE" VARCHAR2(255 BYTE) NULL ,
"PUR_PLANER_NAME" VARCHAR2(255 BYTE) NULL ,
"BUDGET_CORE" VARCHAR2(255) NULL,
"ECONOMIC_MATTERS" VARCHAR2(255) NULL,
"USES" VARCHAR2(255) NULL,
"WAREHOUSE_CODE" VARCHAR2(32) NULL,
"TOTAL_GROUP_ID" VARCHAR2(32) NULL,
"TOTAL_GROUP_NAME" VARCHAR2(255) NULL,
"ACCOUNT_SET_ID" VARCHAR2(32) NULL,
"ACCOUNT_SET_NAME" VARCHAR2(255) NULL,
"ACCOUNT_CODE" VARCHAR2(255) NULL,
"INSTITUTIONS_ID" VARCHAR2(32) NULL,
"INSTITUTIONS_NAME" VARCHAR2(255) NULL,
"IN_THE_ORGANIZATION_ID" VARCHAR2(32) NULL,
"IN_THE_ORGANIZATION_NAME" VARCHAR2(255) NULL,
"DEPART_ID" VARCHAR2(32) NULL,
"DEPART_NAME" VARCHAR2(255) NULL,
"BUDGET_CORE_DESC" VARCHAR2(255) NULL,
"ECONOMIC_MATTERS_DESC" VARCHAR2(255) NULL
);
COMMENT ON TABLE "T_BASE_PUR_ORDER_ITEM_HIS" IS '采购订单行';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."ID" IS 'ID';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."PUR_COMPANY_ID" IS '采购企业id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."PUR_COMPANY_NAME" IS '采购企业名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."PUR_USER_NAME" IS '采购员名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."PUR_USER_ID" IS '采购员id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."SUP_COMPANY_ID" IS '供应商id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."SUP_COMPANY_NAME" IS '供应企业名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."SUP_USER_ID" IS '供应员id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."SUP_USER_NAME" IS '供应员id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."ORDER_ID" IS '订单id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."ORDER_NO" IS '采购凭证号 ';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."ORDER_ITEM_NO" IS '采购凭证的项目编号 ';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."ORDER_DATE" IS '采购凭证日期';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."MATERIAL_CATEGORY_ID" IS '物料组id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."MATERIAL_CATEGORY_NAME" IS '物料组名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."MATERIAL_NAME" IS '物料名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."MATERIAL_CODE" IS '物料号 (客户端物料编码)';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."QUANTITY" IS '采购订单数量';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."PRICE_UNIT" IS '价格单位';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."ORDER_UNIT" IS '订单单位';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."DELIVERED_DATE" IS '交货日期';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."WAREHOUSE_LOCATION" IS '仓库地点';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."WAREHOUSE_NAME" IS '仓库名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."QUA_WAREHOUSE_QUANTITY" IS '待检入库数量';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."IS_UPDATED" IS '是否被修改过，0没有，1已修改';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."UPDATE_TIME" IS '更新日期';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."CURRENCY" IS '币别';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."PRODUCT_NO" IS '品号';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."IS_ENABLE" IS '是否删除或冻结，1未删除，0删除,2已经冻结';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."FINISH_FLAG" IS '交货已完成标识,Y完成';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."VERSION" IS '版本';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."DELIVERY_LOCATION" IS '交货地点';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."PURCHASE_GROUP" IS '采购组';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."CHANGE_AMOUNT" IS '变更数量（预留）';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."SALE_ORDER_MODEL" IS '销售单机型';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."SHORT_TXT" IS '短文本';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."INDUSTRY_STANDARD" IS '行业标准';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."FACTORY" IS '工厂';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."SUP_MATERIAL_CODE" IS '供应商物料号';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."BRAND" IS '品牌';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."FACTORY_NAME" IS '工厂名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."PUR_COMPANY_SRM_CODE" IS '采购公司编码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."PUR_COMPANY_SAP_CODE" IS 'sap公司代码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."ORDER_STATUS" IS '确认状态：1订单未确认，2已确认，3已退回';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."PUR_REMARK" IS '采购备注';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."SUP_REMARK" IS '供应商备注';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."SUP_MATERIAL_DESC" IS '供应商物料描述';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."HAVE_CHANGE" IS '订单是否有更改：0未更改，1更改';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."DELIVERY_MATERIAL_NAME" IS '发货物料名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."FREEZE_QUANTITY" IS '冻结数量';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."SUP_COMPANY_SAP_CODE" IS '供应商SAP编码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."ALREADY_APPLY_MONEY" IS '已申请金额';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."AVAILABLE_APPLY_MONEY" IS '可申请金额';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."SUP_COMPANY_SRM_CODE" IS '供应商srm编码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."PUR_REQ_NO" IS '采购申请单号';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."PUR_REQ_ITEM_NO" IS '采购申请单行号';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."IS_OFFICIAL_PRICE" IS '是否正式价格，1是，0否';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."RETURN_FLAG" IS '退货标识';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."BOM_DESC" IS 'BOM文本描述';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."MASTER_ORDER_NO" IS '总控订单号';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."MASTER_ORDER_ITEM_NO" IS '总控订单行号';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."ORDER_TYPE" IS '订单类型';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."FREEZE_FLAG" IS '冻结标识';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."IS_JIT" IS '是否jit物料1是，0否';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."IS_REFUSE_QUANTITY" IS '是否拒绝数量';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."IS_REFUSE_PRICE" IS '是否拒绝价格';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."IS_REFUSE_DELIVERED_DATE" IS '是否拒绝交期';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."TAX_CODE" IS '税码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."TAX_RATE" IS '税率';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."TAX_UNIT_PRICE" IS '含税单价';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."UNTAX_UNIT_PRICE" IS '不含税单价';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."UNTAX_TOTAL_PRICE" IS '不含税金额';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."TAX_TOTAL_PRICE" IS '价税合计';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."MATERIAL_UNIT_PRICE" IS '材料单价(含税)';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."MATERIAL_TOTAL_PIRCE" IS '材料金额(含税)';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."TOTAL_PRICE" IS '总价';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."PUR_PLANER_ID" IS '采购方计划员id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."IS_CAN_DELIVERY" IS '是否可发货，1可发货，0不可发货';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."ORDER_HIS_ID" IS '历史订单Id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."CAUSE" IS '变更原因';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."HIS_TIME" IS '备份时间';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."FREE_FLAG" IS '免费标识，Y为免费，N为不免费';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."ORDER_NO_TYPE" IS '采购订单类型';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."PUR_PLANER_NAME" IS '采购方计划员名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."BUDGET_CORE" IS '预算中心';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."ECONOMIC_MATTERS" IS '经济事项';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."USES" IS '用途';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."WAREHOUSE_CODE" IS '仓库编码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."TOTAL_GROUP_ID" IS '总集团id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."TOTAL_GROUP_NAME" IS '总集团名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."ACCOUNT_SET_ID" IS '账套 id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."ACCOUNT_SET_NAME" IS '账套名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."ACCOUNT_CODE" IS '账套编码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."INSTITUTIONS_ID" IS '机构id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."INSTITUTIONS_NAME" IS '机构名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."IN_THE_ORGANIZATION_ID" IS '中支机构id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."IN_THE_ORGANIZATION_NAME" IS '中支机构名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."DEPART_ID" IS '部门id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."DEPART_NAME" IS '部门名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."BUDGET_CORE_DESC" IS '预算中心描述';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."ECONOMIC_MATTERS_DESC" IS '经济事项描述';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."MATERIAL_ID" IS '物料ID';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."QUOTE_ORDER_NO" IS '引用单号';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."QUOTE_ORDER_ITEM_NO" IS '引用单行号';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."BUDGET_CORE" IS '预算编号';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."ECONOMIC_MATTERS" IS '经济事项';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_HIS"."USES" IS '用途';
ALTER TABLE "T_BASE_PUR_ORDER_ITEM_HIS" ADD PRIMARY KEY ("ID");



-- ----------------------------
-- 发货单头
-- ----------------------------
CREATE TABLE "T_BASE_DELIVERY_ORDER" (
"ID" NVARCHAR2(50) NOT NULL ,
"PROJECT_ID" NVARCHAR2(32) NULL ,
"COMPANY_ID" NVARCHAR2(32) NULL ,
"COMPANY_NAME" NVARCHAR2(255) NULL ,
"USER_NAME" NVARCHAR2(255) NULL ,
"USER_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_NAME" NVARCHAR2(255) NULL ,
"PUR_USER_ID" NVARCHAR2(32) NULL ,
"PUR_USER_NAME" NVARCHAR2(255) NULL ,
"LOGISTIC_ORDER_NO" NVARCHAR2(50) NULL ,
"DELIVERY_ORDER_NO" NVARCHAR2(50) NOT NULL ,
"DELIVERY_ORDER_TIME" DATE NULL ,
"DELIVERY_DATE" DATE NULL ,
"DELIVERY_STATUS" NUMBER(11) DEFAULT 1  NULL ,
"RECEIVE_DATE" DATE NULL ,
"COMPANY_CODE" NVARCHAR2(100) NULL ,
"PURCHASE_ORDER_ID" NVARCHAR2(500) NULL ,
"ID_CARD" NVARCHAR2(255) NULL ,
"CAR" NVARCHAR2(255) NULL ,
"DRIVER_NAME" NVARCHAR2(255) NULL ,
"EXPECT_DELIVERY_TIME" DATE NULL ,
"EXPECT_ARRIVE_TIME" DATE NULL ,
"INVOICE_NO" NVARCHAR2(255) NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"LAST_UPDATE_TIME" DATE DEFAULT sysdate  NULL ,
"LAST_UPDATE_USER" NVARCHAR2(255) NULL ,
"PUR_COMPANY_CODE" NVARCHAR2(255) NULL ,
"OUT_FACTORY_TIME" DATE NULL ,
"GATE_SCAN_TIME" DATE NULL ,
"TYPE" NVARCHAR2(255) NULL ,
"IS_HK" NUMBER(11) DEFAULT 1  NOT NULL ,
"ITEM_TYPE" VARCHAR2(255 BYTE) NULL ,
"EXPRESS_COMPANY" VARCHAR2(255 BYTE) NULL ,
"EXPRESS_NUMBER" VARCHAR2(255 BYTE) NULL ,
"IS_ENABLE" NUMBER(10) NULL ,
"VOUCHER_TYPE" VARCHAR2(255 BYTE) NULL ,
"PURCHASE_ORDER_NO" VARCHAR2(255 BYTE) NULL ,
"FACTORY_CODE" NVARCHAR2(45) NULL ,
"FACTORY_NAME" NVARCHAR2(45) NULL ,
"TOTAL_GROUP_ID" VARCHAR2(32) NULL,
"TOTAL_GROUP_NAME" VARCHAR2(255) NULL,
"ACCOUNT_SET_ID" VARCHAR2(32) NULL,
"ACCOUNT_SET_NAME" VARCHAR2(255) NULL,
"ACCOUNT_CODE" VARCHAR2(255) NULL,
"INSTITUTIONS_ID" VARCHAR2(32) NULL,
"INSTITUTIONS_NAME" VARCHAR2(255) NULL,
"IN_THE_ORGANIZATION_ID" VARCHAR2(32) NULL,
"IN_THE_ORGANIZATION_NAME" VARCHAR2(255) NULL,
"DEPART_ID" VARCHAR2(32) NULL,
"DEPART_NAME" VARCHAR2(255) NULL
);
COMMENT ON TABLE "T_BASE_DELIVERY_ORDER" IS '发货单头';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."COMPANY_ID" IS '供应商企业id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."COMPANY_NAME" IS '供应商企业名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."USER_NAME" IS '销售方负责人';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."USER_ID" IS '供应商id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."PUR_COMPANY_ID" IS '采购员公司id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."PUR_COMPANY_NAME" IS '客户名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."PUR_USER_ID" IS '采购员id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."PUR_USER_NAME" IS '采购负责人';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."LOGISTIC_ORDER_NO" IS '物流单号';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."DELIVERY_ORDER_NO" IS '送货单号';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."DELIVERY_ORDER_TIME" IS '送货单生成时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."DELIVERY_DATE" IS '送货日期';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."DELIVERY_STATUS" IS '发货状态:1 未发货，2 在途，3收货,4 香港到货';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."RECEIVE_DATE" IS '仓库收货';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."COMPANY_CODE" IS '供应商编码';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."PURCHASE_ORDER_ID" IS '采购单id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."ID_CARD" IS '身份证';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."CAR" IS '车牌号';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."DRIVER_NAME" IS '司机';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."EXPECT_DELIVERY_TIME" IS '预计发货日期';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."EXPECT_ARRIVE_TIME" IS '预计到达日期';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."INVOICE_NO" IS '发票号';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."LAST_UPDATE_TIME" IS '最后更新时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."LAST_UPDATE_USER" IS '最后修改人';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."PUR_COMPANY_CODE" IS '客户编号';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."OUT_FACTORY_TIME" IS '供方出厂';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."GATE_SCAN_TIME" IS 'FGE门岗';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."TYPE" IS '类型：D为送货单，I为invoice单';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."IS_HK" IS '是否香港到货；1未到货，2已到货';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."ITEM_TYPE" IS '单据类型';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."EXPRESS_COMPANY" IS '快递公司';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."EXPRESS_NUMBER" IS '快递单号';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."IS_ENABLE" IS '是否可用，0不可用，1可用';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."VOUCHER_TYPE" IS '采购凭证类型';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."PURCHASE_ORDER_NO" IS '采购订单';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."FACTORY_CODE" IS '采购方工厂';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."FACTORY_NAME" IS '采购方工厂名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."TOTAL_GROUP_ID" IS '总集团id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."TOTAL_GROUP_NAME" IS '总集团名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."ACCOUNT_SET_ID" IS '账套 id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."ACCOUNT_SET_NAME" IS '账套名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."ACCOUNT_CODE" IS '账套编码';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."INSTITUTIONS_ID" IS '机构id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."INSTITUTIONS_NAME" IS '机构名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."IN_THE_ORGANIZATION_ID" IS '中支机构id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."IN_THE_ORGANIZATION_NAME" IS '中支机构名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."DEPART_ID" IS '部门id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER"."DEPART_NAME" IS '部门名称';
ALTER TABLE "T_BASE_DELIVERY_ORDER" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 发货行
-- ----------------------------
CREATE TABLE "T_BASE_DELIVERY_ORDER_ITEM" (
"ID" NVARCHAR2(50) NOT NULL ,
"COMPANY_CODE" NVARCHAR2(45) NULL ,
"DELIVERY_ORDER_ID" NVARCHAR2(32) NULL ,
"DELIVERY_ORDER_NO" NVARCHAR2(50) NULL ,
"DELIVERY_ORDER_ITEM_NO" NVARCHAR2(50) NULL ,
"DELIVERY_DATE" DATE NULL ,
"BATCH" NVARCHAR2(255) NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"MATERIAL_ID" NVARCHAR2(32) NULL ,
"MATERIAL_NO" NVARCHAR2(20) NULL ,
"MATERIAL_DESC" NVARCHAR2(500) NULL ,
"QUANTITY" NUMBER DEFAULT 0  NULL ,
"DELIVERY_QUANTITY" NUMBER DEFAULT 0  NULL ,
"TOTAL_AMOUNT" NUMBER DEFAULT 0  NULL ,
"CURRENCY" NVARCHAR2(15) NULL ,
"ORDER_UNIT" NVARCHAR2(50) NULL ,
"PRICE_UNIT" NVARCHAR2(15) NULL ,
"PUR_ORDER_ID" NVARCHAR2(100) NULL ,
"PUR_ORDER_NO" NVARCHAR2(100) NULL ,
"PUR_ORDER_ITEM_ID" NVARCHAR2(100) NULL ,
"PUR_ORDER_ITEM_NO" NVARCHAR2(100) NULL ,
"NO_TAX_PRICE" NUMBER DEFAULT 0  NULL ,
"NO_TAX_AMOUNT" NUMBER DEFAULT 0  NULL ,
"TAX_PRICE" NUMBER DEFAULT 0  NULL ,
"TAX_AMOUNT" NUMBER DEFAULT 0  NULL ,
"TAX_CODE" NVARCHAR2(45) NULL ,
"DEPARTMENT_NAME" NVARCHAR2(255) NULL ,
"DEPARTMENT_ID" NVARCHAR2(32) NULL ,
"RECEIPT_QUANTITY" NVARCHAR2(45) NULL ,
"RETURN_QUANTITY" NVARCHAR2(45) NULL ,
"RETURN_REASON" NVARCHAR2(500) NULL ,
"RETURN_FACTORY" NVARCHAR2(45) NULL ,
"RETURN_WAREHOUSE" NVARCHAR2(45) NULL ,
"PACK_QUANTITY" NVARCHAR2(45) NULL ,
"EXCHANGE_RATE" NVARCHAR2(45) NULL ,
"FACTORY_CODE" NVARCHAR2(45) NULL ,
"FACTORY_NAME" NVARCHAR2(45) NULL ,
"WAREHOUSE_CODE" NVARCHAR2(45) NULL ,
"WAREHOUSE_NAME" NVARCHAR2(255) NULL ,
"IS_RECONCILIATION" NVARCHAR2(20) NULL ,
"DELIVERY_LOCATION" NVARCHAR2(255) NULL ,
"SUPPLIER_MATERIAL_NUMBER" NVARCHAR2(255) NULL ,
"PROJECT_ID" NVARCHAR2(32) NULL ,
"COMPANY_ID" NVARCHAR2(32) NULL ,
"COMPANY_NAME" NVARCHAR2(255) NULL ,
"USER_ID" NVARCHAR2(32) NULL ,
"USER_NAME" NVARCHAR2(255) NULL ,
"PUR_COMPANY_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_NAME" NVARCHAR2(255) NULL ,
"PUR_USER_ID" NVARCHAR2(32) NULL ,
"PUR_USER_NAME" NVARCHAR2(255) NULL ,
"GATE_SCAN" NVARCHAR2(255) NULL ,
"WAREHOUSE_SCAN" NVARCHAR2(255) NULL ,
"PUR_COMPANY_CODE" NVARCHAR2(255) NULL ,
"CHINESE_NAME" NVARCHAR2(255) NULL ,
"MODEL" NVARCHAR2(255) NULL ,
"REMARK" NVARCHAR2(255) NULL ,
"TYPE" NVARCHAR2(255) NULL ,
"SINGLE_WEIGHT" NUMBER DEFAULT 0  NULL ,
"BRAND" NVARCHAR2(30) NULL ,
"SOURCE_AREA" NVARCHAR2(255) NULL ,
"TOTAL_NET_WEIGHT" NUMBER DEFAULT 0  NULL ,
"TOTAL_GROSS_WEIGHT" NUMBER DEFAULT 0  NULL ,
"CASE_NO" NVARCHAR2(30) NULL ,
"SAP_PUR_COMPANY_CODE" NVARCHAR2(255) DEFAULT NULL  NULL ,
"DELIVERY_MATERIAL_NAME" VARCHAR2(255 BYTE) NULL ,
"PALLET_NUMBER" VARCHAR2(255 BYTE) DEFAULT NULL  NULL ,
"IS_ENABLE" NUMBER(1) DEFAULT 1  NULL ,
"DELIVERY_STATUS" NUMBER(1) DEFAULT 1  NULL ,
"DELIVERY_PLAN_ITEM_ID" VARCHAR2(32 BYTE) NULL ,
"RECEIVE_DATE" DATE NULL ,
"IS_JIT" NUMBER(1) NULL ,
"RECEIVED_QUANTITY" NUMBER(20) NULL,
"RECEIVED_DATE" DATE NULL ,  
"FILE_ID" VARCHAR2(32) NULL  , 
"RECEIVED_REMARK" VARCHAR2(255) NULL  ,
"TOTAL_GROUP_ID" VARCHAR2(32) NULL,
"TOTAL_GROUP_NAME" VARCHAR2(255) NULL,
"ACCOUNT_SET_ID" VARCHAR2(32) NULL,
"ACCOUNT_SET_NAME" VARCHAR2(255) NULL,
"ACCOUNT_CODE" VARCHAR2(255) NULL,
"INSTITUTIONS_ID" VARCHAR2(32) NULL,
"INSTITUTIONS_NAME" VARCHAR2(255) NULL,
"IN_THE_ORGANIZATION_ID" VARCHAR2(32) NULL,
"IN_THE_ORGANIZATION_NAME" VARCHAR2(255) NULL,
"DEPART_ID" VARCHAR2(32) NULL,
"DEPART_NAME" VARCHAR2(255) NULL,
"RECEIVED_AMOUNT" NUMBER(16,4) NULL
);
COMMENT ON TABLE "T_BASE_DELIVERY_ORDER_ITEM" IS '发货行';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."COMPANY_CODE" IS '公司代码';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."DELIVERY_ORDER_NO" IS '送货单号';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."DELIVERY_ORDER_ITEM_NO" IS '项目';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."DELIVERY_DATE" IS '交货日期';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."BATCH" IS '批次';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."CREATE_TIME" IS '发货时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."MATERIAL_ID" IS '物料id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."MATERIAL_NO" IS '物料编码';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."MATERIAL_DESC" IS '物料描述';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."QUANTITY" IS '订单数量(订单单位数量)';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."DELIVERY_QUANTITY" IS '送货数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."TOTAL_AMOUNT" IS '总金额';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."CURRENCY" IS '币别';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."PRICE_UNIT" IS '度量单位';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."PUR_ORDER_NO" IS '采购订单';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."PUR_ORDER_ITEM_NO" IS '订单项';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."NO_TAX_PRICE" IS '不含税单价';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."NO_TAX_AMOUNT" IS '不含税金额';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."TAX_PRICE" IS '含税单价';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."TAX_AMOUNT" IS '含税金额';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."TAX_CODE" IS '税码';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."DEPARTMENT_ID" IS '物料组';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."RECEIPT_QUANTITY" IS '已收货数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."RETURN_QUANTITY" IS '可退货数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."RETURN_REASON" IS '退货原因';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."RETURN_FACTORY" IS '退货工厂';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."RETURN_WAREHOUSE" IS '退货仓库';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."PACK_QUANTITY" IS '包装件数';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."EXCHANGE_RATE" IS '汇率';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."FACTORY_CODE" IS '采购方工厂';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."FACTORY_NAME" IS '采购方工厂名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."WAREHOUSE_CODE" IS '仓库';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."WAREHOUSE_NAME" IS '仓库名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."IS_RECONCILIATION" IS '是否对账，有值则为对账单号';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."DELIVERY_LOCATION" IS '交货地点';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."SUPPLIER_MATERIAL_NUMBER" IS '供应商料号';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."COMPANY_ID" IS '供应商企业id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."COMPANY_NAME" IS '供应商企业名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."USER_ID" IS '供应商id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."USER_NAME" IS '供应商名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."PUR_COMPANY_ID" IS '采购员公司id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."PUR_COMPANY_NAME" IS '客户';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."PUR_USER_ID" IS '采购员id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."PUR_USER_NAME" IS '采购员';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."GATE_SCAN" IS '门岗扫描';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."WAREHOUSE_SCAN" IS '仓库扫描';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."PUR_COMPANY_CODE" IS '客户编号';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."CHINESE_NAME" IS '中文名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."MODEL" IS '型号';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."TYPE" IS '类型：D为送货单，I为invoice单';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."SINGLE_WEIGHT" IS '单重';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."BRAND" IS '品牌';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."SOURCE_AREA" IS '原产地';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."TOTAL_NET_WEIGHT" IS '总净重';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."TOTAL_GROSS_WEIGHT" IS '总毛重';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."CASE_NO" IS '箱号';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."SAP_PUR_COMPANY_CODE" IS 'sap公司代码';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."DELIVERY_MATERIAL_NAME" IS '发货物料名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."PALLET_NUMBER" IS '卡板号';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."IS_ENABLE" IS '是否可用，0不可用，1可用';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."DELIVERY_STATUS" IS '发货状态:1 未发货，2 在途，3收货,4 香港到货';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."DELIVERY_PLAN_ITEM_ID" IS '送货计划id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."RECEIVE_DATE" IS '仓库收货时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."IS_JIT" IS '是否JIT交货计划';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."RECEIVED_QUANTITY" IS '收货数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."RECEIVED_DATE" IS '收货日期';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."FILE_ID" IS '附件ID';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."RECEIVED_REMARK" IS '收货备注';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."TOTAL_GROUP_ID" IS '总集团id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."TOTAL_GROUP_NAME" IS '总集团名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."ACCOUNT_SET_ID" IS '账套 id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."ACCOUNT_SET_NAME" IS '账套名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."ACCOUNT_CODE" IS '账套编码';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."INSTITUTIONS_ID" IS '机构id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."INSTITUTIONS_NAME" IS '机构名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."IN_THE_ORGANIZATION_ID" IS '中支机构id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."IN_THE_ORGANIZATION_NAME" IS '中支机构名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."DEPART_ID" IS '部门id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."DEPART_NAME" IS '部门名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."RECEIVED_AMOUNT" IS '收货金额';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."DELIVERY_ORDER_ID" IS '送货单头ID';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."ORDER_UNIT" IS '物料单位';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."PUR_ORDER_ID" IS '采购订单头ID';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."PUR_ORDER_ITEM_ID" IS '采购订单行ID';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM"."DEPARTMENT_NAME" IS '物料组名称';
ALTER TABLE "T_BASE_DELIVERY_ORDER_ITEM" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 发货单头历史
-- ----------------------------
CREATE TABLE "T_BASE_DELIVERY_ORDER_HIS" (
"HIS_ID" NVARCHAR2(32) NOT NULL ,
"OPERATE_TIME" DATE DEFAULT sysdate  NOT NULL ,
"CAUSE" NVARCHAR2(255) NULL ,
"ID" NVARCHAR2(50) NULL ,
"PROJECT_ID" NVARCHAR2(32) NULL ,
"COMPANY_ID" NVARCHAR2(32) NULL ,
"COMPANY_NAME" NVARCHAR2(255) NULL ,
"USER_NAME" NVARCHAR2(255) NULL ,
"USER_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_NAME" NVARCHAR2(255) NULL ,
"PUR_USER_ID" NVARCHAR2(32) NULL ,
"PUR_USER_NAME" NVARCHAR2(255) NULL ,
"LOGISTIC_ORDER_NO" NVARCHAR2(50) NULL ,
"DELIVERY_ORDER_NO" NVARCHAR2(50) NOT NULL ,
"DELIVERY_ORDER_TIME" DATE NULL ,
"DELIVERY_DATE" DATE NULL ,
"DELIVERY_STATUS" NUMBER(11) DEFAULT 1  NULL ,
"RECEIVE_DATE" DATE NULL ,
"COMPANY_CODE" NVARCHAR2(100) NULL ,
"PURCHASE_ORDER_ID" NVARCHAR2(500) NULL ,
"PURCHASE_ORDER_NO" NVARCHAR2(500) NULL ,
"ID_CARD" NVARCHAR2(255) NULL ,
"CAR" NVARCHAR2(255) NULL ,
"DRIVER_NAME" NVARCHAR2(255) NULL ,
"EXPECT_DELIVERY_TIME" DATE NULL ,
"EXPECT_ARRIVE_TIME" DATE NULL ,
"INVOICE_NO" NVARCHAR2(255) NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"LAST_UPDATE_TIME" DATE DEFAULT sysdate  NULL ,
"LAST_UPDATE_USER" NVARCHAR2(255) NULL ,
"PUR_COMPANY_CODE" NVARCHAR2(255) NULL ,
"OUT_FACTORY_TIME" DATE NULL ,
"GATE_SCAN_TIME" DATE NULL ,
"TYPE" NVARCHAR2(255) NULL ,
"IS_HK" NUMBER(11) DEFAULT 1  NOT NULL ,
"ITEM_TYPE" VARCHAR2(255 BYTE) NULL ,
"EXPRESS_COMPANY" VARCHAR2(255 BYTE) NULL ,
"EXPRESS_NUMBER" VARCHAR2(255 BYTE) NULL ,
"IS_ENABLE" NUMBER(10) NULL ,
"VOUCHER_TYPE" VARCHAR2(255 BYTE) NULL ,
"FACTORY_CODE" NVARCHAR2(45) NULL ,
"FACTORY_NAME" NVARCHAR2(45) NULL ,
"TOTAL_GROUP_ID" VARCHAR2(32) NULL,
"TOTAL_GROUP_NAME" VARCHAR2(255) NULL,
"ACCOUNT_SET_ID" VARCHAR2(32) NULL,
"ACCOUNT_SET_NAME" VARCHAR2(255) NULL,
"ACCOUNT_CODE" VARCHAR2(255) NULL,
"INSTITUTIONS_ID" VARCHAR2(32) NULL,
"INSTITUTIONS_NAME" VARCHAR2(255) NULL,
"IN_THE_ORGANIZATION_ID" VARCHAR2(32) NULL,
"IN_THE_ORGANIZATION_NAME" VARCHAR2(255) NULL,
"DEPART_ID" VARCHAR2(32) NULL,
"DEPART_NAME" VARCHAR2(255) NULL
);
COMMENT ON TABLE "T_BASE_DELIVERY_ORDER_HIS" IS '发货单头历史';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."OPERATE_TIME" IS '操作时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."COMPANY_ID" IS '供应商企业id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."COMPANY_NAME" IS '供应商企业名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."USER_NAME" IS '供应商名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."USER_ID" IS '供应商id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."PUR_COMPANY_ID" IS '采购员公司id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."PUR_COMPANY_NAME" IS '采购企业名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."PUR_USER_ID" IS '采购员id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."PUR_USER_NAME" IS '采购员';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."LOGISTIC_ORDER_NO" IS '物流单号';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."DELIVERY_ORDER_NO" IS '送货单号';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."DELIVERY_ORDER_TIME" IS '送货单生成时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."DELIVERY_DATE" IS '送货日期';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."DELIVERY_STATUS" IS '发货状态:1 未发货，2 在途，3收货,4 香港到货';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."RECEIVE_DATE" IS '收货日期';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."COMPANY_CODE" IS '供应商编码';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."PURCHASE_ORDER_ID" IS '采购单id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."PURCHASE_ORDER_NO" IS '采购订单编号';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."ID_CARD" IS '身份证';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."CAR" IS '车辆';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."DRIVER_NAME" IS '司机名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."EXPECT_DELIVERY_TIME" IS '预计发货时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."EXPECT_ARRIVE_TIME" IS '预计到达时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."INVOICE_NO" IS '发票号';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."LAST_UPDATE_TIME" IS '最后更新时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."LAST_UPDATE_USER" IS '最后修改人';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."PUR_COMPANY_CODE" IS '客户编号';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."OUT_FACTORY_TIME" IS '供方出厂';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."GATE_SCAN_TIME" IS 'FGE门岗';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."TYPE" IS '类型：D为送货单，I为invoice单';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."IS_HK" IS '是否香港到货；1未到货，2已到货';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."ITEM_TYPE" IS '单据类型';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."EXPRESS_COMPANY" IS '快递公司';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."EXPRESS_NUMBER" IS '快递单号';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."IS_ENABLE" IS '是否可用，0不可用，1可用';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."VOUCHER_TYPE" IS '采购凭证类型';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."FACTORY_CODE" IS '采购方工厂';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."FACTORY_NAME" IS '采购方工厂名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."TOTAL_GROUP_ID" IS '总集团id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."TOTAL_GROUP_NAME" IS '总集团名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."ACCOUNT_SET_ID" IS '账套 id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."ACCOUNT_SET_NAME" IS '账套名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."ACCOUNT_CODE" IS '账套编码';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."INSTITUTIONS_ID" IS '机构id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."INSTITUTIONS_NAME" IS '机构名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."IN_THE_ORGANIZATION_ID" IS '中支机构id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."IN_THE_ORGANIZATION_NAME" IS '中支机构名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."DEPART_ID" IS '部门id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."DEPART_NAME" IS '部门名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."HIS_ID" IS '历史单据ID';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."CAUSE" IS '原因';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_HIS"."ID" IS '原数据ID';
ALTER TABLE "T_BASE_DELIVERY_ORDER_HIS" ADD PRIMARY KEY ("HIS_ID");


-- ----------------------------
-- 发货行历史
-- ----------------------------
CREATE TABLE "T_BASE_DELIVERY_ORDER_ITEM_HIS" (
"HIS_ID" NVARCHAR2(32) NOT NULL ,
"OPERATE_TIME" DATE NULL ,
"CAUSE" NVARCHAR2(255) NULL ,
"ID" NVARCHAR2(50) NOT NULL ,
"COMPANY_CODE" NVARCHAR2(45) NULL ,
"DELIVERY_ORDER_ID" NVARCHAR2(32) NULL ,
"DELIVERY_ORDER_NO" NVARCHAR2(50) NULL ,
"DELIVERY_ORDER_ITEM_NO" NVARCHAR2(50) NULL ,
"DELIVERY_DATE" DATE NULL ,
"BATCH" NVARCHAR2(15) NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"MATERIAL_ID" NVARCHAR2(32) NULL ,
"MATERIAL_NO" NVARCHAR2(20) NULL ,
"MATERIAL_DESC" NVARCHAR2(500) NULL ,
"QUANTITY" NUMBER NULL ,
"DELIVERY_QUANTITY" NUMBER NULL ,
"TOTAL_AMOUNT" NUMBER NULL ,
"CURRENCY" NVARCHAR2(15) NULL ,
"ORDER_UNIT" NVARCHAR2(50) NULL ,
"PRICE_UNIT" NVARCHAR2(15) NULL ,
"PUR_ORDER_ID" NVARCHAR2(100) NULL ,
"PUR_ORDER_NO" NVARCHAR2(32) NULL ,
"PUR_ORDER_ITEM_ID" NVARCHAR2(100) NULL ,
"PUR_ORDER_ITEM_NO" NVARCHAR2(32) NULL ,
"NO_TAX_PRICE" NUMBER NULL ,
"NO_TAX_AMOUNT" NUMBER NULL ,
"TAX_PRICE" NUMBER NULL ,
"TAX_AMOUNT" NUMBER NULL ,
"TAX_CODE" NVARCHAR2(45) NULL ,
"DEPARTMENT_NAME" NVARCHAR2(255) NULL ,
"DEPARTMENT_ID" NVARCHAR2(32) NULL ,
"RECEIPT_QUANTITY" NVARCHAR2(45) NULL ,
"RETURN_QUANTITY" NVARCHAR2(45) NULL ,
"RETURN_REASON" NVARCHAR2(500) NULL ,
"RETURN_FACTORY" NVARCHAR2(45) NULL ,
"RETURN_WAREHOUSE" NVARCHAR2(45) NULL ,
"PACK_QUANTITY" NVARCHAR2(45) NULL ,
"EXCHANGE_RATE" NVARCHAR2(45) NULL ,
"FACTORY_CODE" NVARCHAR2(45) NULL ,
"FACTORY_NAME" NVARCHAR2(45) NULL ,
"WAREHOUSE_CODE" NVARCHAR2(45) NULL ,
"WAREHOUSE_NAME" NVARCHAR2(45) NULL ,
"IS_RECONCILIATION" NVARCHAR2(20) NULL ,
"DELIVERY_LOCATION" NVARCHAR2(255) NULL ,
"SUPPLIER_MATERIAL_NUMBER" NVARCHAR2(255) NULL ,
"PROJECT_ID" NVARCHAR2(32) NULL ,
"COMPANY_ID" NVARCHAR2(32) NULL ,
"COMPANY_NAME" NVARCHAR2(255) NULL ,
"USER_ID" NVARCHAR2(32) NULL ,
"USER_NAME" NVARCHAR2(255) NULL ,
"PUR_COMPANY_ID" NVARCHAR2(32) NULL ,
"PUR_COMPANY_NAME" NVARCHAR2(255) NULL ,
"PUR_USER_ID" NVARCHAR2(32) NULL ,
"PUR_USER_NAME" NVARCHAR2(255) NULL ,
"GATE_SCAN" NVARCHAR2(255) NULL ,
"WAREHOUSE_SCAN" NVARCHAR2(255) NULL ,
"PUR_COMPANY_CODE" NVARCHAR2(255) NULL ,
"CHINESE_NAME" NVARCHAR2(255) NULL ,
"MODEL" NVARCHAR2(255) NULL ,
"REMARK" NVARCHAR2(255) NULL ,
"TYPE" NVARCHAR2(255) NULL ,
"SINGLE_WEIGHT" NUMBER NULL ,
"BRAND" NVARCHAR2(30) NULL ,
"SOURCE_AREA" NVARCHAR2(255) NULL ,
"TOTAL_NET_WEIGHT" NUMBER NULL ,
"TOTAL_GROSS_WEIGHT" NUMBER NULL ,
"CASE_NO" NVARCHAR2(30) NULL ,
"SAP_PUR_COMPANY_CODE" NVARCHAR2(255) DEFAULT NULL  NULL ,
"DELIVERY_MATERIAL_NAME" VARCHAR2(255 BYTE) NULL ,
"PALLET_NUMBER" VARCHAR2(255 BYTE) DEFAULT NULL  NULL ,
"IS_ENABLE" NUMBER(1) NULL ,
"DELIVERY_STATUS" NUMBER(1) NULL ,
"DELIVERY_PLAN_ITEM_ID" VARCHAR2(32 BYTE) NULL ,
"RECEIVE_DATE" DATE NULL ,
"IS_JIT" NUMBER(1) NULL ,
"RECEIVED_QUANTITY" NUMBER(20) NULL ,  
"RECEIVED_DATE" DATE NULL  ,
"FILE_ID" VARCHAR2(32) NULL  ,
"RECEIVED_REMARK" VARCHAR2(255) NULL ,
"TOTAL_GROUP_ID" VARCHAR2(32) NULL,
"TOTAL_GROUP_NAME" VARCHAR2(255) NULL,
"ACCOUNT_SET_ID" VARCHAR2(32) NULL,
"ACCOUNT_SET_NAME" VARCHAR2(255) NULL,
"ACCOUNT_CODE" VARCHAR2(255) NULL,
"INSTITUTIONS_ID" VARCHAR2(32) NULL,
"INSTITUTIONS_NAME" VARCHAR2(255) NULL,
"IN_THE_ORGANIZATION_ID" VARCHAR2(32) NULL,
"IN_THE_ORGANIZATION_NAME" VARCHAR2(255) NULL,
"DEPART_ID" VARCHAR2(32) NULL,
"DEPART_NAME" VARCHAR2(255) NULL,
"RECEIVED_AMOUNT" NUMBER(16,4) NULL
);
COMMENT ON TABLE "T_BASE_DELIVERY_ORDER_ITEM_HIS" IS '发货行历史';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."OPERATE_TIME" IS '操作时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."COMPANY_CODE" IS '公司代码';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."DELIVERY_ORDER_NO" IS '发货号';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."DELIVERY_ORDER_ITEM_NO" IS '送货单行项目号';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."DELIVERY_DATE" IS '交货时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."BATCH" IS '批次';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."CREATE_TIME" IS '时间戳';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."MATERIAL_ID" IS '物料id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."MATERIAL_NO" IS '物料号';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."MATERIAL_DESC" IS '本方物料描述';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."QUANTITY" IS '订单数量(订单单位数量)';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."DELIVERY_QUANTITY" IS '发货数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."TOTAL_AMOUNT" IS '总金额';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."CURRENCY" IS '本位币种';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."PRICE_UNIT" IS '度量单位';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."PUR_ORDER_NO" IS '采购订单号';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."PUR_ORDER_ITEM_NO" IS '采购凭证的行项目编号';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."NO_TAX_PRICE" IS '不含税单价';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."NO_TAX_AMOUNT" IS '不含税金额';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."TAX_PRICE" IS '含税单价';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."TAX_AMOUNT" IS '含税金额';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."TAX_CODE" IS '税码';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."DEPARTMENT_ID" IS '物料组';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."RECEIPT_QUANTITY" IS '可收货数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."RETURN_QUANTITY" IS '可退货数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."RETURN_REASON" IS '退货原因';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."RETURN_FACTORY" IS '退货工厂';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."RETURN_WAREHOUSE" IS '退货仓库';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."PACK_QUANTITY" IS '包装件数';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."EXCHANGE_RATE" IS '汇率';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."FACTORY_CODE" IS '工厂';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."FACTORY_NAME" IS '工厂名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."WAREHOUSE_CODE" IS '仓库';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."WAREHOUSE_NAME" IS '仓库名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."IS_RECONCILIATION" IS '是否对账，有值则为对账单号';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."DELIVERY_LOCATION" IS '交货地点';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."SUPPLIER_MATERIAL_NUMBER" IS '供应商料号';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."COMPANY_ID" IS '供应商企业id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."COMPANY_NAME" IS '供应商企业名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."USER_ID" IS '供应商id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."USER_NAME" IS '供应商名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."PUR_COMPANY_ID" IS '采购员公司id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."PUR_COMPANY_NAME" IS '采购企业名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."PUR_USER_ID" IS '采购员id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."PUR_USER_NAME" IS '采购员';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."GATE_SCAN" IS '门岗扫描';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."WAREHOUSE_SCAN" IS '仓库扫描';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."PUR_COMPANY_CODE" IS '客户编号';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."CHINESE_NAME" IS '中文名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."MODEL" IS '型号';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."TYPE" IS '类型：D为送货单，I为invoice单';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."SINGLE_WEIGHT" IS '单重';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."BRAND" IS '品牌';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."SOURCE_AREA" IS '原产地';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."TOTAL_NET_WEIGHT" IS '总净重';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."TOTAL_GROSS_WEIGHT" IS '总毛重';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."CASE_NO" IS '箱号';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."SAP_PUR_COMPANY_CODE" IS 'sap公司代码';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."DELIVERY_MATERIAL_NAME" IS '发货物料名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."PALLET_NUMBER" IS '卡板号';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."DELIVERY_PLAN_ITEM_ID" IS '送货计划id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."RECEIVE_DATE" IS '仓库收货时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."IS_JIT" IS '是否JIT交货计划';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."RECEIVED_QUANTITY" IS '收货数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."RECEIVED_DATE" IS '收货日期';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."FILE_ID" IS '附件ID';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."RECEIVED_REMARK" IS '收货备注';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."TOTAL_GROUP_ID" IS '总集团id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."TOTAL_GROUP_NAME" IS '总集团名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."ACCOUNT_SET_ID" IS '账套 id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."ACCOUNT_SET_NAME" IS '账套名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."ACCOUNT_CODE" IS '账套编码';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."INSTITUTIONS_ID" IS '机构id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."INSTITUTIONS_NAME" IS '机构名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."IN_THE_ORGANIZATION_ID" IS '中支机构id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."IN_THE_ORGANIZATION_NAME" IS '中支机构名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."DEPART_ID" IS '部门id';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."DEPART_NAME" IS '部门名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."RECEIVED_AMOUNT" IS '收货金额';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."HIS_ID" IS '历史数据ID';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."CAUSE" IS '原因';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."ID" IS '原数据ID';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."DELIVERY_ORDER_ID" IS '送货单头ID';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."ORDER_UNIT" IS '物料单位';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."PUR_ORDER_ID" IS '采购订单头ID';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."PUR_ORDER_ITEM_ID" IS '采购订单行ID';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."DEPARTMENT_NAME" IS '物料组名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."IS_ENABLE" IS '是否可用';
COMMENT ON COLUMN "T_BASE_DELIVERY_ORDER_ITEM_HIS"."DELIVERY_STATUS" IS '发货状态';
ALTER TABLE "T_BASE_DELIVERY_ORDER_ITEM_HIS" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 订单变更记录
-- ----------------------------
CREATE TABLE "T_BASE_PUR_ORDER_CHANGE" (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"ORDER_ID" VARCHAR2(32 BYTE) NOT NULL ,
"ORDER_ITEM_ID" VARCHAR2(32 BYTE) NOT NULL ,
"ORDER_NO" VARCHAR2(255 BYTE) NULL ,
"ORDER_ITEM_NO" VARCHAR2(255 BYTE) NULL ,
"MATERIAL_ID" VARCHAR2(32 BYTE) NULL ,
"MATERIAL_CODE" VARCHAR2(255 BYTE) NULL ,
"MATERIAL_DESC" VARCHAR2(255 BYTE) NULL ,
"SUPPLIER_MATERIAL_CODE" VARCHAR2(255 BYTE) NULL ,
"SUPPLIER_MATERIAL_DESC" VARCHAR2(255 BYTE) NULL ,
"ORIGIN_DATA" VARCHAR2(255 BYTE) NULL ,
"CHANGED_DATA" VARCHAR2(255 BYTE) NULL ,
"CREATE_TIME" DATE NULL ,
"SEND_STATUS" VARCHAR2(10 BYTE) NULL ,
"PUR_USER_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_USER_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"CHANGE_FIELD" VARCHAR2(255 BYTE) NULL ,
"CONFIRM_STATUS" NUMBER(2) NULL ,
"CHANGE_TYPE" NUMBER(2) NULL 
);
COMMENT ON TABLE "T_BASE_PUR_ORDER_CHANGE" IS '订单变更记录';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_CHANGE"."ID" IS '主键ID';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_CHANGE"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_CHANGE"."ORDER_ID" IS '采购订单id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_CHANGE"."ORDER_ITEM_ID" IS '采购订单行id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_CHANGE"."ORDER_NO" IS '采购订单号';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_CHANGE"."ORDER_ITEM_NO" IS '采购订单行项目';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_CHANGE"."MATERIAL_ID" IS '物料id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_CHANGE"."MATERIAL_CODE" IS '物料编码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_CHANGE"."MATERIAL_DESC" IS '物料描述';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_CHANGE"."SUPPLIER_MATERIAL_CODE" IS '供应商物料编码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_CHANGE"."SUPPLIER_MATERIAL_DESC" IS '供应商物料描述';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_CHANGE"."ORIGIN_DATA" IS '原始数据';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_CHANGE"."CHANGED_DATA" IS '变更后的数据';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_CHANGE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_CHANGE"."SEND_STATUS" IS '发送状态';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_CHANGE"."PUR_USER_ID" IS '采购员id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_CHANGE"."PUR_USER_NAME" IS '采购员名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_CHANGE"."SUP_USER_ID" IS '供应商用户id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_CHANGE"."SUP_USER_NAME" IS '供应商用户名';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_CHANGE"."CHANGE_FIELD" IS '变更的字段';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_CHANGE"."CONFIRM_STATUS" IS '确认状态:1未确认,2已确认,3已拒绝';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_CHANGE"."CHANGE_TYPE" IS '变更的类型,0新增,1变更,2删除,3关闭';
ALTER TABLE "T_BASE_PUR_ORDER_CHANGE" ADD PRIMARY KEY ("ID");




-- ----------------------------
-- 采购订单行拓展信息
-- ----------------------------
CREATE TABLE "T_BASE_PUR_ORDER_ITEM_EXT" (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"ORDER_ID" VARCHAR2(32 BYTE) NULL ,
"ORDER_ITEM_ID" VARCHAR2(32 BYTE) NULL ,
"ORDER_NO" VARCHAR2(255 BYTE) NULL ,
"ORDER_ITEM_NO" VARCHAR2(255 BYTE) NULL ,
"DELIVERED_QUANTITY" NUMBER(11,3) DEFAULT NULL  NULL ,
"ONWAY_QUANTITY" NUMBER(11,3) DEFAULT NULL  NULL ,
"RECEIVED_QUANTITY" NUMBER(11,3) DEFAULT NULL  NULL ,
"RETURN_QUANTITY" NUMBER(11,3) DEFAULT NULL  NULL ,
"PLAN_QUANTITY" NUMBER(11,3) DEFAULT NULL  NULL 
);
COMMENT ON TABLE "T_BASE_PUR_ORDER_ITEM_EXT" IS '采购订单行拓展信息';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_EXT"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_EXT"."ORDER_ID" IS '订单id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_EXT"."ORDER_ITEM_ID" IS '订单行id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_EXT"."ORDER_NO" IS '订单号';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_EXT"."ORDER_ITEM_NO" IS '订单行号';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_EXT"."DELIVERED_QUANTITY" IS '已经发货数量';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_EXT"."ONWAY_QUANTITY" IS '在途数量';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_EXT"."RECEIVED_QUANTITY" IS '已经收货数量';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_EXT"."RETURN_QUANTITY" IS '退货数量';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_ITEM_EXT"."PLAN_QUANTITY" IS '已经分配计划的数量';
ALTER TABLE "T_BASE_PUR_ORDER_ITEM_EXT" ADD PRIMARY KEY ("ID");



-- ----------------------------
-- 采购订单操作日志
-- ----------------------------
CREATE TABLE "T_BASE_PUR_ORDER_LOG" (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(50 BYTE) NULL ,
"PUR_COMPANY_ID" VARCHAR2(50 BYTE) NULL ,
"PUR_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_SAP_CODE" VARCHAR2(50 BYTE) NULL ,
"PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_ID" VARCHAR2(50 BYTE) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_SAP_CODE" VARCHAR2(60 BYTE) NULL ,
"SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"USER_ID" VARCHAR2(50 BYTE) NULL ,
"USER_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_ORDER_ID" VARCHAR2(32 BYTE) NULL ,
"ORDER_NO" VARCHAR2(255 BYTE) NULL ,
"ORDER_ITEM_NO" VARCHAR2(12 BYTE) NULL ,
"CHANGE_TYPE" NUMBER(2) NULL ,
"CHANGE_REASON" VARCHAR2(20 BYTE) NULL ,
"IS_REFUSE_QUANTITY" NUMBER(1) NULL ,
"IS_REFUSE_PRICE" NUMBER(1) NULL ,
"IS_REFUSE_DELIVERED_DATE" NUMBER(1) NULL ,
"CHANGE_FIELD" VARCHAR2(255 BYTE) NULL ,
"REMARK" VARCHAR2(255 BYTE) NULL ,
"CREATE_TIME" DATE NULL ,
"PUR_ORDER_ITEM_ID" VARCHAR2(32 BYTE) NULL ,
"PLAN_ITEM_ID" VARCHAR2(32 BYTE) NULL ,
"LOG_OPERATE_ID" VARCHAR2(32 BYTE) NULL ,
"FACTORY_NAME" VARCHAR2(255 BYTE) NULL ,
"FACTORY_CODE" VARCHAR2(45 BYTE) NULL ,
"LOG_OPERATE_TYPE" VARCHAR2(6 BYTE) NULL ,
"IS_CHECK" NUMBER(2) NULL ,
"REPLY_TIME" DATE NULL 
);
COMMENT ON TABLE "T_BASE_PUR_ORDER_LOG" IS '采购订单操作日志';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_LOG"."ID" IS '主键ID';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_LOG"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_LOG"."PUR_COMPANY_ID" IS '采购企业id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_LOG"."PUR_COMPANY_NAME" IS '采购企业名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_LOG"."PUR_COMPANY_SAP_CODE" IS '采购方sap编码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_LOG"."PUR_COMPANY_SRM_CODE" IS '采购企业srm编码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_LOG"."SUP_COMPANY_ID" IS '供应商id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_LOG"."SUP_COMPANY_NAME" IS '供应企业名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_LOG"."SUP_COMPANY_SAP_CODE" IS '供应商SAP编码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_LOG"."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_LOG"."USER_ID" IS '操作人id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_LOG"."USER_NAME" IS '操作人名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_LOG"."PUR_ORDER_ID" IS '采购订单id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_LOG"."ORDER_NO" IS '采购凭证号 ';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_LOG"."ORDER_ITEM_NO" IS '采购凭证的项目编号 ';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_LOG"."CHANGE_TYPE" IS '操作类型,2:订单确认,3:订单拒绝,4:订单发送,5:订单变更';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_LOG"."CHANGE_REASON" IS '变更原因：采购方导致PUR, 供应方导致SUP';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_LOG"."IS_REFUSE_QUANTITY" IS '是否拒绝数量';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_LOG"."IS_REFUSE_PRICE" IS '是否拒绝价格';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_LOG"."IS_REFUSE_DELIVERED_DATE" IS '是否拒绝交期';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_LOG"."CHANGE_FIELD" IS '变更的字段';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_LOG"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_LOG"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_LOG"."PUR_ORDER_ITEM_ID" IS '订单行id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_LOG"."PLAN_ITEM_ID" IS '计划id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_LOG"."LOG_OPERATE_ID" IS '当前操作id';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_LOG"."FACTORY_NAME" IS '采购方工厂名称';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_LOG"."FACTORY_CODE" IS '采购方工厂';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_LOG"."LOG_OPERATE_TYPE" IS '操作方，PUR采购方操作，SUP供应商操作';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_LOG"."IS_CHECK" IS '是否需要考核，0不要，1要';
COMMENT ON COLUMN "T_BASE_PUR_ORDER_LOG"."REPLY_TIME" IS '回复时间';
ALTER TABLE "T_BASE_PUR_ORDER_LOG" ADD PRIMARY KEY ("ID");



-- ----------------------------
-- 送货计划头
-- ----------------------------
CREATE TABLE "T_BASE_DELIVERY_CHANGE_PLAN" (
"ID" VARCHAR2(50 BYTE) NOT NULL ,
"FACTORY_CODE" NVARCHAR2(45) NULL ,
"FACTORY_NAME" NVARCHAR2(45) NULL ,
"MATERIAL_CODE" VARCHAR2(32 BYTE) NULL ,
"MATERIAL_DESCRIDE" VARCHAR2(255 BYTE) NULL ,
"JIT_ITEM" VARCHAR2(5 BYTE) NULL ,
"UNIT" VARCHAR2(100 BYTE) NULL ,
"ORIGIN_QUANTITY" NUMBER(11,3) NULL ,
"CHANGE_QUANTITY" NUMBER(11,3) NULL ,
"SUP_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_SRM_CODE" VARCHAR2(100 BYTE) NULL ,
"SUP_COMPANY_SAP_CODE" VARCHAR2(100 BYTE) NULL ,
"PUR_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) DEFAULT NULL  NULL ,
"DELIVERY_PLAN_ITEM_ID" VARCHAR2(32 BYTE) NULL ,
"CHANGE_LOG" VARCHAR2(255 BYTE) NULL ,
"ORIGIN_DELIVERY_DATE" DATE NULL ,
"CHANGE_DELIVERY_DATE" DATE NULL ,
"CREATE_TIME" DATE NULL ,
"CHANGE_TYPE" VARCHAR2(32 BYTE) NULL 
);
COMMENT ON TABLE "T_BASE_DELIVERY_CHANGE_PLAN" IS '送货计划头';
COMMENT ON COLUMN "T_BASE_DELIVERY_CHANGE_PLAN"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_DELIVERY_CHANGE_PLAN"."FACTORY_CODE" IS '采购方工厂';
COMMENT ON COLUMN "T_BASE_DELIVERY_CHANGE_PLAN"."FACTORY_NAME" IS '采购方工厂名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_CHANGE_PLAN"."MATERIAL_CODE" IS '物料编号';
COMMENT ON COLUMN "T_BASE_DELIVERY_CHANGE_PLAN"."MATERIAL_DESCRIDE" IS '物料名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_CHANGE_PLAN"."JIT_ITEM" IS 'JIT标识';
COMMENT ON COLUMN "T_BASE_DELIVERY_CHANGE_PLAN"."UNIT" IS '计量单位';
COMMENT ON COLUMN "T_BASE_DELIVERY_CHANGE_PLAN"."ORIGIN_QUANTITY" IS '原始数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_CHANGE_PLAN"."CHANGE_QUANTITY" IS '变更数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_CHANGE_PLAN"."SUP_COMPANY_ID" IS '供应商企业id';
COMMENT ON COLUMN "T_BASE_DELIVERY_CHANGE_PLAN"."SUP_COMPANY_NAME" IS '供应商企业名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_CHANGE_PLAN"."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BASE_DELIVERY_CHANGE_PLAN"."SUP_COMPANY_SAP_CODE" IS '供应商SAP编码';
COMMENT ON COLUMN "T_BASE_DELIVERY_CHANGE_PLAN"."PUR_COMPANY_ID" IS '采购员公司id';
COMMENT ON COLUMN "T_BASE_DELIVERY_CHANGE_PLAN"."PUR_COMPANY_NAME" IS '客户';
COMMENT ON COLUMN "T_BASE_DELIVERY_CHANGE_PLAN"."PUR_COMPANY_SRM_CODE" IS '客户编号';
COMMENT ON COLUMN "T_BASE_DELIVERY_CHANGE_PLAN"."PUR_COMPANY_SAP_CODE" IS 'sap公司代码';
COMMENT ON COLUMN "T_BASE_DELIVERY_CHANGE_PLAN"."DELIVERY_PLAN_ITEM_ID" IS '计划id';
COMMENT ON COLUMN "T_BASE_DELIVERY_CHANGE_PLAN"."CHANGE_LOG" IS '变更备注';
COMMENT ON COLUMN "T_BASE_DELIVERY_CHANGE_PLAN"."ORIGIN_DELIVERY_DATE" IS '原始发货日期';
COMMENT ON COLUMN "T_BASE_DELIVERY_CHANGE_PLAN"."CHANGE_DELIVERY_DATE" IS '变更发货日期';
COMMENT ON COLUMN "T_BASE_DELIVERY_CHANGE_PLAN"."CREATE_TIME" IS '变更时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_CHANGE_PLAN"."CHANGE_TYPE" IS '变更类型';
ALTER TABLE "T_BASE_DELIVERY_CHANGE_PLAN" ADD PRIMARY KEY ("ID");



-- ----------------------------
-- 送货包装
-- ----------------------------
CREATE TABLE "T_BASE_DELIVERY_PACKAGE" (
"ID" NVARCHAR2(32) NOT NULL ,
"PROJECT_ID" NVARCHAR2(32) NULL ,
"COMPANY_ID" NVARCHAR2(32) NULL ,
"COMPANY_NAME" NVARCHAR2(255) NULL ,
"COMPANY_CODE" NVARCHAR2(100) NULL ,
"USER_ID" NVARCHAR2(32) NULL ,
"USER_NAME" NVARCHAR2(255) NULL ,
"DELIVERY_ORDER_ID" NVARCHAR2(255) NULL ,
"DELIVERY_ORDER_NO" NVARCHAR2(255) NULL ,
"DELIVERY_ORDER_ITEM_ID" NVARCHAR2(255) NULL ,
"DELIVERY_ORDER_ITEM_NO" NVARCHAR2(255) NULL ,
"MATERIAL_ID" NVARCHAR2(255) NULL ,
"MATERIAL_NO" NVARCHAR2(255) NULL ,
"MATERIAL_DESC" NVARCHAR2(255) NULL ,
"ORDER_UNIT" NVARCHAR2(255) NULL ,
"REMARK" NVARCHAR2(255) NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"VOLUME" NVARCHAR2(255) NULL ,
"LENGTH" NUMBER(10,3) NULL ,
"WIDTH" NUMBER(10,3) NULL ,
"HEIGHT" NUMBER(10,3) NULL ,
"DELIVERY_QUANTITY" NUMBER(10) NULL ,
"PACKAGE_QUANTITY" NUMBER(10) NULL ,
"TOTAL_QUANTITY" NUMBER(10) NULL ,
"CASE_NO" VARCHAR2(32 BYTE) NULL ,
"GROSS_WEIGHT" NUMBER(10,3) NULL ,
"IS_MERGER" NUMBER(3) DEFAULT 0  NULL ,
"PALLET_NUMBER" VARCHAR2(32 BYTE) NULL 
);
COMMENT ON TABLE "T_BASE_DELIVERY_PACKAGE" IS '送货包装';
COMMENT ON COLUMN "T_BASE_DELIVERY_PACKAGE"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PACKAGE"."COMPANY_ID" IS '企业id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PACKAGE"."COMPANY_NAME" IS '企业名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_PACKAGE"."COMPANY_CODE" IS '公司代码';
COMMENT ON COLUMN "T_BASE_DELIVERY_PACKAGE"."USER_ID" IS '供应商id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PACKAGE"."USER_NAME" IS '供应商名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_PACKAGE"."DELIVERY_ORDER_NO" IS '送货单号';
COMMENT ON COLUMN "T_BASE_DELIVERY_PACKAGE"."DELIVERY_ORDER_ITEM_NO" IS '送货单行号';
COMMENT ON COLUMN "T_BASE_DELIVERY_PACKAGE"."MATERIAL_NO" IS '采购方物料号';
COMMENT ON COLUMN "T_BASE_DELIVERY_PACKAGE"."MATERIAL_DESC" IS '采购方物料描述';
COMMENT ON COLUMN "T_BASE_DELIVERY_PACKAGE"."ORDER_UNIT" IS '单位';
COMMENT ON COLUMN "T_BASE_DELIVERY_PACKAGE"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_DELIVERY_PACKAGE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_PACKAGE"."VOLUME" IS '体积';
COMMENT ON COLUMN "T_BASE_DELIVERY_PACKAGE"."LENGTH" IS '长度';
COMMENT ON COLUMN "T_BASE_DELIVERY_PACKAGE"."WIDTH" IS '宽度';
COMMENT ON COLUMN "T_BASE_DELIVERY_PACKAGE"."HEIGHT" IS '高度';
COMMENT ON COLUMN "T_BASE_DELIVERY_PACKAGE"."DELIVERY_QUANTITY" IS '每件数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_PACKAGE"."PACKAGE_QUANTITY" IS '件数';
COMMENT ON COLUMN "T_BASE_DELIVERY_PACKAGE"."TOTAL_QUANTITY" IS '总数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_PACKAGE"."GROSS_WEIGHT" IS '毛重';
COMMENT ON COLUMN "T_BASE_DELIVERY_PACKAGE"."IS_MERGER" IS '合并到一个箱子';
COMMENT ON COLUMN "T_BASE_DELIVERY_PACKAGE"."PALLET_NUMBER" IS '卡板号';
COMMENT ON COLUMN "T_BASE_DELIVERY_PACKAGE"."ID" IS '主键ID';
COMMENT ON COLUMN "T_BASE_DELIVERY_PACKAGE"."DELIVERY_ORDER_ID" IS '送货单ID';
COMMENT ON COLUMN "T_BASE_DELIVERY_PACKAGE"."DELIVERY_ORDER_ITEM_ID" IS '送货单行ID';
COMMENT ON COLUMN "T_BASE_DELIVERY_PACKAGE"."MATERIAL_ID" IS '物料ID';
COMMENT ON COLUMN "T_BASE_DELIVERY_PACKAGE"."CASE_NO" IS '案例编号';
ALTER TABLE "T_BASE_DELIVERY_PACKAGE" ADD PRIMARY KEY ("ID");



-- ----------------------------
-- 送货计划头
-- ----------------------------
CREATE TABLE "T_BASE_DELIVERY_PLAN" (
"ID" VARCHAR2(50 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_USER_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"STATUS" NUMBER(11) DEFAULT NULL  NULL ,
"DELIVERY_DATE" DATE NULL ,
"PURCHASE_ORDER_ID" VARCHAR2(500 BYTE) NULL ,
"CREATE_TIME" DATE DEFAULT NULL  NULL ,
"LAST_UPDATE_TIME" DATE DEFAULT NULL  NULL ,
"LAST_UPDATE_USER" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"IS_ENABLE" NUMBER(10) NULL ,
"ORDER_TYPE" VARCHAR2(255 BYTE) NULL ,
"PURCHASE_ORDER_NO" CLOB NULL ,
"REQUIRE_START_DATE" DATE NULL ,
"REQUIRE_END_DATE" DATE NULL ,
"SUP_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_USER_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_COMPANY_SRM_CODE" VARCHAR2(100 BYTE) NULL ,
"SUP_COMPANY_SAP_CODE" VARCHAR2(100 BYTE) NULL ,
"FACTORY_CODE" NVARCHAR2(45) NULL ,
"FACTORY_NAME" NVARCHAR2(45) NULL ,
"WAREHOUSE_CODE" NVARCHAR2(45) NULL ,
"WAREHOUSE_NAME" NVARCHAR2(45) NULL ,
"IS_LOCK" VARCHAR2(2 BYTE) NULL ,
"CHANGE_RESOIRCE" NUMBER(1) NULL ,
"MATERIAL_CODE" VARCHAR2(32 BYTE) NULL ,
"MATERIAL_DESCRIDE" VARCHAR2(255 BYTE) NULL ,
"JIT_ITEM" VARCHAR2(5 BYTE) NULL ,
"UNIT" VARCHAR2(100 BYTE) NULL ,
"MERG_ID" VARCHAR2(32 BYTE) NULL ,
"ARRYVAL_TIME" DATE NULL ,
"CONSUME_MUNBER" NUMBER(20) NULL ,
"IS_ALLOCATED" NUMBER(11) DEFAULT 0  NULL ,
"EXTERNAL_MATERIAL_GROUP" VARCHAR2(255 BYTE) NULL ,
"MATERIAL_GROUP" VARCHAR2(255 BYTE) NULL ,
"USED_STATUS" VARCHAR2(100 BYTE) DEFAULT NULL  NULL 
);
COMMENT ON TABLE "T_BASE_DELIVERY_PLAN" IS '送货计划头';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."PUR_COMPANY_ID" IS '采购员公司id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."PUR_COMPANY_NAME" IS '客户名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."PUR_USER_ID" IS '采购员id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."PUR_USER_NAME" IS '采购负责人';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."STATUS" IS '状态:0未发送供应商，1已发送供应商';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."DELIVERY_DATE" IS '送货时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."PURCHASE_ORDER_ID" IS '采购单id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."LAST_UPDATE_TIME" IS '最后更新时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."LAST_UPDATE_USER" IS '最后修改人';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."PUR_COMPANY_SRM_CODE" IS '客户编号';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."IS_ENABLE" IS '是否可用，0不可用，1可用';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."ORDER_TYPE" IS '订单类型(采购凭证类型)';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."REQUIRE_START_DATE" IS '需求区间开始时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."REQUIRE_END_DATE" IS '需求区间结束时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."SUP_COMPANY_ID" IS '供应商企业id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."SUP_COMPANY_NAME" IS '供应商企业名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."SUP_USER_NAME" IS '销售方负责人';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."SUP_USER_ID" IS '供应商id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."SUP_COMPANY_SAP_CODE" IS '供应商SAP编码';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."FACTORY_CODE" IS '采购方工厂';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."FACTORY_NAME" IS '采购方工厂名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."WAREHOUSE_CODE" IS '仓库';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."WAREHOUSE_NAME" IS '仓库名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."IS_LOCK" IS '锁定标识：F为锁定';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."CHANGE_RESOIRCE" IS '变更原因：0-供应商原因，1-立白原因';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."MATERIAL_CODE" IS '物料编号';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."MATERIAL_DESCRIDE" IS '物料名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."JIT_ITEM" IS 'JIT标识';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."UNIT" IS '计量单位';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."MERG_ID" IS '需求时段ID';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."ARRYVAL_TIME" IS '要求到达时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."CONSUME_MUNBER" IS '需求数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."IS_ALLOCATED" IS '是否分配 0：未分配，1：全部分配，2：部分分配';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."EXTERNAL_MATERIAL_GROUP" IS '外部物料组';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."MATERIAL_GROUP" IS '物料组';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."USED_STATUS" IS '状态，未生成送货单:N，已生成送货单:Y';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN"."PURCHASE_ORDER_NO" IS '采购订单号';
ALTER TABLE "T_BASE_DELIVERY_PLAN" ADD PRIMARY KEY ("ID");



-- ----------------------------
-- 收货凭证表
-- ----------------------------
CREATE TABLE "T_BASE_PUR_VOUCHER" (
"ID" VARCHAR2(32 CHAR) DEFAULT ''  NOT NULL ,
"PUR_COMPANY_ID" VARCHAR2(32 CHAR) NULL ,
"PUR_COMPANY_SRM_CODE" VARCHAR2(32 CHAR) NULL ,
"PUR_COMPANY_SAP_CODE" VARCHAR2(255 CHAR) NULL ,
"PUR_COMPANY_NAME" VARCHAR2(32 CHAR) NULL ,
"PUR_COMPANY_FULL_NAME" VARCHAR2(255 CHAR) NULL ,
"SUP_COMPANY_ID" VARCHAR2(32 CHAR) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 CHAR) NULL ,
"SUP_COMPANY_FULL_NAME" VARCHAR2(255 CHAR) NULL ,
"SUP_COMPANY_SRM_CODE" VARCHAR2(255 CHAR) NULL ,
"SUP_COMPANY_SAP_CODE" VARCHAR2(255 CHAR) NULL ,
"DELIVERY_ORDER_NO" VARCHAR2(32 CHAR) NULL ,
"DELIVERY_ORDER_ITEM_NO" VARCHAR2(32 CHAR) NULL ,
"PURCHASE_ORDER_NO" VARCHAR2(32 CHAR) NULL ,
"PURCHASE_ORDER_ITEM_NO" VARCHAR2(32 CHAR) NULL ,
"MATERIAL_ID" VARCHAR2(32 CHAR) NULL ,
"MATERIAL_NO" VARCHAR2(32 CHAR) NULL ,
"MATERIAL_DESC" VARCHAR2(255 CHAR) NULL ,
"MATERIAL_QUANTITY" NUMBER(11,1) NULL ,
"MATERIAL_VOUCHER_NO" VARCHAR2(32 CHAR) NULL ,
"MATERIAL_VOUCHER_ITEM_NO" VARCHAR2(32 CHAR) NULL ,
"POSTING_TIME" DATE NULL ,
"CURRENCY_TYPE" VARCHAR2(32 CHAR) NULL ,
"BILL_TYPE" VARCHAR2(32 CHAR) NULL ,
"BILL_FLAG" NUMBER(11) DEFAULT 0  NULL ,
"IS_ENABLE" NUMBER(11) DEFAULT 0  NULL ,
"FACTORY" VARCHAR2(255 CHAR) NULL ,
"PROJECT_TYPES" VARCHAR2(255 CHAR) NULL ,
"TAX_RATE" NUMBER(11,2) NULL ,
"NOT_INCLUDE_TAX_AMOUNT" NUMBER(13,4) NULL ,
"INCLUDE_TAX_AMOUNT" NUMBER(13,4) NULL ,
"TAX_AMOUNT" NUMBER(13,4) NULL ,
"LATEST_PRICE" NUMBER(11,2) NULL ,
"ORDER_PRICE" NUMBER(11,2) NULL ,
"ORDER_AMOUNT" NUMBER(11,2) NULL ,
"TAX_CODE" VARCHAR2(255 CHAR) NULL ,
"MATERIAL_UNIT" VARCHAR2(255 CHAR) NULL ,
"ACCOUNTING_YEAR" VARCHAR2(255 CHAR) NULL ,
"VOUCHER_TIME" DATE NULL ,
"INPUT_DATE" DATE NULL ,
"INPUT_TIME" DATE NULL ,
"STOCK_SPACE_CODE" VARCHAR2(255 CHAR) NULL ,
"STOCK_SPACE_REMARK" VARCHAR2(255 CHAR) NULL ,
"COMPANY" VARCHAR2(255 CHAR) NULL ,
"QUANTITY" NUMBER(7,1) NULL ,
"ELEMENTARY_ENTITY" VARCHAR2(255 CHAR) NULL ,
"USER_NAME" VARCHAR2(255 CHAR) NULL ,
"PAYMENT_WAY" VARCHAR2(255 CHAR) NULL ,
"MARK" VARCHAR2(255 CHAR) NULL ,
"PRICE_ENTITY" NUMBER(11,1) NULL ,
"GOODSANDLABOR_NAME" VARCHAR2(255 CHAR) NULL ,
"COMBINED_TAX_CODE" VARCHAR2(255 CHAR) NULL ,
"VOUCHER_ACCOUNTING_YEAR" VARCHAR2(255 CHAR) NULL ,
"VOUCHER_NO" VARCHAR2(255 BYTE) NULL ,
"VOUCHER_PROJECT" VARCHAR2(255 CHAR) NULL ,
"CREATE_TIME" DATE NULL 
);
COMMENT ON TABLE "T_BASE_PUR_VOUCHER" IS '收货凭证表';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."ID" IS '主键ID';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."PUR_COMPANY_ID" IS '采购商公司ID';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."PUR_COMPANY_SRM_CODE" IS '采购商公司SRM编码';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."PUR_COMPANY_SAP_CODE" IS '采购商公司SAP编码';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."PUR_COMPANY_NAME" IS '采购商公司名称';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."PUR_COMPANY_FULL_NAME" IS '采购商公司全称';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."SUP_COMPANY_ID" IS '供应商公司ID';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."SUP_COMPANY_NAME" IS '供应商公司名称';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."SUP_COMPANY_FULL_NAME" IS '供应商公司全称';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."SUP_COMPANY_SRM_CODE" IS '供应商公司SRM编码';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."SUP_COMPANY_SAP_CODE" IS '供应商公司SAP编码';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."DELIVERY_ORDER_NO" IS '送货单号';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."DELIVERY_ORDER_ITEM_NO" IS '送货单行号';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."PURCHASE_ORDER_NO" IS '采购单号';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."PURCHASE_ORDER_ITEM_NO" IS '采购单行号';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."MATERIAL_ID" IS '物料ID';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."MATERIAL_NO" IS '物料编码';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."MATERIAL_DESC" IS '物料描述';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."MATERIAL_QUANTITY" IS '物料数量';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."MATERIAL_VOUCHER_NO" IS '物料凭证号';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."MATERIAL_VOUCHER_ITEM_NO" IS '物料凭证行号';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."POSTING_TIME" IS '过账日期-sap入退库，折让单时间';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."CURRENCY_TYPE" IS '货币类型';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."BILL_TYPE" IS '移动类型';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."BILL_FLAG" IS '是否对账(已对账=1，未对账=0)';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."IS_ENABLE" IS '记录是否可用(可用=1，不可用=0)';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."FACTORY" IS '工厂';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."PROJECT_TYPES" IS '项目类别';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."TAX_RATE" IS '税率';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."NOT_INCLUDE_TAX_AMOUNT" IS '开票未税金额';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."INCLUDE_TAX_AMOUNT" IS '开票含税金额';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."TAX_AMOUNT" IS '开票税额';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."LATEST_PRICE" IS '最新采购信息记录价格';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."ORDER_PRICE" IS '单价';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."ORDER_AMOUNT" IS '订单总金额';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."TAX_CODE" IS '税码';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."MATERIAL_UNIT" IS '物料单位';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."ACCOUNTING_YEAR" IS '会计年度';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."VOUCHER_TIME" IS '凭证日期';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."INPUT_DATE" IS '输入日期';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."INPUT_TIME" IS '输入时间';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."STOCK_SPACE_CODE" IS '库存地点编码';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."STOCK_SPACE_REMARK" IS '库存地点描述';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."COMPANY" IS '公司';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."QUANTITY" IS '数量';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."ELEMENTARY_ENTITY" IS '基本单位';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."USER_NAME" IS '用户名';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."PAYMENT_WAY" IS '付款方式';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."MARK" IS '符号';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."PRICE_ENTITY" IS '价格单位';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."GOODSANDLABOR_NAME" IS '货物和劳务名称';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."COMBINED_TAX_CODE" IS '合并税务编码';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."VOUCHER_ACCOUNTING_YEAR" IS '参考凭证会计年度';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."VOUCHER_NO" IS '参考凭证的凭证号';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."VOUCHER_PROJECT" IS '参考凭证项目';
COMMENT ON COLUMN "T_BASE_PUR_VOUCHER"."CREATE_TIME" IS '获取时间';
ALTER TABLE "T_BASE_PUR_VOUCHER" ADD PRIMARY KEY ("ID");



-- ----------------------------
-- 送货计划行
-- ----------------------------
CREATE TABLE "T_BASE_DELIVERY_SUP_PLAN_ITEM" (
"ID" VARCHAR2(50 BYTE) NOT NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"IS_ENABLE" NUMBER(1) DEFAULT 1  NULL ,
"PLAN_ID" VARCHAR2(32 BYTE) NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) DEFAULT NULL  NULL ,
"PUR_USER_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_SRM_CODE" VARCHAR2(45 BYTE) NULL ,
"SUP_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_USER_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_ORDER_ID" VARCHAR2(100 BYTE) NULL ,
"PUR_ORDER_NO" VARCHAR2(100 BYTE) NULL ,
"PUR_ORDER_ITEM_ID" VARCHAR2(100 BYTE) NULL ,
"PUR_ORDER_ITEM_NO" VARCHAR2(100 BYTE) NULL ,
"MATERIAL_ID" VARCHAR2(32 BYTE) NULL ,
"MATERIAL_NO" VARCHAR2(20 BYTE) NULL ,
"MATERIAL_DESC" VARCHAR2(500 BYTE) NULL ,
"SUPPLIER_MATERIAL_NUMBER" VARCHAR2(255 BYTE) NULL ,
"DELIVERY_MATERIAL_NAME" VARCHAR2(255 BYTE) NULL ,
"CHINESE_NAME" VARCHAR2(255 BYTE) NULL ,
"MODEL" VARCHAR2(255 BYTE) NULL ,
"BRAND" VARCHAR2(30 BYTE) NULL ,
"SOURCE_AREA" VARCHAR2(255 BYTE) NULL ,
"FACTORY_CODE" VARCHAR2(45 BYTE) NULL ,
"FACTORY_NAME" VARCHAR2(255 BYTE) NULL ,
"WAREHOUSE_CODE" VARCHAR2(45 BYTE) NULL ,
"WAREHOUSE_NAME" VARCHAR2(255 BYTE) NULL ,
"DELIVERY_DATE" DATE NULL ,
"DELIVERY_QUANTITY" NUMBER(11,3) DEFAULT 0  NULL ,
"PACK_QUANTITY" VARCHAR2(45 BYTE) NULL ,
"DELIVERY_ORDER_ID" VARCHAR2(32 BYTE) NULL ,
"DELIVERY_ORDER_ITEM_ID" VARCHAR2(32 BYTE) NULL ,
"DELIVERY_ORDER_NO" VARCHAR2(50 BYTE) NULL ,
"DELIVERY_ORDER_ITEM_NO" VARCHAR2(50 BYTE) NULL ,
"IS_JIT" NUMBER(1) NULL ,
"USED_STATUS" VARCHAR2(100 BYTE) DEFAULT NULL  NULL ,
"SEND_STATUS" VARCHAR2(100 BYTE) NULL ,
"CHANGE_STATUS" VARCHAR2(100 BYTE) NULL ,
"PUR_PLANER_ID" VARCHAR2(32 BYTE) NULL ,
"CONFIRM_DELIVERY_DATE" DATE NULL ,
"SEND_TIME" DATE NULL ,
"CONFIRM_TIME" DATE NULL ,
"SUP_REMARK" VARCHAR2(255 BYTE) NULL ,
"PUR_REMARK" VARCHAR2(255 BYTE) NULL ,
"ORDER_DELIVERY_DATE" DATE NULL ,
"PUR_CONFIRM_STATUS" NUMBER(2) NULL ,
"SUP_CONFIRM_STATUS" NUMBER(2) NULL ,
"ORDER_UNIT" VARCHAR2(50 BYTE) NULL ,
"IS_LOCK" VARCHAR2(2 BYTE) NULL ,
"JIT_ITEM" VARCHAR2(5 BYTE) NULL ,
"QUOTA" NUMBER(5) NULL ,
"LAST_DISTRIBUTE_MUN" NUMBER(20) NULL ,
"CUMULATIVE_DISTRIBUTABLE_MUN" NUMBER(20) NULL ,
"LAST_DISTRIBUTION_TIME" DATE NULL ,
"PUR_ORDER_STATUS" NUMBER(11) NULL ,
"CONSUME_MUNBER" NUMBER(20) NULL ,
"PLAN_SEND_STATUS" VARCHAR2(100 BYTE) NULL ,
"CHANGE_REASON" VARCHAR2(20 BYTE) NULL ,
"IS_CAN_DELIVERY" NUMBER(11) DEFAULT 0  NULL ,
"ONWAY_QUANTITY" NUMBER(11,3) DEFAULT NULL  NULL ,
"RECEIVED_QUANTITY" NUMBER(11,3) DEFAULT NULL  NULL ,
"EXTERNAL_MATERIAL_GROUP" VARCHAR2(255 BYTE) NULL ,
"MATERIAL_GROUP" VARCHAR2(255 BYTE) NULL ,
"FINISHED_PRODUCT_CODE" VARCHAR2(255 BYTE) NULL ,
"FINISHED_PRODUCT_DESC" VARCHAR2(255 BYTE) NULL ,
"TOTAL_GROUP_ID" VARCHAR2(32) NULL,
"TOTAL_GROUP_NAME" VARCHAR2(255) NULL,
"ACCOUNT_SET_ID" VARCHAR2(32) NULL,
"ACCOUNT_SET_NAME" VARCHAR2(255) NULL,
"ACCOUNT_CODE" VARCHAR2(255) NULL,
"INSTITUTIONS_ID" VARCHAR2(32) NULL,
"INSTITUTIONS_NAME" VARCHAR2(255) NULL,
"IN_THE_ORGANIZATION_ID" VARCHAR2(32) NULL,
"IN_THE_ORGANIZATION_NAME" VARCHAR2(255) NULL,
"DEPART_ID" VARCHAR2(32) NULL,
"DEPART_NAME" VARCHAR2(255) NULL
);
COMMENT ON TABLE "T_BASE_DELIVERY_SUP_PLAN_ITEM" IS '送货计划行';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."CREATE_TIME" IS '发货时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."IS_ENABLE" IS '是否可用，0不可用，1可用';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."PLAN_ID" IS '送货计划头id';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."PUR_COMPANY_ID" IS '采购员公司id';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."PUR_COMPANY_NAME" IS '客户';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."PUR_COMPANY_SRM_CODE" IS '客户编号';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."PUR_COMPANY_SAP_CODE" IS 'sap公司代码';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."PUR_USER_ID" IS '采购员id';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."PUR_USER_NAME" IS '采购员';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."SUP_COMPANY_ID" IS '供应商企业id';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."SUP_COMPANY_NAME" IS '供应商企业名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."SUP_COMPANY_SRM_CODE" IS '公司代码';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."SUP_USER_ID" IS '供应商id';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."SUP_USER_NAME" IS '供应商名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."PUR_ORDER_NO" IS '采购订单';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."PUR_ORDER_ITEM_NO" IS '订单项';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."MATERIAL_ID" IS '物料id';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."MATERIAL_NO" IS '物料编码';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."MATERIAL_DESC" IS '物料描述';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."SUPPLIER_MATERIAL_NUMBER" IS '供应商料号';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."DELIVERY_MATERIAL_NAME" IS '发货物料名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."CHINESE_NAME" IS '中文名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."MODEL" IS '型号';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."BRAND" IS '品牌';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."SOURCE_AREA" IS '原产地';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."FACTORY_CODE" IS '采购方工厂';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."FACTORY_NAME" IS '采购方工厂名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."WAREHOUSE_CODE" IS '仓库';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."WAREHOUSE_NAME" IS '仓库名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."DELIVERY_DATE" IS '交货日期';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."DELIVERY_QUANTITY" IS '送货数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."PACK_QUANTITY" IS '包装件数';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."DELIVERY_ORDER_NO" IS '送货单号';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."DELIVERY_ORDER_ITEM_NO" IS '项目';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."IS_JIT" IS '是否JIT物料';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."USED_STATUS" IS '状态，未生成送货单:N，部分送货:P，已生成送货单:Y';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."SEND_STATUS" IS '是否已发送：Y已发送，N未发送';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."CHANGE_STATUS" IS '是否变更，Y已变更，N未变更';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."PUR_PLANER_ID" IS '采购方计划员id';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."CONFIRM_DELIVERY_DATE" IS '确认交货日期';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."SEND_TIME" IS '发送日期';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."CONFIRM_TIME" IS '确认时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."SUP_REMARK" IS '供应商备注';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."PUR_REMARK" IS '采购方备注';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."ORDER_DELIVERY_DATE" IS '订单上交货日期';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."PUR_CONFIRM_STATUS" IS '采购确认状态：1未确认,2已确认,3已拒绝';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."SUP_CONFIRM_STATUS" IS '供应商确认状态：1未确认,2已确认,3已拒绝';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."ORDER_UNIT" IS '订单单位';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."IS_LOCK" IS '锁定标识：F为锁定';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."JIT_ITEM" IS 'JIT标识';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."QUOTA" IS '配额%';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."LAST_DISTRIBUTE_MUN" IS '上次分配数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."CUMULATIVE_DISTRIBUTABLE_MUN" IS '累计可分配数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."LAST_DISTRIBUTION_TIME" IS '上次分配时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."PUR_ORDER_STATUS" IS '采购订单确认状态：1订单未确认，2已确认，3已退回';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."CONSUME_MUNBER" IS '需求数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."PLAN_SEND_STATUS" IS '交货订单是否已发送：Y已发送，N未发送';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."CHANGE_REASON" IS '变更原因：采购方导致PUR, 供应方导致SUP';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."IS_CAN_DELIVERY" IS '是否可发货，0为否，1为是';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."ONWAY_QUANTITY" IS '在途数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."RECEIVED_QUANTITY" IS '收货数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."EXTERNAL_MATERIAL_GROUP" IS '外部物料组';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."MATERIAL_GROUP" IS '物料组';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."FINISHED_PRODUCT_CODE" IS '成品编号';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."FINISHED_PRODUCT_DESC" IS '成品描述';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."TOTAL_GROUP_ID" IS '总集团id';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."TOTAL_GROUP_NAME" IS '总集团名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."ACCOUNT_SET_ID" IS '账套 id';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."ACCOUNT_SET_NAME" IS '账套名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."ACCOUNT_CODE" IS '账套编码';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."INSTITUTIONS_ID" IS '机构id';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."INSTITUTIONS_NAME" IS '机构名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."IN_THE_ORGANIZATION_ID" IS '中支机构id';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."IN_THE_ORGANIZATION_NAME" IS '中支机构名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."DEPART_ID" IS '部门id';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."DEPART_NAME" IS '部门名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."ID" IS '主键ID';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."SUP_COMPANY_SAP_CODE" IS '供应商sap编码';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."PUR_ORDER_ID" IS '采购订单ID';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."PUR_ORDER_ITEM_ID" IS '采购订单行ID';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."DELIVERY_ORDER_ID" IS '送货单ID';
COMMENT ON COLUMN "T_BASE_DELIVERY_SUP_PLAN_ITEM"."DELIVERY_ORDER_ITEM_ID" IS '送货单行ID';
ALTER TABLE "T_BASE_DELIVERY_SUP_PLAN_ITEM" ADD PRIMARY KEY ("ID");



-- ----------------------------
-- 送货计划行
-- ----------------------------
CREATE TABLE "T_BASE_DELIVERY_PUR_PLAN_ITEM" (
"ID" VARCHAR2(50 BYTE) NOT NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"IS_ENABLE" NUMBER(1) DEFAULT 1  NULL ,
"PLAN_ID" VARCHAR2(32 BYTE) NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) DEFAULT NULL  NULL ,
"PUR_USER_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_SRM_CODE" VARCHAR2(45 BYTE) NULL ,
"SUP_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_USER_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_ORDER_ID" VARCHAR2(100 BYTE) NULL ,
"PUR_ORDER_NO" VARCHAR2(100 BYTE) NULL ,
"PUR_ORDER_ITEM_ID" VARCHAR2(100 BYTE) NULL ,
"PUR_ORDER_ITEM_NO" VARCHAR2(100 BYTE) NULL ,
"MATERIAL_ID" VARCHAR2(32 BYTE) NULL ,
"MATERIAL_NO" VARCHAR2(20 BYTE) NULL ,
"MATERIAL_DESC" VARCHAR2(500 BYTE) NULL ,
"SUPPLIER_MATERIAL_NUMBER" VARCHAR2(255 BYTE) NULL ,
"DELIVERY_MATERIAL_NAME" VARCHAR2(255 BYTE) NULL ,
"CHINESE_NAME" VARCHAR2(255 BYTE) NULL ,
"MODEL" VARCHAR2(255 BYTE) NULL ,
"BRAND" VARCHAR2(30 BYTE) NULL ,
"SOURCE_AREA" VARCHAR2(255 BYTE) NULL ,
"FACTORY_CODE" VARCHAR2(45 BYTE) NULL ,
"FACTORY_NAME" VARCHAR2(255 BYTE) NULL ,
"WAREHOUSE_CODE" VARCHAR2(45 BYTE) NULL ,
"WAREHOUSE_NAME" VARCHAR2(255 BYTE) NULL ,
"DELIVERY_DATE" DATE NULL ,
"DELIVERY_QUANTITY" NUMBER(11,3) DEFAULT 0  NULL ,
"PACK_QUANTITY" VARCHAR2(45 BYTE) NULL ,
"DELIVERY_ORDER_ID" VARCHAR2(32 BYTE) NULL ,
"DELIVERY_ORDER_ITEM_ID" VARCHAR2(32 BYTE) NULL ,
"DELIVERY_ORDER_NO" VARCHAR2(50 BYTE) NULL ,
"DELIVERY_ORDER_ITEM_NO" VARCHAR2(50 BYTE) NULL ,
"IS_JIT" NUMBER(1) NULL ,
"USED_STATUS" VARCHAR2(100 BYTE) DEFAULT NULL  NULL ,
"SEND_STATUS" VARCHAR2(100 BYTE) NULL ,
"CHANGE_STATUS" VARCHAR2(100 BYTE) NULL ,
"PUR_PLANER_ID" VARCHAR2(32 BYTE) NULL ,
"CONFIRM_DELIVERY_DATE" DATE NULL ,
"SEND_TIME" DATE NULL ,
"CONFIRM_TIME" DATE NULL ,
"SUP_REMARK" VARCHAR2(255 BYTE) NULL ,
"PUR_REMARK" VARCHAR2(255 BYTE) NULL ,
"ORDER_DELIVERY_DATE" DATE NULL ,
"ORDER_UNIT" VARCHAR2(50 BYTE) NULL ,
"PUR_CONFIRM_STATUS" NUMBER(2) NULL ,
"SUP_CONFIRM_STATUS" NUMBER(2) NULL ,
"IS_LOCK" VARCHAR2(2 BYTE) NULL ,
"JIT_ITEM" VARCHAR2(5 BYTE) NULL ,
"QUOTA" NUMBER(5) NULL ,
"LAST_DISTRIBUTE_MUN" NUMBER(20) NULL ,
"CUMULATIVE_DISTRIBUTABLE_MUN" NUMBER(20) NULL ,
"LAST_DISTRIBUTION_TIME" DATE NULL ,
"PUR_ORDER_STATUS" NUMBER(11) NULL ,
"CONSUME_MUNBER" NUMBER(20) NULL ,
"PLAN_SEND_STATUS" VARCHAR2(100 BYTE) NULL ,
"CHANGE_REASON" VARCHAR2(20 BYTE) NULL ,
"IS_CAN_DELIVERY" NUMBER(11) DEFAULT 0  NULL ,
"ONWAY_QUANTITY" NUMBER(11,3) DEFAULT NULL  NULL ,
"RECEIVED_QUANTITY" NUMBER(11,3) DEFAULT NULL  NULL ,
"EXTERNAL_MATERIAL_GROUP" VARCHAR2(255 BYTE) NULL ,
"MATERIAL_GROUP" VARCHAR2(255 BYTE) NULL ,
"FINISHED_PRODUCT_CODE" VARCHAR2(255 BYTE) NULL ,
"FINISHED_PRODUCT_DESC" VARCHAR2(255 BYTE) NULL ,
"TOTAL_GROUP_ID" VARCHAR2(32) NULL,
"TOTAL_GROUP_NAME" VARCHAR2(255) NULL,
"ACCOUNT_SET_ID" VARCHAR2(32) NULL,
"ACCOUNT_SET_NAME" VARCHAR2(255) NULL,
"ACCOUNT_CODE" VARCHAR2(255) NULL,
"INSTITUTIONS_ID" VARCHAR2(32) NULL,
"INSTITUTIONS_NAME" VARCHAR2(255) NULL,
"IN_THE_ORGANIZATION_ID" VARCHAR2(32) NULL,
"IN_THE_ORGANIZATION_NAME" VARCHAR2(255) NULL,
"DEPART_ID" VARCHAR2(32) NULL,
"DEPART_NAME" VARCHAR2(255) NULL
);
COMMENT ON TABLE "T_BASE_DELIVERY_PUR_PLAN_ITEM" IS '送货计划行';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."CREATE_TIME" IS '发货时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."IS_ENABLE" IS '是否可用，0不可用，1可用';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."PLAN_ID" IS '送货计划头id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."PUR_COMPANY_ID" IS '采购员公司id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."PUR_COMPANY_NAME" IS '客户';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."PUR_COMPANY_SRM_CODE" IS '客户编号';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."PUR_COMPANY_SAP_CODE" IS 'sap公司代码';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."PUR_USER_ID" IS '采购员id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."PUR_USER_NAME" IS '采购员';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."SUP_COMPANY_ID" IS '供应商企业id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."SUP_COMPANY_NAME" IS '供应商企业名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."SUP_COMPANY_SRM_CODE" IS '公司代码';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."SUP_USER_ID" IS '供应商id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."SUP_USER_NAME" IS '供应商名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."PUR_ORDER_NO" IS '采购订单';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."PUR_ORDER_ITEM_NO" IS '订单项';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."MATERIAL_ID" IS '物料id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."MATERIAL_NO" IS '物料编码';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."MATERIAL_DESC" IS '物料描述';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."SUPPLIER_MATERIAL_NUMBER" IS '供应商料号';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."DELIVERY_MATERIAL_NAME" IS '发货物料名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."CHINESE_NAME" IS '中文名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."MODEL" IS '型号';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."BRAND" IS '品牌';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."SOURCE_AREA" IS '原产地';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."FACTORY_CODE" IS '采购方工厂';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."FACTORY_NAME" IS '采购方工厂名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."WAREHOUSE_CODE" IS '仓库';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."WAREHOUSE_NAME" IS '仓库名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."DELIVERY_DATE" IS '交货日期';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."DELIVERY_QUANTITY" IS '送货数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."PACK_QUANTITY" IS '包装件数';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."DELIVERY_ORDER_NO" IS '送货单号';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."DELIVERY_ORDER_ITEM_NO" IS '项目';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."IS_JIT" IS '是否JIT物料';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."USED_STATUS" IS '状态，未生成送货单:N，已生成送货单:Y';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."SEND_STATUS" IS '是否已发送：Y已发送，N未发送';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."CHANGE_STATUS" IS '是否变更，Y已变更，N未变更';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."PUR_PLANER_ID" IS '采购方计划员id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."CONFIRM_DELIVERY_DATE" IS '确认交货日期';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."SEND_TIME" IS '发送日期';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."CONFIRM_TIME" IS '确认时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."SUP_REMARK" IS '供应商备注';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."PUR_REMARK" IS '采购方备注';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."ORDER_DELIVERY_DATE" IS '订单上交货日期';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."ORDER_UNIT" IS '订单单位';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."PUR_CONFIRM_STATUS" IS '采购确认状态：1未确认,2已确认,3已拒绝';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."SUP_CONFIRM_STATUS" IS '供应商确认状态：1未确认,2已确认,3已拒绝';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."IS_LOCK" IS '锁定标识：F为锁定';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."JIT_ITEM" IS 'JIT标识';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."QUOTA" IS '配额%';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."LAST_DISTRIBUTE_MUN" IS '上次分配数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."CUMULATIVE_DISTRIBUTABLE_MUN" IS '累计可分配数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."LAST_DISTRIBUTION_TIME" IS '上次分配时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."PUR_ORDER_STATUS" IS '采购订单确认状态：1订单未确认，2已确认，3已退回';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."CONSUME_MUNBER" IS '需求数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."PLAN_SEND_STATUS" IS '交货订单是否已发送：Y已发送，N未发送';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."CHANGE_REASON" IS '变更原因：采购方导致PUR, 供应方导致SUP';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."IS_CAN_DELIVERY" IS '是否可发货，0为否，1为是';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."ONWAY_QUANTITY" IS '在途数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."RECEIVED_QUANTITY" IS '收货数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."EXTERNAL_MATERIAL_GROUP" IS '外部物料组';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."MATERIAL_GROUP" IS '物料组';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."FINISHED_PRODUCT_CODE" IS '成品编号';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."FINISHED_PRODUCT_DESC" IS '成品描述';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."TOTAL_GROUP_ID" IS '总集团id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."TOTAL_GROUP_NAME" IS '总集团名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."ACCOUNT_SET_ID" IS '账套 id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."ACCOUNT_SET_NAME" IS '账套名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."ACCOUNT_CODE" IS '账套编码';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."INSTITUTIONS_ID" IS '机构id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."INSTITUTIONS_NAME" IS '机构名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."IN_THE_ORGANIZATION_ID" IS '中支机构id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."IN_THE_ORGANIZATION_NAME" IS '中支机构名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."DEPART_ID" IS '部门id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."DEPART_NAME" IS '部门名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."ID" IS '主键ID';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."SUP_COMPANY_SAP_CODE" IS '供应商sap编码';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."PUR_ORDER_ID" IS '采购订单ID';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."PUR_ORDER_ITEM_ID" IS '采购订单行ID';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."DELIVERY_ORDER_ID" IS '送货单ID';
COMMENT ON COLUMN "T_BASE_DELIVERY_PUR_PLAN_ITEM"."DELIVERY_ORDER_ITEM_ID" IS '送货单行ID';
ALTER TABLE "T_BASE_DELIVERY_PUR_PLAN_ITEM" ADD PRIMARY KEY ("ID");



-- ----------------------------
-- 送货通知单的变更日志
-- ----------------------------
CREATE TABLE "T_BASE_DELIVERY_PLAN_ITEM_LOG" (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"DELIVERY_PLAN_ITEM_ID" VARCHAR2(32 BYTE) NOT NULL ,
"CHANGE_LOG" VARCHAR2(255 BYTE) NULL ,
"ORIGIN_QUANTITY" NUMBER(11,3) NULL ,
"CHANGE_QUANTITY" VARCHAR2(11 BYTE) NULL ,
"ORIGIN_DELIVERY_DATE" DATE NULL ,
"CHANGE_DELIVERY_DATE" DATE NULL 
);
COMMENT ON TABLE "T_BASE_DELIVERY_PLAN_ITEM_LOG" IS '送货通知单的变更日志';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_LOG"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_LOG"."DELIVERY_PLAN_ITEM_ID" IS '计划id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_LOG"."CHANGE_LOG" IS '变更备注';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_LOG"."ORIGIN_QUANTITY" IS '原始数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_LOG"."CHANGE_QUANTITY" IS '变更数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_LOG"."ORIGIN_DELIVERY_DATE" IS '原始发货日期';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_LOG"."CHANGE_DELIVERY_DATE" IS '变更发货日期';
ALTER TABLE "T_BASE_DELIVERY_PLAN_ITEM_LOG" ADD PRIMARY KEY ("ID");




-- ----------------------------
-- 送货计划行备份记录
-- ----------------------------
CREATE TABLE "T_BASE_DELIVERY_PLAN_ITEM_HIS" (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"IS_ENABLE" NUMBER(1) DEFAULT 1  NULL ,
"PLAN_ID" VARCHAR2(32 BYTE) NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) DEFAULT NULL  NULL ,
"PUR_USER_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_SRM_CODE" VARCHAR2(45 BYTE) NULL ,
"SUP_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_USER_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_ORDER_ID" VARCHAR2(100 BYTE) NULL ,
"PUR_ORDER_NO" VARCHAR2(100 BYTE) NULL ,
"PUR_ORDER_ITEM_ID" VARCHAR2(100 BYTE) NULL ,
"PUR_ORDER_ITEM_NO" VARCHAR2(100 BYTE) NULL ,
"MATERIAL_ID" VARCHAR2(32 BYTE) NULL ,
"MATERIAL_NO" VARCHAR2(20 BYTE) NULL ,
"MATERIAL_DESC" VARCHAR2(500 BYTE) NULL ,
"SUPPLIER_MATERIAL_NUMBER" VARCHAR2(255 BYTE) NULL ,
"DELIVERY_MATERIAL_NAME" VARCHAR2(255 BYTE) NULL ,
"CHINESE_NAME" VARCHAR2(255 BYTE) NULL ,
"MODEL" VARCHAR2(255 BYTE) NULL ,
"BRAND" VARCHAR2(30 BYTE) NULL ,
"SOURCE_AREA" VARCHAR2(255 BYTE) NULL ,
"FACTORY_CODE" VARCHAR2(45 BYTE) NULL ,
"FACTORY_NAME" VARCHAR2(255 BYTE) NULL ,
"WAREHOUSE_CODE" VARCHAR2(45 BYTE) NULL ,
"WAREHOUSE_NAME" VARCHAR2(255 BYTE) NULL ,
"DELIVERY_DATE" DATE NULL ,
"DELIVERY_QUANTITY" NUMBER(11,3) DEFAULT 0  NULL ,
"PACK_QUANTITY" VARCHAR2(45 BYTE) NULL ,
"DELIVERY_ORDER_ID" VARCHAR2(32 BYTE) NULL ,
"DELIVERY_ORDER_ITEM_ID" VARCHAR2(32 BYTE) NULL ,
"DELIVERY_ORDER_NO" VARCHAR2(50 BYTE) NULL ,
"DELIVERY_ORDER_ITEM_NO" VARCHAR2(50 BYTE) NULL ,
"IS_JIT" NUMBER(1) NULL ,
"USED_STATUS" VARCHAR2(100 BYTE) DEFAULT NULL  NULL ,
"SEND_STATUS" VARCHAR2(100 BYTE) NULL ,
"CHANGE_STATUS" VARCHAR2(100 BYTE) NULL ,
"PUR_PLANER_ID" VARCHAR2(32 BYTE) NULL ,
"CONFIRM_DELIVERY_DATE" DATE NULL ,
"SEND_TIME" DATE NULL ,
"CONFIRM_TIME" DATE NULL ,
"SUP_REMARK" VARCHAR2(255 BYTE) NULL ,
"PUR_REMARK" VARCHAR2(255 BYTE) NULL ,
"ORDER_DELIVERY_DATE" DATE NULL ,
"ORDER_HIS_ID" VARCHAR2(32 BYTE) NOT NULL ,
"CAUSE" VARCHAR2(255 BYTE) NULL ,
"HIS_TIME" DATE NULL ,
"PUR_CONFIRM_STATUS" VARCHAR2(1 BYTE) NULL ,
"SUP_CONFIRM_STATUS" VARCHAR2(1 BYTE) NULL ,
"ORDER_UNIT" VARCHAR2(50 BYTE) NULL ,
"IS_LOCK" VARCHAR2(2 BYTE) NULL ,
"JIT_ITEM" VARCHAR2(5 BYTE) NULL ,
"QUOTA" NUMBER(5) NULL ,
"LAST_DISTRIBUTE_MUN" NUMBER(20) NULL ,
"CUMULATIVE_DISTRIBUTABLE_MUN" NUMBER(20) NULL ,
"LAST_DISTRIBUTION_TIME" DATE NULL ,
"PUR_ORDER_STATUS" NUMBER(11) NULL ,
"CONSUME_MUNBER" NUMBER(20) NULL ,
"PLAN_SEND_STATUS" VARCHAR2(100 BYTE) NULL ,
"CHANGE_REASON" VARCHAR2(20 BYTE) NULL ,
"IS_CAN_DELIVERY" NUMBER(11) DEFAULT 0  NULL ,
"ONWAY_QUANTITY" NUMBER(11,3) DEFAULT NULL  NULL ,
"RECEIVED_QUANTITY" NUMBER(11,3) DEFAULT NULL  NULL ,
"EXTERNAL_MATERIAL_GROUP" VARCHAR2(255 BYTE) NULL ,
"MATERIAL_GROUP" VARCHAR2(255 BYTE) NULL ,
"FINISHED_PRODUCT_CODE" VARCHAR2(255 BYTE) NULL ,
"FINISHED_PRODUCT_DESC" VARCHAR2(255 BYTE) NULL ,
"TOTAL_GROUP_ID" VARCHAR2(32) NULL,
"TOTAL_GROUP_NAME" VARCHAR2(255) NULL,
"ACCOUNT_SET_ID" VARCHAR2(32) NULL,
"ACCOUNT_SET_NAME" VARCHAR2(255) NULL,
"ACCOUNT_CODE" VARCHAR2(255) NULL,
"INSTITUTIONS_ID" VARCHAR2(32) NULL,
"INSTITUTIONS_NAME" VARCHAR2(255) NULL,
"IN_THE_ORGANIZATION_ID" VARCHAR2(32) NULL,
"IN_THE_ORGANIZATION_NAME" VARCHAR2(255) NULL,
"DEPART_ID" VARCHAR2(32) NULL,
"DEPART_NAME" VARCHAR2(255) NULL
);
COMMENT ON TABLE "T_BASE_DELIVERY_PLAN_ITEM_HIS" IS '送货计划行备份记录';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."CREATE_TIME" IS '发货时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."IS_ENABLE" IS '是否可用，0不可用，1可用';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."PLAN_ID" IS '送货计划头id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."PUR_COMPANY_ID" IS '采购员公司id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."PUR_COMPANY_NAME" IS '客户';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."PUR_COMPANY_SRM_CODE" IS '客户编号';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."PUR_COMPANY_SAP_CODE" IS 'sap公司代码';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."PUR_USER_ID" IS '采购员id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."PUR_USER_NAME" IS '采购员';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."SUP_COMPANY_ID" IS '供应商企业id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."SUP_COMPANY_NAME" IS '供应商企业名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."SUP_COMPANY_SRM_CODE" IS '公司代码';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."SUP_USER_ID" IS '供应商id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."SUP_USER_NAME" IS '供应商名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."PUR_ORDER_NO" IS '采购订单';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."PUR_ORDER_ITEM_NO" IS '订单项';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."MATERIAL_ID" IS '物料id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."MATERIAL_NO" IS '物料编码';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."MATERIAL_DESC" IS '物料描述';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."SUPPLIER_MATERIAL_NUMBER" IS '供应商料号';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."DELIVERY_MATERIAL_NAME" IS '发货物料名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."CHINESE_NAME" IS '中文名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."MODEL" IS '型号';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."BRAND" IS '品牌';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."SOURCE_AREA" IS '原产地';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."FACTORY_CODE" IS '采购方工厂';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."FACTORY_NAME" IS '采购方工厂名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."WAREHOUSE_CODE" IS '仓库';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."WAREHOUSE_NAME" IS '仓库名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."DELIVERY_DATE" IS '交货日期';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."DELIVERY_QUANTITY" IS '送货数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."PACK_QUANTITY" IS '包装件数';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."DELIVERY_ORDER_NO" IS '送货单号';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."DELIVERY_ORDER_ITEM_NO" IS '项目';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."IS_JIT" IS '是否JIT物料';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."USED_STATUS" IS '状态，未生成送货单:N，已生成送货单:Y';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."SEND_STATUS" IS '是否已发送：Y已发送，N未发送';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."CHANGE_STATUS" IS '是否变更，Y已变更，N未变更';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."PUR_PLANER_ID" IS '采购方计划员id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."CONFIRM_DELIVERY_DATE" IS '确认交货日期';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."SEND_TIME" IS '发送日期';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."CONFIRM_TIME" IS '确认时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."SUP_REMARK" IS '供应商备注';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."PUR_REMARK" IS '采购方备注';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."ORDER_DELIVERY_DATE" IS '订单上交货日期';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."ORDER_HIS_ID" IS '历史订单Id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."CAUSE" IS '变更原因';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."HIS_TIME" IS '备份时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."PUR_CONFIRM_STATUS" IS '采购确认状态：已确认CONFIRM,未确认UNCONFIRM,已拒绝REFUSE';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."SUP_CONFIRM_STATUS" IS '供应商确认状态：已确认CONFIRM,未确认UNCONFIRM,已拒绝REFUSE';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."ORDER_UNIT" IS '订单单位';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."IS_LOCK" IS '锁定标识：F为锁定';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."JIT_ITEM" IS 'JIT标识';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."QUOTA" IS '配额%';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."LAST_DISTRIBUTE_MUN" IS '上次分配数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."CUMULATIVE_DISTRIBUTABLE_MUN" IS '累计可分配数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."LAST_DISTRIBUTION_TIME" IS '上次分配时间';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."PUR_ORDER_STATUS" IS '采购订单确认状态：1订单未确认，2已确认，3已退回';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."CONSUME_MUNBER" IS '需求数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."PLAN_SEND_STATUS" IS '交货订单是否已发送：Y已发送，N未发送';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."CHANGE_REASON" IS '变更原因：采购方导致PUR, 供应方导致SUP';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."IS_CAN_DELIVERY" IS '是否可发货，0为否，1为是';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."ONWAY_QUANTITY" IS '在途数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."RECEIVED_QUANTITY" IS '收货数量';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."EXTERNAL_MATERIAL_GROUP" IS '外部物料组';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."MATERIAL_GROUP" IS '物料组';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."FINISHED_PRODUCT_CODE" IS '成品编号';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."FINISHED_PRODUCT_DESC" IS '成品描述';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."TOTAL_GROUP_ID" IS '总集团id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."TOTAL_GROUP_NAME" IS '总集团名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."ACCOUNT_SET_ID" IS '账套 id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."ACCOUNT_SET_NAME" IS '账套名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."ACCOUNT_CODE" IS '账套编码';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."INSTITUTIONS_ID" IS '机构id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."INSTITUTIONS_NAME" IS '机构名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."IN_THE_ORGANIZATION_ID" IS '中支机构id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."IN_THE_ORGANIZATION_NAME" IS '中支机构名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."DEPART_ID" IS '部门id';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."DEPART_NAME" IS '部门名称';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."ID" IS '原数据ID';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."SUP_COMPANY_SAP_CODE" IS '供应商sap编码';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."PUR_ORDER_ID" IS '采购订单ID';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."PUR_ORDER_ITEM_ID" IS '采购订单行ID';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."DELIVERY_ORDER_ID" IS '送货单ID';
COMMENT ON COLUMN "T_BASE_DELIVERY_PLAN_ITEM_HIS"."DELIVERY_ORDER_ITEM_ID" IS '送货单行ID';
ALTER TABLE "T_BASE_DELIVERY_PLAN_ITEM_HIS" ADD PRIMARY KEY ("ID");



-- ----------------------------
-- 物料文件表
-- ----------------------------
CREATE TABLE "T_BASE_MATERIAL_FILE_NOTICE" (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"MATERIAL_NAME" VARCHAR2(255 BYTE) NULL ,
"MATERIAL_CODE" VARCHAR2(255 BYTE) NULL ,
"DESCRIPTION" VARCHAR2(255 BYTE) NULL ,
"CREATE_TIME" DATE DEFAULT NULL  NULL ,
"UPDATE_TIME" DATE DEFAULT NULL  NULL ,
"FILE_SUFFIX" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
"FILE_VERSION" VARCHAR2(255 BYTE) DEFAULT ''  NOT NULL ,
"MATERIAL_ID" VARCHAR2(32 BYTE) NULL ,
"FILE_CODE" VARCHAR2(255 BYTE) NOT NULL ,
"FILE_ID" VARCHAR2(32 BYTE) NULL ,
"FILE_NAME" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
"FILE_RENAME" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
"FILE_TYPE" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
"MATERIAL_CATEGORY" VARCHAR2(255 BYTE) NULL ,
"CATEGORY_PURCHASER" VARCHAR2(255 BYTE) NULL ,
"CATEGORY_PURCHASER_ID" VARCHAR2(32 BYTE) NULL ,
"CATEGORY_PURCHASER_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_ID" VARCHAR2(32 BYTE) NOT NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_SRM_CODE" VARCHAR2(100 BYTE) NULL ,
"SUP_COMPANY_SAP_CODE" VARCHAR2(100 BYTE) NULL ,
"SEND_TIME" DATE DEFAULT NULL  NULL ,
"CONFIRM_TIME" DATE NULL ,
"CONFIRM_STATUS" NUMBER(1) DEFAULT 0  NULL ,
"CONFIRM_USER_ID" VARCHAR2(32 BYTE) NULL ,
"CONFIRM_USER_NAME" VARCHAR2(255 BYTE) NULL 
);
COMMENT ON TABLE "T_BASE_MATERIAL_FILE_NOTICE" IS '物料文件表';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."COMPANY_ID" IS '公司ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."MATERIAL_NAME" IS '物料名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."MATERIAL_CODE" IS '物料标识';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."DESCRIPTION" IS '物料描述';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."FILE_SUFFIX" IS '文件后缀';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."FILE_VERSION" IS '文件版本';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."MATERIAL_ID" IS '物料ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."FILE_CODE" IS '文件编码';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."FILE_ID" IS '文件ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."FILE_NAME" IS '附件名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."FILE_RENAME" IS '文件重命名';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."FILE_TYPE" IS '文件重命名';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."MATERIAL_CATEGORY" IS '物料品类';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."CATEGORY_PURCHASER" IS '品类采购员';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."CATEGORY_PURCHASER_ID" IS '品类采购员id';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."CATEGORY_PURCHASER_NAME" IS '品类采购员名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."SUP_COMPANY_ID" IS '供应商企业id';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."SUP_COMPANY_NAME" IS '供应商企业名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."SUP_COMPANY_SAP_CODE" IS '供应商SAP编码';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."SEND_TIME" IS '发送时间';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."CONFIRM_TIME" IS '确认时间';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."CONFIRM_STATUS" IS '确认状态：0：未确认；1：已确认';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."CONFIRM_USER_ID" IS '确认人ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_NOTICE"."CONFIRM_USER_NAME" IS '确认人名称';
ALTER TABLE "T_BASE_MATERIAL_FILE_NOTICE" ADD PRIMARY KEY ("ID");




-- ----------------------------
-- 物料文件历史表
-- ----------------------------
CREATE TABLE "T_BASE_MATERIAL_FILE_HIS" (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"MATERIAL_NAME" VARCHAR2(255 BYTE) NULL ,
"MATERIAL_CODE" VARCHAR2(255 BYTE) NULL ,
"DESCRIPTION" VARCHAR2(255 BYTE) NULL ,
"CREATE_TIME" DATE DEFAULT NULL  NULL ,
"UPDATE_TIME" DATE DEFAULT NULL  NULL ,
"PARENT_ID" VARCHAR2(32 BYTE) NULL ,
"FILE_SUFFIX" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
"FILE_VERSION" VARCHAR2(255 BYTE) DEFAULT ''  NOT NULL ,
"MATERIAL_ID" VARCHAR2(32 BYTE) NOT NULL ,
"FILE_CODE" VARCHAR2(255 BYTE) NOT NULL ,
"FILE_ID" VARCHAR2(32 BYTE) NULL ,
"FILE_NAME" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
"FILE_RENAME" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
"FILE_TYPE" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
"MATERIAL_CATEGORY" VARCHAR2(255 BYTE) NULL ,
"CATEGORY_PURCHASER" VARCHAR2(255 BYTE) NULL ,
"CATEGORY_PURCHASER_ID" VARCHAR2(32 BYTE) NULL ,
"CATEGORY_PURCHASER_NAME" VARCHAR2(255 BYTE) NULL ,
"IS_ENABLE" NUMBER(3) NULL 
);
COMMENT ON TABLE "T_BASE_MATERIAL_FILE_HIS" IS '物料文件历史表';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."COMPANY_ID" IS '公司ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."MATERIAL_NAME" IS '物料名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."MATERIAL_CODE" IS '物料标识';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."DESCRIPTION" IS '物料描述';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."PARENT_ID" IS '上级ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."FILE_SUFFIX" IS '文件后缀';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."FILE_VERSION" IS '文件后缀';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."MATERIAL_ID" IS '物料ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."FILE_CODE" IS '文件编码';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."FILE_ID" IS '文件ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."FILE_NAME" IS '附件名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."FILE_RENAME" IS '文件重命名';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."FILE_TYPE" IS '文件重命名';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."MATERIAL_CATEGORY" IS '物料品类';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."CATEGORY_PURCHASER" IS '品类采购员';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."CATEGORY_PURCHASER_ID" IS '品类采购员id';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."CATEGORY_PURCHASER_NAME" IS '品类采购员名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE_HIS"."IS_ENABLE" IS '是否可用';
ALTER TABLE "T_BASE_MATERIAL_FILE_HIS" ADD PRIMARY KEY ("ID");





-- ----------------------------
-- 物料文件表
-- ----------------------------
CREATE TABLE "T_BASE_MATERIAL_FILE" (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"MATERIAL_NAME" VARCHAR2(255 BYTE) NULL ,
"MATERIAL_CODE" VARCHAR2(255 BYTE) NULL ,
"DESCRIPTION" VARCHAR2(255 BYTE) NULL ,
"CREATE_TIME" DATE DEFAULT NULL  NULL ,
"UPDATE_TIME" DATE DEFAULT NULL  NULL ,
"PARENT_ID" VARCHAR2(32 BYTE) NULL ,
"FILE_SUFFIX" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
"FILE_VERSION" VARCHAR2(255 BYTE) DEFAULT ''  NOT NULL ,
"MATERIAL_ID" VARCHAR2(32 BYTE) NULL ,
"FILE_CODE" VARCHAR2(255 BYTE) NOT NULL ,
"FILE_ID" VARCHAR2(32 BYTE) NULL ,
"FILE_NAME" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
"FILE_RENAME" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
"FILE_TYPE" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
"MATERIAL_CATEGORY" VARCHAR2(255 BYTE) NULL ,
"CATEGORY_PURCHASER" VARCHAR2(255 BYTE) NULL ,
"CATEGORY_PURCHASER_ID" VARCHAR2(32 BYTE) NULL ,
"CATEGORY_PURCHASER_NAME" VARCHAR2(255 BYTE) NULL ,
"IS_ENABLE" NUMBER(3) NULL 
);
COMMENT ON TABLE "T_BASE_MATERIAL_FILE" IS '物料文件表';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."COMPANY_ID" IS '公司ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."MATERIAL_NAME" IS '物料名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."MATERIAL_CODE" IS '物料标识';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."DESCRIPTION" IS '物料描述';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."PARENT_ID" IS '上级ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."FILE_SUFFIX" IS '文件后缀';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."FILE_VERSION" IS '文件后缀';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."MATERIAL_ID" IS '物料ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."FILE_CODE" IS '文件编码';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."FILE_ID" IS '文件ID';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."FILE_NAME" IS '附件名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."FILE_RENAME" IS '文件重命名';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."FILE_TYPE" IS '文件重命名';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."MATERIAL_CATEGORY" IS '物料品类';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."CATEGORY_PURCHASER" IS '品类采购员';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."CATEGORY_PURCHASER_ID" IS '品类采购员id';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."CATEGORY_PURCHASER_NAME" IS '品类采购员名称';
COMMENT ON COLUMN "T_BASE_MATERIAL_FILE"."IS_ENABLE" IS '是否可用';
ALTER TABLE "T_BASE_MATERIAL_FILE" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 收货人信息表
-- ----------------------------
CREATE TABLE "T_LIBY_WAREHOUSE_RECEIVER_REF" (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"WAREHOUSE_ID" VARCHAR2(50 BYTE) NULL ,
"WAREHOUSE_NAME" VARCHAR2(255 BYTE) NULL ,
"WAREHOUSE_CODE" VARCHAR2(50 BYTE) NULL ,
"RECEIVER_NAME" VARCHAR2(32 BYTE) NULL ,
"RECEIVER_PHONE" VARCHAR2(255 BYTE) NULL ,
"RECEIVER_EMAIL" VARCHAR2(255 BYTE) NULL ,
"RECEIVER_FAX" VARCHAR2(255 BYTE) NULL ,
"CREATE_TIME" DATE NULL ,
"UPDATE_TIME" DATE NULL ,
"IS_ENABLE" NUMBER(2) DEFAULT 1  NULL ,
"LAST_UPDATE_TIME" DATE NULL 
);
COMMENT ON TABLE "T_LIBY_WAREHOUSE_RECEIVER_REF" IS '收货人信息表';
COMMENT ON COLUMN "T_LIBY_WAREHOUSE_RECEIVER_REF"."ID" IS '主键ID';
COMMENT ON COLUMN "T_LIBY_WAREHOUSE_RECEIVER_REF"."WAREHOUSE_ID" IS '仓库id';
COMMENT ON COLUMN "T_LIBY_WAREHOUSE_RECEIVER_REF"."WAREHOUSE_NAME" IS '仓库名称';
COMMENT ON COLUMN "T_LIBY_WAREHOUSE_RECEIVER_REF"."WAREHOUSE_CODE" IS 'code';
COMMENT ON COLUMN "T_LIBY_WAREHOUSE_RECEIVER_REF"."RECEIVER_NAME" IS '联系人';
COMMENT ON COLUMN "T_LIBY_WAREHOUSE_RECEIVER_REF"."RECEIVER_PHONE" IS '电话号码';
COMMENT ON COLUMN "T_LIBY_WAREHOUSE_RECEIVER_REF"."RECEIVER_EMAIL" IS '邮箱';
COMMENT ON COLUMN "T_LIBY_WAREHOUSE_RECEIVER_REF"."RECEIVER_FAX" IS '传真';
COMMENT ON COLUMN "T_LIBY_WAREHOUSE_RECEIVER_REF"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_LIBY_WAREHOUSE_RECEIVER_REF"."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN "T_LIBY_WAREHOUSE_RECEIVER_REF"."IS_ENABLE" IS '是否禁用（0 禁用 1 启用）';
COMMENT ON COLUMN "T_LIBY_WAREHOUSE_RECEIVER_REF"."LAST_UPDATE_TIME" IS '最后更新时间';
ALTER TABLE "T_LIBY_WAREHOUSE_RECEIVER_REF" ADD PRIMARY KEY ("ID");





-- ----------------------------
-- 采购方订单头
-- ----------------------------

CREATE TABLE "T_BASE_SUP_ORDER_HIS" (
"ID" VARCHAR2(50 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(50 BYTE) NULL ,
"PUR_COMPANY_ID" VARCHAR2(50 BYTE) NULL ,
"PUR_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_SAP_CODE" VARCHAR2(50 BYTE) NULL ,
"PUR_USER_ID" VARCHAR2(50 BYTE) NULL ,
"PUR_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"DEPARTMENT_ID" VARCHAR2(50 BYTE) NULL ,
"DEPARTMENT_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_ID" VARCHAR2(50 BYTE) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_SAP_CODE" VARCHAR2(60 BYTE) NULL ,
"SUP_USER_ID" VARCHAR2(50 BYTE) NULL ,
"SUP_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"ORDER_NO" VARCHAR2(255 BYTE) NOT NULL ,
"ORDER_TYPE" VARCHAR2(11 BYTE) NULL ,
"ORDER_STATUS" NUMBER(11) NULL ,
"ORDER_SEND_STATUS" NUMBER(11) NULL ,
"ORDER_DATE" DATE NULL ,
"DELIVERY_STATUS" NUMBER(11) NULL ,
"PUR_REMARK" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
"SUP_REMARK" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"CREATE_USER" VARCHAR2(50 BYTE) NULL ,
"LAST_UPDATE_TIME" DATE DEFAULT sysdate  NULL ,
"LAST_UPDATE_USER" VARCHAR2(50 BYTE) NULL ,
"SEND_TIME" DATE NULL ,
"TAX_RATE" NUMBER(11,6) NULL ,
"TAX_AMOUNT" NUMBER(11,3) NULL ,
"EXCHANGE_RATE" VARCHAR2(50 BYTE) NULL ,
"AUDIT_STATUS" NUMBER(11) NULL ,
"IS_AUDIT" NCHAR(1) NULL ,
"PAY_TERMS" VARCHAR2(50 BYTE) NULL ,
"PAY_TERMS_DESC" VARCHAR2(255 BYTE) NULL ,
"CURRENCY" VARCHAR2(255 BYTE) NULL ,
"TAX_TOTAL_PRICE" NUMBER(11,3) DEFAULT 0  NULL ,
"TOTAL_QUANTITY" NUMBER(11,3) DEFAULT 0  NULL ,
"IS_ENABLE" NUMBER(11) DEFAULT 1  NULL ,
"VERSION" VARCHAR2(255 BYTE) DEFAULT 0  NULL ,
"SUPPLIER_TEL" VARCHAR2(255 BYTE) NULL ,
"SUPPLIER_FAX" VARCHAR2(255 BYTE) NULL ,
"SUPPLIER_PERSON" VARCHAR2(255 BYTE) NULL ,
"PURCHASE_GROUP" VARCHAR2(255 BYTE) NULL ,
"BILL_NAME" VARCHAR2(255 BYTE) NULL ,
"ADDRESS_NO" VARCHAR2(255 BYTE) NULL ,
"SALE_PERSON" VARCHAR2(255 BYTE) NULL ,
"HEAD_TXT" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_SHORT_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"TAX_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_PLANER_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_PLANER_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_PLANER_WORK_NUM" VARCHAR2(255 BYTE) NULL ,
"HIS_ID" VARCHAR2(32 BYTE) NOT NULL ,
"CAUSE" VARCHAR2(255 BYTE) NULL ,
"HIS_TIME" DATE NULL ,
"IS_REFUSE_PRICE" NUMBER(1) NULL ,
"IS_REFUSE_QUANTITY" NUMBER(1) NULL ,
"IS_REFUSE_DELIVERED_DATE" NUMBER(1) NULL ,
"INTER_TRADE_CODE" VARCHAR2(255 BYTE) NULL ,
"INTER_TRADE_DESC" VARCHAR2(255 BYTE) NULL ,
"RETURN_FLAG" VARCHAR2(255 BYTE) NULL ,
"FREE_FLAG" VARCHAR2(255 BYTE) NULL ,
"REPLY_TIME" DATE NULL ,
"PURCHASE_APPLY_NO" VARCHAR2(255) NULL,
"CONTRACT_NUMBER" VARCHAR2(255) NULL,
"ORDER_TOTAL" NUMBER(20,3) NULL,
"TOTAL_GROUP_ID" VARCHAR2(32) NULL,
"TOTAL_GROUP_NAME" VARCHAR2(255) NULL,
"ACCOUNT_SET_ID" VARCHAR2(32) NULL,
"ACCOUNT_SET_NAME" VARCHAR2(255) NULL,
"ACCOUNT_CODE" VARCHAR2(255) NULL,
"INSTITUTIONS_ID" VARCHAR2(32) NULL,
"INSTITUTIONS_NAME" VARCHAR2(255) NULL,
"IN_THE_ORGANIZATION_ID" VARCHAR2(32) NULL,
"IN_THE_ORGANIZATION_NAME" VARCHAR2(255) NULL,
"DEPART_ID" VARCHAR2(32) NULL,
"DEPART_NAME" VARCHAR2(255) NULL
);
COMMENT ON TABLE "T_BASE_SUP_ORDER_HIS" IS '采购方订单头';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."PUR_COMPANY_ID" IS '采购企业id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."PUR_COMPANY_NAME" IS '采购企业名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."PUR_COMPANY_SAP_CODE" IS '采购方sap编码';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."PUR_USER_ID" IS '采购员id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."PUR_USER_NAME" IS '采购员名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."DEPARTMENT_ID" IS '采购组织';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."DEPARTMENT_NAME" IS '采购组织名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."SUP_COMPANY_ID" IS '供应商id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."SUP_COMPANY_NAME" IS '供应企业名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."SUP_COMPANY_SAP_CODE" IS '供应商编码';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."SUP_USER_ID" IS '供应商用户id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."SUP_USER_NAME" IS '供应商用户名';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."ORDER_NO" IS '采购订单号 ';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."ORDER_TYPE" IS '订单类型';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."ORDER_STATUS" IS '确认状态：1订单未确认，2已确认，3已退回';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."ORDER_SEND_STATUS" IS '发送状态：1未发送，2已发送，3变更未发送，4变更已发送';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."ORDER_DATE" IS '采购订单生成日期';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."DELIVERY_STATUS" IS '发送状态：1未发送，2已发送，3变更未发送，4变更已发送';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."PUR_REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."CREATE_USER" IS '创建人';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."LAST_UPDATE_TIME" IS '最后更新时间';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."LAST_UPDATE_USER" IS '最后修改人';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."SEND_TIME" IS '发送供应商时间';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."TAX_RATE" IS '税率';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."TAX_AMOUNT" IS '税额';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."EXCHANGE_RATE" IS '汇率';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."AUDIT_STATUS" IS '1-审批通过，2-未审批，3-审批中，4-审批拒绝';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."IS_AUDIT" IS '审批标识 Y 已审批';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."PAY_TERMS" IS '付款条件';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."PAY_TERMS_DESC" IS '付款条件描述';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."CURRENCY" IS '币别';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."TAX_TOTAL_PRICE" IS '含税总金额';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."TOTAL_QUANTITY" IS '总数量';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."IS_ENABLE" IS '是否删除，1未删除，0删除,2冻结';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."VERSION" IS '版本';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."SUPPLIER_TEL" IS '供应商电话';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."SUPPLIER_FAX" IS '供应商传真';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."SUPPLIER_PERSON" IS '供应商联系人';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."PURCHASE_GROUP" IS '采购组';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."BILL_NAME" IS '单据名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."ADDRESS_NO" IS '地址号码';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."SALE_PERSON" IS '供应商办公室的责任销售员';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."HEAD_TXT" IS '抬头文本';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."SUP_COMPANY_SHORT_NAME" IS '供应商简称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."PUR_COMPANY_SRM_CODE" IS '采购企业srm编码';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."TAX_CODE" IS '税码';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."PUR_PLANER_ID" IS '采购方计划员id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."PUR_PLANER_NAME" IS '采购方计划员名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."PUR_PLANER_WORK_NUM" IS '计划员工号';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."CAUSE" IS '操作原因';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."HIS_TIME" IS '备份时间';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."IS_REFUSE_PRICE" IS '是否拒绝价格';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."IS_REFUSE_QUANTITY" IS '是否拒绝数量';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."IS_REFUSE_DELIVERED_DATE" IS '是否拒绝交期';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."INTER_TRADE_CODE" IS '国际贸易条款编码';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."INTER_TRADE_DESC" IS '国际贸易条款描述';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."RETURN_FLAG" IS '退货标识,Y为退货';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."FREE_FLAG" IS '免费标识，Y为免费，N为不免费';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."REPLY_TIME" IS '供应商回复时间';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."PURCHASE_APPLY_NO" IS '采购申请号';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."CONTRACT_NUMBER" IS '合同编号';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."ORDER_TOTAL" IS '订单总额';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."TOTAL_GROUP_ID" IS '总集团id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."TOTAL_GROUP_NAME" IS '总集团名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."ACCOUNT_SET_ID" IS '账套 id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."ACCOUNT_SET_NAME" IS '账套名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."ACCOUNT_CODE" IS '账套编码';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."INSTITUTIONS_ID" IS '机构id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."INSTITUTIONS_NAME" IS '机构名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."IN_THE_ORGANIZATION_ID" IS '中支机构id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."IN_THE_ORGANIZATION_NAME" IS '中支机构名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."DEPART_ID" IS '部门id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."DEPART_NAME" IS '部门名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."ID" IS '原数据ID';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."SUP_REMARK" IS '供应商备注';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."SUP_COMPANY_SRM_CODE" IS '供应商srm编码';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_HIS"."HIS_ID" IS '历史数据ID';
ALTER TABLE "T_BASE_SUP_ORDER_HIS" ADD PRIMARY KEY ("HIS_ID");





-- ----------------------------
-- 采购订单行
-- ----------------------------
CREATE TABLE "T_BASE_SUP_ORDER_ITEM_HIS" (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_USER_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_USER_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"ORDER_ID" VARCHAR2(32 BYTE) NULL ,
"ORDER_NO" VARCHAR2(255 BYTE) NULL ,
"ORDER_ITEM_NO" VARCHAR2(12 BYTE) NULL ,
"ORDER_DATE" DATE NULL ,
"MATERIAL_CATEGORY_ID" VARCHAR2(32 BYTE) NULL ,
"MATERIAL_CATEGORY_NAME" VARCHAR2(45 BYTE) NULL ,
"MATERIAL_ID" VARCHAR2(32 BYTE) NULL ,
"MATERIAL_NAME" VARCHAR2(255 BYTE) NULL ,
"MATERIAL_CODE" VARCHAR2(20 BYTE) NULL ,
"QUANTITY" NUMBER(20,3) DEFAULT 0  NULL ,
"PRICE_UNIT" VARCHAR2(15 BYTE) NULL ,
"ORDER_UNIT" VARCHAR2(50 BYTE) NULL ,
"DELIVERED_DATE" DATE NULL ,
"WAREHOUSE_LOCATION" VARCHAR2(150 BYTE) NULL ,
"WAREHOUSE_NAME" VARCHAR2(150 BYTE) NULL ,
"QUA_WAREHOUSE_QUANTITY" NUMBER(20,3) DEFAULT 0  NULL ,
"IS_UPDATED" NUMBER(11) DEFAULT 0  NULL ,
"REMARK" NCLOB NULL ,
"UPDATE_TIME" DATE NULL ,
"CURRENCY" VARCHAR2(15 BYTE) NULL ,
"PRODUCT_NO" VARCHAR2(100 BYTE) NULL ,
"IS_ENABLE" NUMBER(11) DEFAULT 1  NULL ,
"FINISH_FLAG" NCHAR(1) NULL ,
"VERSION" VARCHAR2(255 BYTE) DEFAULT 0  NULL ,
"DELIVERY_LOCATION" VARCHAR2(255 BYTE) NULL ,
"PURCHASE_GROUP" VARCHAR2(255 BYTE) NULL ,
"CHANGE_AMOUNT" NUMBER(12) DEFAULT 0  NULL ,
"SALE_ORDER_MODEL" VARCHAR2(255 BYTE) NULL ,
"SHORT_TXT" VARCHAR2(255 BYTE) NULL ,
"INDUSTRY_STANDARD" VARCHAR2(255 BYTE) NULL ,
"FACTORY" VARCHAR2(255 BYTE) NULL ,
"SUP_MATERIAL_CODE" VARCHAR2(255 BYTE) NULL ,
"BRAND" VARCHAR2(255 BYTE) NULL ,
"FACTORY_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) NULL ,
"ORDER_STATUS" NUMBER(11) DEFAULT 1  NULL ,
"PUR_REMARK" VARCHAR2(255 BYTE) DEFAULT NULL  NULL ,
"SUP_REMARK" VARCHAR2(255 BYTE) DEFAULT NULL  NULL ,
"SUP_MATERIAL_DESC" VARCHAR2(255 CHAR) NULL ,
"HAVE_CHANGE" NUMBER(2) NULL ,
"DELIVERY_MATERIAL_NAME" VARCHAR2(255 BYTE) NULL ,
"FREEZE_QUANTITY" NUMBER(20,3) DEFAULT 0  NULL ,
"SUP_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) NULL ,
"ALREADY_APPLY_MONEY" NUMBER(20,4) NULL ,
"AVAILABLE_APPLY_MONEY" NUMBER(20,4) NULL ,
"SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_REQ_NO" VARCHAR2(80 BYTE) NULL ,
"PUR_REQ_ITEM_NO" VARCHAR2(80 BYTE) NULL ,
"QUOTE_ORDER_NO" VARCHAR2(255 BYTE) NULL ,
"QUOTE_ORDER_ITEM_NO" VARCHAR2(255 BYTE) NULL ,
"IS_OFFICIAL_PRICE" NUMBER(1) NULL ,
"RETURN_FLAG" VARCHAR2(255 BYTE) NULL ,
"BOM_DESC" VARCHAR2(255 BYTE) NULL ,
"MASTER_ORDER_NO" VARCHAR2(255 BYTE) NULL ,
"MASTER_ORDER_ITEM_NO" VARCHAR2(255 BYTE) NULL ,
"ORDER_TYPE" VARCHAR2(11 BYTE) NULL ,
"FREEZE_FLAG" NUMBER(1) NULL ,
"IS_JIT" NUMBER(1) NULL ,
"IS_REFUSE_QUANTITY" NUMBER(1) NULL ,
"IS_REFUSE_PRICE" NUMBER(1) NULL ,
"IS_REFUSE_DELIVERED_DATE" NUMBER(1) NULL ,
"TAX_CODE" VARCHAR2(255 BYTE) NULL ,
"TAX_RATE" NUMBER(20,6) NULL ,
"TAX_UNIT_PRICE" NUMBER(20,3) DEFAULT 0  NULL ,
"UNTAX_UNIT_PRICE" NUMBER(20,3) DEFAULT 0  NULL ,
"UNTAX_TOTAL_PRICE" NUMBER(20,3) DEFAULT 0  NULL ,
"TAX_TOTAL_PRICE" NUMBER(20,3) NULL ,
"MATERIAL_UNIT_PRICE" NUMBER(20,3) NULL ,
"MATERIAL_TOTAL_PIRCE" NUMBER(20,3) NULL ,
"TOTAL_PRICE" NUMBER(20,3) NULL ,
"PUR_PLANER_ID" VARCHAR2(32 BYTE) NULL ,
"IS_CAN_DELIVERY" NUMBER(1) NULL ,
"ORDER_HIS_ID" VARCHAR2(32 BYTE) NOT NULL ,
"CAUSE" VARCHAR2(255 BYTE) NULL ,
"HIS_TIME" DATE NULL ,
"FREE_FLAG" VARCHAR2(255 BYTE) NULL ,
"ORDER_NO_TYPE" VARCHAR2(255 BYTE) NULL ,
"PUR_PLANER_NAME" VARCHAR2(255 BYTE) NULL ,
"BUDGET_CORE" VARCHAR2(255) NULL,
"ECONOMIC_MATTERS" VARCHAR2(255) NULL,
"USES" VARCHAR2(255) NULL,
"WAREHOUSE_CODE" VARCHAR2(32) NULL,
"TOTAL_GROUP_ID" VARCHAR2(32) NULL,
"TOTAL_GROUP_NAME" VARCHAR2(255) NULL,
"ACCOUNT_SET_ID" VARCHAR2(32) NULL,
"ACCOUNT_SET_NAME" VARCHAR2(255) NULL,
"ACCOUNT_CODE" VARCHAR2(255) NULL,
"INSTITUTIONS_ID" VARCHAR2(32) NULL,
"INSTITUTIONS_NAME" VARCHAR2(255) NULL,
"IN_THE_ORGANIZATION_ID" VARCHAR2(32) NULL,
"IN_THE_ORGANIZATION_NAME" VARCHAR2(255) NULL,
"DEPART_ID" VARCHAR2(32) NULL,
"DEPART_NAME" VARCHAR2(255) NULL
);
COMMENT ON TABLE "T_BASE_SUP_ORDER_ITEM_HIS" IS '采购订单行';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."ID" IS 'ID';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."PUR_COMPANY_ID" IS '采购企业id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."PUR_COMPANY_NAME" IS '采购企业名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."PUR_USER_NAME" IS '采购员名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."PUR_USER_ID" IS '采购员id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."SUP_COMPANY_ID" IS '供应商id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."SUP_COMPANY_NAME" IS '供应企业名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."SUP_USER_ID" IS '供应员id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."SUP_USER_NAME" IS '供应员id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."ORDER_ID" IS '订单id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."ORDER_NO" IS '采购凭证号 ';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."ORDER_ITEM_NO" IS '采购凭证的项目编号 ';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."ORDER_DATE" IS '采购凭证日期';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."MATERIAL_CATEGORY_ID" IS '物料组id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."MATERIAL_CATEGORY_NAME" IS '物料组名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."MATERIAL_NAME" IS '物料名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."MATERIAL_CODE" IS '物料号 (客户端物料编码)';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."QUANTITY" IS '采购订单数量';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."PRICE_UNIT" IS '价格单位';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."ORDER_UNIT" IS '订单单位';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."DELIVERED_DATE" IS '交货日期';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."WAREHOUSE_LOCATION" IS '仓库地点';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."WAREHOUSE_NAME" IS '仓库名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."QUA_WAREHOUSE_QUANTITY" IS '待检入库数量';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."IS_UPDATED" IS '是否被修改过，0没有，1已修改';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."UPDATE_TIME" IS '更新日期';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."CURRENCY" IS '币别';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."PRODUCT_NO" IS '品号';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."IS_ENABLE" IS '是否删除或冻结，1未删除，0删除,2已经冻结';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."FINISH_FLAG" IS '交货已完成标识,Y完成';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."VERSION" IS '版本';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."DELIVERY_LOCATION" IS '交货地点';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."PURCHASE_GROUP" IS '采购组';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."CHANGE_AMOUNT" IS '变更数量（预留）';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."SALE_ORDER_MODEL" IS '销售单机型';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."SHORT_TXT" IS '短文本';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."INDUSTRY_STANDARD" IS '行业标准';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."FACTORY" IS '工厂';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."SUP_MATERIAL_CODE" IS '供应商物料号';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."BRAND" IS '品牌';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."FACTORY_NAME" IS '工厂名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."PUR_COMPANY_SRM_CODE" IS '采购公司编码';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."PUR_COMPANY_SAP_CODE" IS 'sap公司代码';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."ORDER_STATUS" IS '确认状态：1订单未确认，2已确认，3已退回';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."PUR_REMARK" IS '采购备注';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."SUP_REMARK" IS '供应商备注';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."SUP_MATERIAL_DESC" IS '供应商物料描述';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."HAVE_CHANGE" IS '订单是否有更改：0未更改，1更改';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."DELIVERY_MATERIAL_NAME" IS '发货物料名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."FREEZE_QUANTITY" IS '冻结数量';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."SUP_COMPANY_SAP_CODE" IS '供应商SAP编码';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."ALREADY_APPLY_MONEY" IS '已申请金额';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."AVAILABLE_APPLY_MONEY" IS '可申请金额';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."SUP_COMPANY_SRM_CODE" IS '供应商srm编码';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."PUR_REQ_NO" IS '采购申请单号';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."PUR_REQ_ITEM_NO" IS '采购申请单行号';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."IS_OFFICIAL_PRICE" IS '是否正式价格，1是，0否';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."RETURN_FLAG" IS '退货标识';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."BOM_DESC" IS 'BOM文本描述';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."MASTER_ORDER_NO" IS '总控订单号';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."MASTER_ORDER_ITEM_NO" IS '总控订单行号';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."ORDER_TYPE" IS '订单类型';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."FREEZE_FLAG" IS '冻结标识';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."IS_JIT" IS '是否jit物料1是，0否';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."IS_REFUSE_QUANTITY" IS '是否拒绝数量';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."IS_REFUSE_PRICE" IS '是否拒绝价格';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."IS_REFUSE_DELIVERED_DATE" IS '是否拒绝交期';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."TAX_CODE" IS '税码';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."TAX_RATE" IS '税率';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."TAX_UNIT_PRICE" IS '含税单价';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."UNTAX_UNIT_PRICE" IS '不含税单价';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."UNTAX_TOTAL_PRICE" IS '不含税金额';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."TAX_TOTAL_PRICE" IS '价税合计';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."MATERIAL_UNIT_PRICE" IS '材料单价(含税)';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."MATERIAL_TOTAL_PIRCE" IS '材料金额(含税)';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."TOTAL_PRICE" IS '总价';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."PUR_PLANER_ID" IS '采购方计划员id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."IS_CAN_DELIVERY" IS '是否可发货，1可发货，0不可发货';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."ORDER_HIS_ID" IS '历史订单Id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."CAUSE" IS '变更原因';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."HIS_TIME" IS '备份时间';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."FREE_FLAG" IS '免费标识，Y为免费，N为不免费';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."ORDER_NO_TYPE" IS '采购订单类型';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."PUR_PLANER_NAME" IS '采购方计划员名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."BUDGET_CORE" IS '预算中心';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."ECONOMIC_MATTERS" IS '经济事项';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."USES" IS '用途';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."WAREHOUSE_CODE" IS '仓库编码';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."TOTAL_GROUP_ID" IS '总集团id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."TOTAL_GROUP_NAME" IS '总集团名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."ACCOUNT_SET_ID" IS '账套 id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."ACCOUNT_SET_NAME" IS '账套名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."ACCOUNT_CODE" IS '账套编码';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."INSTITUTIONS_ID" IS '机构id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."INSTITUTIONS_NAME" IS '机构名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."IN_THE_ORGANIZATION_ID" IS '中支机构id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."IN_THE_ORGANIZATION_NAME" IS '中支机构名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."DEPART_ID" IS '部门id';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."DEPART_NAME" IS '部门名称';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."MATERIAL_ID" IS '物料ID';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."QUOTE_ORDER_NO" IS '引单号';
COMMENT ON COLUMN "T_BASE_SUP_ORDER_ITEM_HIS"."QUOTE_ORDER_ITEM_NO" IS '引用单行号';
ALTER TABLE "T_BASE_SUP_ORDER_ITEM_HIS" ADD PRIMARY KEY ("ID");

