/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.quality.harms.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.quality.harms.command.CreateHarmsCmd;
import com.els.base.quality.harms.command.ModifyHarmsCmd;
import com.els.base.quality.harms.common.HarmsInvorker;
import com.els.base.quality.harms.entity.QualityHarmMaterials;
import com.els.base.quality.harms.entity.QualityHarmMaterialsExample;
import com.els.base.quality.harms.entity.QualityHarmMaterialsItem;
import com.els.base.quality.harms.entity.QualityHarmMaterialsItemExample;
import com.els.base.quality.harms.service.QualityHarmMaterialsItemService;
import com.els.base.quality.harms.service.QualityHarmMaterialsService;
import com.els.base.quality.harms.vo.QualityHarmMaterialsVO;
import com.els.base.quality.utils.BillStatusEnum;
import com.els.base.quality.utils.ReportValidStatusEnum;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.StrToObjConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import com.qqt.utils.JsonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Api(value="\u6709\u5bb3\u7269\u8d28\u62a5\u544a")
@Controller
@RequestMapping(value={"qualityHarmMaterials"})
public class QualityHarmMaterialsController {
    @Resource
    private HarmsInvorker Invorker;
    @Resource
    protected QualityHarmMaterialsService qualityHarmMaterialsService;
    @Resource
    protected QualityHarmMaterialsItemService qualityHarmMaterialsItemService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u6709\u5bb3\u7269\u8d28\u62a5\u544a")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody QualityHarmMaterialsVO qualityHarmMaterialsVO) {
        CreateHarmsCmd cmd = new CreateHarmsCmd(qualityHarmMaterialsVO);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        this.Invorker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u6709\u5bb3\u7269\u8d28\u62a5\u544a")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody QualityHarmMaterialsVO vo) {
        Assert.isNotBlank((String)vo.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        ModifyHarmsCmd cmd = new ModifyHarmsCmd(vo);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        this.Invorker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664\u6709\u5bb3\u7269\u8d28\u62a5\u544a")
    @RequestMapping(value={"service/pur/delete"})
    @ResponseBody
    public ResponseResult<String> delete(@RequestBody List<QualityHarmMaterials> data) {
        this.qualityHarmMaterialsService.delete(data, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u4f5c\u5e9f\u5355\u636e")
    @RequestMapping(value={"service/pur/abolish"})
    @ResponseBody
    public ResponseResult<String> abolish(@RequestBody List<QualityHarmMaterials> data) {
        this.qualityHarmMaterialsService.abolish(data, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u53d1\u9001\u5355\u636e")
    @RequestMapping(value={"service/pur/sendToSup"})
    @ResponseBody
    public ResponseResult<String> sendToSup(@RequestBody List<QualityHarmMaterials> data) {
        this.qualityHarmMaterialsService.sendToSup(data, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u56de\u7b7e\u5355\u636e")
    @RequestMapping(value={"service/pur/sendToPur"})
    @ResponseBody
    public ResponseResult<String> sendToPur(@RequestBody List<QualityHarmMaterials> data) {
        this.qualityHarmMaterialsService.sendToPur(data, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u63a5\u6536\u6216\u62d2\u7edd\u5355\u636e")
    @RequestMapping(value={"service/sup/supReceivedOrRefused"})
    @ResponseBody
    public ResponseResult<String> supReceivedOrRefused(@RequestBody List<QualityHarmMaterials> data) {
        this.qualityHarmMaterialsService.supReceivedOrRefused(data, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u8d44\u6599\u5ba1\u5ba1\u6279")
    @RequestMapping(value={"service/pur/audit"})
    @ResponseBody
    public ResponseResult<String> audit(@RequestBody List<QualityHarmMaterials> data) {
        this.qualityHarmMaterialsService.audit(data, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u9a73\u56de\u5355\u636e")
    @RequestMapping(value={"service/pur/reject"})
    @ResponseBody
    public ResponseResult<String> reject(@RequestBody List<QualityHarmMaterials> data) {
        this.qualityHarmMaterialsService.reject(data, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u66f4\u65b0\u9644\u4ef6\u4fe1\u606f")
    @RequestMapping(value={"service/sup/updateBillAttachmentInfo"})
    @ResponseBody
    public ResponseResult<String> updateBillAttachmentInfo(@RequestBody QualityHarmMaterialsVO vo) {
        this.qualityHarmMaterialsService.updateBillAttachmentInfo(vo);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u6709\u5bb3\u7269\u8d28\u62a5\u544a(\u91c7\u8d2d\u65b9)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 QualityHarmMaterials", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/pur/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<QualityHarmMaterials>> findByPageForPur(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        QualityHarmMaterialsExample example = new QualityHarmMaterialsExample();
        example.setPageView((PageView<QualityHarmMaterials>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        QualityHarmMaterialsExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.qualityHarmMaterialsService.queryObjByPage((IExample)example);
        List harmMaterialsList = pageData.getQueryResult();
        for (QualityHarmMaterials m : harmMaterialsList) {
            QualityHarmMaterialsItemExample exampleItem = new QualityHarmMaterialsItemExample();
            exampleItem.createCriteria().andHarmMaterialIdEqualTo(m.getId());
            List itemList = this.qualityHarmMaterialsItemService.queryAllObjByExample((IExample)exampleItem);
            ArrayList<String> reportValidStatusList = new ArrayList<String>();
            if (CollectionUtils.isNotEmpty((Collection)itemList)) {
                for (QualityHarmMaterialsItem qualityHarmMaterials : itemList) {
                    if (qualityHarmMaterials.getValidCheckTime() == null) {
                        reportValidStatusList.add(ReportValidStatusEnum.NOT_EXPIRED.getReportValidStatusDesc());
                        continue;
                    }
                    int timeCompareBiddingDeadline = this.compareTwoTimes(new Date(), qualityHarmMaterials.getValidCheckTime());
                    if (timeCompareBiddingDeadline == 1) {
                        reportValidStatusList.add(ReportValidStatusEnum.EXPIRED.getReportValidStatusDesc());
                        continue;
                    }
                    reportValidStatusList.add(ReportValidStatusEnum.NOT_EXPIRED.getReportValidStatusDesc());
                }
            }
            int count = Collections.frequency(reportValidStatusList, ReportValidStatusEnum.EXPIRED.getReportValidStatusDesc());
            String str = "";
            str = count == reportValidStatusList.size() && reportValidStatusList.size() > 0 ? ReportValidStatusEnum.ALL_EXPIRED.getReportValidStatusDesc() : (count < reportValidStatusList.size() && count > 0 && reportValidStatusList.size() > 0 ? ReportValidStatusEnum.PART_EXPIRED.getReportValidStatusDesc() : ReportValidStatusEnum.NOT_EXPIRED.getReportValidStatusDesc());
            m.setReportValidStatus(str);
        }
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u6709\u5bb3\u7269\u8d28\u62a5\u544a(\u4f9b\u5e94\u5546\u65b9)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 QualityHarmMaterials", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/sup/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<QualityHarmMaterials>> findByPageForSup(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        QualityHarmMaterialsExample example = new QualityHarmMaterialsExample();
        example.setPageView((PageView<QualityHarmMaterials>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        Company company = CompanyUtils.currentCompany();
        QualityHarmMaterialsExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andSendStatusEqualTo(Constant.YES_INT).andSupCompanyIdEqualTo(company.getId());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.qualityHarmMaterialsService.queryObjByPage((IExample)example);
        List harmMaterialsList = pageData.getQueryResult();
        for (QualityHarmMaterials m : harmMaterialsList) {
            if (BillStatusEnum.STATUS_AUDITING.getBillStatus().equals(m.getBillStatus())) {
                m.setBillStatus(BillStatusEnum.STATUS_SIGNED.getBillStatus());
                m.setReportCheckStatus(BillStatusEnum.STATUS_SIGNED.getBillStatusDesc());
            }
            QualityHarmMaterialsItemExample exampleItem = new QualityHarmMaterialsItemExample();
            exampleItem.createCriteria().andHarmMaterialIdEqualTo(m.getId());
            List itemList = this.qualityHarmMaterialsItemService.queryAllObjByExample((IExample)exampleItem);
            ArrayList<String> reportValidStatusList = new ArrayList<String>();
            if (CollectionUtils.isNotEmpty((Collection)itemList)) {
                for (QualityHarmMaterialsItem qualityHarmMaterials : itemList) {
                    if (qualityHarmMaterials.getValidCheckTime() == null) {
                        reportValidStatusList.add(ReportValidStatusEnum.NOT_EXPIRED.getReportValidStatusDesc());
                        continue;
                    }
                    int timeCompareBiddingDeadline = this.compareTwoTimes(new Date(), qualityHarmMaterials.getValidCheckTime());
                    if (timeCompareBiddingDeadline == 1) {
                        reportValidStatusList.add(ReportValidStatusEnum.EXPIRED.getReportValidStatusDesc());
                        continue;
                    }
                    reportValidStatusList.add(ReportValidStatusEnum.NOT_EXPIRED.getReportValidStatusDesc());
                }
            }
            int count = Collections.frequency(reportValidStatusList, ReportValidStatusEnum.EXPIRED.getReportValidStatusDesc());
            String str = "";
            str = count == reportValidStatusList.size() && reportValidStatusList.size() > 0 ? ReportValidStatusEnum.ALL_EXPIRED.getReportValidStatusDesc() : (count < reportValidStatusList.size() && count > 0 && reportValidStatusList.size() > 0 ? ReportValidStatusEnum.PART_EXPIRED.getReportValidStatusDesc() : ReportValidStatusEnum.NOT_EXPIRED.getReportValidStatusDesc());
            m.setReportValidStatus(str);
        }
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u770b\u5355\u636e\u8be6\u60c5(\u91c7\u8d2d\u65b9)")
    @RequestMapping(value={"service/pur/findDetailById"})
    @ResponseBody
    public ResponseResult<QualityHarmMaterialsVO> findDetailByIdForPur(String id) {
        if (StringUtils.isEmpty((String)id)) {
            throw new CommonException("\u4f20\u9012\u7684id\u4e3a\u7a7a!");
        }
        QualityHarmMaterials data = (QualityHarmMaterials)this.qualityHarmMaterialsService.queryObjById(id);
        if (null == data) {
            throw new CommonException("\u6839\u636eid\u67e5\u627e\u7684\u5355\u636e\u4e0d\u5b58\u5728!");
        }
        QualityHarmMaterialsVO vo = new QualityHarmMaterialsVO();
        BeanUtils.copyProperties((Object)data, (Object)vo);
        QualityHarmMaterialsItemExample example = new QualityHarmMaterialsItemExample();
        example.createCriteria().andHarmMaterialIdEqualTo(id);
        List itemList = this.qualityHarmMaterialsItemService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)itemList)) {
            for (QualityHarmMaterialsItem qualityHarmMaterials : itemList) {
                if (qualityHarmMaterials.getValidCheckTime() == null) {
                    qualityHarmMaterials.setReportValidStatus(ReportValidStatusEnum.NOT_EXPIRED.getReportValidStatusDesc());
                } else {
                    int timeCompareBiddingDeadline = this.compareTwoTimes(new Date(), qualityHarmMaterials.getValidCheckTime());
                    if (timeCompareBiddingDeadline == 1) {
                        qualityHarmMaterials.setReportValidStatus(ReportValidStatusEnum.EXPIRED.getReportValidStatusDesc());
                    } else {
                        qualityHarmMaterials.setReportValidStatus(ReportValidStatusEnum.NOT_EXPIRED.getReportValidStatusDesc());
                    }
                }
                if (!BillStatusEnum.STATUS_UN_SIGN.getBillStatus().equals(vo.getBillStatus())) continue;
                qualityHarmMaterials.setAttachment(null);
                qualityHarmMaterials.setCheckTime(null);
                qualityHarmMaterials.setItemSupRemark(null);
            }
        }
        vo.setItemList(itemList);
        return ResponseResult.success((Object)vo);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u770b\u5355\u636e\u8be6\u60c5(\u4f9b\u5e94\u5546\u65b9)")
    @RequestMapping(value={"service/sup/findDetailById"})
    @ResponseBody
    public ResponseResult<QualityHarmMaterialsVO> findDetailById(String id) {
        if (StringUtils.isEmpty((String)id)) {
            throw new CommonException("\u4f20\u9012\u7684id\u4e3a\u7a7a!");
        }
        QualityHarmMaterials data = (QualityHarmMaterials)this.qualityHarmMaterialsService.queryObjById(id);
        if (null == data) {
            throw new CommonException("\u6839\u636eid\u67e5\u627e\u7684\u5355\u636e\u4e0d\u5b58\u5728!");
        }
        if (BillStatusEnum.STATUS_AUDITING.getBillStatus().equals(data.getBillStatus())) {
            data.setBillStatus(BillStatusEnum.STATUS_SIGNED.getBillStatus());
            data.setReportCheckStatus(BillStatusEnum.STATUS_SIGNED.getBillStatusDesc());
        }
        QualityHarmMaterialsVO vo = new QualityHarmMaterialsVO();
        BeanUtils.copyProperties((Object)data, (Object)vo);
        QualityHarmMaterialsItemExample example = new QualityHarmMaterialsItemExample();
        example.createCriteria().andHarmMaterialIdEqualTo(id);
        List itemList = this.qualityHarmMaterialsItemService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)itemList)) {
            for (QualityHarmMaterialsItem qualityHarmMaterials : itemList) {
                if (qualityHarmMaterials.getValidCheckTime() == null) {
                    qualityHarmMaterials.setReportValidStatus(ReportValidStatusEnum.NOT_EXPIRED.getReportValidStatusDesc());
                    continue;
                }
                int timeCompareBiddingDeadline = this.compareTwoTimes(new Date(), qualityHarmMaterials.getValidCheckTime());
                if (timeCompareBiddingDeadline == 1) {
                    qualityHarmMaterials.setReportValidStatus(ReportValidStatusEnum.EXPIRED.getReportValidStatusDesc());
                    continue;
                }
                qualityHarmMaterials.setReportValidStatus(ReportValidStatusEnum.NOT_EXPIRED.getReportValidStatusDesc());
            }
        }
        vo.setItemList(itemList);
        return ResponseResult.success((Object)vo);
    }

    private int compareTwoTimes(Date date, Date biddingDeadline) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String format = sdf.format(date);
        String format2 = sdf.format(biddingDeadline);
        int compareTo = 0;
        try {
            Date date_01 = sdf.parse(format);
            Date date_02 = sdf.parse(format2);
            compareTo = date_01.compareTo(date_02);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return compareTo;
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u6709\u5bb3\u7269\u8d28\u62a5\u544a\u5bfc\u51faexcel")
    @RequestMapping(value={"service/downloadExcel"})
    @ResponseBody
    public ModelAndView downloadExcel(@RequestParam(required=false) String queryParams, HttpServletResponse response) {
        try {
            QualityHarmMaterialsExample example = new QualityHarmMaterialsExample();
            example.setOrderByClause("CREATE_TIME DESC");
            QualityHarmMaterialsExample.Criteria criteria = example.createCriteria();
            criteria.andIsEnableEqualTo(Constant.YES_INT);
            QueryParamWapper wapper = null;
            if (StringUtils.isNotBlank((String)queryParams)) {
                wapper = (QueryParamWapper)JsonUtil.convertValue((String)queryParams, QueryParamWapper.class);
            }
            if (wapper != null) {
                CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
            }
            ArrayList<QualityHarmMaterials> harmMaterialsExcelList = new ArrayList<QualityHarmMaterials>();
            List harmMaterialsList = this.qualityHarmMaterialsService.queryAllObjByExample((IExample)example);
            for (QualityHarmMaterials m : harmMaterialsList) {
                if (BillStatusEnum.STATUS_UN_SIGN.getBillStatus().equals(m.getBillStatus())) {
                    m.setReportCheckStatus(BillStatusEnum.STATUS_UN_SIGN.getBillStatusDesc());
                } else if (BillStatusEnum.STATUS_SIGNED.getBillStatus().equals(m.getBillStatus())) {
                    m.setReportCheckStatus(BillStatusEnum.STATUS_SIGNED.getBillStatusDesc());
                } else if (BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatus().equals(m.getBillStatus())) {
                    m.setReportCheckStatus(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatusDesc());
                } else if (BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatus().equals(m.getBillStatus())) {
                    m.setReportCheckStatus(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatusDesc());
                } else if (BillStatusEnum.STATUS_ABOLISH.getBillStatus().equals(m.getBillStatus())) {
                    m.setReportCheckStatus(BillStatusEnum.STATUS_ABOLISH.getBillStatusDesc());
                } else if (BillStatusEnum.STATUS_UN_PUBLISHED.getBillStatus().equals(m.getBillStatus())) {
                    m.setReportCheckStatus(BillStatusEnum.STATUS_UN_PUBLISHED.getBillStatusDesc());
                } else if (BillStatusEnum.STATUS_PUBLISHED.getBillStatus().equals(m.getBillStatus())) {
                    m.setReportCheckStatus(BillStatusEnum.STATUS_PUBLISHED.getBillStatusDesc());
                } else if (BillStatusEnum.STATUS_RECEIVED.getBillStatus().equals(m.getBillStatus())) {
                    m.setReportCheckStatus(BillStatusEnum.STATUS_RECEIVED.getBillStatusDesc());
                } else if (BillStatusEnum.STATUS_REFUSED.getBillStatus().equals(m.getBillStatus())) {
                    m.setReportCheckStatus(BillStatusEnum.STATUS_REFUSED.getBillStatusDesc());
                } else if (BillStatusEnum.STATUS_AUDITING.getBillStatus().equals(m.getBillStatus())) {
                    m.setReportCheckStatus(BillStatusEnum.STATUS_AUDITING.getBillStatusDesc());
                } else if (BillStatusEnum.STATUS_APPROVE_REFUSED.getBillStatus().equals(m.getBillStatus())) {
                    m.setReportCheckStatus(BillStatusEnum.STATUS_APPROVE_REFUSED.getBillStatusDesc());
                } else if (BillStatusEnum.STATUS_DELETE.getBillStatus().equals(m.getBillStatus())) {
                    m.setReportCheckStatus(BillStatusEnum.STATUS_DELETE.getBillStatusDesc());
                }
                QualityHarmMaterialsItemExample exampleItem = new QualityHarmMaterialsItemExample();
                exampleItem.createCriteria().andHarmMaterialIdEqualTo(m.getId());
                List itemList = this.qualityHarmMaterialsItemService.queryAllObjByExample((IExample)exampleItem);
                if (!CollectionUtils.isNotEmpty((Collection)itemList)) continue;
                for (QualityHarmMaterialsItem materialsItem : itemList) {
                    QualityHarmMaterials materials = new QualityHarmMaterials();
                    BeanUtils.copyProperties((Object)m, (Object)materials);
                    materials.setLayerLevel(materialsItem.getLayerLevel());
                    materials.setSupComponentNo(materialsItem.getSupComponentNo());
                    materials.setSupComponentName(materialsItem.getSupComponentName());
                    materials.setQuantity(materialsItem.getQuantity());
                    materials.setMaterialInfo(materialsItem.getMaterialInfo());
                    materials.setSubstance(materialsItem.getSubstance());
                    materials.setFaceHandle(materialsItem.getFaceHandle());
                    materials.setBrandInfo(materialsItem.getBrandInfo());
                    materials.setCheckReportName(materialsItem.getCheckReportName());
                    materials.setReportCode(materialsItem.getReportCode());
                    materials.setOtherReportCode(materialsItem.getOtherReportCode());
                    materials.setCheckTime(materialsItem.getCheckTime());
                    materials.setReportValidStatus(materialsItem.getReportValidStatus());
                    harmMaterialsExcelList.add(materials);
                }
            }
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode("\u6709\u5bb3\u7269\u8d28\u62a5\u544a.xls", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = this.getTitleAndModelKeys();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, harmMaterialsExcelList, (String)"\u6709\u5bb3\u7269\u8d28\u62a5\u544a", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private List<TitleAndModelKey> getTitleAndModelKeys() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u53f7", (String)"harmBillNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u7801", (String)"materialCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u63cf\u8ff0", (String)"materialDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7f16\u7801", (String)"supCompanySrmCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u72b6\u6001", (String)"reportCheckStatus"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5c42\u7ea7", (String)"layerLevel"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u5206\u96f6\u4ef6\u53f7", (String)"supComponentNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u96f6\u4ef6\u540d\u79f0", (String)"supComponentName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6570\u91cf", (String)"quantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6750\u6599\u540d\u79f0/\u724c\u53f7\uff08\u989c\u8272\uff09", (String)"materialInfo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u51c0\u91cd\uff08\u514b\uff09", (String)"substance"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8868\u9762\u5904\u7406", (String)"faceHandle"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5382\u5546/\u54c1\u724c\uff08\u751f\u4ea7\u5730\u70b9\uff09", (String)"brandInfo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u68c0\u6d4b\u62a5\u544a\u540d\u79f0", (String)"checkReportName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u62a5\u544a\u7f16\u7801", (String)"reportCode"));
        TitleAndModelKey titleAndModelKey3 = ExcelUtils.createTitleAndModelKey((String)"\u68c0\u6d4b\u62a5\u544a\u65e5\u671f", (String)"checkTime");
        DateConverter dateConverter3 = new DateConverter().setDateFormat("yyyy-MM-dd");
        titleAndModelKey3.setToObjConverter((StrToObjConverter)dateConverter3);
        titleAndModelKey3.setToStrConverter((ObjToStrConverter)dateConverter3);
        titleAndModelKeys.add(titleAndModelKey3);
        return titleAndModelKeys;
    }

    @ApiOperation(httpMethod="POST", value="\u6d4b\u8bd5\u8fc7\u671f\u63d0\u9192")
    @RequestMapping(value={"service/findExpiredQualityHarmMaterials"})
    @ResponseBody
    public ResponseResult<QualityHarmMaterialsVO> findExpiredQualityHarmMaterials(String id) {
        QualityHarmMaterialsVO vo = new QualityHarmMaterialsVO();
        this.qualityHarmMaterialsService.findExpiredQualityHarmMaterials();
        return ResponseResult.success((Object)vo);
    }
}

