/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.quality.report.service.impl;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.quality.harms.im.HarmMaterialImTemplet;
import com.els.base.quality.report.dao.BadReportMapper;
import com.els.base.quality.report.entity.BadReport;
import com.els.base.quality.report.entity.BadReportExample;
import com.els.base.quality.report.entity.BadReportItem;
import com.els.base.quality.report.entity.BadReportItemExample;
import com.els.base.quality.report.service.BadReportItemService;
import com.els.base.quality.report.service.BadReportService;
import com.els.base.quality.utils.BillStatusEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBadeReportService")
public class BadReportServiceImpl
implements BadReportService {
    private static final String IM_CODE = "BAD_REPORT_MESSAGE";
    @Resource
    private BadReportMapper badReportMapper;
    @Resource
    private CompanyService companyService;
    @Resource
    private GenerateCodeService generateCodeService;
    @Resource
    private BadReportItemService badReportItemService;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    private ThreadPoolTaskExecutor defaultThreadPool;

    @Override
    @CacheEvict(value={"badReport"}, allEntries=true)
    @Transactional
    public void editForSup(Project project, Company company, User loginUser, BadReport badReport) {
        Assert.isNotBlank((String)badReport.getId(), (String)"\u4e0d\u826f\u62a5\u544aID\u4e0d\u80fd\u4e3a\u7a7a,\u64cd\u4f5c\u5931\u8d25!");
        BadReport badReportOld = this.badReportMapper.selectByPrimaryKey(badReport.getId());
        Assert.isNotNull((Object)badReportOld, (String)"\u4e0d\u826f\u62a5\u544a\u4e0d\u5b58\u5728,\u64cd\u4f5c\u5931\u8d25!");
        this.updateBadReportInfoForSup(badReport, badReportOld);
    }

    private void updateBadReportInfoForSup(BadReport badReport, BadReport badReportOld) {
        Assert.isNotBlank((String)badReport.getSupBadReportFile(), (String)"\u5355\u636e\u4e2d\u4f9b\u5e94\u5546\u56de\u590d\u9644\u4ef6\u6ca1\u6709\u4e0a\u4f20\uff0c\u8bf7\u68c0\u67e5\uff0c\u8c22\u8c22\uff01");
        if (badReport.getSupBadReportFile().equals("[]") || badReport.getSupBadReportFile().equals("[ ]")) {
            throw new CommonException("\u5355\u636e\u4e2d\u4f9b\u5e94\u5546\u56de\u590d\u9644\u4ef6\u6ca1\u6709\u4e0a\u4f20\uff0c\u8bf7\u68c0\u67e5\uff0c\u8c22\u8c22\uff01");
        }
        badReportOld.setSupBadReportFile(badReport.getSupBadReportFile());
        badReportOld.setSupCommitTime(new Date());
        this.badReportMapper.updateByPrimaryKeySelective(badReportOld);
    }

    @Override
    @CacheEvict(value={"badReport"}, allEntries=true)
    @Transactional
    public void editForPur(Project project, Company company, User loginUser, BadReport badReport) {
        Assert.isNotBlank((String)badReport.getId(), (String)"\u4e0d\u826f\u62a5\u544aID\u4e0d\u80fd\u4e3a\u7a7a,\u64cd\u4f5c\u5931\u8d25!");
        BadReport badReportOld = this.badReportMapper.selectByPrimaryKey(badReport.getId());
        Assert.isNotNull((Object)badReportOld, (String)"\u4e0d\u826f\u62a5\u544a\u4e0d\u5b58\u5728,\u64cd\u4f5c\u5931\u8d25!");
        this.updateBadReportInfoForPur(badReport, badReportOld);
        this.updateBadReportItemInfoForPur(badReport, badReportOld);
    }

    private void updateBadReportItemInfoForPur(BadReport badReport, BadReport badReportOld) {
        List<BadReportItem> badReportItemList = badReport.getBadReportItemList();
        Assert.isNotEmpty(badReportItemList, (String)"\u4e0d\u826f\u62a5\u544a\u884c\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank((String)badReport.getId(), (String)"\u4e0d\u826f\u62a5\u544aID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        BadReportItemExample badReportItemExample = new BadReportItemExample();
        badReportItemExample.createCriteria().andBadReportIdEqualTo(badReport.getId());
        this.badReportItemService.deleteByExample(badReportItemExample);
        for (BadReportItem badReportItem : badReportItemList) {
            badReportItem.setId(null);
            badReportItem.setBadReportId(badReportOld.getId());
            this.badReportItemService.addObj(badReportItem);
        }
    }

    private void updateBadReportInfoForPur(BadReport badReport, BadReport badReportOld) {
        badReportOld.setModelName(badReport.getModelName());
        badReportOld.setSupComponentNo(badReport.getSupComponentNo());
        badReportOld.setSupComponentName(badReport.getSupComponentName());
        badReportOld.setLotNo(badReport.getLotNo());
        badReportOld.setLotQuantity(badReport.getLotQuantity());
        badReportOld.setLotDesc(badReport.getLotDesc());
        badReportOld.setReportTime(badReport.getReportTime());
        badReportOld.setReportPlace(badReport.getReportPlace());
        badReportOld.setRecognizedUserId(badReport.getRecognizedUserId());
        badReportOld.setRecognizedUserName(badReport.getRecognizedUserName());
        badReportOld.setQualityConfirmId(badReport.getQualityConfirmId());
        badReportOld.setQualityConfirmName(badReport.getQualityConfirmName());
        badReportOld.setPublishName(badReport.getPublishName());
        badReportOld.setBadReportImg(badReport.getBadReportImg());
        badReportOld.setPurBadReportFile(badReport.getPurBadReportFile());
        badReportOld.setSupBadReportFile(badReport.getSupBadReportFile());
        badReportOld.setPurCommitTime(new Date());
        badReportOld.setPurRemark(badReport.getPurRemark());
        this.badReportMapper.updateByPrimaryKeySelective(badReportOld);
    }

    @Override
    @CacheEvict(value={"badReport"}, allEntries=true)
    @Transactional
    public void reject(Project project, Company company, final User loginUser, List<BadReport> badReportList) {
        Assert.isNotEmpty(badReportList, (String)"\u4e0d\u826f\u62a5\u544a\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        ArrayList<String> ids = new ArrayList<String>();
        for (BadReport badReport : badReportList) {
            Assert.isNotBlank((String)badReport.getId(), (String)"\u4e0d\u826f\u62a5\u544aID\u4e0d\u80fd\u4e3a\u7a7a!");
            ids.add(badReport.getId());
        }
        BadReportExample badReportExample = new BadReportExample();
        badReportExample.createCriteria().andProjectIdEqualTo(project.getId()).andPurCompanyIdEqualTo(project.getCompanyId()).andSendStatusEqualTo(Constant.NO_INT).andIdIn(ids);
        int countByExample = this.badReportMapper.countByExample(badReportExample);
        if (countByExample > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u542b\u6709\u672a\u53d1\u9001\u6570\u636e\uff0c\u64cd\u4f5c\u5931\u8d25!");
        }
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(BillStatusEnum.STATUS_UN_SIGN.getBillStatus());
        billStatus.add(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatus());
        billStatus.add(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatus());
        billStatus.add(BillStatusEnum.STATUS_ABOLISH.getBillStatus());
        badReportExample.clear();
        badReportExample.createCriteria().andProjectIdEqualTo(project.getId()).andSendStatusEqualTo(Constant.YES_INT).andPurCompanyIdEqualTo(project.getCompanyId()).andBillStatusIn(billStatus).andIdIn(ids);
        int countByExample2 = this.badReportMapper.countByExample(badReportExample);
        if (countByExample2 > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u542b\u6709\u5df2\u9a73\u56de\uff0c\u5df2\u4f5c\u5e9f\uff0c\u5df2\u5ba1\u6279\uff0c\u672a\u56de\u7b7e\u7b49\u6570\u636e\uff0c\u64cd\u4f5c\u5931\u8d25!");
        }
        badReportExample.clear();
        badReportExample.createCriteria().andProjectIdEqualTo(project.getId()).andPurCompanyIdEqualTo(project.getCompanyId()).andSendStatusEqualTo(Constant.YES_INT).andBillStatusEqualTo(BillStatusEnum.STATUS_SIGNED.getBillStatus()).andIdIn(ids);
        BadReport badReport = new BadReport();
        badReport.setPurSendTime(new Date());
        badReport.setBillStatus(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatus());
        this.badReportMapper.updateByExampleSelective(badReport, badReportExample);
        badReportExample.clear();
        badReportExample.createCriteria().andIdIn(ids);
        final List<BadReport> badReports = this.badReportMapper.selectByExample(badReportExample);
        if (CollectionUtils.isNotEmpty(badReports)) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    for (BadReport badReport : badReports) {
                        HarmMaterialImTemplet templet = BadReportServiceImpl.this.constructImInfo(1, "\u9a73\u56de", badReport);
                        BadReportServiceImpl.this.sendMessagesToSup(loginUser, templet, badReport);
                    }
                }
            });
        }
    }

    @Override
    @CacheEvict(value={"badReport"}, allEntries=true)
    @Transactional
    public void audit(Project project, Company company, final User loginUser, List<BadReport> badReportList) {
        Assert.isNotEmpty(badReportList, (String)"\u4e0d\u826f\u62a5\u544a\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        ArrayList<String> ids = new ArrayList<String>();
        for (BadReport badReport : badReportList) {
            Assert.isNotBlank((String)badReport.getId(), (String)"\u4e0d\u826f\u62a5\u544aID\u4e0d\u80fd\u4e3a\u7a7a!");
            ids.add(badReport.getId());
        }
        BadReportExample badReportExample = new BadReportExample();
        badReportExample.createCriteria().andProjectIdEqualTo(project.getId()).andPurCompanyIdEqualTo(project.getCompanyId()).andSendStatusEqualTo(Constant.NO_INT).andIdIn(ids);
        int countByExample = this.badReportMapper.countByExample(badReportExample);
        if (countByExample > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u542b\u6709\u672a\u53d1\u9001\u6570\u636e\uff0c\u64cd\u4f5c\u5931\u8d25!");
        }
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(BillStatusEnum.STATUS_UN_SIGN.getBillStatus());
        billStatus.add(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatus());
        billStatus.add(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatus());
        billStatus.add(BillStatusEnum.STATUS_ABOLISH.getBillStatus());
        badReportExample.clear();
        badReportExample.createCriteria().andProjectIdEqualTo(project.getId()).andSendStatusEqualTo(Constant.YES_INT).andPurCompanyIdEqualTo(project.getCompanyId()).andBillStatusIn(billStatus).andIdIn(ids);
        int countByExample2 = this.badReportMapper.countByExample(badReportExample);
        if (countByExample2 > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u542b\u6709\u5df2\u9a73\u56de\uff0c\u5df2\u4f5c\u5e9f\uff0c\u5df2\u5ba1\u6279\uff0c\u672a\u56de\u7b7e\u7b49\u6570\u636e\uff0c\u64cd\u4f5c\u5931\u8d25!");
        }
        badReportExample.clear();
        badReportExample.createCriteria().andProjectIdEqualTo(project.getId()).andPurCompanyIdEqualTo(project.getCompanyId()).andSendStatusEqualTo(Constant.YES_INT).andBillStatusEqualTo(BillStatusEnum.STATUS_SIGNED.getBillStatus()).andIdIn(ids);
        BadReport badReport = new BadReport();
        badReport.setPurSendTime(new Date());
        badReport.setBillStatus(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatus());
        this.badReportMapper.updateByExampleSelective(badReport, badReportExample);
        badReportExample.clear();
        badReportExample.createCriteria().andIdIn(ids);
        final List<BadReport> badReports = this.badReportMapper.selectByExample(badReportExample);
        if (CollectionUtils.isNotEmpty(badReports)) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    for (BadReport badReport : badReports) {
                        HarmMaterialImTemplet templet = BadReportServiceImpl.this.constructImInfo(1, "\u5ba1\u6838\u901a\u8fc7", badReport);
                        BadReportServiceImpl.this.sendMessagesToSup(loginUser, templet, badReport);
                    }
                }
            });
        }
    }

    @Override
    @CacheEvict(value={"badReport"}, allEntries=true)
    @Transactional
    public void abolish(Project project, Company company, final User loginUser, List<BadReport> badReportList) {
        Assert.isNotEmpty(badReportList, (String)"\u4e0d\u826f\u62a5\u544a\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        ArrayList<String> ids = new ArrayList<String>();
        for (BadReport badReport : badReportList) {
            Assert.isNotBlank((String)badReport.getId(), (String)"\u4e0d\u826f\u62a5\u544aID\u4e0d\u80fd\u4e3a\u7a7a!");
            ids.add(badReport.getId());
        }
        BadReportExample badReportExample = new BadReportExample();
        badReportExample.createCriteria().andProjectIdEqualTo(project.getId()).andPurCompanyIdEqualTo(project.getCompanyId()).andSendStatusEqualTo(Constant.NO_INT).andIdIn(ids);
        int countByExample = this.badReportMapper.countByExample(badReportExample);
        if (countByExample > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u542b\u6709\u672a\u53d1\u9001\u6570\u636e\uff0c\u64cd\u4f5c\u5931\u8d25!");
        }
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(BillStatusEnum.STATUS_SIGNED.getBillStatus());
        billStatus.add(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatus());
        billStatus.add(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatus());
        billStatus.add(BillStatusEnum.STATUS_ABOLISH.getBillStatus());
        badReportExample.clear();
        badReportExample.createCriteria().andProjectIdEqualTo(project.getId()).andSendStatusEqualTo(Constant.YES_INT).andPurCompanyIdEqualTo(project.getCompanyId()).andBillStatusIn(billStatus).andIdIn(ids);
        int countByExample2 = this.badReportMapper.countByExample(badReportExample);
        if (countByExample2 > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u542b\u6709\u5df2\u9a73\u56de\uff0c\u5df2\u4f5c\u5e9f\uff0c\u5df2\u5ba1\u6279\uff0c\u5df2\u56de\u7b7e\u7b49\u6570\u636e\uff0c\u64cd\u4f5c\u5931\u8d25!");
        }
        BadReport badReport = new BadReport();
        badReport.setPurSendTime(new Date());
        badReport.setBillStatus(BillStatusEnum.STATUS_ABOLISH.getBillStatus());
        badReportExample.clear();
        badReportExample.createCriteria().andProjectIdEqualTo(project.getId()).andPurCompanyIdEqualTo(project.getCompanyId()).andSendStatusEqualTo(Constant.YES_INT).andBillStatusEqualTo(BillStatusEnum.STATUS_UN_SIGN.getBillStatus()).andIdIn(ids);
        this.badReportMapper.updateByExampleSelective(badReport, badReportExample);
        badReportExample.clear();
        badReportExample.createCriteria().andIdIn(ids);
        final List<BadReport> badReports = this.badReportMapper.selectByExample(badReportExample);
        if (CollectionUtils.isNotEmpty(badReports)) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    for (BadReport badReport : badReports) {
                        HarmMaterialImTemplet templet = BadReportServiceImpl.this.constructImInfo(1, "\u4f5c\u5e9f", badReport);
                        BadReportServiceImpl.this.sendMessagesToSup(loginUser, templet, badReport);
                    }
                }
            });
        }
    }

    @Override
    @CacheEvict(value={"badReport"}, allEntries=true)
    @Transactional
    public void sendForSup(Project project, Company company, User loginUser, List<BadReport> badReportList) {
        Assert.isNotEmpty(badReportList, (String)"\u4e0d\u826f\u62a5\u544a\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        ArrayList<String> ids = new ArrayList<String>();
        for (BadReport badReport : badReportList) {
            Assert.isNotBlank((String)badReport.getId(), (String)"\u4e0d\u826f\u62a5\u544aID\u4e0d\u80fd\u4e3a\u7a7a!");
            ids.add(badReport.getId());
        }
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(BillStatusEnum.STATUS_SIGNED.getBillStatus());
        billStatus.add(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatus());
        billStatus.add(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatus());
        billStatus.add(BillStatusEnum.STATUS_ABOLISH.getBillStatus());
        BadReportExample badReportExample = new BadReportExample();
        badReportExample.createCriteria().andProjectIdEqualTo(project.getId()).andPurCompanyIdEqualTo(project.getCompanyId()).andSupCompanyIdEqualTo(company.getId()).andBillStatusIn(billStatus).andIdIn(ids);
        int countByExample = this.badReportMapper.countByExample(badReportExample);
        if (countByExample > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u542b\u6709\u5df2\u56de\u7b7e\uff0c\u5df2\u5ba1\u6279\uff0c\u5df2\u9a73\u56de\uff0c\u5df2\u4f5c\u5e9f\u7b49\u6570\u636e\uff0c\u64cd\u4f5c\u5931\u8d25!");
        }
        badReportExample.clear();
        badReportExample.createCriteria().andProjectIdEqualTo(project.getId()).andPurCompanyIdEqualTo(project.getCompanyId()).andSupCompanyIdEqualTo(company.getId()).andBillStatusEqualTo(BillStatusEnum.STATUS_UN_SIGN.getBillStatus()).andIdIn(ids);
        final List<BadReport> badReports = this.badReportMapper.selectByExample(badReportExample);
        if (CollectionUtils.isEmpty(badReports)) {
            throw new CommonException("\u627e\u4e0d\u5230\u7b26\u5408\u6761\u4ef6\u7684\u5355\u636e\uff0c\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        for (BadReport report : badReports) {
            Assert.isNotBlank((String)report.getSupBadReportFile(), (String)"\u5355\u636e\u4e2d\u542b\u6709\u4f9b\u5e94\u5546\u56de\u590d\u9644\u4ef6\u8fd8\u6ca1\u6709\u4e0a\u4f20\uff0c\u8bf7\u5148\u4e0a\u4f20\u540e\u518d\u56de\u7b7e\uff0c\u8c22\u8c22\uff01");
            if (report.getSupBadReportFile().equals("[]") || report.getSupBadReportFile().equals("[ ]")) {
                throw new CommonException("\u5355\u636e\u4e2d\u542b\u6709\u4f9b\u5e94\u5546\u56de\u590d\u9644\u4ef6\u8fd8\u6ca1\u6709\u4e0a\u4f20\uff0c\u8bf7\u5148\u4e0a\u4f20\u540e\u518d\u56de\u7b7e\uff0c\u8c22\u8c22\uff01");
            }
            report.setSupSignTime(new Date());
            report.setBillStatus(BillStatusEnum.STATUS_SIGNED.getBillStatus());
            this.badReportMapper.updateByPrimaryKeySelective(report);
        }
        this.defaultThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                for (BadReport badReport : badReports) {
                    HarmMaterialImTemplet templet = BadReportServiceImpl.this.constructImInfo(2, "\u56de\u7b7e", badReport);
                    BadReportServiceImpl.this.sendMessagesToPur(badReport, templet);
                }
            }
        });
    }

    private HarmMaterialImTemplet constructImInfo(int role, String operate, BadReport list) {
        Assert.isNotNull((Object)list, (String)"\u4f20\u8f93\u6570\u636e\u4e3a\u7a7a");
        HarmMaterialImTemplet tem = new HarmMaterialImTemplet();
        if (role == 1) {
            tem.setRole("\u91c7\u8d2d\u5546");
            if (StringUtils.isNotEmpty((String)list.getPurCompanyName())) {
                tem.setCompanyName(list.getPurCompanyName());
            } else {
                tem.setCompanyName("");
            }
        } else {
            tem.setRole("\u4f9b\u5e94\u5546");
            if (StringUtils.isNotEmpty((String)list.getSupCompanyName())) {
                tem.setCompanyName(list.getSupCompanyName());
            } else {
                tem.setCompanyName("");
            }
        }
        if (StringUtils.isEmpty((String)operate)) {
            throw new CommonException("\u6ca1\u6709\u4f20\u5165\u64cd\u4f5c\u5b57\u6bb5,\u65e0\u6cd5\u751f\u6210\u6d88\u606f\u6a21\u677f!");
        }
        tem.setOperate(operate);
        tem.setOtherInfo("\u4e86\u65b0\u7684\u96f6\u4ef6\u4e0d\u826f\u62a5\u544a\u5355\u636e,\u5355\u636e\u53f7\u5305\u62ec\uff1a");
        tem.setBillList(list.getBadReportNo());
        return tem;
    }

    public void sendMessagesToSup(User loginUser, HarmMaterialImTemplet templet, BadReport data) {
        User supUser = this.companyUserRefService.queryMainUserOfCompany(data.getSupCompanyId());
        Message message = Message.init((Object)templet).setBusinessTypeCode(IM_CODE).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(supUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    public void sendMessagesToPur(BadReport data, HarmMaterialImTemplet templet) {
        User supUser = this.companyUserRefService.queryMainUserOfCompany(data.getSupCompanyId());
        Message message = Message.init((Object)templet).setBusinessTypeCode(IM_CODE).setCompanyCode(data.getSupCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(supUser.getId()).addReceiverId(data.getPurUserId());
        MessageSendUtils.sendMessage((Message)message);
    }

    @Override
    @CacheEvict(value={"badReport"}, allEntries=true)
    @Transactional
    public void sendForPur(Project project, Company company, final User loginUser, List<BadReport> badReportList) {
        Assert.isNotEmpty(badReportList, (String)"\u4e0d\u826f\u62a5\u544a\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        ArrayList<String> ids = new ArrayList<String>();
        for (BadReport badReport : badReportList) {
            Assert.isNotBlank((String)badReport.getId(), (String)"\u4e0d\u826f\u62a5\u544aID\u4e0d\u80fd\u4e3a\u7a7a!");
            ids.add(badReport.getId());
        }
        BadReportExample badReportExample = new BadReportExample();
        badReportExample.createCriteria().andProjectIdEqualTo(project.getId()).andPurCompanyIdEqualTo(project.getCompanyId()).andSendStatusEqualTo(Constant.YES_INT).andIdIn(ids);
        int countByExample = this.badReportMapper.countByExample(badReportExample);
        if (countByExample > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u542b\u6709\u5df2\u53d1\u9001\u6570\u636e\uff0c\u64cd\u4f5c\u5931\u8d25!");
        }
        badReportExample.clear();
        badReportExample.createCriteria().andProjectIdEqualTo(project.getId()).andPurCompanyIdEqualTo(project.getCompanyId()).andSendStatusEqualTo(Constant.NO_INT).andIdIn(ids);
        BadReport badReport = new BadReport();
        badReport.setPurSendTime(new Date());
        badReport.setSendStatus(Constant.YES_INT);
        this.badReportMapper.updateByExampleSelective(badReport, badReportExample);
        badReportExample.clear();
        badReportExample.createCriteria().andIdIn(ids);
        final List<BadReport> badReports = this.badReportMapper.selectByExample(badReportExample);
        if (CollectionUtils.isNotEmpty(badReports)) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    for (BadReport badReport : badReports) {
                        HarmMaterialImTemplet templet = BadReportServiceImpl.this.constructImInfo(1, "\u53d1\u9001", badReport);
                        BadReportServiceImpl.this.sendMessagesToSup(loginUser, templet, badReport);
                    }
                }
            });
        }
    }

    @Override
    @CacheEvict(value={"badReport"}, allEntries=true)
    @Transactional
    public void create(Project project, Company company, User loginUser, BadReport badReport) {
        Assert.isNotNull((Object)badReport, (String)"\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        this.setPurCompanyInfo(project, company, badReport);
        this.setSupCompanyInfo(badReport);
        this.setBadeReportInfo(loginUser, badReport);
    }

    private void setBadeReportInfo(User loginUser, BadReport badReport) {
        badReport.setId(null);
        badReport.setIsEnable(Constant.YES_INT);
        badReport.setBadReportNo(this.generateCodeService.getNextCode("BAD_REPORT_NO"));
        badReport.setPurUserId(loginUser.getId());
        badReport.setCreateTime(new Date());
        badReport.setUpdateTime(new Date());
        badReport.setPurCommitTime(new Date());
        this.badReportMapper.insertSelective(badReport);
        List<BadReportItem> badReportItemList = badReport.getBadReportItemList();
        Assert.isNotEmpty(badReportItemList, (String)"\u4e0d\u826f\u62a5\u544a\u884c\u6570\u636e\uff0c\u4e0d\u80fd\u4e3a\u7a7a!");
        for (BadReportItem badReportItem : badReportItemList) {
            Assert.isNotNull((Object)badReportItem, (String)"\u4e0d\u826f\u62a5\u544a\u6570\u636e\uff0c\u4e0d\u80fd\u4e3a\u7a7a!");
            badReportItem.setId(null);
            badReportItem.setBadReportId(badReport.getId());
            this.badReportItemService.addObj(badReportItem);
        }
    }

    private void setSupCompanyInfo(BadReport badReport) {
        Assert.isNotBlank((String)badReport.getSupCompanySrmCode(), (String)"\u4f9b\u5e94\u5546SRM\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        Company supCompany = this.companyService.queryCompanyByCode(badReport.getSupCompanySrmCode());
        Assert.isNotNull((Object)supCompany, (String)"\u516c\u53f8\u4e0d\u5b58\u5728\uff0c\u64cd\u4f5c\u5931\u8d25");
        badReport.setSupCompanyId(supCompany.getId());
        badReport.setSupCompanyName(supCompany.getCompanyName());
        badReport.setSupCompanyFullName(supCompany.getCompanyFullName());
        badReport.setSupCompanySrmCode(supCompany.getCompanyCode());
        badReport.setPurCompanySapCode(supCompany.getCompanySapCode());
    }

    private void setPurCompanyInfo(Project project, Company company, BadReport badReport) {
        badReport.setProjectId(project.getId());
        badReport.setPurCompanyId(project.getCompanyId());
        badReport.setPurCompanyName(company.getCompanyName());
        badReport.setPurCompanyFullName(company.getCompanyFullName());
        badReport.setPurCompanySrmCode(company.getCompanyCode());
        badReport.setPurCompanySapCode(company.getCompanySapCode());
    }

    @Override
    @CacheEvict(value={"badReport"}, allEntries=true)
    @Transactional
    public void deleteObjByIds(Project project, Company company, User loginUser, List<BadReport> badReportList) {
        Assert.isNotEmpty(badReportList, (String)"\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        ArrayList<String> ids = new ArrayList<String>();
        for (BadReport badReport : badReportList) {
            Assert.isNotBlank((String)badReport.getId(), (String)"\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a!");
            ids.add(badReport.getId());
        }
        BadReportExample example = new BadReportExample();
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andProjectIdEqualTo(project.getId()).andPurCompanyIdEqualTo(project.getCompanyId()).andSendStatusEqualTo(Constant.YES_INT).andIdIn(ids);
        int countByExample = this.badReportMapper.countByExample(example);
        if (countByExample > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u5305\u542b\u5df2\u53d1\u9001\u6570\u636e\uff0c\u64cd\u4f5c\u5931\u8d25!");
        }
        example.clear();
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andProjectIdEqualTo(project.getId()).andPurCompanyIdEqualTo(project.getCompanyId()).andBillStatusNotEqualTo(BillStatusEnum.STATUS_UN_SIGN.getBillStatus()).andIdIn(ids);
        int countByExample2 = this.badReportMapper.countByExample(example);
        if (countByExample2 > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u5305\u542b\u9664\u4e86\u672a\u56de\u7b7e\u7b49\u72b6\u6001\u5176\u4ed6\u6570\u636e\uff0c\u64cd\u4f5c\u5931\u8d25!");
        }
        example.clear();
        example.createCriteria().andProjectIdEqualTo(project.getId()).andPurCompanyIdEqualTo(project.getCompanyId()).andIsEnableEqualTo(Constant.YES_INT).andBillStatusEqualTo(BillStatusEnum.STATUS_UN_SIGN.getBillStatus()).andIdIn(ids);
        BadReport badReport = new BadReport();
        badReport.setIsEnable(Constant.NO_INT);
        this.badReportMapper.updateByExampleSelective(badReport, example);
    }

    @CacheEvict(value={"badReport"}, allEntries=true)
    public void addObj(BadReport t) {
        this.badReportMapper.insertSelective(t);
    }

    @CacheEvict(value={"badReport"}, allEntries=true)
    public void deleteObjById(String id) {
        this.badReportMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"badReport"}, allEntries=true)
    public void modifyObj(BadReport t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.badReportMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"badReport"}, keyGenerator="redisKeyGenerator")
    public BadReport queryObjById(String id) {
        return this.badReportMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"badReport"}, keyGenerator="redisKeyGenerator")
    public List<BadReport> queryAllObjByExample(BadReportExample example) {
        return this.badReportMapper.selectByExample(example);
    }

    @Cacheable(value={"badReport"}, keyGenerator="redisKeyGenerator")
    public PageView<BadReport> queryObjByPage(BadReportExample example) {
        PageView<BadReport> pageView = example.getPageView();
        pageView.setQueryResult(this.badReportMapper.selectByExampleByPage(example));
        return pageView;
    }
}

