/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.quality.result.service.impl;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.quality.harms.im.HarmMaterialImTemplet;
import com.els.base.quality.result.dao.CheckResultMapper;
import com.els.base.quality.result.entity.CheckResult;
import com.els.base.quality.result.entity.CheckResultData;
import com.els.base.quality.result.entity.CheckResultDataExample;
import com.els.base.quality.result.entity.CheckResultExample;
import com.els.base.quality.result.entity.CheckResultItem;
import com.els.base.quality.result.entity.CheckResultItemExample;
import com.els.base.quality.result.service.CheckResultDataService;
import com.els.base.quality.result.service.CheckResultItemService;
import com.els.base.quality.result.service.CheckResultService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCheckResultService")
public class CheckResultServiceImpl
implements CheckResultService {
    private static final String IM_CODE = "BAD_RESULT_REPORT_MESSAGE";
    @Resource
    protected CheckResultMapper checkResultMapper;
    @Resource
    private CompanyService companyService;
    @Resource
    private GenerateCodeService generateCodeService;
    @Resource
    private CheckResultItemService checkResultItemService;
    @Resource
    private CheckResultDataService checkResultDataService;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    private ThreadPoolTaskExecutor defaultThreadPool;

    @Override
    @CacheEvict(value={"checkResult"}, allEntries=true)
    @Transactional
    public void deleteObjByIds(Project project, Company company, User loginUser, List<CheckResult> checkResultList) {
        Assert.isNotEmpty(checkResultList, (String)"\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        ArrayList<String> ids = new ArrayList<String>();
        for (CheckResult checkResult : checkResultList) {
            Assert.isNotBlank((String)checkResult.getId(), (String)"\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a!");
            ids.add(checkResult.getId());
        }
        CheckResultExample example = new CheckResultExample();
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andProjectIdEqualTo(project.getId()).andPurCompanyIdEqualTo(project.getCompanyId()).andSendStatusEqualTo(Constant.YES_INT).andIdIn(ids);
        int countByExample = this.checkResultMapper.countByExample(example);
        if (countByExample > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u5305\u542b\u5df2\u53d1\u9001\u6570\u636e\uff0c\u64cd\u4f5c\u5931\u8d25!");
        }
        CheckResult checkResult = new CheckResult();
        checkResult.setIsEnable(Constant.NO_INT);
        example.clear();
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andProjectIdEqualTo(project.getId()).andPurCompanyIdEqualTo(project.getCompanyId()).andIdIn(ids);
        this.checkResultMapper.updateByExampleSelective(checkResult, example);
    }

    @Override
    @CacheEvict(value={"checkResult"}, allEntries=true)
    @Transactional
    public void sendForPur(Project project, Company company, final User loginUser, List<CheckResult> checkResultList) {
        Assert.isNotEmpty(checkResultList, (String)"\u68c0\u67e5\u7ed3\u679c\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        ArrayList<String> ids = new ArrayList<String>();
        for (CheckResult checkResult : checkResultList) {
            Assert.isNotBlank((String)checkResult.getId(), (String)"\u68c0\u67e5\u7ed3\u679c\u62a5\u544aID\u4e0d\u80fd\u4e3a\u7a7a!");
            ids.add(checkResult.getId());
        }
        CheckResultExample checkResultExample = new CheckResultExample();
        checkResultExample.createCriteria().andProjectIdEqualTo(project.getId()).andPurCompanyIdEqualTo(project.getCompanyId()).andSendStatusEqualTo(Constant.YES_INT).andIdIn(ids);
        int countByExample = this.checkResultMapper.countByExample(checkResultExample);
        if (countByExample > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u542b\u6709\u5df2\u53d1\u9001\u6570\u636e\uff0c\u64cd\u4f5c\u5931\u8d25!");
        }
        checkResultExample.clear();
        checkResultExample.createCriteria().andProjectIdEqualTo(project.getId()).andPurCompanyIdEqualTo(project.getCompanyId()).andSendStatusEqualTo(Constant.NO_INT).andIdIn(ids);
        CheckResult checkResult = new CheckResult();
        checkResult.setPurSendTime(new Date());
        checkResult.setSendStatus(Constant.YES_INT);
        this.checkResultMapper.updateByExampleSelective(checkResult, checkResultExample);
        checkResultExample.clear();
        checkResultExample.createCriteria().andIdIn(ids);
        final List<CheckResult> checkResults = this.checkResultMapper.selectByExample(checkResultExample);
        if (CollectionUtils.isNotEmpty(checkResults)) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    for (CheckResult checkResult : checkResults) {
                        HarmMaterialImTemplet templet = CheckResultServiceImpl.this.constructImInfo(1, "\u53d1\u9001", checkResult);
                        CheckResultServiceImpl.this.sendMessagesToSup(loginUser, templet, checkResult);
                    }
                }
            });
        }
    }

    private HarmMaterialImTemplet constructImInfo(int role, String operate, CheckResult list) {
        Assert.isNotNull((Object)list, (String)"\u4f20\u8f93\u6570\u636e\u4e3a\u7a7a");
        HarmMaterialImTemplet tem = new HarmMaterialImTemplet();
        if (role == 1) {
            tem.setRole("\u91c7\u8d2d\u5546");
            if (StringUtils.isNotEmpty((String)list.getPurCompanyName())) {
                tem.setCompanyName(list.getPurCompanyName());
            } else {
                tem.setCompanyName("");
            }
        } else {
            tem.setRole("\u4f9b\u5e94\u5546");
            if (StringUtils.isNotEmpty((String)list.getSupCompanyName())) {
                tem.setCompanyName(list.getSupCompanyName());
            } else {
                tem.setCompanyName("");
            }
        }
        if (StringUtils.isEmpty((String)operate)) {
            throw new CommonException("\u6ca1\u6709\u4f20\u5165\u64cd\u4f5c\u5b57\u6bb5,\u65e0\u6cd5\u751f\u6210\u6d88\u606f\u6a21\u677f!");
        }
        tem.setOperate(operate);
        tem.setOtherInfo("\u4e86\u65b0\u7684\u68c0\u67e5\u7ed3\u679c\u517c\u5904\u7406\u62a5\u544a\u5355\u636e,\u5355\u636e\u53f7\u5305\u62ec\uff1a");
        tem.setBillList(list.getResultReportNo());
        return tem;
    }

    public void sendMessagesToSup(User loginUser, HarmMaterialImTemplet templet, CheckResult data) {
        User supUser = this.companyUserRefService.queryMainUserOfCompany(data.getSupCompanyId());
        Message message = Message.init((Object)templet).setBusinessTypeCode(IM_CODE).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(supUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    @Override
    @CacheEvict(value={"checkResult"}, allEntries=true)
    @Transactional
    public void edit(Project project, Company company, User loginUser, CheckResult checkResult) {
        Assert.isNotBlank((String)checkResult.getId(), (String)"\u68c0\u67e5\u7ed3\u679c\u517c\u5904\u7406\u62a5\u544aID\u4e0d\u80fd\u4e3a\u7a7a,\u64cd\u4f5c\u5931\u8d25!");
        CheckResult checkResultOld = this.checkResultMapper.selectByPrimaryKey(checkResult.getId());
        Assert.isNotNull((Object)checkResultOld, (String)"\u68c0\u67e5\u7ed3\u679c\u517c\u5904\u7406\u62a5\u544a\u4e0d\u5b58\u5728,\u64cd\u4f5c\u5931\u8d25!");
        this.updateCheckResultForPur(checkResult, checkResultOld);
        this.updateCheckResultItemInfoForPur(checkResult, checkResultOld);
        this.updateCheckResultDataForPur(checkResult, checkResultOld);
    }

    private void updateCheckResultDataForPur(CheckResult checkResult, CheckResult checkResultOld) {
        List<CheckResultData> checkResultDataList = checkResult.getCheckResultDataList();
        Assert.isNotEmpty(checkResultDataList, (String)"\u5c3a\u5bf8\u6d4b\u91cf\u6570\u636e\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank((String)checkResult.getId(), (String)"\u68c0\u67e5\u7ed3\u679cID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        CheckResultDataExample checkResultDataExample = new CheckResultDataExample();
        checkResultDataExample.createCriteria().andQualityResultIdEqualTo(checkResult.getId());
        this.checkResultDataService.deleteByExample(checkResultDataExample);
        for (CheckResultData checkResultData : checkResultDataList) {
            checkResultData.setId(null);
            checkResultData.setQualityResultId(checkResultOld.getId());
            this.checkResultDataService.addObj(checkResultData);
        }
    }

    private void updateCheckResultItemInfoForPur(CheckResult checkResult, CheckResult checkResultOld) {
        List<CheckResultItem> checkResultItemList = checkResult.getCheckResultItemList();
        Assert.isNotEmpty(checkResultItemList, (String)"\u68c0\u67e5\u7ed3\u679c\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank((String)checkResult.getId(), (String)"\u68c0\u67e5\u7ed3\u679cID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        CheckResultItemExample checkResultItemExample = new CheckResultItemExample();
        checkResultItemExample.createCriteria().andQualityResultIdEqualTo(checkResult.getId());
        this.checkResultItemService.deleteByExample(checkResultItemExample);
        for (CheckResultItem checkResultItem : checkResultItemList) {
            checkResultItem.setId(null);
            checkResultItem.setQualityResultId(checkResultOld.getId());
            this.checkResultItemService.addObj(checkResultItem);
        }
    }

    private void updateCheckResultForPur(CheckResult checkResult, CheckResult checkResultOld) {
        checkResultOld.setPurMaterialCode(checkResult.getPurMaterialCode());
        checkResultOld.setPurMaterialName(checkResult.getPurMaterialName());
        checkResultOld.setPurMaterialDesc(checkResult.getPurMaterialDesc());
        checkResultOld.setSampling(checkResult.getSampling());
        checkResultOld.setAvailableMachine(checkResult.getAvailableMachine());
        checkResultOld.setIncomeMaterialTime(checkResult.getIncomeMaterialTime());
        checkResultOld.setInspectionLot(checkResult.getInspectionLot());
        checkResultOld.setLotNo(checkResult.getLotNo());
        checkResultOld.setLotDesc(checkResult.getLotDesc());
        checkResultOld.setLotQuantity(checkResult.getLotQuantity());
        checkResultOld.setCheckTime(checkResult.getCheckTime());
        checkResultOld.setCheckStandard(checkResult.getCheckStandard());
        checkResultOld.setCheckPurpose(checkResult.getCheckPurpose());
        checkResultOld.setPurRemark(checkResult.getPurRemark());
        checkResultOld.setDefectDesc(checkResult.getDefectDesc());
        checkResultOld.setHandleWay(checkResult.getHandleWay());
        checkResultOld.setConfirmUserId(checkResult.getConfirmUserId());
        checkResultOld.setConfirmUserName(checkResult.getConfirmUserName());
        checkResultOld.setRecognizeUserId(checkResult.getRecognizeUserId());
        checkResultOld.setRecognizeUserName(checkResult.getRecognizeUserName());
        checkResultOld.setBioTechUserId(checkResult.getBioTechUserId());
        checkResultOld.setBioTechUserName(checkResult.getBioTechUserName());
        checkResultOld.setQualityTechUserId(checkResult.getQualityTechUserId());
        checkResultOld.setQualityTechUserName(checkResult.getQualityTechUserName());
        this.checkResultMapper.updateByPrimaryKeySelective(checkResultOld);
    }

    @Override
    @CacheEvict(value={"checkResult"}, allEntries=true)
    @Transactional
    public void create(Project project, Company company, User loginUser, CheckResult checkResult) {
        Assert.isNotNull((Object)checkResult, (String)"\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        this.setPurCompanyInfo(project, company, checkResult);
        this.setSupCompanyInfo(checkResult);
        this.setCheckResultInfo(loginUser, checkResult);
    }

    private void setCheckResultInfo(User loginUser, CheckResult checkResult) {
        checkResult.setId(null);
        checkResult.setIsEnable(Constant.YES_INT);
        checkResult.setResultReportNo(this.generateCodeService.getNextCode("RESULT_REPORT_NO"));
        checkResult.setPurUserId(loginUser.getId());
        checkResult.setCreateTime(new Date());
        checkResult.setUpdateTime(new Date());
        checkResult.setPurUserId(loginUser.getId());
        checkResult.setPurUserName(loginUser.getNickName());
        this.checkResultMapper.insertSelective(checkResult);
        List<CheckResultItem> checkResultItemList = checkResult.getCheckResultItemList();
        Assert.isNotEmpty(checkResultItemList, (String)"\u68c0\u67e5\u7ed3\u679c\u62a5\u544a\u884c\u6570\u636e\uff0c\u4e0d\u80fd\u4e3a\u7a7a!");
        for (CheckResultItem checkResultItem : checkResultItemList) {
            Assert.isNotNull((Object)checkResultItem, (String)"\u68c0\u67e5\u7ed3\u679c\u62a5\u544a\u6570\u636e\uff0c\u4e0d\u80fd\u4e3a\u7a7a!");
            checkResultItem.setId(null);
            checkResultItem.setQualityResultId(checkResult.getId());
            this.checkResultItemService.addObj(checkResultItem);
        }
        List<CheckResultData> checkResultDataList = checkResult.getCheckResultDataList();
        Assert.isNotEmpty(checkResultDataList, (String)"\u5c3a\u5bf8\u6d4b\u91cf\u6570\u636e\u5217\u8868\uff0c\u4e0d\u80fd\u4e3a\u7a7a!");
        for (CheckResultData checkResultData : checkResultDataList) {
            Assert.isNotNull((Object)checkResultData, (String)"\u5c3a\u5bf8\u6d4b\u91cf\u6570\u636e\uff0c\u4e0d\u80fd\u4e3a\u7a7a!");
            checkResultData.setId(null);
            checkResultData.setQualityResultId(checkResult.getId());
            this.checkResultDataService.addObj(checkResultData);
        }
    }

    private void setSupCompanyInfo(CheckResult checkResult) {
        Assert.isNotBlank((String)checkResult.getSupCompanySrmCode(), (String)"\u4f9b\u5e94\u5546SRM\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        Company supCompany = this.companyService.queryCompanyByCode(checkResult.getSupCompanySrmCode());
        Assert.isNotNull((Object)supCompany, (String)"\u516c\u53f8\u4e0d\u5b58\u5728\uff0c\u64cd\u4f5c\u5931\u8d25");
        checkResult.setSupCompanyId(supCompany.getId());
        checkResult.setSupCompanyName(supCompany.getCompanyName());
        checkResult.setSupCompanyFullName(supCompany.getCompanyFullName());
        checkResult.setPurCompanySapCode(supCompany.getCompanySapCode());
        checkResult.setSupCompanySrmCode(supCompany.getCompanyCode());
    }

    private void setPurCompanyInfo(Project project, Company company, CheckResult checkResult) {
        checkResult.setProjectId(project.getId());
        checkResult.setPurCompanyId(project.getCompanyId());
        checkResult.setPurCompanyName(company.getCompanyName());
        checkResult.setPurCompanySrmCode(company.getCompanyCode());
        checkResult.setPurCompanyFullName(company.getCompanyFullName());
        checkResult.setPurCompanySapCode(company.getCompanySapCode());
    }

    @CacheEvict(value={"checkResult"}, allEntries=true)
    public void addObj(CheckResult t) {
        this.checkResultMapper.insertSelective(t);
    }

    @CacheEvict(value={"checkResult"}, allEntries=true)
    public void deleteObjById(String id) {
        this.checkResultMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"checkResult"}, allEntries=true)
    public void modifyObj(CheckResult t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.checkResultMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"checkResult"}, keyGenerator="redisKeyGenerator")
    public CheckResult queryObjById(String id) {
        return this.checkResultMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"checkResult"}, keyGenerator="redisKeyGenerator")
    public List<CheckResult> queryAllObjByExample(CheckResultExample example) {
        return this.checkResultMapper.selectByExample(example);
    }

    @Cacheable(value={"checkResult"}, keyGenerator="redisKeyGenerator")
    public PageView<CheckResult> queryObjByPage(CheckResultExample example) {
        PageView<CheckResult> pageView = example.getPageView();
        pageView.setQueryResult(this.checkResultMapper.selectByExampleByPage(example));
        return pageView;
    }
}

