
CREATE TABLE T_BASE_QUALITY_HARM_MATERIALS (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_FULL_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_FULL_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"HARM_BILL_NO" VARCHAR2(255 BYTE) NULL ,
"MATERIAL_CODE" VARCHAR2(255 BYTE) NULL ,
"MATERIAL_DESC" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPONENT_NO" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPONENT_NAME" VARCHAR2(255 BYTE) NULL ,
"QUANTITY" NUMBER(13,3) NULL ,
"MATERIAL_INFO" VARCHAR2(255 BYTE) NULL ,
"SUBSTANCE" NUMBER(13,3) NULL ,
"FACE_HANDLE" VARCHAR2(255 BYTE) NULL ,
"BRAND_INFO" VARCHAR2(255 BYTE) NULL ,
"REPORT_CHECK_STATUS" VARCHAR2(255 BYTE) NULL ,
"LAYER_LEVEL" VARCHAR2(255 BYTE) NULL ,
"PUR_USER_ID" VARCHAR2(255 BYTE) NULL ,
"SUP_USER_ID" VARCHAR2(255 BYTE) NULL ,
"PUR_REMARK" VARCHAR2(1000 BYTE) NULL ,
"SUP_REMARK" VARCHAR2(1000 BYTE) NULL ,
"NECESSARY_FILLING" VARCHAR2(255 BYTE) NULL ,
"SEND_STATUS" NUMBER(7) NULL ,
"PUR_SEND_TIME" DATE NULL ,
"PUR_COMMIT_TIME" DATE NULL ,
"SUP_COMMIT_TIME" DATE NULL ,
"APPROVE_USERNAME" VARCHAR2(255 BYTE) NULL ,
"APPROVE_TIME" DATE NULL ,
"APPROVE_SUGGESTION" VARCHAR2(1000 BYTE) NULL ,
"SUP_SIGN_TIME" DATE NULL ,
"IS_ENABLE" NUMBER(7) NULL ,
"BILL_STATUS" NUMBER(7) NULL ,
"CREATE_TIME" DATE NULL ,
"UPDATE_TIME" DATE NULL 
)
;
COMMENT ON TABLE T_BASE_QUALITY_HARM_MATERIALS IS '有害物质报告';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."ID" IS '主键';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."PROJECT_ID" IS '表的项目ID';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."PUR_COMPANY_ID" IS '采购商ID';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."PUR_COMPANY_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."PUR_COMPANY_FULL_NAME" IS '采购商全称';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."PUR_COMPANY_NAME" IS '采购商简称';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."SUP_COMPANY_SAP_CODE" IS '供应商SAP编码';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."SUP_COMPANY_FULL_NAME" IS '供应商全称';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."SUP_COMPANY_NAME" IS '供应商简称';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."HARM_BILL_NO" IS '单据号';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."MATERIAL_CODE" IS '物料编码';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."MATERIAL_DESC" IS '物料描述';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."SUP_COMPONENT_NO" IS '供应商分零件号';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."SUP_COMPONENT_NAME" IS '供应商分零件名称';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."QUANTITY" IS '数量';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."MATERIAL_INFO" IS '材料名称/牌号（颜色）';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."SUBSTANCE" IS '单重（克）';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."FACE_HANDLE" IS '表面处理';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."BRAND_INFO" IS '厂商/品牌（生产地点）';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."REPORT_CHECK_STATUS" IS '报告检测状态';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."LAYER_LEVEL" IS '层级';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."PUR_USER_ID" IS '消息推送(采购方)';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."SUP_USER_ID" IS '消息推送(供应商方)';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."PUR_REMARK" IS '采购商备注';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."SUP_REMARK" IS '供应商备注';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."NECESSARY_FILLING" IS '选择必填项';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."SEND_STATUS" IS '发送状态（0=未发送，1=已发送）';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."PUR_SEND_TIME" IS '发送供应商时间';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."PUR_COMMIT_TIME" IS '采购商资料提交时间';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."SUP_COMMIT_TIME" IS '供应商资料提交时间';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."APPROVE_USERNAME" IS '审核人';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."APPROVE_TIME" IS '审核时间';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."APPROVE_SUGGESTION" IS '审核意见';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."SUP_SIGN_TIME" IS '供应商回签时间';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."BILL_STATUS" IS '单据状态(未回签=0,已回签=1,已审核=2,已驳回=3,已作废=4)';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIALS."UPDATE_TIME" IS '修改时间';


ALTER TABLE T_BASE_QUALITY_HARM_MATERIALS ADD CHECK ("ID" IS NOT NULL);
ALTER TABLE T_BASE_QUALITY_HARM_MATERIALS ADD CHECK ("ID" IS NOT NULL);


ALTER TABLE T_BASE_QUALITY_HARM_MATERIALS ADD PRIMARY KEY ("ID");
