
CREATE TABLE "T_BASE_QUALITY_BAD_REPORT" (
  "ID" VARCHAR2(32 BYTE) DEFAULT '' NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 BYTE) DEFAULT '' ,
  "PUR_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) DEFAULT '' ,
  "PUR_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) DEFAULT '' ,
  "PUR_COMPANY_NAME" VARCHAR2(255 BYTE) DEFAULT '' ,
  "PUR_COMPANY_FULL_NAME" VARCHAR2(255 BYTE) DEFAULT '' ,
  "SUP_COMPANY_ID" VARCHAR2(32 BYTE) DEFAULT '' ,
  "SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) DEFAULT '' ,
  "SUP_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) DEFAULT '' ,
  "SUP_COMPANY_NAME" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_FULL_NAME" VARCHAR2(255 BYTE) DEFAULT '' ,
  "PUR_USER_ID" VARCHAR2(255 BYTE) DEFAULT '' ,
  "SUP_USER_ID" VARCHAR2(255 BYTE) DEFAULT '' ,
  "PUR_REMARK" VARCHAR2(1000 BYTE) DEFAULT '' ,
  "SUP_REMARK" VARCHAR2(1000 BYTE) DEFAULT '' ,
  "SEND_STATUS" NUMBER(7) DEFAULT 0  ,
  "PUR_SEND_TIME" DATE ,
  "PUR_COMMIT_TIME" DATE ,
  "SUP_COMMIT_TIME" DATE ,
  "SUP_SIGN_TIME" DATE ,
  "IS_ENABLE" NUMBER(7) DEFAULT 1  ,
  "BILL_STATUS" NUMBER(7) DEFAULT 0  ,
  "CREATE_TIME" DATE ,
  "UPDATE_TIME" DATE ,
  "BAD_REPORT_NO" VARCHAR2(255 BYTE) DEFAULT '' ,
  "MODEL_NAME" VARCHAR2(255 BYTE) DEFAULT '' ,
  "SUP_COMPONENT_NO" VARCHAR2(255 BYTE) DEFAULT '' ,
  "SUP_COMPONENT_NAME" VARCHAR2(255 BYTE) DEFAULT '' ,
  "LOT_NO" VARCHAR2(255 BYTE) ,
  "LOT_DESC" VARCHAR2(255 BYTE) ,
  "LOT_QUANTITY" NUMBER(7) DEFAULT 0  ,
  "REPORT_TIME" DATE ,
  "REPORT_PLACE" VARCHAR2(255 BYTE) DEFAULT '' ,
  "RECOGNIZED_USER_ID" VARCHAR2(255 BYTE) DEFAULT '' ,
  "RECOGNIZED_USER_NAME" VARCHAR2(255 BYTE) DEFAULT '' ,
  "QUALITY_CONFIRM_ID" VARCHAR2(255 BYTE) DEFAULT '' ,
  "QUALITY_CONFIRM_NAME" VARCHAR2(255 BYTE) DEFAULT '' ,
  "PUBLISH_NAME" VARCHAR2(255 BYTE) DEFAULT '' ,
  "BAD_REPORT_IMG" VARCHAR2(2048 BYTE) DEFAULT '' ,
  "SUP_BAD_REPORT_FILE" VARCHAR2(2048 BYTE) DEFAULT '' ,
  "PUR_BAD_REPORT_FILE" VARCHAR2(2048 BYTE) DEFAULT ''

);

COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."PUR_COMPANY_ID" IS '采购商ID';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."PUR_COMPANY_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."PUR_COMPANY_SAP_CODE" IS '采购商SAP编码';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."PUR_COMPANY_NAME" IS '采购商简称';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."PUR_COMPANY_FULL_NAME" IS '采购商全称';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."SUP_COMPANY_SAP_CODE" IS '供应商SAP编码';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."SUP_COMPANY_NAME" IS '供应商简称';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."SUP_COMPANY_FULL_NAME" IS '供应商全称';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."PUR_USER_ID" IS '消息推送(采购方)';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."SUP_USER_ID" IS '消息推送(供应商方)';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."PUR_REMARK" IS '采购商备注';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."SUP_REMARK" IS '供应商备注';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."SEND_STATUS" IS '发送状态（0=未发送，1=已发送）';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."PUR_SEND_TIME" IS '供应商发送时间';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."PUR_COMMIT_TIME" IS '采购商资料提交时间';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."SUP_COMMIT_TIME" IS '供应商资料提交时间';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."SUP_SIGN_TIME" IS '供应商回签时间';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."BILL_STATUS" IS '(未回签=0, 已回签=1, 已审核=2, 已驳回=3, 已作废=4)';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."BAD_REPORT_NO" IS '单据号';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."MODEL_NAME" IS '机种名';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."SUP_COMPONENT_NO" IS '供应商分零件号';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."SUP_COMPONENT_NAME" IS '供应商分零件名称';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."LOT_NO" IS 'LOT NO';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."LOT_DESC" IS 'LOT 描述';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."LOT_QUANTITY" IS 'LOT 数量';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."REPORT_TIME" IS '发生时间';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."REPORT_PLACE" IS '发生地方';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."RECOGNIZED_USER_ID" IS '承认人ID';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."RECOGNIZED_USER_NAME" IS '承认人名称';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."QUALITY_CONFIRM_ID" IS '品管部门确认人ID';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."QUALITY_CONFIRM_NAME" IS '品管部门确认人名称';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."PUBLISH_NAME" IS '发行';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."BAD_REPORT_IMG" IS '不良报告图片';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."SUP_BAD_REPORT_FILE" IS '采购上传附件名称';
COMMENT ON COLUMN "T_BASE_QUALITY_BAD_REPORT"."PUR_BAD_REPORT_FILE" IS '供应商回复附件名称';
COMMENT ON TABLE "T_BASE_QUALITY_BAD_REPORT" IS '质量管理-零件不良报告书';


ALTER TABLE "T_BASE_QUALITY_BAD_REPORT" ADD  PRIMARY KEY ("ID");

