
CREATE TABLE T_BASE_QUALITY_HARM_MATS_ITEM (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"HARM_MATERIAL_ID" VARCHAR2(32 BYTE) NULL ,
"HARM_BILL_NO" VARCHAR2(255 BYTE) NULL ,
"LAYER_LEVEL" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPONENT_NO" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPONENT_NAME" VARCHAR2(255 BYTE) NULL ,
"QUANTITY" NUMBER(13,3) NULL ,
"MATERIAL_INFO" VARCHAR2(255 BYTE) NULL ,
"SUBSTANCE" NUMBER(13,3) NULL ,
"FACE_HANDLE" VARCHAR2(255 BYTE) NULL ,
"BRAND_INFO" VARCHAR2(255 BYTE) NULL ,
"CHECK_REPORT_NAME" VARCHAR2(255 BYTE) NULL ,
"ATTACHMENT" VARCHAR2(2048 BYTE) NULL ,
"REPORT_CODE" VARCHAR2(255 BYTE) NULL ,
"OTHER_REPORT_CODE" VARCHAR2(255 BYTE) NULL ,
"CHECK_TIME" DATE NULL ,
"ITEM_PUR_REMARK" VARCHAR2(1000 BYTE) NULL ,
"ITEM_SUP_REMARK" VARCHAR2(1000 BYTE) NULL ,
"CREATE_TIME" DATE NULL ,
"UPDATE_TIME" DATE NULL 
)
;
COMMENT ON TABLE T_BASE_QUALITY_HARM_MATS_ITEM IS '有害物质报告行项';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATS_ITEM."ID" IS '主键';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATS_ITEM."PROJECT_ID" IS '表的项目ID';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATS_ITEM."HARM_MATERIAL_ID" IS '有害物质报告ID';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATS_ITEM."HARM_BILL_NO" IS '单据号';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATS_ITEM."LAYER_LEVEL" IS '层级';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATS_ITEM."SUP_COMPONENT_NO" IS '供应商分零件号';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATS_ITEM."SUP_COMPONENT_NAME" IS '供应商分零件名称';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATS_ITEM."QUANTITY" IS '数量';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATS_ITEM."MATERIAL_INFO" IS '材料名称/牌号（颜色）';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATS_ITEM."SUBSTANCE" IS '单重（克）';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATS_ITEM."FACE_HANDLE" IS '表面处理';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATS_ITEM."BRAND_INFO" IS '厂商/品牌（生产地点）';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATS_ITEM."CHECK_REPORT_NAME" IS '检测报告名称';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATS_ITEM."ATTACHMENT" IS '检测报告原件';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATS_ITEM."REPORT_CODE" IS '报告编码';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATS_ITEM."OTHER_REPORT_CODE" IS '另存报告编码';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATS_ITEM."CHECK_TIME" IS '检测报告日期';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATS_ITEM."ITEM_PUR_REMARK" IS '行项采购商备注';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATS_ITEM."ITEM_SUP_REMARK" IS '行项供应商备注';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATS_ITEM."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATS_ITEM."UPDATE_TIME" IS '修改时间';


ALTER TABLE T_BASE_QUALITY_HARM_MATS_ITEM ADD CHECK ("ID" IS NOT NULL);
ALTER TABLE T_BASE_QUALITY_HARM_MATS_ITEM ADD CHECK ("ID" IS NOT NULL);


ALTER TABLE T_BASE_QUALITY_HARM_MATS_ITEM ADD PRIMARY KEY ("ID");
