/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.quality.result.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.quality.result.entity.CheckResult;
import com.els.base.quality.result.entity.CheckResultData;
import com.els.base.quality.result.entity.CheckResultExample;
import com.els.base.quality.result.entity.CheckResultItem;
import com.els.base.quality.result.service.CheckResultDataService;
import com.els.base.quality.result.service.CheckResultItemService;
import com.els.base.quality.result.service.CheckResultService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u8d28\u91cf\u7ba1\u7406-\u68c0\u67e5\u7ed3\u679c\u517c\u5904\u7406\u62a5\u544a")
@Controller
@RequestMapping(value={"checkResult"})
public class CheckResultController {
    @Resource
    protected CheckResultService checkResultService;
    @Resource
    protected CheckResultItemService checkResultItemService;
    @Resource
    protected CheckResultDataService checkResultDataService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8d28\u91cf\u7ba1\u7406-\u91c7\u8d2d\u5546\u53d1\u9001\u68c0\u67e5\u7ed3\u679c\u517c\u5904\u7406\u62a5\u544a\u7ed9\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/pur/send"})
    @ResponseBody
    public ResponseResult<String> sendForPur(@RequestBody List<CheckResult> checkResultList) {
        this.checkResultService.sendForPur(ProjectUtils.getProject(), CompanyUtils.currentCompany(), (User)SpringSecurityUtils.getLoginUser(), checkResultList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8d28\u91cf\u7ba1\u7406-\u68c0\u67e5\u7ed3\u679c\u517c\u5904\u7406\u62a5\u544a")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CheckResult checkResult) {
        this.checkResultService.create(ProjectUtils.getProject(), CompanyUtils.currentCompany(), (User)SpringSecurityUtils.getLoginUser(), checkResult);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8d28\u91cf\u7ba1\u7406-\u68c0\u67e5\u7ed3\u679c\u517c\u5904\u7406\u62a5\u544a")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody CheckResult checkResult) {
        this.checkResultService.edit(ProjectUtils.getProject(), CompanyUtils.currentCompany(), (User)SpringSecurityUtils.getLoginUser(), checkResult);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664\u8d28\u91cf\u7ba1\u7406-\u68c0\u67e5\u7ed3\u679c\u517c\u5904\u7406\u62a5\u544a")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody List<CheckResult> checkResultList) {
        this.checkResultService.deleteObjByIds(ProjectUtils.getProject(), CompanyUtils.currentCompany(), (User)SpringSecurityUtils.getLoginUser(), checkResultList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8d28\u91cf\u7ba1\u7406-\u68c0\u67e5\u7ed3\u679c\u517c\u5904\u7406\u62a5\u544a\uff08\u4f9b\u5e94\u65b9\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CheckResult", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/sup/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<CheckResult>> findByPageForSup(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PageView pageData;
        List queryResult;
        CheckResultExample example = new CheckResultExample();
        example.setPageView((PageView<CheckResult>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        CheckResultExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andPurCompanyIdEqualTo(ProjectUtils.getCompanyId()).andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andIsEnableEqualTo(Constant.YES_INT).andSendStatusEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        if (CollectionUtils.isEmpty((Collection)(queryResult = (pageData = this.checkResultService.queryObjByPage((IExample)example)).getQueryResult()))) {
            return ResponseResult.success((Object)pageData);
        }
        for (CheckResult checkResult : queryResult) {
            String id = checkResult.getId();
            List<CheckResultItem> list = this.checkResultItemService.queryByCheckResultId(id);
            checkResult.setCheckResultItemList(list);
            List<CheckResultData> checkResultDataList = this.checkResultDataService.queryByCheckResultId(id);
            checkResult.setCheckResultDataList(checkResultDataList);
        }
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8d28\u91cf\u7ba1\u7406-\u68c0\u67e5\u7ed3\u679c\u517c\u5904\u7406\u62a5\u544a(\u91c7\u8d2d\u65b9)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CheckResult", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/pur/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<CheckResult>> findByPageForPur(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PageView pageData;
        List queryResult;
        CheckResultExample example = new CheckResultExample();
        example.setPageView((PageView<CheckResult>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        CheckResultExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andIsEnableEqualTo(Constant.YES_INT).andPurCompanyIdEqualTo(ProjectUtils.getCompanyId());
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        if (CollectionUtils.isEmpty((Collection)(queryResult = (pageData = this.checkResultService.queryObjByPage((IExample)example)).getQueryResult()))) {
            return ResponseResult.success((Object)pageData);
        }
        for (CheckResult checkResult : queryResult) {
            String id = checkResult.getId();
            List<CheckResultItem> list = this.checkResultItemService.queryByCheckResultId(id);
            checkResult.setCheckResultItemList(list);
            List<CheckResultData> checkResultDataList = this.checkResultDataService.queryByCheckResultId(id);
            checkResult.setCheckResultDataList(checkResultDataList);
        }
        return ResponseResult.success((Object)pageData);
    }
}

