
CREATE TABLE T_BASE_QUALITY_HARM_MAT_ITEM (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"HARM_MATERIAL_ID" VARCHAR2(32 BYTE) NULL ,
"HARM_BILL_NO" VARCHAR2(255 BYTE) NULL ,
"CHECK_REPORT_NAME" VARCHAR2(255 BYTE) NULL ,
"CHECK_TIME" DATE NULL ,
"ATTACHMENT" VARCHAR2(2048 BYTE) NULL ,
"IS_COMMIT" NUMBER(7) NULL ,
"ITEM_PUR_REMARK" VARCHAR2(1000 BYTE) NULL ,
"ITEM_SUP_REMARK" VARCHAR2(1000 BYTE) NULL ,
"CREATE_TIME" DATE NULL ,
"UPDATE_TIME" DATE NULL 
)

;
COMMENT ON TABLE T_BASE_QUALITY_HARM_MAT_ITEM IS '有害物质报告行项';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MAT_ITEM."ID" IS '主键';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MAT_ITEM."PROJECT_ID" IS '表的项目ID';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MAT_ITEM."HARM_MATERIAL_ID" IS '有害物质报告ID';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MAT_ITEM."HARM_BILL_NO" IS '单据号';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MAT_ITEM."CHECK_REPORT_NAME" IS '检测报告名称';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MAT_ITEM."CHECK_TIME" IS '检测日期';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MAT_ITEM."ATTACHMENT" IS '附件';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MAT_ITEM."IS_COMMIT" IS '是否提交(0=未提交,1=已提交)';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MAT_ITEM."ITEM_PUR_REMARK" IS '行项采购商备注';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MAT_ITEM."ITEM_SUP_REMARK" IS '行项供应商备注';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MAT_ITEM."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MAT_ITEM."UPDATE_TIME" IS '修改时间';


ALTER TABLE T_BASE_QUALITY_HARM_MAT_ITEM ADD CHECK ("ID" IS NOT NULL);


ALTER TABLE T_BASE_QUALITY_HARM_MAT_ITEM ADD PRIMARY KEY ("ID");
