/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.schedule.web.controller;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.schedule.entity.ScheduleJob;
import com.els.base.schedule.entity.ScheduleJobExample;
import com.els.base.schedule.plugin.QuartzManager;
import com.els.base.schedule.service.ScheduleJobService;
import com.els.base.utils.SpringContextHolder;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u5b9a\u65f6\u4efb\u52a1"})
@Controller
@RequestMapping(value={"scheduleJob"})
public class ScheduleJobController {
    private static final Logger logger = LoggerFactory.getLogger(ScheduleJobController.class);
    @Resource
    protected ScheduleJobService scheduleJobService;
    private QuartzManager quartzManager;

    private QuartzManager getQuartzManager() {
        if (this.quartzManager == null) {
            this.quartzManager = (QuartzManager)SpringContextHolder.getOneBean(QuartzManager.class);
        }
        if (this.quartzManager == null) {
            throw new CommonException("\u7cfb\u7edf\u672a\u5f00\u542f\u5b9a\u65f6\u4efb\u52a1\u529f\u80fd");
        }
        return this.quartzManager;
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody ScheduleJob scheduleJob) {
        this.scheduleJobService.addObj(scheduleJob);
        return ResponseResult.success((Object)scheduleJob.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u5b9a\u65f6\u4efb\u52a1")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody ScheduleJob scheduleJob) {
        this.scheduleJobService.modifyObj(scheduleJob);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u5b9a\u65f6\u4efb\u52a1")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(String id) {
        this.scheduleJobService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u5b9a\u65f6\u4efb\u52a1")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u8bf7\u9009\u4e2d\u9700\u8981\u64cd\u4f5c\u7684\u5355\u636e\uff01");
        for (String id : ids) {
            this.deleteById(id);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u5b9a\u65f6\u4efb\u52a1")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<ScheduleJob>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=false) QueryParamWapper queryParams) {
        ScheduleJobExample example = new ScheduleJobExample();
        example.setPageView((PageView<ScheduleJob>)new PageView(pageNo, pageSize));
        ScheduleJobExample.Criteria criteria = example.createCriteria();
        if (queryParams != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)queryParams);
        }
        return ResponseResult.success((Object)this.scheduleJobService.queryObjByPage((IExample)example));
    }

    @ApiOperation(httpMethod="GET", value="\u73b0\u5728\u6267\u884c\u4efb\u52a1")
    @RequestMapping(value={"service/runJobNow"})
    @ResponseBody
    public ResponseResult<String> runJobNow(String id) {
        ScheduleJob job = (ScheduleJob)this.scheduleJobService.queryObjById(id);
        Assert.isNotNull((Object)job, (String)"\u5b9a\u65f6\u4efb\u52a1\u4e0d\u5b58\u5728");
        try {
            this.getQuartzManager().runJobNow(job);
        }
        catch (SchedulerException e) {
            logger.error("\u6267\u884c\u5931\u8d25", (Throwable)e);
            throw new CommonException("\u6267\u884c\u5931\u8d25", "base_fail");
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u505c\u6b62\u4efb\u52a1")
    @RequestMapping(value={"service/pauseJob"})
    @ResponseBody
    public ResponseResult<String> pauseJob(String id) {
        ScheduleJob job = (ScheduleJob)this.scheduleJobService.queryObjById(id);
        Assert.isNotNull((Object)job, (String)"\u5b9a\u65f6\u4efb\u52a1\u4e0d\u5b58\u5728");
        try {
            this.getQuartzManager().pauseJob(job);
        }
        catch (SchedulerException e) {
            logger.error("\u505c\u6b62\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            throw new CommonException("job \u505c\u6b62\u4efb\u52a1\u5931\u8d25", "base_fail");
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u542f\u52a8\u4efb\u52a1")
    @RequestMapping(value={"service/resumeJob"})
    @ResponseBody
    public ResponseResult<String> resumeJob(String id) {
        ScheduleJob job = (ScheduleJob)this.scheduleJobService.queryObjById(id);
        Assert.isNotNull((Object)job, (String)"\u5b9a\u65f6\u4efb\u52a1\u4e0d\u5b58\u5728");
        try {
            this.getQuartzManager().resumeJob(job);
        }
        catch (SchedulerException e) {
            logger.error("\u542f\u52a8\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            throw new CommonException("job \u542f\u52a8\u4efb\u52a1\u5931\u8d25", "base_fail");
        }
        return ResponseResult.success();
    }
}

