
-- ----------------------------
--  Table structure for T_BASE_SCHEDULE_JOB_LOG
-- ----------------------------
DROP TABLE "T_BASE_SCHEDULE_JOB_LOG";
CREATE TABLE "T_BASE_SCHEDULE_JOB_LOG" (   "ID" VARCHAR2(32BYTE) NOT NULL, "JOB_NAME" VARCHAR2(100BYTE), "JOB_CODE" VARCHAR2(100BYTE), "DESCRIPTOPN" VARCHAR2(255BYTE), "JOB_CLASS" VARCHAR2(100BYTE), "JOB_METHOD" VARCHAR2(50BYTE), "JOB_STATE" NUMBER(5,0) DEFAULT 0      , "CRON_EXPRESSION" VARCHAR2(50BYTE), "IS_ENABLE" NUMBER(2,0) DEFAULT 1     , "IS_CONCURRENT" NUMBER(2,0) DEFAULT 0      , "CREATE_TIME" DATE DEFAULT NULL, "UPDATE_TIME" DATE, "JOB_METHOD_PARAMS" VARCHAR2(255BYTE), "JOB_GROUP" VARCHAR2(255BYTE), "TIMES" NUMBER(12,0), "JOB_ID" VARCHAR2(255BYTE), "INSTANCE_NAME" VARCHAR2(255BYTE));
COMMENT ON COLUMN "T_BASE_SCHEDULE_JOB_LOG"."ID" IS '定时任务Id';
COMMENT ON COLUMN "T_BASE_SCHEDULE_JOB_LOG"."JOB_NAME" IS '定时任务名称';
COMMENT ON COLUMN "T_BASE_SCHEDULE_JOB_LOG"."JOB_CODE" IS 'job唯一代码';
COMMENT ON COLUMN "T_BASE_SCHEDULE_JOB_LOG"."DESCRIPTOPN" IS '定时任务描述';
COMMENT ON COLUMN "T_BASE_SCHEDULE_JOB_LOG"."JOB_CLASS" IS '定时任务完整类名称';
COMMENT ON COLUMN "T_BASE_SCHEDULE_JOB_LOG"."JOB_METHOD" IS '定时任务方法名称';
COMMENT ON COLUMN "T_BASE_SCHEDULE_JOB_LOG"."JOB_STATE" IS 'job状态,1正常运行，2运行异常';
COMMENT ON COLUMN "T_BASE_SCHEDULE_JOB_LOG"."CRON_EXPRESSION" IS '定时任务的Corn表达式';
COMMENT ON COLUMN "T_BASE_SCHEDULE_JOB_LOG"."IS_ENABLE" IS '是否启用，1启用，0禁用';
COMMENT ON COLUMN "T_BASE_SCHEDULE_JOB_LOG"."IS_CONCURRENT" IS '能否并发运行，1可以，0不可以';
COMMENT ON COLUMN "T_BASE_SCHEDULE_JOB_LOG"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_SCHEDULE_JOB_LOG"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_BASE_SCHEDULE_JOB_LOG"."JOB_METHOD_PARAMS" IS '定时任务方法参数';
COMMENT ON COLUMN "T_BASE_SCHEDULE_JOB_LOG"."JOB_GROUP" IS '定时任务组';
COMMENT ON COLUMN "T_BASE_SCHEDULE_JOB_LOG"."TIMES" IS '定时任务执行消耗的时间';
COMMENT ON COLUMN "T_BASE_SCHEDULE_JOB_LOG"."JOB_ID" IS '定时任务关联ID';
COMMENT ON COLUMN "T_BASE_SCHEDULE_JOB_LOG"."INSTANCE_NAME" IS '实例名称';

-- ----------------------------
--  Primary key structure for table T_BASE_SCHEDULE_JOB_LOG
-- ----------------------------
ALTER TABLE "T_BASE_SCHEDULE_JOB_LOG" ADD CONSTRAINT "SYS_C0046615" PRIMARY KEY("ID");

-- ----------------------------
--  Checks structure for table T_BASE_SCHEDULE_JOB_LOG
-- ----------------------------
ALTER TABLE "T_BASE_SCHEDULE_JOB_LOG" ADD CONSTRAINT "SYS_C0046614" CHECK ("ID" IS NOT NULL) ENABLE;

-- ----------------------------
--  Comment for table T_BASE_SCHEDULE_JOB_LOG
-- ----------------------------
COMMENT ON TABLE "T_BASE_SCHEDULE_JOB_LOG" IS '定时任务执行历史';



-- ----------------------------
--  Table structure for T_BASE_SCHEDULE_JOB
-- ----------------------------
DROP TABLE "T_BASE_SCHEDULE_JOB";
CREATE TABLE "T_BASE_SCHEDULE_JOB" (   "ID" NVARCHAR2(32) NOT NULL, "JOB_NAME" NVARCHAR2(100) NOT NULL, "JOB_CODE" NVARCHAR2(100) NOT NULL, "DESCRIPTOPN" NVARCHAR2(255), "JOB_CLASS" NVARCHAR2(100) NOT NULL, "JOB_METHOD" NVARCHAR2(50) NOT NULL, "JOB_STATE" NUMBER(11,0) DEFAULT 0    NOT NULL, "CRON_EXPRESSION" NVARCHAR2(50) NOT NULL, "IS_ENABLE" NUMBER(11,0) DEFAULT 1  , "IS_CONCURRENT" NUMBER(11,0) DEFAULT 0    NOT NULL, "CREATE_TIME" DATE DEFAULT sysdate    NOT NULL, "UPDATE_TIME" DATE, "JOB_METHOD_PARAMS" VARCHAR2(255BYTE), "JOB_GROUP" VARCHAR2(255BYTE));
COMMENT ON COLUMN "T_BASE_SCHEDULE_JOB"."ID" IS '定时任务Id';
COMMENT ON COLUMN "T_BASE_SCHEDULE_JOB"."JOB_NAME" IS '定时任务名称';
COMMENT ON COLUMN "T_BASE_SCHEDULE_JOB"."JOB_CODE" IS 'job唯一代码';
COMMENT ON COLUMN "T_BASE_SCHEDULE_JOB"."JOB_CLASS" IS '定时任务完整类名称';
COMMENT ON COLUMN "T_BASE_SCHEDULE_JOB"."JOB_METHOD" IS '定时任务方法名称';
COMMENT ON COLUMN "T_BASE_SCHEDULE_JOB"."JOB_STATE" IS 'job状态,1正常运行，2运行异常';
COMMENT ON COLUMN "T_BASE_SCHEDULE_JOB"."CRON_EXPRESSION" IS '定时任务的Corn表达式';
COMMENT ON COLUMN "T_BASE_SCHEDULE_JOB"."IS_ENABLE" IS '是否启用，1启用，0禁用';
COMMENT ON COLUMN "T_BASE_SCHEDULE_JOB"."IS_CONCURRENT" IS '能否并发运行，1可以，0不可以';
COMMENT ON COLUMN "T_BASE_SCHEDULE_JOB"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_SCHEDULE_JOB"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_BASE_SCHEDULE_JOB"."JOB_METHOD_PARAMS" IS '定时任务方法参数';
COMMENT ON COLUMN "T_BASE_SCHEDULE_JOB"."JOB_GROUP" IS '定时任务组';

-- ----------------------------
--  Checks structure for table T_BASE_SCHEDULE_JOB
-- ----------------------------
ALTER TABLE "T_BASE_SCHEDULE_JOB" ADD CONSTRAINT "SYS_C0020473" CHECK ("ID" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C0020474" CHECK ("JOB_NAME" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C0020475" CHECK ("JOB_CODE" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C0020476" CHECK ("JOB_CLASS" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C0020477" CHECK ("JOB_METHOD" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C0020478" CHECK ("JOB_STATE" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C0020479" CHECK ("CRON_EXPRESSION" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C0020480" CHECK ("IS_CONCURRENT" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C0020481" CHECK ("CREATE_TIME" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C007344" CHECK ("ID" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C007345" CHECK ("JOB_NAME" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C007346" CHECK ("JOB_CODE" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C007347" CHECK ("JOB_CLASS" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C007348" CHECK ("JOB_METHOD" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C007349" CHECK ("JOB_STATE" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C007350" CHECK ("CRON_EXPRESSION" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C007351" CHECK ("IS_CONCURRENT" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C007352" CHECK ("CREATE_TIME" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C007611" CHECK ("ID" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C007612" CHECK ("JOB_NAME" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C007613" CHECK ("JOB_CODE" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C007614" CHECK ("JOB_CLASS" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C007615" CHECK ("JOB_METHOD" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C007616" CHECK ("JOB_STATE" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C007617" CHECK ("CRON_EXPRESSION" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C007618" CHECK ("IS_CONCURRENT" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C007619" CHECK ("CREATE_TIME" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C007620" CHECK ("ID" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C007621" CHECK ("JOB_NAME" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C007622" CHECK ("JOB_CODE" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C007623" CHECK ("JOB_CLASS" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C007624" CHECK ("JOB_METHOD" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C007625" CHECK ("JOB_STATE" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C007626" CHECK ("CRON_EXPRESSION" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C007627" CHECK ("IS_CONCURRENT" IS NOT NULL) ENABLE ADD CONSTRAINT "SYS_C007628" CHECK ("CREATE_TIME" IS NOT NULL) ENABLE;

-- ----------------------------
--  Comment for table T_BASE_SCHEDULE_JOB
-- ----------------------------
COMMENT ON TABLE "T_BASE_SCHEDULE_JOB" IS '定时任务';



