package com.els.base.schedule.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.schedule.dao.ScheduleJobLogMapper;
import com.els.base.schedule.entity.ScheduleJobLog;
import com.els.base.schedule.entity.ScheduleJobLogExample;
import com.els.base.schedule.service.ScheduleJobLogService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultScheduleJobLogService")
public class ScheduleJobLogServiceImpl implements ScheduleJobLogService {
    @Resource
    protected ScheduleJobLogMapper scheduleJobLogMapper;

    @CacheEvict(value={"scheduleJobLog"}, allEntries=true)
    @Override
    public void addObj(ScheduleJobLog t) {
        this.scheduleJobLogMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"scheduleJobLog"}, allEntries=true)
    @Override
    public void addAll(List<ScheduleJobLog> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item->{
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.scheduleJobLogMapper.insertBatch(list);
    }

    @CacheEvict(value={"scheduleJobLog"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.scheduleJobLogMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"scheduleJobLog"}, allEntries=true)
    @Override
    public void deleteByExample(ScheduleJobLogExample example) {
        Assert.isNotNull(example, "参数不能为空");
        Assert.isNotEmpty(example.getOredCriteria(), "批量删除不能全表删除");
        this.scheduleJobLogMapper.deleteByExample(example);
    }

    @CacheEvict(value={"scheduleJobLog"}, allEntries=true)
    @Override
    public void modifyObj(ScheduleJobLog t) {
        Assert.isNotBlank(t.getId(), "id 为空，无法修改");
        this.scheduleJobLogMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="scheduleJobLog", keyGenerator="redisKeyGenerator")
    @Override
    public ScheduleJobLog queryObjById(String id) {
        return this.scheduleJobLogMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="scheduleJobLog", keyGenerator="redisKeyGenerator")
    @Override
    public List<ScheduleJobLog> queryAllObjByExample(ScheduleJobLogExample example) {
        return this.scheduleJobLogMapper.selectByExample(example);
    }

    @Cacheable(value="scheduleJobLog", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<ScheduleJobLog> queryObjByPage(ScheduleJobLogExample example) {
        PageView<ScheduleJobLog> pageView = example.getPageView();
        pageView.setQueryResult(this.scheduleJobLogMapper.selectByExampleByPage(example));
        return pageView;
    }
}