package com.els.base.schedule.web.controller;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.schedule.entity.ScheduleJobLog;
import com.els.base.schedule.entity.ScheduleJobLogExample;
import com.els.base.schedule.service.ScheduleJobLogService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="定时任务执行历史")
@Controller
@RequestMapping("scheduleJobLog")
public class ScheduleJobLogController {
    @Resource
    protected ScheduleJobLogService scheduleJobLogService;

    @ApiOperation(httpMethod="POST", value="创建定时任务执行历史")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody ScheduleJobLog scheduleJobLog) {
        this.scheduleJobLogService.addObj(scheduleJobLog);
        return ResponseResult.success(scheduleJobLog.getId());
    }

    @ApiOperation(httpMethod="POST", value="编辑定时任务执行历史")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody ScheduleJobLog scheduleJobLog) {
        Assert.isNotBlank(scheduleJobLog.getId(), "id 为空，保存失败");
        this.scheduleJobLogService.modifyObj(scheduleJobLog);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除定时任务执行历史")
    @RequestMapping("service/deleteByIds")
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, "删除失败,id不能为空");
        ScheduleJobLogExample example = new ScheduleJobLogExample();
        example.createCriteria().andIdIn(ids);
        this.scheduleJobLogService.deleteByExample(example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询定时任务执行历史")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 ScheduleJobLog", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<ScheduleJobLog>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        ScheduleJobLogExample example = new ScheduleJobLogExample();
        example.setPageView(new PageView<ScheduleJobLog>(pageNo, pageSize));
        
        ScheduleJobLogExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<ScheduleJobLog> pageData = this.scheduleJobLogService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}