-- ----------------------------
-- 模板中心
-- ----------------------------
-- DROP TABLE "T_TEMPLATE_CENTER";
CREATE TABLE "T_TEMPLATE_CENTER"
(
    "ID"                   VARCHAR2(32 BYTE) NOT NULL,
    "TEMPLATE_NO"          VARCHAR2(32 BYTE),
    "TEMPLATE_NAME"        VARCHAR2(255 BYTE),
    "TEMPLATE_LANGUAGE"    VARCHAR2(255 BYTE),
    "TEMPLATE_DESCRIPTION" VARCHAR2(255 BYTE),
    "IS_VALID"             NUMBER(11),
    "VERSION"              VARCHAR2(255 BYTE),
    "TEMPLATE_TYPE"        VARCHAR2(255 BYTE),
    "EFFECTIVE_DATE"       DATE,
    "EXPRIATION_DATE"      DATE,
    "CREATE_USER_NAME"     VARCHAR2(255 BYTE),
    "CREATE_TIME"          DATE,
    "UPDATE_USER_NAME"     VARCHAR2(255 BYTE),
    "UPDATE_TIME"          DATE,
    "REMARK"               VARCHAR2(255 BYTE),
    "IS_ENABLE"            NUMBER(11),
    "FILE_TYPE"            VARCHAR2(255 BYTE),
    "TEMPLATE_CONTENT"     CLOB,
    "ATTACHMENT"           CLOB,
    "HTML_CONTENT"         CLOB,
    "CREATE_USER_ID"       VARCHAR2(32 BYTE),
    "UPDATE_USER_ID"       VARCHAR2(32 BYTE)
);

COMMENT ON COLUMN "T_TEMPLATE_CENTER"."ID" IS 'ID';
COMMENT ON COLUMN "T_TEMPLATE_CENTER"."TEMPLATE_NO" IS '模板编号';
COMMENT ON COLUMN "T_TEMPLATE_CENTER"."TEMPLATE_NAME" IS '模板名称';
COMMENT ON COLUMN "T_TEMPLATE_CENTER"."TEMPLATE_LANGUAGE" IS '模板语言';
COMMENT ON COLUMN "T_TEMPLATE_CENTER"."TEMPLATE_DESCRIPTION" IS '模板描述';
COMMENT ON COLUMN "T_TEMPLATE_CENTER"."IS_VALID" IS '是否启用（有效=1，无效=0）';
COMMENT ON COLUMN "T_TEMPLATE_CENTER"."VERSION" IS '版本，可以找回历史版本';
COMMENT ON COLUMN "T_TEMPLATE_CENTER"."TEMPLATE_TYPE" IS '模板类型';
COMMENT ON COLUMN "T_TEMPLATE_CENTER"."EFFECTIVE_DATE" IS '生效日期';
COMMENT ON COLUMN "T_TEMPLATE_CENTER"."EXPRIATION_DATE" IS '失效日期';
COMMENT ON COLUMN "T_TEMPLATE_CENTER"."CREATE_USER_NAME" IS '创建人';
COMMENT ON COLUMN "T_TEMPLATE_CENTER"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_TEMPLATE_CENTER"."UPDATE_USER_NAME" IS '更新人';
COMMENT ON COLUMN "T_TEMPLATE_CENTER"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_TEMPLATE_CENTER"."REMARK" IS '备注';
COMMENT ON COLUMN "T_TEMPLATE_CENTER"."IS_ENABLE" IS '软删除（可用=1，不可用=0）';
COMMENT ON COLUMN "T_TEMPLATE_CENTER"."FILE_TYPE" IS '文件类型';
COMMENT ON COLUMN "T_TEMPLATE_CENTER"."TEMPLATE_CONTENT" IS '模板语言内容';
COMMENT ON COLUMN "T_TEMPLATE_CENTER"."ATTACHMENT" IS '模板附件';
COMMENT ON COLUMN "T_TEMPLATE_CENTER"."HTML_CONTENT" IS 'html模板静态内容';
COMMENT ON COLUMN "T_TEMPLATE_CENTER"."CREATE_USER_ID" IS '创建用户ID';
COMMENT ON COLUMN "T_TEMPLATE_CENTER"."UPDATE_USER_ID" IS '更新用户ID';
COMMENT ON TABLE "T_TEMPLATE_CENTER" IS '模板中心';

ALTER TABLE "T_TEMPLATE_CENTER"  ADD PRIMARY KEY ("ID");
