package com.els.base.userprofile.service.impl;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.userprofile.dao.ProfileOptionMapper;
import com.els.base.userprofile.entity.ProfileOption;
import com.els.base.userprofile.entity.ProfileOptionExample;
import com.els.base.userprofile.service.ProfileOptionService;

@Service("defaultProfileOptionService")
public class ProfileOptionServiceImpl implements ProfileOptionService {
    @Resource
    protected ProfileOptionMapper profileOptionMapper;

    @CacheEvict(value={"profileOption"}, allEntries=true)
    @Override
    public void addObj(ProfileOption t) {
        this.profileOptionMapper.insertSelective(t);
    }

    @CacheEvict(value={"profileOption"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.profileOptionMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"profileOption"}, allEntries=true)
    @Override
    public void modifyObj(ProfileOption t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.profileOptionMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="profileOption", keyGenerator="redisKeyGenerator")
    @Override
    public ProfileOption queryObjById(String id) {
        return this.profileOptionMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="profileOption", key="'ProfileOptionService_' + #root.methodName + '_'+ T(com.els.base.utils.encryption.Md5Utils).md5Object(#example)")
    @Override
    public List<ProfileOption> queryAllObjByExample(ProfileOptionExample example) {
        return this.profileOptionMapper.selectByExample(example);
    }

    @Cacheable(value="profileOption", key="'ProfileOptionService_' + #root.methodName + '_'+ T(com.els.base.utils.encryption.Md5Utils).md5Object(#example)")
    @Override
    public PageView<ProfileOption> queryObjByPage(ProfileOptionExample example) {
        PageView<ProfileOption> pageView = example.getPageView();
        pageView.setQueryResult(this.profileOptionMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"profileOption"}, allEntries=true)
	@Override
	public void deleteByExample(ProfileOptionExample example) {
    	Assert.isNotNull(example, "参数不能为空");
       	Assert.isNotEmpty(example.getOredCriteria(), "批量删除不能全表删除");
       	
       	this.profileOptionMapper.deleteByExample(example);
	}

    @CacheEvict(value={"profileOption"}, allEntries=true)
    @Transactional
	@Override
	public void addAll(List<ProfileOption> list) {
    	if (CollectionUtils.isEmpty(list)) {
   			return;
   		}
   		
   		list.forEach(record ->{
   			this.profileOptionMapper.insertSelective(record);		
   		});
	}
}