package com.els.base.userprofile.service.impl;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.userprofile.dao.UserColumnDefinedMapper;
import com.els.base.userprofile.entity.UserColumnDefined;
import com.els.base.userprofile.entity.UserColumnDefinedExample;
import com.els.base.userprofile.service.UserColumnDefinedService;

@Service("defaultUserColumnDefinedService")
public class UserColumnDefinedServiceImpl implements UserColumnDefinedService {
    @Resource
    protected UserColumnDefinedMapper userColumnDefinedMapper;

    @CacheEvict(value={"userColumnDefined"}, allEntries=true)
    @Override
    public void addObj(UserColumnDefined t) {
        this.userColumnDefinedMapper.insertSelective(t);
    }

    @CacheEvict(value={"userColumnDefined"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.userColumnDefinedMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"userColumnDefined"}, allEntries=true)
    @Override
    public void modifyObj(UserColumnDefined t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.userColumnDefinedMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="userColumnDefined", keyGenerator="redisKeyGenerator")
    @Override
    public UserColumnDefined queryObjById(String id) {
        return this.userColumnDefinedMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="userColumnDefined", keyGenerator="redisKeyGenerator")
    @Override
    public UserColumnDefined queryObjByUserModelCode(String userId, String modelCode) {
    	UserColumnDefinedExample example = new UserColumnDefinedExample();
    	example.setOrderByClause("CREATE_TIME DESC");
    	
    	example.createCriteria().andUserIdEqualTo(userId).andModelCodeEqualTo(modelCode);
    	List<UserColumnDefined> list = this.userColumnDefinedMapper.selectByExampleWithBLOBs(example);
    	if (CollectionUtils.isEmpty(list)) {
			return null;
		}
    	
    	return list.get(0);
    }
    
    @Cacheable(value="userColumnDefined", keyGenerator="redisKeyGenerator")
    @Override
    public List<UserColumnDefined> queryAllObjByExample(UserColumnDefinedExample example) {
        return this.userColumnDefinedMapper.selectByExample(example);
    }

    @Cacheable(value="userColumnDefined", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<UserColumnDefined> queryObjByPage(UserColumnDefinedExample example) {
        PageView<UserColumnDefined> pageView = example.getPageView();
        pageView.setQueryResult(this.userColumnDefinedMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"userColumnDefined"}, allEntries=true)
	@Override
	public void deleteByExample(UserColumnDefinedExample example) {
		Assert.isNotNull(example, "参数不能为空");
       	Assert.isNotEmpty(example.getOredCriteria(), "批量删除不能全表删除");
       	
       	this.userColumnDefinedMapper.deleteByExample(example);
	}

    @CacheEvict(value={"userColumnDefined"}, allEntries=true)
    @Transactional
	@Override
	public void addAll(List<UserColumnDefined> list) {
    	if (CollectionUtils.isEmpty(list)) {
   			return;
   		}
   		
   		list.forEach(record ->{
   			this.userColumnDefinedMapper.insertSelective(record);		
   		});
	}
}