//package com.els.base.userprofile.web.controller;
//
//import com.els.base.core.entity.PageView;
//import com.els.base.core.entity.ResponseResult;
//import com.els.base.core.exception.CommonException;
//import com.els.base.core.utils.CriteriaUtils;
//import com.els.base.core.utils.query.QueryParamWapper;
//import com.els.base.userprofile.entity.ProfileOption;
//import com.els.base.userprofile.entity.ProfileOptionExample;
//import com.els.base.userprofile.service.ProfileOptionService;
//
//import io.swagger.annotations.Api;
//import io.swagger.annotations.ApiImplicitParam;
//import io.swagger.annotations.ApiImplicitParams;
//import io.swagger.annotations.ApiOperation;
//import javax.annotation.Resource;
//import org.apache.commons.lang.StringUtils;
//import org.springframework.stereotype.Controller;
//import org.springframework.web.bind.annotation.RequestBody;
//import org.springframework.web.bind.annotation.RequestMapping;
//import org.springframework.web.bind.annotation.RequestParam;
//import org.springframework.web.bind.annotation.ResponseBody;
//
//@Api(value = "T_BASE_PROFILE_OPTION")
//@Controller
//@RequestMapping("profileOption")
//public class ProfileOptionController {
//	@Resource
//	protected ProfileOptionService profileOptionService;
//
//	@ApiOperation(httpMethod = "POST", value = "创建T_BASE_PROFILE_OPTION")
//	@RequestMapping("service/create")
//	@ResponseBody
//	public ResponseResult<String> create(@RequestBody ProfileOption profileOption) {
//		this.profileOptionService.addObj(profileOption);
//		return ResponseResult.success();
//	}
//
//	@ApiOperation(httpMethod = "POST", value = "编辑T_BASE_PROFILE_OPTION")
//	@RequestMapping("service/edit")
//	@ResponseBody
//	public ResponseResult<String> edit(@RequestBody ProfileOption profileOption) {
//		if (StringUtils.isBlank(profileOption.getId())) {
//			throw new CommonException("id 为空，保存失败");
//		}
//		this.profileOptionService.modifyObj(profileOption);
//		return ResponseResult.success();
//	}
//
//	@ApiOperation(httpMethod = "POST", value = "删除T_BASE_PROFILE_OPTION")
//	@RequestMapping("service/deleteById")
//	@ResponseBody
//	public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
//		if (StringUtils.isBlank(id)) {
//			throw new CommonException("删除失败,id不能为空");
//		}
//		this.profileOptionService.deleteObjById(id);
//		return ResponseResult.success();
//	}
//
//	@ApiOperation(httpMethod = "POST", value = "查询T_BASE_PROFILE_OPTION")
//	@ApiImplicitParams({
//			@ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
//			@ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
//			@ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 ProfileOption", paramType = "body", dataType = "QueryParamWapper") })
//	@RequestMapping("service/findByPage")
//	@ResponseBody
//	public ResponseResult<PageView<ProfileOption>> findByPage(@RequestParam(defaultValue = "0") int pageNo,
//			@RequestParam(defaultValue = "10") int pageSize, @RequestBody(required = false) QueryParamWapper wapper) {
//		ProfileOptionExample example = new ProfileOptionExample();
//		example.setPageView(new PageView<ProfileOption>(pageNo, pageSize));
//
//		if (wapper != null) {
//			ProfileOptionExample.Criteria criteria = example.createCriteria();
//			CriteriaUtils.addCriterion(criteria, wapper);
//		}
//
//		PageView<ProfileOption> pageData = this.profileOptionService.queryObjByPage(example);
//		return ResponseResult.success(pageData);
//	}
//}