package com.els.base.userprofile.web.controller;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.userprofile.entity.UserColumnDefined;
import com.els.base.userprofile.entity.UserColumnDefinedExample;
import com.els.base.userprofile.service.UserColumnDefinedService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api(value="用户列自定义")
@Controller
@RequestMapping("userColumnDefined") 
public class UserColumnDefinedController {
    @Resource
    protected UserColumnDefinedService userColumnDefinedService;

    @ApiOperation(httpMethod="POST", value="创建自定义")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody UserColumnDefined userColumnDefined) {
    	String userId = SpringSecurityUtils.getLoginUserId();
    	String projectId = ProjectUtils.getProjectId();
    	UserColumnDefinedExample example = new UserColumnDefinedExample();
        UserColumnDefinedExample.Criteria criteria = example.createCriteria();
        criteria.andUserIdEqualTo(userId);
        criteria.andProjectIdEqualTo(projectId);
        criteria.andModelCodeEqualTo(userColumnDefined.getModelCode());
        List<UserColumnDefined> list = this.userColumnDefinedService.queryAllObjByExample(example);
        if(list.size()!=0){  // 已存在该模块的自定义列
        	userColumnDefined.setId(list.get(0).getId());
            this.userColumnDefinedService.modifyObj(userColumnDefined);
        }else{
        	userColumnDefined.setUserId(userId);
        	userColumnDefined.setProjectId(projectId);
            this.userColumnDefinedService.addObj(userColumnDefined);
        }
        return ResponseResult.success();
    } 

    @ApiOperation(httpMethod="GET", value="查询用户下模块的自定义")
    @RequestMapping("service/findByUserIdModelCode")
    @ResponseBody
    public ResponseResult<UserColumnDefined> findByUserIdModelCode(@ApiParam(value="模块编码") @RequestParam(required=true) String modelCode) {
    	String userId = SpringSecurityUtils.getLoginUserId();
        if (StringUtils.isBlank(modelCode)) {
            throw new CommonException("模块为空","isNull","用户下模块");
        }
        UserColumnDefined userColumnDefined = this.userColumnDefinedService.queryObjByUserModelCode(userId,modelCode);
        return ResponseResult.success(userColumnDefined);
    }
    
    @ApiOperation(httpMethod="POST", value="编辑自定义")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody UserColumnDefined userColumnDefined) {
        if (StringUtils.isBlank(userColumnDefined.getId())) {
            throw new CommonException("id 为空，保存失败","id_is_blank");
        }
    	String userId = SpringSecurityUtils.getLoginUserId();
    	userColumnDefined.setUserId(userId);
        this.userColumnDefinedService.modifyObj(userColumnDefined);
        return ResponseResult.success();  
    }

    @ApiOperation(httpMethod="GET", value="删除自定义")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank(id)) {
            throw new CommonException("删除失败,id不能为空","id_is_blank");
        }
        this.userColumnDefinedService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询自定义列表")
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<UserColumnDefined>> findByPage(@ApiParam(value="所在页",defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="每页数量",defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="查询条件,属性名请参考 UserColumnDefined") @RequestBody(required=false) QueryParamWapper wapper) {
        UserColumnDefinedExample example = new UserColumnDefinedExample();
        example.setPageView(new PageView<UserColumnDefined>(pageNo, pageSize));
        
        if (wapper != null) {
            UserColumnDefinedExample.Criteria criteria = example.createCriteria();
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        
        PageView<UserColumnDefined> pageData = this.userColumnDefinedService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}