/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.userprofile.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.userprofile.dao.DefaultProfileMapper;
import com.els.base.userprofile.dao.ProfileOptionMapper;
import com.els.base.userprofile.entity.DefaultProfile;
import com.els.base.userprofile.entity.DefaultProfileExample;
import com.els.base.userprofile.entity.ProfileOption;
import com.els.base.userprofile.entity.ProfileOptionExample;
import com.els.base.userprofile.service.DefaultProfileService;
import com.els.base.userprofile.web.controller.vo.ProfileVO;
import com.els.base.utils.json.JsonUtils;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service(value="defaultDefaultProfileService")
public class DefaultProfileServiceImpl
implements DefaultProfileService {
    private static Logger logger = LoggerFactory.getLogger(DefaultProfileServiceImpl.class);
    @Resource
    protected DefaultProfileMapper defaultProfileMapper;
    @Resource
    protected ProfileOptionMapper profileOptionMapper;

    @CacheEvict(value={"defaultProfile"}, allEntries=true)
    public void addObj(DefaultProfile t) {
        this.defaultProfileMapper.insertSelective(t);
    }

    @CacheEvict(value={"defaultProfile"}, allEntries=true)
    public void deleteObjById(String id) {
        this.defaultProfileMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"defaultProfile"}, allEntries=true)
    public void modifyObj(DefaultProfile t) {
        if (org.apache.commons.lang.StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.defaultProfileMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"defaultProfile"}, keyGenerator="redisKeyGenerator")
    public DefaultProfile queryObjById(String id) {
        return this.defaultProfileMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"defaultProfile"}, key="'DefaultProfileService_' + #root.methodName + '_'+ T(com.els.base.utils.encryption.Md5Utils).md5Object(#example)")
    public List<DefaultProfile> queryAllObjByExample(DefaultProfileExample example) {
        return this.defaultProfileMapper.selectByExample(example);
    }

    @Cacheable(value={"defaultProfile"}, key="'DefaultProfileService_' + #root.methodName + '_'+ T(com.els.base.utils.encryption.Md5Utils).md5Object(#example)")
    public PageView<DefaultProfile> queryObjByPage(DefaultProfileExample example) {
        PageView<DefaultProfile> pageView = example.getPageView();
        pageView.setQueryResult(this.defaultProfileMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"defaultProfile"}, allEntries=true)
    public void insertObj(ProfileVO profileVO) {
        DefaultProfile defaultProfile = this.commonModify(profileVO);
        this.defaultProfileMapper.insertSelective(defaultProfile);
        String profileId = defaultProfile.getId();
        Map<String, String> options = profileVO.getOptions();
        for (Map.Entry<String, String> entry : options.entrySet()) {
            ProfileOption profileOption = new ProfileOption();
            profileOption.setId(UUID.randomUUID().toString().replaceAll("-", ""));
            profileOption.setProfileId(profileId);
            profileOption.setName(entry.getKey());
            profileOption.setVal(entry.getValue());
            this.profileOptionMapper.insert(profileOption);
        }
    }

    private DefaultProfile commonModify(ProfileVO profileVO) {
        String defaultValue;
        if (profileVO == null) {
            throw new CommonException("\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        if (StringUtils.isEmpty((Object)profileVO.getCode())) {
            throw new CommonException("\u8bbe\u7f6e\u9879CODE\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)profileVO.getName())) {
            throw new CommonException("\u8bbe\u7f6e\u9879\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (profileVO.getDefaultValue() == null) {
            throw new CommonException("\u9ed8\u8ba4\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (profileVO.getOptions() == null) {
            throw new CommonException("\u8bbe\u7f6e\u9879\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DefaultProfile defaultProfile = new DefaultProfile();
        defaultProfile.setName(profileVO.getName());
        defaultProfile.setProfileType(profileVO.getProfileType());
        try {
            defaultValue = JsonUtils.writeValueAsString(profileVO.getDefaultValue());
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            logger.error("{}", (Throwable)e);
            throw new CommonException("\u9ed8\u8ba4\u503c\u8f6c\u6362\u4e3aJSON\u51fa\u9519");
        }
        defaultProfile.setDefaultValue(defaultValue);
        return defaultProfile;
    }

    @Override
    public void updateObj(ProfileVO profileVO) {
        if (StringUtils.isEmpty((Object)profileVO.getId())) {
            throw new CommonException("\u8bbe\u7f6e\u9879ID\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DefaultProfile defaultProfile = this.commonModify(profileVO);
        DefaultProfileExample example = new DefaultProfileExample();
        DefaultProfileExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(profileVO.getId());
        this.defaultProfileMapper.updateByExample(defaultProfile, example);
        String profileId = defaultProfile.getId();
        ProfileOptionExample optionExample = new ProfileOptionExample();
        ProfileOptionExample.Criteria optionCriteria = optionExample.createCriteria();
        optionCriteria.andProfileIdEqualTo(profileId);
        this.profileOptionMapper.deleteByExample(optionExample);
        Map<String, String> options = profileVO.getOptions();
        for (Map.Entry<String, String> entry : options.entrySet()) {
            ProfileOption profileOption = new ProfileOption();
            profileOption.setId(UUID.randomUUID().toString().replaceAll("-", ""));
            profileOption.setProfileId(profileId);
            profileOption.setName(entry.getKey());
            profileOption.setVal(entry.getValue());
            this.profileOptionMapper.insert(profileOption);
        }
    }

    @Override
    public List<ProfileVO> listAll(String code) {
        List<DefaultProfile> profiles;
        ArrayList<ProfileVO> list = new ArrayList<ProfileVO>();
        if (code == null) {
            profiles = this.defaultProfileMapper.selectByExample(null);
        } else {
            DefaultProfileExample example = new DefaultProfileExample();
            DefaultProfileExample.Criteria criteria = example.createCriteria();
            criteria.andCodeEqualTo(code);
            profiles = this.defaultProfileMapper.selectByExample(example);
        }
        if (profiles == null || profiles.isEmpty()) {
            return list;
        }
        for (DefaultProfile profile : profiles) {
            ProfileVO profileVO = new ProfileVO();
            String profileId = profile.getId();
            profileVO.setId(profileId);
            profileVO.setName(profile.getName());
            profileVO.setProfileType(profile.getProfileType());
            profileVO.setCode(profile.getCode());
            profileVO.setSort(profile.getSort());
            String defaultValue = profile.getDefaultValue();
            ObjectMapper mapper = new ObjectMapper();
            TypeReference<Map<String, Set<String>>> typeRef = new TypeReference<Map<String, Set<String>>>(){};
            HashMap<String, Set<String>> defaultValueMap = new HashMap();
            try {
                defaultValueMap = (Map)mapper.readValue(defaultValue, (TypeReference)typeRef);
            }
            catch (JsonParseException e) {
                e.printStackTrace();
                logger.error("{}", (Throwable)e);
            }
            catch (JsonMappingException e) {
                e.printStackTrace();
                logger.error("{}", (Throwable)e);
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("{}", (Throwable)e);
            }
            profileVO.setDefaultValue(defaultValueMap);
            ProfileOptionExample example = new ProfileOptionExample();
            ProfileOptionExample.Criteria criteria = example.createCriteria();
            criteria.andProfileIdEqualTo(profileId);
            List<ProfileOption> profileOptions = this.profileOptionMapper.selectByExample(example);
            if (profileOptions != null) {
                TreeMap<String, String> options = new TreeMap<String, String>();
                for (ProfileOption profileOption : profileOptions) {
                    options.put(profileOption.getName(), profileOption.getVal());
                }
                profileVO.setOptions(options);
            }
            list.add(profileVO);
        }
        return list;
    }

    @CacheEvict(value={"defaultProfile"}, allEntries=true)
    public void deleteByExample(DefaultProfileExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.defaultProfileMapper.deleteByExample(example);
    }

    @CacheEvict(value={"defaultProfile"}, allEntries=true)
    @Transactional
    public void addAll(List<DefaultProfile> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.defaultProfileMapper.insertSelective((DefaultProfile)record));
    }
}

