/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.userprofile.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.userprofile.dao.UserColumnDefinedMapper;
import com.els.base.userprofile.entity.UserColumnDefined;
import com.els.base.userprofile.entity.UserColumnDefinedExample;
import com.els.base.userprofile.service.UserColumnDefinedService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultUserColumnDefinedService")
public class UserColumnDefinedServiceImpl
implements UserColumnDefinedService {
    @Resource
    protected UserColumnDefinedMapper userColumnDefinedMapper;

    @CacheEvict(value={"userColumnDefined"}, allEntries=true)
    public void addObj(UserColumnDefined t) {
        this.userColumnDefinedMapper.insertSelective(t);
    }

    @CacheEvict(value={"userColumnDefined"}, allEntries=true)
    public void deleteObjById(String id) {
        this.userColumnDefinedMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"userColumnDefined"}, allEntries=true)
    public void modifyObj(UserColumnDefined t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.userColumnDefinedMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"userColumnDefined"}, keyGenerator="redisKeyGenerator")
    public UserColumnDefined queryObjById(String id) {
        return this.userColumnDefinedMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"userColumnDefined"}, keyGenerator="redisKeyGenerator")
    public UserColumnDefined queryObjByUserModelCode(String userId, String modelCode) {
        UserColumnDefinedExample example = new UserColumnDefinedExample();
        example.setOrderByClause("CREATE_TIME DESC");
        example.createCriteria().andUserIdEqualTo(userId).andModelCodeEqualTo(modelCode);
        List<UserColumnDefined> list = this.userColumnDefinedMapper.selectByExampleWithBLOBs(example);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Cacheable(value={"userColumnDefined"}, keyGenerator="redisKeyGenerator")
    public List<UserColumnDefined> queryAllObjByExample(UserColumnDefinedExample example) {
        return this.userColumnDefinedMapper.selectByExample(example);
    }

    @Cacheable(value={"userColumnDefined"}, keyGenerator="redisKeyGenerator")
    public PageView<UserColumnDefined> queryObjByPage(UserColumnDefinedExample example) {
        PageView<UserColumnDefined> pageView = example.getPageView();
        pageView.setQueryResult(this.userColumnDefinedMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"userColumnDefined"}, allEntries=true)
    public void deleteByExample(UserColumnDefinedExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.userColumnDefinedMapper.deleteByExample(example);
    }

    @CacheEvict(value={"userColumnDefined"}, allEntries=true)
    @Transactional
    public void addAll(List<UserColumnDefined> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.userColumnDefinedMapper.insertSelective((UserColumnDefined)record));
    }
}

