/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.userprofile.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.userprofile.dao.UserProfileMapper;
import com.els.base.userprofile.entity.UserProfile;
import com.els.base.userprofile.entity.UserProfileExample;
import com.els.base.userprofile.service.DefaultProfileService;
import com.els.base.userprofile.service.UserProfileService;
import com.els.base.userprofile.web.controller.vo.ProfileVO;
import com.els.base.userprofile.web.controller.vo.UserProfileVO;
import com.els.base.utils.json.JsonUtils;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultUserProfileService")
public class UserProfileServiceImpl
implements UserProfileService {
    private static Logger logger = LoggerFactory.getLogger(UserProfileServiceImpl.class);
    @Resource
    protected UserProfileMapper userProfileMapper;
    @Resource
    protected DefaultProfileService defaultProfileService;

    @CacheEvict(value={"userProfile"}, allEntries=true)
    public void addObj(UserProfile t) {
        this.userProfileMapper.insertSelective(t);
    }

    @CacheEvict(value={"userProfile"}, allEntries=true)
    public void deleteObjById(String id) {
        this.userProfileMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"userProfile"}, allEntries=true)
    public void modifyObj(UserProfile t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.userProfileMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"userProfile"}, keyGenerator="redisKeyGenerator")
    public UserProfile queryObjById(String id) {
        return this.userProfileMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"userProfile"}, key="'UserProfileService_' + #root.methodName + '_'+ T(com.els.base.utils.encryption.Md5Utils).md5Object(#example)")
    public List<UserProfile> queryAllObjByExample(UserProfileExample example) {
        return this.userProfileMapper.selectByExample(example);
    }

    @Cacheable(value={"userProfile"}, key="'UserProfileService_' + #root.methodName + '_'+ T(com.els.base.utils.encryption.Md5Utils).md5Object(#example)")
    public PageView<UserProfile> queryObjByPage(UserProfileExample example) {
        PageView<UserProfile> pageView = example.getPageView();
        pageView.setQueryResult(this.userProfileMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void add(String userId, String platform, List<UserProfileVO> userProfiles) {
        if (userProfiles == null) {
            throw new CommonException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UserProfileVO userProfileVO : userProfiles) {
            String profileId = userProfileVO.getProfileId();
            Set<String> values = userProfileVO.getValues();
            if (profileId == null || "".equals(profileId.trim())) {
                logger.error("profileId is null or empty.");
                continue;
            }
            if (values == null || values.isEmpty()) {
                logger.error("values is null or empty.");
                continue;
            }
            UserProfile userProfile = new UserProfile();
            userProfile.setUserId(userId);
            userProfile.setProfileId(profileId);
            userProfile.setPlatform(platform);
            try {
                String defaultValue = JsonUtils.writeValueAsString(values);
                userProfile.setOptionVal(defaultValue);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
                logger.error("{}", (Throwable)e);
            }
            UserProfileExample example = new UserProfileExample();
            UserProfileExample.Criteria criteria = example.createCriteria();
            criteria.andUserIdEqualTo(userId);
            criteria.andPlatformEqualTo(platform);
            criteria.andProfileIdEqualTo(profileId);
            List<UserProfile> listUserProfiles = this.userProfileMapper.selectByExample(example);
            if (listUserProfiles == null || listUserProfiles.isEmpty()) {
                this.userProfileMapper.insert(userProfile);
                continue;
            }
            userProfile.setId(listUserProfiles.get(0).getId());
            this.userProfileMapper.updateByExample(userProfile, example);
        }
    }

    @Override
    public List<ProfileVO> display(String userId, String code) {
        List<ProfileVO> defaultProfiles = this.defaultProfileService.listAll(code);
        if (defaultProfiles == null) {
            return new ArrayList<ProfileVO>();
        }
        UserProfileExample example = new UserProfileExample();
        UserProfileExample.Criteria criteria = example.createCriteria();
        criteria.andUserIdEqualTo(userId);
        List<UserProfile> userProfiles = this.userProfileMapper.selectByExample(example);
        if (userProfiles == null) {
            return defaultProfiles;
        }
        ObjectMapper mapper = new ObjectMapper();
        TypeReference<Set<String>> typeRef = new TypeReference<Set<String>>(){};
        for (UserProfile userProfile : userProfiles) {
            for (ProfileVO profile : defaultProfiles) {
                if (!userProfile.getProfileId().equals(profile.getId())) continue;
                String platform = userProfile.getPlatform();
                String optionValString = userProfile.getOptionVal();
                Set optionVals = new HashSet();
                try {
                    optionVals = (Set)mapper.readValue(optionValString, (TypeReference)typeRef);
                }
                catch (JsonParseException e) {
                    e.printStackTrace();
                    logger.error("{}", (Throwable)e);
                }
                catch (JsonMappingException e) {
                    e.printStackTrace();
                    logger.error("{}", (Throwable)e);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    logger.error("{}", (Throwable)e);
                }
                Map<String, Set<String>> defaultValue = Collections.singletonMap(platform, optionVals);
                profile.setDefaultValue(defaultValue);
            }
        }
        return defaultProfiles;
    }

    @Override
    public Map<String, Set<String>> queryProfile(String userId, String platform, String code) {
        List<ProfileVO> defaultProfiles = this.display(userId, code);
        HashMap<String, Set<String>> results = new HashMap<String, Set<String>>();
        for (ProfileVO vo : defaultProfiles) {
            Map<String, Set<String>> defaultValue = vo.getDefaultValue();
            if (defaultValue == null || !defaultValue.containsKey(platform)) continue;
            results.put(vo.getCode(), defaultValue.get(platform));
        }
        return results;
    }

    @CacheEvict(value={"userProfile"}, allEntries=true)
    public void deleteByExample(UserProfileExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.userProfileMapper.deleteByExample(example);
    }

    @CacheEvict(value={"userProfile"}, allEntries=true)
    @Transactional
    public void addAll(List<UserProfile> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.userProfileMapper.insertSelective((UserProfile)record));
    }
}

