/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.utils.excel;

import com.els.base.utils.excel.ConverterFactory;
import com.els.base.utils.excel.IContentChecker;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.StrToObjConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.reflect.ReflectUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.write.Label;
import jxl.write.NumberFormats;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.FieldUtils;

public class ExcelUtils {
    public static WritableWorkbook exportDataToExcel(OutputStream os, List<TitleAndModelKey> titleAndModelKeys, List<? extends Object> data, String sheetTitle, String headTitle, int sheetIndex) throws IOException, RowsExceededException, WriteException, ParseException {
        return ExcelUtils.exportDataToExcel(os, titleAndModelKeys, data, sheetTitle, headTitle, sheetIndex, null);
    }

    public static WritableWorkbook exportDataToExcel(OutputStream os, List<TitleAndModelKey> titleAndModelKeys, List<? extends Object> data, String sheetTitle, String headTitle, int sheetIndex, WritableWorkbook writeablebook) throws IOException, RowsExceededException, WriteException, ParseException {
        int i;
        if (CollectionUtils.isEmpty(titleAndModelKeys)) {
            throw new NullPointerException("export setting 'titleAndModelKeys' can not be null");
        }
        if (writeablebook == null) {
            writeablebook = Workbook.createWorkbook((OutputStream)os);
        }
        WritableSheet sheet = writeablebook.createSheet(sheetTitle, sheetIndex);
        int headTitleRowIndex = 0;
        int titleRowIndex = 1;
        WritableCellFormat defaultHeadTitleFormat = new WritableCellFormat(new WritableFont(WritableFont.createFont((String)"\u5fae\u8f6f\u96c5\u9ed1"), 12, WritableFont.BOLD));
        if (StringUtils.isNotBlank((String)headTitle)) {
            defaultHeadTitleFormat.setAlignment(Alignment.CENTRE);
            Label headLabel = new Label(0, headTitleRowIndex, headTitle, (CellFormat)defaultHeadTitleFormat);
            headLabel.setCellFormat((CellFormat)new WritableCellFormat(NumberFormats.TEXT));
            sheet.mergeCells(0, headTitleRowIndex, titleAndModelKeys.size() - 1, headTitleRowIndex);
            sheet.addCell((WritableCell)headLabel);
        } else {
            titleRowIndex = 0;
        }
        for (i = 0; i < titleAndModelKeys.size(); ++i) {
            WritableCellFormat titleFormat = titleAndModelKeys.get(i).getTitleFormat();
            if (titleFormat == null) {
                titleFormat = new WritableCellFormat(new WritableFont(WritableFont.createFont((String)"\u5fae\u8f6f\u96c5\u9ed1"), 12));
                titleFormat.setBackground(Colour.GRAY_25);
                titleFormat.setBorder(Border.ALL, BorderLineStyle.THIN, Colour.BLACK);
            }
            Label label = new Label(i, titleRowIndex, titleAndModelKeys.get(i).getTitle(), (CellFormat)titleFormat);
            sheet.setColumnView(i, 20);
            sheet.addCell((WritableCell)label);
        }
        if (CollectionUtils.isEmpty(data)) {
            return writeablebook;
        }
        for (i = 0; data != null && i < data.size(); ++i) {
            for (int j = 0; j < titleAndModelKeys.size(); ++j) {
                TitleAndModelKey titleAndModelKey = titleAndModelKeys.get(j);
                String key = titleAndModelKey.getModelKey();
                if (StringUtils.isBlank((String)key)) {
                    throw new IllegalArgumentException(MessageFormat.format("\u5bfc\u5165\u7684excel\u53c2\u6570\u5f02\u5e38\uff0ctitleAndModelKeys\u4e2d, title{0}, key{1}", titleAndModelKey.getTitle(), titleAndModelKey.getModelKey()));
                }
                Object value = ReflectUtils.getValue(data.get(i), key);
                String content = null;
                content = value == null ? titleAndModelKey.getDefaultValue() : (titleAndModelKey.getToStrConverter() != null ? titleAndModelKey.getToStrConverter().convert(value, data.get(i), i) : (ConverterFactory.getDefaultToStrConverter(value.getClass()) != null ? ConverterFactory.getDefaultToStrConverter(value.getClass()).convert(value, data.get(i), i) : String.valueOf(value)));
                WritableCellFormat contentFormate = titleAndModelKey.getContentFormat();
                if (contentFormate == null) {
                    contentFormate = new WritableCellFormat(new WritableFont(WritableFont.createFont((String)"\u5fae\u8f6f\u96c5\u9ed1"), 10));
                    contentFormate.setBorder(Border.ALL, BorderLineStyle.THIN, Colour.BLACK);
                }
                int dataRow = i + titleRowIndex + 1;
                Label tmpLabel = new Label(j, dataRow, String.valueOf(content), (CellFormat)contentFormate);
                sheet.addCell((WritableCell)tmpLabel);
                sheet.setRowView(dataRow, true);
            }
        }
        return writeablebook;
    }

    public static <T> List<T> importExcelDataToMap(InputStream in, int sheetIndex, int dataStartRowIndex, int headRowIndex, List<TitleAndModelKey> titleAndModelKeys, Class<T> clazz) throws Exception {
        if (CollectionUtils.isEmpty(titleAndModelKeys)) {
            throw new NullPointerException("export setting 'titleAndModelKeys' can not be null");
        }
        Workbook workbook = Workbook.getWorkbook((InputStream)in);
        Sheet sheet = workbook.getSheet(sheetIndex);
        Cell[] headRow = sheet.getRow(headRowIndex);
        ExcelUtils.checkExcel(titleAndModelKeys, headRow);
        List<List<Cell>> allRows = ExcelUtils.getAllRows(sheet, dataStartRowIndex, headRow.length);
        ArrayList<T> dataList = new ArrayList<T>();
        int rowCount = allRows.size();
        for (int i = 0; sheet != null && i < rowCount; ++i) {
            List<Cell> row = allRows.get(i);
            dataList.add(ExcelUtils.converteRowToObject(sheet, headRow, row, titleAndModelKeys, clazz));
        }
        return dataList;
    }

    private static <T> T converteRowToObject(Sheet sheet, Cell[] headRow, List<Cell> row, List<TitleAndModelKey> titleAndModelKeys, Class<T> clazz) throws Exception {
        T object = clazz.newInstance();
        for (int j = 0; j < titleAndModelKeys.size(); ++j) {
            IContentChecker checker;
            TitleAndModelKey titleAndModelKey = titleAndModelKeys.get(j);
            String title = titleAndModelKey.getTitle();
            Integer index = titleAndModelKey.getColumIndex();
            String key = titleAndModelKey.getModelKey();
            String content = row.get(index).getContents();
            if (StringUtils.isBlank((String)content)) {
                if (titleAndModelKey.isRequired()) {
                    throw new NullPointerException(String.format("[%s] \u4e0d\u80fd\u4e3a\u7a7a\u503c\u3002", title));
                }
                if (StringUtils.isBlank((String)titleAndModelKey.getDefaultValue())) continue;
                content = titleAndModelKey.getDefaultValue();
            }
            if ((checker = titleAndModelKey.getContentChecker()) != null && !checker.vaild(content)) {
                throw new RuntimeException(String.format("\u5bfc\u5165\u5931\u8d25\uff0c\u5217[%s] \u7684\u5185\u5bb9 [%s] \u4e0d\u7b26\u5408\u8981\u6c42", title, content));
            }
            try {
                ReflectUtils.setValue(object, key, ExcelUtils.convertStrToObject(object, sheet, row, titleAndModelKey));
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("\u5bfc\u5165[%s]\u5931\u8d25\uff0c\u539f\u56e0:%s", title, e.getMessage()), e);
            }
        }
        return object;
    }

    private static Object convertStrToObject(Object object, Sheet sheet, List<Cell> row, TitleAndModelKey titleAndModelKey) throws Exception {
        Integer index = titleAndModelKey.getColumIndex();
        String key = titleAndModelKey.getModelKey();
        String content = row.get(index).getContents();
        StrToObjConverter converter = titleAndModelKey.getToObjConverter();
        if (converter != null) {
            return converter.convert(content, row, sheet);
        }
        Class<?> cla = FieldUtils.getField(object.getClass(), (String)key, (boolean)true).getType();
        if (cla.equals(String.class)) {
            return content;
        }
        converter = ConverterFactory.getDefaultToObjConverter(cla);
        if (converter == null) {
            throw new RuntimeException("\u627e\u4e0d\u5230\u5408\u9002\u8f6c\u6362\u5668 class[" + cla + "]");
        }
        return converter.convert(content, row, sheet);
    }

    private static List<List<Cell>> getAllRows(Sheet sheet, int dataStartRowIndex, int length) {
        ArrayList<List<Cell>> allRows = new ArrayList<List<Cell>>();
        boolean isEnd = false;
        int readIndex = dataStartRowIndex;
        while (!isEnd) {
            if (readIndex == sheet.getRows() + dataStartRowIndex - 1) {
                isEnd = true;
                break;
            }
            ArrayList<Cell> row = new ArrayList<Cell>(length);
            for (int i = 0; i < length; ++i) {
                Cell cell = sheet.getCell(i, readIndex);
                row.add(cell);
            }
            boolean isAllBlank = true;
            for (Cell cell : row) {
                if (!StringUtils.isNotBlank((String)cell.getContents())) continue;
                isAllBlank = false;
                break;
            }
            if (!isAllBlank) {
                allRows.add(row);
                ++readIndex;
                continue;
            }
            isEnd = true;
            break;
        }
        return allRows;
    }

    private static Cell[] getFromSheet(Sheet sheet, int startRowIndex, int length) {
        Cell[] cells = new Cell[length];
        for (int i = 0; i < length; ++i) {
            cells[i] = sheet.getCell(i, startRowIndex);
        }
        return cells;
    }

    private static void checkExcel(List<TitleAndModelKey> titleAndModelKeys, Cell[] headRow) {
        for (int j = 0; j < titleAndModelKeys.size(); ++j) {
            String title = titleAndModelKeys.get(j).getTitle();
            Integer titleIndex = titleAndModelKeys.get(j).getColumIndex();
            if (StringUtils.isBlank((String)title) && titleIndex == null) {
                throw new IllegalArgumentException("excel \u5bfc\u5165\u5bfc\u51fa\u7684\u64cd\u4f5c\u4e2d\uff0ctitleAndModelKey\u914d\u7f6e\u5f02\u5e38\uff0c title \u4e0e columIndex \u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            }
            if (titleIndex == null) {
                titleIndex = ExcelUtils.getTitleIndexInRow(headRow, title);
                titleAndModelKeys.get(j).setColumIndex(titleIndex);
            }
            if (titleIndex >= 0) continue;
            throw new IllegalArgumentException("excel\u8868\u683c\u5f0f\u5f02\u5e38\uff0c\u627e\u4e0d\u5230\u5217[" + title + "]");
        }
    }

    public static int getTitleIndexInRow(Cell[] headRow, String title) {
        if (StringUtils.isBlank((String)title)) {
            throw new NullPointerException("title can not be null");
        }
        int index = -1;
        for (int i = 0; i < headRow.length; ++i) {
            String content = headRow[i].getContents();
            if (!StringUtils.equals((String)content.trim(), (String)title.trim())) continue;
            index = i;
            return i;
        }
        return index;
    }

    public static TitleAndModelKey createTitleAndModelKey(String title, String modelKey) {
        return new TitleAndModelKey(title, modelKey);
    }

    public static TitleAndModelKey createTitleAndModelKey(String title, String modelKey, boolean isRequired) {
        TitleAndModelKey t = new TitleAndModelKey(title, modelKey);
        t.setRequired(isRequired);
        return t;
    }

    public static TitleAndModelKey createTitleAndModelKey(int columIndex, String modelKey) {
        return new TitleAndModelKey(columIndex, modelKey);
    }

    public static TitleAndModelKey createTitleAndModelKey(String title, String modelKey, StrToObjConverter toObjConverter) {
        return new TitleAndModelKey(title, modelKey, toObjConverter);
    }

    public static TitleAndModelKey createTitleAndModelKey(String title, String modelKey, ObjToStrConverter toStrConverter) {
        return new TitleAndModelKey(title, modelKey, toStrConverter);
    }
}

