/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.login.controller;

import com.els.base.wechat.account.utils.WxAccountConfigUtils;
import com.els.base.wechat.common.WxMpServiceUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpQrcodeService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.result.WxMpQrCodeTicket;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u5fae\u4fe1\u626b\u63cf\u767b\u5f55"})
@Controller
@RequestMapping(value={"wxLoginQrCode"})
public class WxLoginQrCodeController {
    @ApiOperation(httpMethod="GET", value="\u521b\u5efa\u5fae\u4fe1\u767b\u5f55\u4e8c\u7ef4\u7801")
    @RequestMapping(value={"service/createQrcodeForLogin"})
    @ResponseBody
    public ModelAndView createQrcodeForLogin(String key, HttpServletResponse response) throws WxErrorException, IOException {
        WxMpService wxMpService = WxMpServiceUtils.getWxMpServiceByAccount(WxAccountConfigUtils.getDefaultAccountFromConfig());
        String sceneStr = "LOGIN_" + key;
        WxMpQrcodeService qrcodeService = wxMpService.getQrcodeService();
        WxMpQrCodeTicket ticket = qrcodeService.qrCodeCreateTmpTicket(sceneStr, Integer.valueOf(30));
        File file = qrcodeService.qrCodePicture(ticket);
        response.addHeader("Content-Disposition", "inline;filename=\"" + URLEncoder.encode("loginQrcode.jpg", "UTF-8") + "\";");
        response.setContentType("image/jpg");
        ServletOutputStream outputStream = response.getOutputStream();
        byte[] tmp = new byte[1024];
        FileInputStream inputStream = new FileInputStream(file);
        while (inputStream.read(tmp) != -1) {
            outputStream.write(tmp);
        }
        outputStream.flush();
        outputStream.close();
        inputStream.close();
        return null;
    }
}

