/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.msg.web.controller;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.wechat.msg.entity.WxMsgRule;
import com.els.base.wechat.msg.entity.WxMsgRuleExample;
import com.els.base.wechat.msg.service.WxMsgRuleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u5fae\u4fe1-\u516c\u4f17\u53f7\u540e\u53f0\u6d88\u606f\u89c4\u5219"})
@Controller
@RequestMapping(value={"wechatMsgRule"})
public class WechatMsgRuleController {
    @Resource
    protected WxMsgRuleService wxMsgRuleService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u5fae\u4fe1\u6d88\u606f\u89c4\u5219")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody WxMsgRule wxMsgRule) {
        this.wxMsgRuleService.addObj(wxMsgRule);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u5fae\u4fe1\u6d88\u606f\u89c4\u5219")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody WxMsgRule wxMsgRule) {
        if (StringUtils.isBlank((String)wxMsgRule.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        this.wxMsgRuleService.modifyObj(wxMsgRule);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u5fae\u4fe1\u6d88\u606f\u89c4\u5219")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(String id) {
        this.wxMsgRuleService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u5fae\u4fe1\u6d88\u606f\u89c4\u5219")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<WxMsgRule>> findByPage(@ApiParam(name="\u5206\u9875\u7d22\u5f15", defaultValue="0") @RequestParam(defaultValue="1") int pageNo, @ApiParam(name="\u6bcf\u9875\u7684\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(name="\u67e5\u8be2\u6761\u4ef6") String sSearch, @ApiParam(name="\u516c\u4f17\u53f7\u539f\u59cbid") String originId) {
        PageView pageView = new PageView(pageNo, pageSize);
        WxMsgRuleExample example = new WxMsgRuleExample();
        example.setPageView((PageView<WxMsgRule>)pageView);
        example.createCriteria().andWxAccountOriginIdEqualTo(originId);
        if (StringUtils.isNotBlank((String)sSearch)) {
            // empty if block
        }
        example.setOrderByClause("priority DESC");
        return ResponseResult.success((Object)this.wxMsgRuleService.queryObjByPage((IExample)example));
    }

    @ApiOperation(httpMethod="GET", value="\u542f\u7528\u6216\u7981\u7528\u6d88\u606f\u89c4\u5219")
    @RequestMapping(value={"service/setIsEnableById"})
    @ResponseBody
    public ResponseResult<String> setIsEnableById(String id, int isEnable) {
        WxMsgRule tmp = (WxMsgRule)this.wxMsgRuleService.queryObjById(id);
        tmp.setId(id);
        if (Constant.YES_INT.equals(isEnable)) {
            tmp.setIsEnable(Constant.YES_INT);
        } else {
            tmp.setIsEnable(Constant.NO_INT);
        }
        this.wxMsgRuleService.modifyObj(tmp);
        return ResponseResult.success();
    }
}

