-- ----------------------------
-- 微信配置
-- ----------------------------
-- DROP TABLE "T_WX_ACCOUNT_CONFIG";
CREATE TABLE "T_WX_ACCOUNT_CONFIG"
(
    "ID"               VARCHAR2(32 BYTE) NOT NULL,
    "NAME"             VARCHAR2(100 CHAR),
    "ACCOUNT_TYPE"     NUMBER(2),
    "CODE"             VARCHAR2(100 CHAR),
    "ORIGIN_ID"        VARCHAR2(100 CHAR),
    "APP_ID"           VARCHAR2(100 CHAR),
    "APP_SECRET"       VARCHAR2(255 CHAR),
    "TOKEN"            VARCHAR2(100 CHAR),
    "AES_KEY"          VARCHAR2(43 CHAR),
    "ENCRYPT_TYPE"     NUMBER(2),
    "IS_PAY_ENABLE"    NUMBER(2),
    "MCH_ID"           VARCHAR2(100 CHAR),
    "MCH_KEY"          VARCHAR2(255 CHAR),
    "DOMAIN"           VARCHAR2(255 CHAR),
    "WXPAY_NOTIFY_URL" VARCHAR2(255 CHAR),
    "CERT_PATH"        VARCHAR2(255 CHAR)
);

COMMENT ON COLUMN "T_WX_ACCOUNT_CONFIG"."NAME" IS '公众号 名字';
COMMENT ON COLUMN "T_WX_ACCOUNT_CONFIG"."ACCOUNT_TYPE" IS '公众号类型，1服务号，2订阅号，3企业号';
COMMENT ON COLUMN "T_WX_ACCOUNT_CONFIG"."CODE" IS '微信号';
COMMENT ON COLUMN "T_WX_ACCOUNT_CONFIG"."ORIGIN_ID" IS '公众号 原始id';
COMMENT ON COLUMN "T_WX_ACCOUNT_CONFIG"."ENCRYPT_TYPE" IS '加密模式，1明文模式，2兼容模式，3安全模式';
COMMENT ON COLUMN "T_WX_ACCOUNT_CONFIG"."IS_PAY_ENABLE" IS '是否支持微信支付，1支持，0不支持';
COMMENT ON COLUMN "T_WX_ACCOUNT_CONFIG"."MCH_ID" IS '微信支付，商户id';
COMMENT ON COLUMN "T_WX_ACCOUNT_CONFIG"."MCH_KEY" IS '微信支付,商户key';
COMMENT ON COLUMN "T_WX_ACCOUNT_CONFIG"."DOMAIN" IS '公众号服务器域名';
COMMENT ON COLUMN "T_WX_ACCOUNT_CONFIG"."WXPAY_NOTIFY_URL" IS '微信支付后的回调url，不带servername，path，默认wechatPay/notifyUrl';
COMMENT ON COLUMN "T_WX_ACCOUNT_CONFIG"."CERT_PATH" IS '商户证书的存储路径';
COMMENT ON TABLE "T_WX_ACCOUNT_CONFIG" IS '微信配置';

ALTER TABLE "T_WX_ACCOUNT_CONFIG"
    ADD PRIMARY KEY ("ID");



-- ----------------------------
-- 微信会员
-- ----------------------------
-- DROP TABLE "T_WX_MEMBER";
CREATE TABLE "T_WX_MEMBER"
(
    "ID"                      VARCHAR2(32 BYTE) NOT NULL,
    "MEMBER_ID"               VARCHAR2(32 BYTE),
    "WX_OPENID"               VARCHAR2(255 CHAR),
    "WX_NICKNAME"             NVARCHAR2(255),
    "WX_SEX"                  NUMBER(2),
    "WX_CITY"                 VARCHAR2(255 CHAR),
    "WX_COUNTRY"              VARCHAR2(255 CHAR),
    "WX_PROVINCE"             VARCHAR2(255 CHAR),
    "WX_LANGUAGE"             VARCHAR2(255 CHAR),
    "WX_HEADIMGURL"           VARCHAR2(255 CHAR),
    "WX_SUBSCRIBE"            NUMBER(5),
    "WX_SUBSCRIBE_TIME"       DATE,
    "WX_UNIONID"              VARCHAR2(255 CHAR),
    "WX_REMARK"               VARCHAR2(255 CHAR),
    "WX_GROUPID"              NUMBER(5),
    "WX_FIRST_SUBSCRIBE_TIME" DATE,
    "WX_SUBSCRIBE_KEY"        VARCHAR2(255 CHAR),
    "WX_ACCOUNT_ORIGIN_ID"    VARCHAR2(255 CHAR),
    "CREATE_TIME"             DATE
);

COMMENT ON COLUMN "T_WX_MEMBER"."ID" IS 'id';
COMMENT ON COLUMN "T_WX_MEMBER"."MEMBER_ID" IS '关联的会员id';
COMMENT ON COLUMN "T_WX_MEMBER"."WX_OPENID" IS 'open_id';
COMMENT ON COLUMN "T_WX_MEMBER"."WX_NICKNAME" IS '称昵';
COMMENT ON COLUMN "T_WX_MEMBER"."WX_SEX" IS '用户的性别，值为1时是男性，值为2时是女性，值为0时是未知';
COMMENT ON COLUMN "T_WX_MEMBER"."WX_CITY" IS '用户所在城市';
COMMENT ON COLUMN "T_WX_MEMBER"."WX_COUNTRY" IS '用户所在国家';
COMMENT ON COLUMN "T_WX_MEMBER"."WX_PROVINCE" IS '用户所在省份';
COMMENT ON COLUMN "T_WX_MEMBER"."WX_LANGUAGE" IS '用户的语言，简体中文为zh_CN';
COMMENT ON COLUMN "T_WX_MEMBER"."WX_HEADIMGURL" IS '用户头像';
COMMENT ON COLUMN "T_WX_MEMBER"."WX_SUBSCRIBE" IS '是否关注公众号，1已关注，0未关注';
COMMENT ON COLUMN "T_WX_MEMBER"."WX_SUBSCRIBE_TIME" IS '用户关注时间';
COMMENT ON COLUMN "T_WX_MEMBER"."WX_UNIONID" IS '管理多个公众号时，作为唯一吗';
COMMENT ON COLUMN "T_WX_MEMBER"."WX_REMARK" IS '公众号运营者对粉丝的备注';
COMMENT ON COLUMN "T_WX_MEMBER"."WX_GROUPID" IS '用户所在的分组ID';
COMMENT ON COLUMN "T_WX_MEMBER"."WX_FIRST_SUBSCRIBE_TIME" IS '第一次关注的时间';
COMMENT ON COLUMN "T_WX_MEMBER"."WX_SUBSCRIBE_KEY" IS '第一次关注的key';
COMMENT ON COLUMN "T_WX_MEMBER"."CREATE_TIME" IS '创建时间';

COMMENT ON TABLE "T_WX_MEMBER" IS '微信会员';

ALTER TABLE "T_WX_MEMBER"
    ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 微信自动回复
-- ----------------------------
-- DROP TABLE "T_WX_MSG_AUTO_REPLY";
CREATE TABLE "T_WX_MSG_AUTO_REPLY"
(
    "ID"                   NUMBER(11) NOT NULL,
    "WX_ACCOUNT_ORIGIN_ID" VARCHAR2(255 CHAR),
    "KEYWORDS"             VARCHAR2(255 CHAR),
    "REPLY_TYPE"           NUMBER(11),
    "REPLY_CONTENT"        VARCHAR2(255 CHAR),
    "MATCH_TYPE"           VARCHAR2(255 CHAR),
    "PRIORITY"             NUMBER(11),
    "IS_DEFAULT"           NUMBER(11),
    "CREATE_TIME"          DATE
);

COMMENT ON COLUMN "T_WX_MSG_AUTO_REPLY"."ID" IS '主键';
COMMENT ON COLUMN "T_WX_MSG_AUTO_REPLY"."WX_ACCOUNT_ORIGIN_ID" IS '微信公众号原始id';
COMMENT ON COLUMN "T_WX_MSG_AUTO_REPLY"."KEYWORDS" IS '关键字';
COMMENT ON COLUMN "T_WX_MSG_AUTO_REPLY"."REPLY_TYPE" IS '回复类型，1文本，2图文';
COMMENT ON COLUMN "T_WX_MSG_AUTO_REPLY"."REPLY_CONTENT" IS '自动回复的内容';
COMMENT ON COLUMN "T_WX_MSG_AUTO_REPLY"."MATCH_TYPE" IS '匹配模式，100完全匹配，200模糊匹配';
COMMENT ON COLUMN "T_WX_MSG_AUTO_REPLY"."PRIORITY" IS '优先级';
COMMENT ON COLUMN "T_WX_MSG_AUTO_REPLY"."IS_DEFAULT" IS '是否默认回复';
COMMENT ON COLUMN "T_WX_MSG_AUTO_REPLY"."CREATE_TIME" IS '创建时间';

COMMENT ON TABLE "T_WX_MSG_AUTO_REPLY" IS '微信自动回复';

ALTER TABLE "T_WX_MSG_AUTO_REPLY"
    ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 微信信息规则
-- ----------------------------
-- DROP TABLE "T_WX_MSG_RULE";
CREATE TABLE "T_WX_MSG_RULE"
(
    "ID"                   VARCHAR2(32 BYTE) NOT NULL,
    "NAME"                 VARCHAR2(255 CHAR),
    "WX_ACCOUNT_ID"        VARCHAR2(32 BYTE),
    "WX_ACCOUNT_ORIGIN_ID" VARCHAR2(100 CHAR),
    "HANDLERS"             VARCHAR2(255 CHAR),
    "IS_ENABLE"            NUMBER(2),
    "IS_DEFAULT"           NUMBER(2),
    "IS_SYCN"              NUMBER(2),
    "FROM_USER_NAME"       VARCHAR2(255 CHAR),
    "MSG_TYPE"             VARCHAR2(255 CHAR),
    "CONTENT"              VARCHAR2(255 CHAR),
    "MSG_START_TIME"       DATE,
    "MSG_END_TIME"         DATE,
    "EVENT"                VARCHAR2(255 CHAR),
    "EVENT_KEY"            VARCHAR2(255 CHAR),
    "MATCH_TYPE"           NUMBER(5),
    "REPLY_CONTENT_REF_ID" VARCHAR2(32 BYTE),
    "REPLY_CONTENT"        CLOB,
    "PRIORITY"             NUMBER(7),
    "CREATE_TIME"          DATE
);

COMMENT ON COLUMN "T_WX_MSG_RULE"."ID" IS '主键';
COMMENT ON COLUMN "T_WX_MSG_RULE"."NAME" IS '规则名称';
COMMENT ON COLUMN "T_WX_MSG_RULE"."WX_ACCOUNT_ID" IS '微信公众号id';
COMMENT ON COLUMN "T_WX_MSG_RULE"."WX_ACCOUNT_ORIGIN_ID" IS '微信公众号编码';
COMMENT ON COLUMN "T_WX_MSG_RULE"."HANDLERS" IS '规则处理器';
COMMENT ON COLUMN "T_WX_MSG_RULE"."IS_ENABLE" IS '是否启用';
COMMENT ON COLUMN "T_WX_MSG_RULE"."IS_DEFAULT" IS '是否默认处理器';
COMMENT ON COLUMN "T_WX_MSG_RULE"."IS_SYCN" IS '是否异步操作，1是，0否';
COMMENT ON COLUMN "T_WX_MSG_RULE"."FROM_USER_NAME" IS '消息来源openid';
COMMENT ON COLUMN "T_WX_MSG_RULE"."MSG_TYPE" IS '消息类型';
COMMENT ON COLUMN "T_WX_MSG_RULE"."CONTENT" IS '消息内容';
COMMENT ON COLUMN "T_WX_MSG_RULE"."MSG_START_TIME" IS '消息的有效开始时间';
COMMENT ON COLUMN "T_WX_MSG_RULE"."MSG_END_TIME" IS '消息有效的截止时间';
COMMENT ON COLUMN "T_WX_MSG_RULE"."EVENT" IS '事件类型';
COMMENT ON COLUMN "T_WX_MSG_RULE"."EVENT_KEY" IS '事件KEY值';
COMMENT ON COLUMN "T_WX_MSG_RULE"."MATCH_TYPE" IS '匹配类型,100完全匹配，200正则匹配';
COMMENT ON COLUMN "T_WX_MSG_RULE"."REPLY_CONTENT_REF_ID" IS '回复内容的外键id';
COMMENT ON COLUMN "T_WX_MSG_RULE"."REPLY_CONTENT" IS '回复的文本';
COMMENT ON COLUMN "T_WX_MSG_RULE"."PRIORITY" IS '优先级';

COMMENT ON TABLE "T_WX_MSG_RULE" IS '微信规则';

ALTER TABLE "T_WX_MSG_RULE"
    ADD PRIMARY KEY ("ID");



-- ----------------------------
-- 公众号模板消息
-- ----------------------------
-- DROP TABLE "T_WX_TEMPLATE_MESSAGE";
CREATE TABLE "T_WX_TEMPLATE_MESSAGE"
(
    "ID"             VARCHAR2(32 BYTE) NOT NULL,
    "WX_ACCOUNT_ID"  VARCHAR2(32 BYTE),
    "TEMPLATE_ID"    VARCHAR2(255 BYTE),
    "CREATE_TIME"    DATE DEFAULT sysdate,
    "UPDATE_TIME"    DATE DEFAULT sysdate,
    "TYPE"           VARCHAR2(255 BYTE),
    "FIRST"          VARCHAR2(255 BYTE),
    "FIRST_COLOR"    VARCHAR2(255 BYTE),
    "KEYWORD1"       VARCHAR2(255 BYTE),
    "KEYWORD1_COLOR" VARCHAR2(255 BYTE),
    "KEYWORD2"       VARCHAR2(255 BYTE),
    "KEYWORD2_COLOR" VARCHAR2(255 BYTE),
    "KEYWORD3"       VARCHAR2(255 BYTE),
    "KEYWORD3_COLOR" VARCHAR2(255 BYTE),
    "KEYWORD4"       VARCHAR2(255 BYTE),
    "KEYWORD4_COLOR" VARCHAR2(255 BYTE),
    "KEYWORD5"       VARCHAR2(255 BYTE),
    "KEYWORD5_COLOR" VARCHAR2(255 BYTE),
    "REMARK"         VARCHAR2(255 BYTE),
    "REMARK_COLOR"   VARCHAR2(255 BYTE),
    "URL"            VARCHAR2(512 BYTE)
);

COMMENT ON COLUMN "T_WX_TEMPLATE_MESSAGE"."ID" IS '主键';
COMMENT ON COLUMN "T_WX_TEMPLATE_MESSAGE"."WX_ACCOUNT_ID" IS '微信id';
COMMENT ON COLUMN "T_WX_TEMPLATE_MESSAGE"."TEMPLATE_ID" IS '模板消息在公众号配置的id';
COMMENT ON COLUMN "T_WX_TEMPLATE_MESSAGE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_WX_TEMPLATE_MESSAGE"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_WX_TEMPLATE_MESSAGE"."TYPE" IS '业务类型';
COMMENT ON TABLE "T_WX_TEMPLATE_MESSAGE" IS '公众号模板消息';


ALTER TABLE "T_WX_TEMPLATE_MESSAGE"
    ADD PRIMARY KEY ("ID");



-- ----------------------------
-- 微信二维码
-- ----------------------------
-- DROP TABLE "T_WX_QRCODE";
CREATE TABLE "T_WX_QRCODE"
(
    "ID"                VARCHAR2(32 BYTE) NOT NULL,
    "ACCOUNT_ID"        VARCHAR2(32 BYTE),
    "ACCOUNT_ORIGIN_ID" VARCHAR2(100 CHAR),
    "NAME"              VARCHAR2(255 CHAR),
    "TYPE"              NUMBER(2),
    "IMG_URL"           VARCHAR2(255 CHAR),
    "SCENE_STR"         VARCHAR2(64 CHAR),
    "VALID_TIME"        DATE,
    "TICKET"            VARCHAR2(255 CHAR),
    "CONTENT"           VARCHAR2(255 CHAR),
    "SCAN_COUNT"        NUMBER(6),
    "HANDLER_ID"        VARCHAR2(32 BYTE),
    "REPLY_TYPE"        VARCHAR2(255 CHAR),
    "REPLY_CONTENT"     VARCHAR2(255 CHAR)
);


COMMENT ON COLUMN "T_WX_QRCODE"."ACCOUNT_ID" IS '微信公众号id';
COMMENT ON COLUMN "T_WX_QRCODE"."ACCOUNT_ORIGIN_ID" IS '公众号的原始id';
COMMENT ON COLUMN "T_WX_QRCODE"."NAME" IS '二维码名字';
COMMENT ON COLUMN "T_WX_QRCODE"."TYPE" IS '二维码类型:1临时二维码，2永久二维码，3自定义二维码';
COMMENT ON COLUMN "T_WX_QRCODE"."IMG_URL" IS '二维码的存储地址';
COMMENT ON COLUMN "T_WX_QRCODE"."SCENE_STR" IS '场景id，临时是整型，长久是字符串';
COMMENT ON COLUMN "T_WX_QRCODE"."VALID_TIME" IS '过期时间';
COMMENT ON COLUMN "T_WX_QRCODE"."TICKET" IS '获取的二维码ticket';
COMMENT ON COLUMN "T_WX_QRCODE"."CONTENT" IS '二维码图片解析后的地址';
COMMENT ON COLUMN "T_WX_QRCODE"."SCAN_COUNT" IS '扫码的次数';
COMMENT ON COLUMN "T_WX_QRCODE"."HANDLER_ID" IS '处理器';
COMMENT ON COLUMN "T_WX_QRCODE"."REPLY_TYPE" IS '回复类型';
COMMENT ON COLUMN "T_WX_QRCODE"."REPLY_CONTENT" IS '回复内容';
COMMENT ON TABLE "T_WX_QRCODE" IS '微信二维码';

ALTER TABLE "T_WX_QRCODE"
    ADD PRIMARY KEY ("ID");





