/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.menu.web.controller;

import com.els.base.core.entity.ResponseResult;
import com.els.base.utils.json.JsonUtils;
import com.els.base.wechat.account.entity.AccountConfig;
import com.els.base.wechat.account.service.AccountConfigService;
import com.els.base.wechat.common.WxMpServiceUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import javax.annotation.Resource;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import me.chanjar.weixin.mp.bean.menu.WxMpMenu;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u5fae\u4fe1-\u516c\u4f17\u53f7\u81ea\u5b9a\u4e49\u83dc\u5355\u63a5\u53e3")
@Controller
@RequestMapping(value={"wechatMenu"})
public class WechatMenuController {
    @Resource
    protected AccountConfigService accountConfigService;

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u5fae\u4fe1\u83dc\u5355")
    @RequestMapping(value={"/service/menuGet"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseResult<WxMpMenu> menuGet(@RequestParam(required=true, value="originId") String originId) throws WxErrorException {
        AccountConfig account = this.accountConfigService.queryByOriginId(originId);
        WxMpServiceImpl wxMpService = (WxMpServiceImpl)WxMpServiceUtils.getWxMpServiceByAccount(account);
        WxMpMenu wxMenu = wxMpService.getMenuService().menuGet();
        return ResponseResult.success((Object)wxMenu);
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u6216\u66f4\u65b0\u5fae\u4fe1\u83dc\u5355")
    @RequestMapping(value={"service/create"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseResult<WxMpMenu> create(@RequestParam(required=true, value="originId") String originId, @RequestBody WxMpMenu wxMenu) throws Exception {
        AccountConfig account = this.accountConfigService.queryByOriginId(originId);
        WxMpServiceImpl wxMpService = (WxMpServiceImpl)WxMpServiceUtils.getWxMpServiceByAccount(account);
        if (CollectionUtils.isEmpty((Collection)wxMenu.getMenu().getButtons())) {
            wxMpService.getMenuService().menuDelete();
        } else {
            wxMpService.getMenuService().menuCreate(JsonUtils.writeValueAsString((Object)wxMenu.getMenu()));
        }
        WxMpMenu newMenu = wxMpService.getMenuService().menuGet();
        return ResponseResult.success((Object)newMenu);
    }
}

