/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.msg.handler;

import com.els.base.core.entity.IExample;
import com.els.base.utils.SpringContextHolder;
import com.els.base.wechat.member.entity.WxMember;
import com.els.base.wechat.member.entity.WxMemberExample;
import com.els.base.wechat.member.service.WxMemberService;
import com.els.base.wechat.msg.entity.WxMsgRule;
import com.els.base.wechat.msg.handler.BaseMsgHandler;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutTextMessage;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSubscribeHandler
extends BaseMsgHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSubscribeHandler.class);
    protected static WxMemberService wxMemberService = (WxMemberService)SpringContextHolder.getBean((String)"wxMemberService");

    public DefaultSubscribeHandler(WxMsgRule wxMsgRule) {
        super(wxMsgRule);
    }

    @Override
    public WxMpXmlOutMessage handle(WxMpXmlMessage wxMessage, Map<String, Object> context, WxMpService wxMpService, WxSessionManager sessionManager) throws WxErrorException {
        logger.debug("com.els.base.msg.weixin.ScanQrcodeHandler.handle => {}", (Object)wxMessage);
        if (!"event".equals(wxMessage.getMsgType())) {
            return null;
        }
        if (!"SCAN".equals(wxMessage.getEvent()) && !"subscribe".equals(wxMessage.getEvent())) {
            return null;
        }
        String key = wxMessage.getEventKey().replaceAll("qrscene_", "");
        if (!key.startsWith("BIND_USER_")) {
            return null;
        }
        String userId = key.replaceAll("BIND_USER_", "");
        WxMemberExample wxMemberExample = new WxMemberExample();
        wxMemberExample.createCriteria().andWxOpenidEqualTo(wxMessage.getFromUser());
        WxMemberService wxMemberService = (WxMemberService)SpringContextHolder.getBean((String)"wxMemberService");
        List memberList = wxMemberService.queryAllObjByExample((IExample)wxMemberExample);
        String wxMemberId = null;
        if (CollectionUtils.isEmpty((Collection)memberList)) {
            WxMpUser wxMpUser = wxMpService.getUserService().userInfo(wxMessage.getFromUser(), null);
            wxMemberId = wxMemberService.createOrEditWxMember(wxMpUser, wxMessage.getEventKey(), wxMessage.getToUser()).getId();
        } else {
            wxMemberId = ((WxMember)memberList.get(0)).getId();
        }
        logger.debug("================ userId: {} ================", (Object)userId);
        WxMember wxMember = new WxMember();
        wxMember.setId(wxMemberId);
        wxMember.setMemberId(userId);
        wxMemberService.modifyObj(wxMember);
        logger.debug("================ userId: {} ================", (Object)userId);
        WxMpXmlOutTextMessage outMessage = new WxMpXmlOutTextMessage();
        outMessage.setCreateTime(Long.valueOf(System.currentTimeMillis()));
        outMessage.setFromUserName(wxMessage.getToUser());
        outMessage.setToUserName(wxMessage.getFromUser());
        outMessage.setContent("\u7ed1\u5b9a\u6210\u529f\u3002");
        return outMessage;
    }
}

