/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.msg.handler;

import com.els.base.wechat.msg.entity.WxMsgRule;
import com.els.base.wechat.msg.handler.BaseMsgHandler;
import java.util.Map;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutTextMessage;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplyTextHandler
extends BaseMsgHandler {
    private static Logger logger = LoggerFactory.getLogger(ReplyTextHandler.class);
    private String replyContent = "\u6b22\u8fce!! ^_^";

    public ReplyTextHandler(WxMsgRule wxMsgRule) {
        super(wxMsgRule);
        if (wxMsgRule != null && StringUtils.isNotBlank((String)wxMsgRule.getReplyContent())) {
            this.replyContent = wxMsgRule.getReplyContent();
        }
    }

    @Override
    public WxMpXmlOutMessage handle(WxMpXmlMessage inMessage, Map<String, Object> context, WxMpService wxMpService, WxSessionManager sessionManager) throws WxErrorException {
        logger.debug("com.els.base.wechat.msg.handler.ReplyTextHandler.handle => {}", (Object)inMessage);
        WxMpXmlOutTextMessage outMessage = new WxMpXmlOutTextMessage();
        outMessage.setCreateTime(Long.valueOf(System.currentTimeMillis()));
        outMessage.setFromUserName(inMessage.getToUser());
        outMessage.setToUserName(inMessage.getFromUser());
        outMessage.setContent(this.replyContent);
        return outMessage;
    }

    public String getReplyContent() {
        return this.replyContent;
    }

    public void setReplyContent(String replyContent) {
        this.replyContent = replyContent;
    }
}

