/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.pay.utils;

import com.els.base.core.exception.CommonException;
import com.els.base.utils.encryption.Md5Utils;
import com.els.base.wechat.jssdk.entity.WxJsPayParams;
import com.els.base.wechat.pay.entity.WxMpOrder;
import com.els.base.wechat.pay.entity.WxMpXmlUnifiedOrderOutMessage;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxPaySignUtils {
    private static Logger logger = LoggerFactory.getLogger(WxPaySignUtils.class);

    public static String sign(Object message, String key) throws IllegalArgumentException, IllegalAccessException, NoSuchAlgorithmException, UnsupportedEncodingException {
        Field[] fields;
        ArrayList<String> list = new ArrayList<String>();
        Class<?> cls = message.getClass();
        for (Field f : fields = cls.getDeclaredFields()) {
            f.setAccessible(true);
            if ("serialVersionUID".equals(f.getName()) || f.get(message) == null || f.get(message) == "") continue;
            list.add(f.getName() + "=" + f.get(message) + "&");
        }
        int size = list.size();
        String[] arrayToSort = list.toArray(new String[size]);
        Arrays.sort(arrayToSort, String.CASE_INSENSITIVE_ORDER);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(arrayToSort[i]);
        }
        String result = sb.toString();
        result = result + "key=" + key;
        logger.debug("Sign Before MD5:" + result);
        result = Md5Utils.md5Encode((String)result).toUpperCase();
        logger.debug("Sign Result:" + result);
        return result;
    }

    public static String getSignForJsParams(WxJsPayParams message, String key) throws IllegalArgumentException, IllegalAccessException, NoSuchAlgorithmException, UnsupportedEncodingException {
        if (StringUtils.isBlank((String)message.getAppId()) || StringUtils.isBlank((String)message.getNonceStr()) || StringUtils.isBlank((String)message.getPackageStr()) || StringUtils.isBlank((String)message.getSignType()) || StringUtils.isBlank((String)message.getTimeStamp())) {
            throw new CommonException("\u652f\u4ed8\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        if (String.valueOf(System.currentTimeMillis()).length() == message.getTimeStamp().length()) {
            throw new CommonException("\u652f\u4ed8jsapi\u53c2\u6570\u4e2d\uff0c\u65f6\u95f4\u6233\u7684\u5355\u4f4d\u662f \u79d2");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("appId=").append(message.getAppId()).append("&");
        sb.append("nonceStr=").append(message.getNonceStr()).append("&");
        sb.append("package=").append(message.getPackageStr()).append("&");
        sb.append("signType=").append(message.getSignType()).append("&");
        sb.append("timeStamp=").append(message.getTimeStamp()).append("&");
        sb.append("key=").append(key);
        String result = sb.toString();
        logger.debug("Sign Before MD5:" + result);
        result = Md5Utils.md5Encode((String)result).toUpperCase();
        logger.debug("Sign Result:" + result);
        return result;
    }

    public static WxMpXmlUnifiedOrderOutMessage fromWxOrder(WxMpOrder wxMpOrder) {
        WxMpXmlUnifiedOrderOutMessage outMsg = new WxMpXmlUnifiedOrderOutMessage();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        outMsg.setBody(wxMpOrder.getProductBody());
        outMsg.setDetail(wxMpOrder.getProductDetail());
        outMsg.setAttach(wxMpOrder.getAttach());
        outMsg.setOutTradeNo(wxMpOrder.getOutTradeNo());
        outMsg.setTotalFee(wxMpOrder.getTotalFee());
        outMsg.setGoodsTag(wxMpOrder.getGoodsTag());
        outMsg.setOpenid(wxMpOrder.getOpenId());
        if (StringUtils.isNotBlank((String)wxMpOrder.getFeeType())) {
            outMsg.setFeeType(wxMpOrder.getFeeType());
        } else {
            outMsg.setFeeType("CNY");
        }
        if (wxMpOrder.getTimeStart() != null) {
            outMsg.setTimeStartStr(format.format(wxMpOrder.getTimeStart()));
        }
        if (wxMpOrder.getTimeExpire() != null) {
            outMsg.setTimeExpire(format.format(wxMpOrder.getTimeExpire()));
        }
        return outMsg;
    }
}

