/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.customer.service.impl;

import com.els.base.certification.customer.dao.CompanyCustomerMapper;
import com.els.base.certification.customer.entity.CompanyCustomer;
import com.els.base.certification.customer.entity.CompanyCustomerExample;
import com.els.base.certification.customer.service.CompanyCustomerService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCompanyCustomerService")
public class CompanyCustomerServiceImpl
implements CompanyCustomerService {
    @Resource
    protected CompanyCustomerMapper companyCustomerMapper;

    @Override
    @Cacheable(value={"companyCustomer"}, keyGenerator="redisKeyGenerator")
    public Integer isFinish(Project project, Company company) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(Constant.NO_INT);
        CompanyCustomerExample companyCustomerExample = new CompanyCustomerExample();
        companyCustomerExample.createCriteria().andProjectIdEqualTo(project.getId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
        if (this.companyCustomerMapper.countByExample(companyCustomerExample) <= 0) {
            return 0;
        }
        companyCustomerExample.clear();
        companyCustomerExample.createCriteria().andProjectIdEqualTo(project.getId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT).andFinishFlagIn(list);
        int count = this.companyCustomerMapper.countByExample(companyCustomerExample);
        if (count > 0) {
            return 0;
        }
        return 1;
    }

    @CacheEvict(value={"companyCustomer"}, allEntries=true)
    public void addObj(CompanyCustomer t) {
        this.companyCustomerMapper.insertSelective(t);
    }

    @CacheEvict(value={"companyCustomer"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companyCustomerMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyCustomer"}, allEntries=true)
    public void modifyObj(CompanyCustomer t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.companyCustomerMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"companyCustomer"}, keyGenerator="redisKeyGenerator")
    public CompanyCustomer queryObjById(String id) {
        return this.companyCustomerMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"companyCustomer"}, keyGenerator="redisKeyGenerator")
    public List<CompanyCustomer> queryAllObjByExample(CompanyCustomerExample example) {
        return this.companyCustomerMapper.selectByExample(example);
    }

    @Cacheable(value={"companyCustomer"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanyCustomer> queryObjByPage(CompanyCustomerExample example) {
        PageView<CompanyCustomer> pageView = example.getPageView();
        pageView.setQueryResult(this.companyCustomerMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Transactional
    @CacheEvict(value={"companyCustomer"}, allEntries=true)
    public Integer batchInsert(String projectId, Company supCompany, Company purCompany, List<CompanyCustomer> customerList) {
        if (CollectionUtils.isEmpty(customerList)) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        CompanyCustomerExample example = new CompanyCustomerExample();
        example.createCriteria().andProjectIdEqualTo(projectId).andSupCompanyIdEqualTo(supCompany.getId()).andIsEnableEqualTo(Constant.YES_INT);
        CompanyCustomer customer = new CompanyCustomer();
        customer.setIsEnable(Constant.NO_INT);
        this.companyCustomerMapper.updateByExampleSelective(customer, example);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (CompanyCustomer companyCustomer : customerList) {
            companyCustomer.setId(null);
            companyCustomer.setProjectId(projectId);
            companyCustomer.setPurCompanyId(purCompany.getId());
            companyCustomer.setPurCompanySrmCode(purCompany.getCompanyCode());
            companyCustomer.setPurCompanyName(purCompany.getCompanyName());
            companyCustomer.setSupCompanyId(supCompany.getId());
            companyCustomer.setSupCompanySrmCode(supCompany.getCompanyCode());
            companyCustomer.setSupCompanyName(supCompany.getCompanyName());
            companyCustomer.setIsEnable(Constant.YES_INT);
            companyCustomer.setCreateTime(new Date());
            companyCustomer.setUpdateTime(new Date());
            companyCustomer.setFinishFlag(Constant.NO_INT);
            Integer finishFlag = companyCustomer.getFinishFlag();
            companyCustomer.setFinishFlag(finishFlag);
            this.addObj(companyCustomer);
            list.add(finishFlag);
        }
        if (list.contains(Constant.NO_INT)) {
            return 0;
        }
        return 1;
    }

    @Override
    @Transactional
    @CacheEvict(value={"companyCustomer"}, allEntries=true)
    public void deleteObjByIds(String projectId, Company company, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u4f20\u9012\u7684id\u5217\u8868\u4e3a\u7a7a!");
        }
        CompanyCustomerExample example = new CompanyCustomerExample();
        example.createCriteria().andProjectIdEqualTo(projectId).andSupCompanyIdEqualTo(company.getId()).andIdIn((List)ids);
        CompanyCustomer customer = new CompanyCustomer();
        customer.setIsEnable(Constant.NO_INT);
        this.companyCustomerMapper.updateByExampleSelective(customer, example);
    }

    @CacheEvict(value={"companyCustomer"}, allEntries=true)
    public void deleteByExample(CompanyCustomerExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.companyCustomerMapper.deleteByExample(example);
    }

    @CacheEvict(value={"companyCustomer"}, allEntries=true)
    @Transactional
    public void addAll(List<CompanyCustomer> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.companyCustomerMapper.insertSelective((CompanyCustomer)record));
    }
}

