/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.file.service.impl;

import com.els.base.certification.file.dao.CompanyFileMapper;
import com.els.base.certification.file.entity.CompanyFile;
import com.els.base.certification.file.entity.CompanyFileExample;
import com.els.base.certification.file.service.CompanyFileService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCompanyFileService")
public class CompanyFileServiceImpl
implements CompanyFileService {
    @Resource
    private CompanyFileMapper companyFileMapper;

    @Override
    @Cacheable(value={"companyFile"}, keyGenerator="redisKeyGenerator")
    public Integer isFinish(Project project, Company company) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(Constant.NO_INT);
        CompanyFileExample companyFileExample = new CompanyFileExample();
        companyFileExample.createCriteria().andProjectIdEqualTo(project.getId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
        int count = this.companyFileMapper.countByExample(companyFileExample);
        if (count <= 0) {
            return 0;
        }
        companyFileExample.clear();
        companyFileExample.createCriteria().andProjectIdEqualTo(project.getId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
        int finishCount = this.companyFileMapper.countByExample(companyFileExample);
        if (finishCount > 0) {
            return 0;
        }
        return 1;
    }

    @Override
    @CacheEvict(value={"companyFile"}, allEntries=true)
    @Transactional
    public void deleteObjByIds(String projectId, Company company, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e"});
        }
        CompanyFileExample companyFileExample = new CompanyFileExample();
        companyFileExample.createCriteria().andProjectIdEqualTo(projectId).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT).andIdIn((List)ids);
        CompanyFile companyFile = new CompanyFile();
        companyFile.setIsEnable(Constant.NO_INT);
        this.companyFileMapper.updateByExampleSelective(companyFile, companyFileExample);
    }

    @CacheEvict(value={"companyFile"}, allEntries=true)
    public void addObj(CompanyFile t) {
        this.companyFileMapper.insertSelective(t);
    }

    @CacheEvict(value={"companyFile"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companyFileMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyFile"}, allEntries=true)
    public void modifyObj(CompanyFile t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.companyFileMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"companyFile"}, keyGenerator="redisKeyGenerator")
    public CompanyFile queryObjById(String id) {
        return this.companyFileMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"companyFile"}, keyGenerator="redisKeyGenerator")
    public List<CompanyFile> queryAllObjByExample(CompanyFileExample example) {
        return this.companyFileMapper.selectByExample(example);
    }

    @Cacheable(value={"companyFile"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanyFile> queryObjByPage(CompanyFileExample example) {
        PageView<CompanyFile> pageView = example.getPageView();
        pageView.setQueryResult(this.companyFileMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"companyFile"}, allEntries=true)
    @Transactional
    public Integer batchInsert(String projectId, Company company, List<CompanyFile> companyFileList) {
        if (CollectionUtils.isEmpty(companyFileList)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e"});
        }
        CompanyFileExample companyEquipmentExample = new CompanyFileExample();
        companyEquipmentExample.createCriteria().andProjectIdEqualTo(projectId).andSupCompanyIdEqualTo(company.getId());
        this.companyFileMapper.deleteByExample(companyEquipmentExample);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (CompanyFile companyFile : companyFileList) {
            companyFile.setId(null);
            companyFile.setProjectId(projectId);
            companyFile.setSupCompanyId(company.getId());
            companyFile.setIsEnable(Constant.YES_INT);
            companyFile.setCreateTime(new Date());
            companyFile.setUpdateTime(new Date());
            Integer finishFlag = companyFile.getFinishFlag();
            companyFile.setFinishFlag(finishFlag);
            this.companyFileMapper.insertSelective(companyFile);
            list.add(finishFlag);
        }
        if (list.contains(Constant.NO_INT)) {
            return 0;
        }
        return 1;
    }

    @CacheEvict(value={"companyFile"}, allEntries=true)
    public void deleteByExample(CompanyFileExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.companyFileMapper.deleteByExample(example);
    }

    @CacheEvict(value={"companyFile"}, allEntries=true)
    @Transactional
    public void addAll(List<CompanyFile> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.companyFileMapper.insertSelective((CompanyFile)record));
    }
}

