/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.quality.web.controller;

import com.els.base.certification.common.CompanyFinishFlag;
import com.els.base.certification.quality.entity.CompanyQuality;
import com.els.base.certification.quality.entity.CompanyQualityExample;
import com.els.base.certification.quality.service.CompanyQualityService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u4f9b\u5e94\u5546\u51c6\u5165--\u8d28\u91cf\u7ba1\u7406")
@Controller
@RequestMapping(value={"companyQuality"})
public class CompanyQualityController {
    @Resource
    protected CompanyQualityService companyQualityService;
    @Resource
    private CompanyService companyService;

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u521b\u5efa\u4f9b\u5e94\u5546\u51c6\u5165--\u8d28\u91cf\u7ba1\u7406")
    @RequestMapping(value={"service/batchInsert"})
    @ResponseBody
    public ResponseResult<Map<String, Integer>> batchInsert(@RequestBody List<CompanyQuality> companyQualityList) {
        if (CollectionUtils.isEmpty(companyQualityList)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e"});
        }
        Integer qualityStatus = this.companyQualityService.batchInsert(ProjectUtils.getProjectId(), CompanyUtils.currentCompany(), companyQualityList);
        CompanyFinishFlag companyFinishFlag = new CompanyFinishFlag();
        companyFinishFlag.setProprietaryTechnology(qualityStatus);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("quality", qualityStatus);
        return ResponseResult.success(map);
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f9b\u5e94\u5546\u51c6\u5165--\u8d28\u91cf\u7ba1\u7406")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CompanyQuality companyQuality) {
        this.companyQualityService.addObj(companyQuality);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4f9b\u5e94\u5546\u51c6\u5165--\u8d28\u91cf\u7ba1\u7406")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody CompanyQuality companyQuality) {
        Assert.isNotBlank((String)companyQuality.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.companyQualityService.modifyObj(companyQuality);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u4f9b\u5e94\u5546\u51c6\u5165--\u8d28\u91cf\u7ba1\u7406")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        CompanyQualityExample example = new CompanyQualityExample();
        example.createCriteria().andIdIn((List)ids);
        this.companyQualityService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u51c6\u5165--\u8d28\u91cf\u7ba1\u7406")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanyQuality", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<CompanyQuality>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        CompanyQualityExample example = new CompanyQualityExample();
        example.setPageView((PageView<CompanyQuality>)new PageView(pageNo, pageSize));
        CompanyQualityExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.companyQualityService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u51c6\u5165--\u8d28\u91cf\u7ba1\u7406")
    @ApiImplicitParams(value={@ApiImplicitParam(name="supCompanySrmCode", required=false, value="\u4f9b\u5e94\u5546SRM\u7f16\u7801", paramType="query", dataType="String"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanyPatents", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findAll"})
    @ResponseBody
    public ResponseResult<List<CompanyQuality>> findAll(@RequestParam(required=false) String supCompanySrmCode, @RequestBody(required=false) QueryParamWapper wapper) throws IOException {
        CompanyQualityExample example = new CompanyQualityExample();
        example.setOrderByClause("CREATE_TIME DESC");
        CompanyQualityExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isBlank((String)supCompanySrmCode)) {
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        } else {
            Company company = this.companyService.queryCompanyByCode(supCompanySrmCode);
            if (company == null) {
                throw new CommonException("\u516c\u53f8\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            }
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andSupCompanyIdEqualTo(company.getId());
        }
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        List companyQualityList = this.companyQualityService.queryAllObjByExample((IExample)example);
        return ResponseResult.success((Object)companyQualityList);
    }
}

