-- 2019-10-18
-- ----------------------------
-- 企业通过的认证
-- ----------------------------
DROP TABLE "T_BASE_COMPANY_AUTH";
CREATE TABLE "T_BASE_COMPANY_AUTH" (
  "ID" VARCHAR2(32 BYTE) DEFAULT '' NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 BYTE) DEFAULT '' ,
  "SUP_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "CERTIFICATE_TYPE_NAME" VARCHAR2(255 BYTE) DEFAULT '' ,
  "CERTIFICATE_TYPE_CODE" VARCHAR2(255 BYTE) DEFAULT '' ,
  "CERTIFICATE_NAME" VARCHAR2(255 BYTE) DEFAULT '' ,
  "CERTIFICATION_AUTHORITY" VARCHAR2(255 BYTE) DEFAULT '' ,
  "CERTIFICATE_CREATE_TIME" DATE ,
  "START_TIME" DATE ,
  "END_TIME" DATE ,
  "CREATE_TIME" DATE ,
  "EFFECTIVE_DATE" NUMBER(7) ,
  "REMARK" VARCHAR2(1000 BYTE) ,
  "FINISH_FLAG" NUMBER(7) DEFAULT 0   ,
  "IS_ENABLE" NUMBER(7) DEFAULT 1   ,
  "UPDATE_TIME" DATE ,
  "PATENT_DESC" VARCHAR2(1000 BYTE) DEFAULT '' ,
  "CERTIFICATE_FILE" CLOB ,
  "UPLOAD_TIME" DATE 
);
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."ID" IS 'ID';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."CERTIFICATE_TYPE_NAME" IS '证书类型名称';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."CERTIFICATE_TYPE_CODE" IS '证书类型CODE值';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."CERTIFICATE_NAME" IS '证书名称,类型';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."CERTIFICATION_AUTHORITY" IS '认证机构';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."CERTIFICATE_CREATE_TIME" IS '证书签发日期';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."START_TIME" IS '证书开始时间';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."END_TIME" IS '结束时间';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."CREATE_TIME" IS '上传时间';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."EFFECTIVE_DATE" IS '有效天数(天)';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."FINISH_FLAG" IS '完成标识符(0=未完成，1=已完成)';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."PATENT_DESC" IS '适用于';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."CERTIFICATE_FILE" IS '证书文件';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."UPLOAD_TIME" IS '上传时间';
COMMENT ON TABLE "T_BASE_COMPANY_AUTH" IS '企业通过的认证';

-- ----------------------------
-- 供应商准入-业务情况
-- ----------------------------
DROP TABLE "T_BASE_COMPANY_BUSINESS";
CREATE TABLE "T_BASE_COMPANY_BUSINESS" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 BYTE) ,
  "PUR_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) ,
  "PUR_COMPANY_NAME" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_NAME" VARCHAR2(255 BYTE) ,
  "RAW_MATERIAL" VARCHAR2(255 BYTE) ,
  "ORIGIN" VARCHAR2(255 BYTE) ,
  "SUPPLIER" VARCHAR2(255 BYTE) ,
  "PUR_AMOUNT_PROPORTION" NUMBER(20,2) ,
  "PURCHASE_AMOUNT" NUMBER(20,2) ,
  "START_TIME" DATE ,
  "EXPLAINATION" VARCHAR2(1000 BYTE) ,
  "IS_ENABLE" NUMBER(7) DEFAULT 1   ,
  "FINISH_FLAG" NUMBER(7) DEFAULT 0   ,
  "CREATE_TIME" DATE DEFAULT SYSDATE   ,
  "UPDATE_TIME" DATE ,
  "LASTYEAR_SALES" NUMBER(20) ,
  "PRODUCT_SERVICE_NAME" VARCHAR2(255 BYTE) ,
  "GENERAL_SALES" VARCHAR2(255 BYTE) ,
  "PRODUCT_SALES_ PERCENT" VARCHAR2(255 BYTE) ,
  "MARKET_SALES_PERCENT" VARCHAR2(255 BYTE) ,
  "PRIMARY_COMPETITORS" VARCHAR2(255 BYTE) ,
  "RAW_MATERIAL_SUPPLIER" VARCHAR2(255 BYTE) ,
  "MARKET_CONDITIONS" VARCHAR2(255 BYTE) ,
  "RAW_MATERIALS_USER" VARCHAR2(255 BYTE) ,
  "PRODUCT_CAPACITY" VARCHAR2(255 BYTE) ,
  "ANNUAL_OUTPUT" VARCHAR2(255 BYTE) ,
  "PRODUCT_EXPANSION_PLAN" VARCHAR2(255 BYTE) ,
  "PRODUCT_COST_PLAN" VARCHAR2(255 BYTE) ,
  "PRODUCT_SAFETY_STOCK" VARCHAR2(255 BYTE) 
);
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."PUR_COMPANY_ID" IS '采购商公司ID';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."PUR_COMPANY_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."PUR_COMPANY_NAME" IS '采购商名称';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."SUP_COMPANY_NAME" IS '供应商名称';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."RAW_MATERIAL" IS '主要原材料';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."ORIGIN" IS '原产地';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."SUPPLIER" IS '供应商';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."PUR_AMOUNT_PROPORTION" IS '占原材料总采购金额的比例';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."PURCHASE_AMOUNT" IS '年采购额';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."START_TIME" IS '业务开始时间';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."EXPLAINATION" IS '说明';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."FINISH_FLAG" IS '完成标识符(0=未完成，1=已完成)';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."LASTYEAR_SALES" IS '上一年销售额';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."PRODUCT_SERVICE_NAME" IS '主要产品/服务名称';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."GENERAL_SALES" IS '主要客户及大致销量';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."PRODUCT_SALES_ PERCENT" IS '产品销售比例';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."MARKET_SALES_PERCENT" IS '市场销售比';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."PRIMARY_COMPETITORS" IS '主要竞争对手';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."RAW_MATERIAL_SUPPLIER" IS '原料来源/供应商';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."MARKET_CONDITIONS" IS '市场状况';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."RAW_MATERIALS_USER" IS '原料用途';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."PRODUCT_CAPACITY" IS '产品产能';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."ANNUAL_OUTPUT" IS '上一年产品年度产量';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."PRODUCT_EXPANSION_PLAN" IS '产品扩产计划';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."PRODUCT_COST_PLAN" IS '产品成本方案';
COMMENT ON COLUMN "T_BASE_COMPANY_BUSINESS"."PRODUCT_SAFETY_STOCK" IS '产品安全库存';
COMMENT ON TABLE "T_BASE_COMPANY_BUSINESS" IS '供应商准入-业务情况';
ALTER TABLE "T_BASE_COMPANY_BUSINESS" ADD CONSTRAINT "SYS_C0034709" PRIMARY KEY ("ID");

-- ----------------------------
-- 联系人信息
-- ----------------------------
DROP TABLE "T_BASE_COMPANY_CONTACTS";
CREATE TABLE "T_BASE_COMPANY_CONTACTS" (
  "ID" VARCHAR2(32 CHAR) NOT NULL ,
  "NAME" VARCHAR2(20 CHAR) ,
  "GENDER" VARCHAR2(2 CHAR) ,
  "POST" VARCHAR2(30 CHAR) ,
  "DEPARTMENT" VARCHAR2(30 CHAR) ,
  "OFFICE_PHONE" VARCHAR2(20 CHAR) ,
  "MOBILE_PHONE" VARCHAR2(20 CHAR) ,
  "EMAIL" VARCHAR2(100 CHAR) ,
  "FAX" VARCHAR2(50 CHAR) ,
  "SUP_COMPANY_ID" VARCHAR2(32 CHAR) ,
  "PROJECT_ID" VARCHAR2(32 CHAR) ,
  "IS_ENABLE" NUMBER(7) DEFAULT 1   ,
  "FINISH_FLAG" NUMBER(7) DEFAULT 0   ,
  "CREATE_TIME" DATE ,
  "SORT_NO" NUMBER(4) ,
  "REMARK" VARCHAR2(255 BYTE) 
);
COMMENT ON COLUMN "T_BASE_COMPANY_CONTACTS"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_COMPANY_CONTACTS"."NAME" IS '姓名';
COMMENT ON COLUMN "T_BASE_COMPANY_CONTACTS"."GENDER" IS '性别';
COMMENT ON COLUMN "T_BASE_COMPANY_CONTACTS"."POST" IS '职务';
COMMENT ON COLUMN "T_BASE_COMPANY_CONTACTS"."DEPARTMENT" IS '部门';
COMMENT ON COLUMN "T_BASE_COMPANY_CONTACTS"."OFFICE_PHONE" IS '办公电话';
COMMENT ON COLUMN "T_BASE_COMPANY_CONTACTS"."MOBILE_PHONE" IS '手机号';
COMMENT ON COLUMN "T_BASE_COMPANY_CONTACTS"."EMAIL" IS '电子邮箱';
COMMENT ON COLUMN "T_BASE_COMPANY_CONTACTS"."FAX" IS '传真';
COMMENT ON COLUMN "T_BASE_COMPANY_CONTACTS"."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_BASE_COMPANY_CONTACTS"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_COMPANY_CONTACTS"."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';
COMMENT ON COLUMN "T_BASE_COMPANY_CONTACTS"."FINISH_FLAG" IS '完成标识符(0=未完成，1=已完成)';
COMMENT ON COLUMN "T_BASE_COMPANY_CONTACTS"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_COMPANY_CONTACTS"."SORT_NO" IS '排序号';
COMMENT ON COLUMN "T_BASE_COMPANY_CONTACTS"."REMARK" IS '备注';
COMMENT ON TABLE "T_BASE_COMPANY_CONTACTS" IS '联系人信息';
ALTER TABLE "T_BASE_COMPANY_CONTACTS" ADD CONSTRAINT "SYS_C0034655" PRIMARY KEY ("ID");

-- ----------------------------
-- 关键试验，检验设备
-- ----------------------------
DROP TABLE "T_BASE_COMPANY_EQUIPMENT";
CREATE TABLE "T_BASE_COMPANY_EQUIPMENT" (
  "ID" VARCHAR2(32 BYTE) DEFAULT '' NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 BYTE) ,
  "SUP_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "EQUIPMENT_CODE" VARCHAR2(255 BYTE) DEFAULT '' ,
  "EQUIPMENT_NAME" VARCHAR2(255 BYTE) DEFAULT '' ,
  "EQUIPMENT_PRODUCT_PLACE" VARCHAR2(1000 BYTE) DEFAULT '' ,
  "EQUIPMENT_ADVANTAGE" VARCHAR2(1000 BYTE) DEFAULT '' ,
  "CREATE_TIME" DATE ,
  "EQUIPMENT_QUANTITY" NUMBER(15) DEFAULT 0   ,
  "REMARK" VARCHAR2(1000 BYTE) ,
  "FINISH_FLAG" NUMBER(7) DEFAULT 0   ,
  "IS_ENABLE" NUMBER(7) DEFAULT 1   ,
  "EQUIPMENT_CREATE_TIME" DATE ,
  "UPDATE_TIME" DATE ,
  "EQUIPMENT_PRODUCTER" VARCHAR2(255 BYTE) DEFAULT '' ,
  "PURCHASE_PLAN" VARCHAR2(255 BYTE) DEFAULT '' 
);
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."ID" IS 'ID';
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."EQUIPMENT_CODE" IS '设备型号';
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."EQUIPMENT_NAME" IS '设备名称';
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."EQUIPMENT_PRODUCT_PLACE" IS '设备生产地';
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."EQUIPMENT_ADVANTAGE" IS '技术指标，优势简述';
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."EQUIPMENT_QUANTITY" IS '设备数量';
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."FINISH_FLAG" IS '完成标识符(0=未完成，1=已完成)';
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."EQUIPMENT_CREATE_TIME" IS '设备生产时间';
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."EQUIPMENT_PRODUCTER" IS '设备生产商';
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."PURCHASE_PLAN" IS '同级设备购买计划';
COMMENT ON TABLE "T_BASE_COMPANY_EQUIPMENT" IS '关键试验，检验设备';

-- ----------------------------
-- 供应商准入--附件
-- ----------------------------
DROP TABLE "T_BASE_COMPANY_FILE";
CREATE TABLE "T_BASE_COMPANY_FILE" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 BYTE) ,
  "SUP_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "SALES_CERT" VARCHAR2(255 BYTE) ,
  "PRODUCTION_EQUIPMENT" VARCHAR2(255 BYTE) ,
  "DETECTION_EQUIPMENT_LIST" VARCHAR2(255 BYTE) ,
  "QUALITY_PROCESS" VARCHAR2(255 BYTE) ,
  "PRODUCTION_CHART" VARCHAR2(255 BYTE) ,
  "BUSINESS_LICENCE" VARCHAR2(255 BYTE) ,
  "TAX_CERT" VARCHAR2(255 BYTE) ,
  "ORGANZATION_CERT" VARCHAR2(255 BYTE) ,
  "CREATE_TIME" DATE ,
  "UPDATE_TIME" DATE ,
  "IS_ENABLE" NUMBER(7) DEFAULT 1   ,
  "FINISH_FLAG" NUMBER(7) DEFAULT 0   ,
  "CERTIFICATE" VARCHAR2(255 BYTE) 
);
COMMENT ON COLUMN "T_BASE_COMPANY_FILE"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_COMPANY_FILE"."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_BASE_COMPANY_FILE"."SALES_CERT" IS '生产销售许可证';
COMMENT ON COLUMN "T_BASE_COMPANY_FILE"."PRODUCTION_EQUIPMENT" IS '主要生产设备';
COMMENT ON COLUMN "T_BASE_COMPANY_FILE"."DETECTION_EQUIPMENT_LIST" IS '检测设备清单';
COMMENT ON COLUMN "T_BASE_COMPANY_FILE"."QUALITY_PROCESS" IS '质量检验流程';
COMMENT ON COLUMN "T_BASE_COMPANY_FILE"."PRODUCTION_CHART" IS '产品生产流程图';
COMMENT ON COLUMN "T_BASE_COMPANY_FILE"."BUSINESS_LICENCE" IS '营业执照';
COMMENT ON COLUMN "T_BASE_COMPANY_FILE"."TAX_CERT" IS '税务登记证';
COMMENT ON COLUMN "T_BASE_COMPANY_FILE"."ORGANZATION_CERT" IS '组织架构证';
COMMENT ON COLUMN "T_BASE_COMPANY_FILE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_COMPANY_FILE"."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN "T_BASE_COMPANY_FILE"."IS_ENABLE" IS '记录是否可用（0=不可用，1=可用）';
COMMENT ON COLUMN "T_BASE_COMPANY_FILE"."FINISH_FLAG" IS '完成标识符(0=未完成，1=已完成)';
COMMENT ON COLUMN "T_BASE_COMPANY_FILE"."CERTIFICATE" IS '三证合一';
COMMENT ON TABLE "T_BASE_COMPANY_FILE" IS '供应商准入--附件';
ALTER TABLE "T_BASE_COMPANY_FILE" ADD CONSTRAINT "SYS_C0034708" PRIMARY KEY ("ID");

-- ----------------------------
-- 专利，专有技术，许可
-- ----------------------------
DROP TABLE "T_BASE_COMPANY_PATENTS";
CREATE TABLE "T_BASE_COMPANY_PATENTS" (
  "ID" VARCHAR2(32 BYTE) DEFAULT '' NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 BYTE) DEFAULT '' ,
  "SUP_COMPANY_ID" VARCHAR2(32 BYTE) DEFAULT '' ,
  "PATENT_CODE" VARCHAR2(255 BYTE) DEFAULT '' ,
  "PATENT_NAME" VARCHAR2(255 BYTE) DEFAULT '' ,
  "PATENT_ORGANIZATION" VARCHAR2(255 BYTE) DEFAULT '' ,
  "PATENT_DESC" VARCHAR2(1000 BYTE) DEFAULT '' ,
  "START_TIME" DATE ,
  "END_TIME" DATE ,
  "PATENT_VALUE" VARCHAR2(1000 BYTE) ,
  "REMARK" VARCHAR2(1000 BYTE) DEFAULT '' ,
  "FINISH_FLAG" NUMBER(7) DEFAULT 0   ,
  "IS_ENABLE" NUMBER(7) DEFAULT 1   ,
  "CREATE_TIME" DATE ,
  "UPDATE_TIME" DATE ,
  "PATENT_FILE" CLOB ,
  "TECHNICIAN_NUMBER" NUMBER(38) ,
  "TECHNICIAN_DEGREE" VARCHAR2(255 BYTE) ,
  "PRODUCTION_PROCESS" VARCHAR2(255 BYTE) ,
  "FEEDING_RATIO" VARCHAR2(255 BYTE) ,
  "EQUIPMENT_INTRODUCED" VARCHAR2(255 BYTE) ,
  "PRODUCTION_EQUIPMENT" VARCHAR2(255 BYTE) ,
  "RAW_MATERIAL" VARCHAR2(255 BYTE) ,
  "OTHER_PRODUCTS" VARCHAR2(255 BYTE) ,
  "PATENT_APPLY" VARCHAR2(255 BYTE) ,
  "DEVELOPMENT_PROCESS" VARCHAR2(255 BYTE) ,
  "TECHNOLOGY_INTRODUCED" VARCHAR2(255 BYTE) 
);
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."ID" IS 'ID';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."PATENT_CODE" IS '专利代码';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."PATENT_NAME" IS '专利名称';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."PATENT_ORGANIZATION" IS '专利授予机构';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."PATENT_DESC" IS '专利使用的地方';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."START_TIME" IS '专利开始时间';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."END_TIME" IS '专利有效截止时间';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."PATENT_VALUE" IS '专利价值';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."FINISH_FLAG" IS '完成标识符(0=未完成，1=已完成)';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."PATENT_FILE" IS '专利文件';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."TECHNICIAN_NUMBER" IS '技术研发人员人数';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."TECHNICIAN_DEGREE" IS '技术人员学历';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."PRODUCTION_PROCESS" IS '拟供应包材的生产工艺';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."FEEDING_RATIO" IS '拟供应包材投料配比';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."EQUIPMENT_INTRODUCED" IS '包材检测设备介绍';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."PRODUCTION_EQUIPMENT" IS '拟供应包材的生产设备及型号';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."RAW_MATERIAL" IS '拟供应包材所用原料及型号';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."OTHER_PRODUCTS" IS '能够生产的其他产品';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."PATENT_APPLY" IS '专利申请或技术创新情况说明';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."DEVELOPMENT_PROCESS" IS '新产品开发流程介绍';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."TECHNOLOGY_INTRODUCED" IS '创新型、领先型技术介绍';
COMMENT ON TABLE "T_BASE_COMPANY_PATENTS" IS '专利，专有技术，许可';
ALTER TABLE "T_BASE_COMPANY_PATENTS" ADD CONSTRAINT "SYS_C0034729" PRIMARY KEY ("ID");

-- ----------------------------
-- 供应商准入-关键生产设备
-- ----------------------------
DROP TABLE "T_BASE_COMPANY_PRODUCT_DEVICE";
CREATE TABLE "T_BASE_COMPANY_PRODUCT_DEVICE" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 BYTE) ,
  "PUR_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) ,
  "PUR_COMPANY_NAME" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_NAME" VARCHAR2(255 BYTE) ,
  "DEVICE_NAME" VARCHAR2(255 BYTE) ,
  "ORIGIN" VARCHAR2(255 BYTE) ,
  "PRODUCER" VARCHAR2(255 BYTE) ,
  "DESCRIPTION" VARCHAR2(255 BYTE) ,
  "DEVICE_PRODUCE_TIME" DATE ,
  "QUANTITY" NUMBER(20,2) DEFAULT 0   ,
  "PURCHASE_PLAN" VARCHAR2(255 BYTE) ,
  "IS_ENABLE" NUMBER(7) DEFAULT 1   ,
  "FINISH_FLAG" NUMBER(7) DEFAULT 0   ,
  "CREATE_TIME" DATE DEFAULT SYSDATE   ,
  "UPDATE_TIME" DATE ,
  "OPERATION_TYPE" NUMBER(7) 
);
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_DEVICE"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_DEVICE"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_DEVICE"."PUR_COMPANY_ID" IS '采购商公司ID';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_DEVICE"."PUR_COMPANY_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_DEVICE"."PUR_COMPANY_NAME" IS '采购商名称';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_DEVICE"."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_DEVICE"."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_DEVICE"."SUP_COMPANY_NAME" IS '供应商名称';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_DEVICE"."DEVICE_NAME" IS '设备名称/型号';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_DEVICE"."ORIGIN" IS '产地';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_DEVICE"."PRODUCER" IS '生产商';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_DEVICE"."DESCRIPTION" IS '技术指标或优势简述';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_DEVICE"."DEVICE_PRODUCE_TIME" IS '设备生产时间';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_DEVICE"."QUANTITY" IS '数量';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_DEVICE"."PURCHASE_PLAN" IS '同级设备购买计划';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_DEVICE"."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_DEVICE"."FINISH_FLAG" IS '完成标识符(0=未完成，1=已完成)';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_DEVICE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_DEVICE"."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_DEVICE"."OPERATION_TYPE" IS '设备目前是否运作(0,是 1，否)';
COMMENT ON TABLE "T_BASE_COMPANY_PRODUCT_DEVICE" IS '供应商准入-关键生产设备';

-- ----------------------------
-- 供应商准入--生产情况
-- ----------------------------
DROP TABLE "T_BASE_COMPANY_PRODUCTION";
CREATE TABLE "T_BASE_COMPANY_PRODUCTION" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 BYTE) ,
  "PUR_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) ,
  "PUR_COMPANY_NAME" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_NAME" VARCHAR2(255 BYTE) ,
  "PLANT_AREA" NUMBER(16,2) ,
  "WAREHOUSE_AREA" NUMBER(16,2) ,
  "PRODUCT_ORDER_CYCLE" VARCHAR2(40 BYTE) ,
  "TRAVELING_TIME" VARCHAR2(255 BYTE) ,
  "FREIGHT" NUMBER(16,2) ,
  "WORKING_HOURS" VARCHAR2(255 BYTE) ,
  "VACATION" VARCHAR2(255 BYTE) ,
  "CREATE_TIME" DATE ,
  "UPDATE_TIME" DATE ,
  "FINISH_FLAG" NUMBER(7) DEFAULT 0   
);
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCTION"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCTION"."PUR_COMPANY_ID" IS '采购商公司ID';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCTION"."PUR_COMPANY_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCTION"."PUR_COMPANY_NAME" IS '采购商名称';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCTION"."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCTION"."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCTION"."SUP_COMPANY_NAME" IS '供应商名称';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCTION"."PLANT_AREA" IS '厂房面积';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCTION"."WAREHOUSE_AREA" IS '仓库面积';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCTION"."PRODUCT_ORDER_CYCLE" IS '产品订单周期';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCTION"."TRAVELING_TIME" IS '在途时间';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCTION"."FREIGHT" IS '运费';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCTION"."WORKING_HOURS" IS '工时/班次';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCTION"."VACATION" IS '假期';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCTION"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCTION"."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCTION"."FINISH_FLAG" IS '完成标识符(0=未完成，1=已完成)';
COMMENT ON TABLE "T_BASE_COMPANY_PRODUCTION" IS '供应商准入--生产情况';
ALTER TABLE "T_BASE_COMPANY_PRODUCTION" ADD CONSTRAINT "SYS_C0034676" PRIMARY KEY ("ID");

-- ----------------------------
-- 供应商准入--质量管理
-- ----------------------------
DROP TABLE "T_BASE_COMPANY_QUALITY";
CREATE TABLE "T_BASE_COMPANY_QUALITY" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "PLANT_AREA" NUMBER(11,2) ,
  "WAREHOUSE_AREA" NUMBER(11,2) ,
  "QUALITY_INSPECTOR_NUMBER" NUMBER(11) ,
  "ISO9001NAME_TYPE" NUMBER(11) ,
  "THROUGH_YEAR" DATE ,
  "SYSTEM_KIND" VARCHAR2(255 BYTE) ,
  "QUALITY_CERTIFICATION" NUMBER(11) ,
  "QUALITY_SOFTWARE" NUMBER(11) ,
  "ADOPTED_SYSTEM" VARCHAR2(255 BYTE) ,
  "FINAL_DECISION" NUMBER(11) ,
  "QUALITY_COMMITMENT" NUMBER(11) ,
  "QUALITY_OBJECTIVES" NUMBER(11) ,
  "QUALITY_AWARD" NUMBER(11) ,
  "TRAINING_PROGRAM" NUMBER(11) ,
  "TRAINING_PLAN" NUMBER(11) ,
  "TRAINING_APPRAISAL" NUMBER(11) ,
  "TRAINING_RECORDS" NUMBER(11) ,
  "QUALITY_MANUAL" NUMBER(11) ,
  "FILE_TRAINING" NUMBER(11) ,
  "CONTROLLED_MANAGEMENT" NUMBER(11) ,
  "REGULAR_REVIEW" NUMBER(11) ,
  "STANDARD_MANAGEMENT" NUMBER(11) ,
  "STANDARD_RECORD" NUMBER(11) ,
  "STANDARD_CONTERLLED" NUMBER(11) ,
  "PRODUCTION_EQUIPMENT" NUMBER(11) ,
  "EQUIPMENT_ARCHIVES" NUMBER(11) ,
  "EQUIPMENT_MAINTENANCE" NUMBER(11) ,
  "WORKSHOP_CLOSED" NUMBER(11) ,
  "PEST_CONTROL_PROCEDURE" NUMBER(11) ,
  "PEST_CONTROL_FACILITIES" NUMBER(11) ,
  "PEST_CONTROL_RECORD" NUMBER(11) ,
  "PROTECTIVE_CLOTHING_HATS" NUMBER(11) ,
  "BATCH_RECORD" NUMBER(11) ,
  "SWITCHING_REQUIREMENTS" NUMBER(11) ,
  "WORK_INSTRUCTIONS" NUMBER(11) ,
  "PROCESS_CORD" NUMBER(11) ,
  "PROCESS_PARAMETER_RECORD" NUMBER(11) ,
  "CLEAR_STANDARD" NUMBER(11) ,
  "DETECTION_EQUIPMENT_LISTING" NUMBER(11) ,
  "EQUIPMENT_CALIBRATION" NUMBER(11) ,
  "EXCEPTION_HANDLER" NUMBER(11) ,
  "PROCESSING_RECORDS" NUMBER(11) ,
  "QUALITY_STATISTICS" NUMBER(11) ,
  "MANAGE_FILES" NUMBER(11) ,
  "DIVIDE_AREA" NUMBER(11) ,
  "INSPECTION_RECORD" NUMBER(11) ,
  "SUPPLIER_PROCEDURES" NUMBER(11) ,
  "QUALIFIED_SUPPLIERLIST" NUMBER(11) ,
  "SUPPLIERQUALITY_ASSESSMENT" NUMBER(11) ,
  "INTERNAL_AUDIT" NUMBER(11) ,
  "INTERNAL_RECORD" NUMBER(11) ,
  "CUSTOMER_COMPLAINT" NUMBER(11) ,
  "PERIODIC_TRACKING" NUMBER(11) ,
  "QUALITY_ANALYSIS_RECORD" NUMBER(11) ,
  "CREATE_TIME" DATE ,
  "UPDATE_TIME" DATE ,
  "PROJECT_ID" VARCHAR2(32 BYTE) ,
  "PUR_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) ,
  "PUR_COMPANY_NAME" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_NAME" VARCHAR2(255 BYTE) ,
  "FINISH_FLAG" NUMBER(7) DEFAULT 0   ,
  "IS_ENABLE" NUMBER(7) DEFAULT 1   
);
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."PLANT_AREA" IS '厂房面积';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."WAREHOUSE_AREA" IS '仓库面积';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."QUALITY_INSPECTOR_NUMBER" IS '专职质量管理人员人数';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."ISO9001NAME_TYPE" IS '是否通过ISO9001质量体系认证(1-是；2-否)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."THROUGH_YEAR" IS '哪年通过';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."SYSTEM_KIND" IS '采用何种质量体系';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."QUALITY_CERTIFICATION" IS '是否通过其他质量认证(1-是；2-否)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."QUALITY_SOFTWARE" IS '是否有质量软件系统(1-是；2-否)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."ADOPTED_SYSTEM" IS '采用的系统';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."FINAL_DECISION" IS '对产品/材料发放或拒绝决定(1-是；2-否)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."QUALITY_COMMITMENT" IS '质量承诺(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."QUALITY_OBJECTIVES" IS '质量目标(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."QUALITY_AWARD" IS '质量奖励(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."TRAINING_PROGRAM" IS '培训程序(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."TRAINING_PLAN" IS '培训计划(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."TRAINING_APPRAISAL" IS '培训考核(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."TRAINING_RECORDS" IS '培训档案(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."QUALITY_MANUAL" IS '质量手册(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."FILE_TRAINING" IS '文件培训(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."CONTROLLED_MANAGEMENT" IS '受控管理(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."REGULAR_REVIEW" IS '定期回顾(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."STANDARD_MANAGEMENT" IS '技术标准管理程序(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."STANDARD_RECORD" IS '标准记录(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."STANDARD_CONTERLLED" IS '标准受控管理';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."PRODUCTION_EQUIPMENT" IS '生产设备台帐(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."EQUIPMENT_ARCHIVES" IS '设备档案(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."EQUIPMENT_MAINTENANCE" IS '设备定期维护保养(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."WORKSHOP_CLOSED" IS '车间为封闭式(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."PEST_CONTROL_PROCEDURE" IS '虫害控制程序(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."PEST_CONTROL_FACILITIES" IS '虫害控制设施(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."PEST_CONTROL_RECORD" IS '虫害控制记录(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."PROTECTIVE_CLOTHING_HATS" IS '配备防护衣帽(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."BATCH_RECORD" IS '关键工序配料/投料记录(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."SWITCHING_REQUIREMENTS" IS '系统切换控制/产品要求(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."WORK_INSTRUCTIONS" IS '生产作业指导书(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."PROCESS_CORD" IS '工序工艺卡(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."PROCESS_PARAMETER_RECORD" IS '工艺参数记录(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."CLEAR_STANDARD" IS '明确的标准(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."DETECTION_EQUIPMENT_LISTING" IS '检测设备清单(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."EQUIPMENT_CALIBRATION" IS '计量仪器定期检定/校正(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."EXCEPTION_HANDLER" IS '不合格或异常处理程序(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."PROCESSING_RECORDS" IS '不合格品处理记录(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."QUALITY_STATISTICS" IS '定期质量数据统计与分析(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."MANAGE_FILES" IS '仓储管理规定/文件(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."DIVIDE_AREA" IS '划分不合格品区、中转区、合格品区(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."INSPECTION_RECORD" IS '货车检查记录(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."SUPPLIER_PROCEDURES" IS '供应商管理程序(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."QUALIFIED_SUPPLIERLIST" IS '合格供应商清单(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."SUPPLIERQUALITY_ASSESSMENT" IS '供应商质量考核(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."INTERNAL_AUDIT" IS '内部质量审核(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."INTERNAL_RECORD" IS '内审记录(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."CUSTOMER_COMPLAINT" IS '客户投诉系统(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."PERIODIC_TRACKING" IS '定期跟踪衡量指标(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."QUALITY_ANALYSIS_RECORD" IS '质量分析记录(1-有；2-无)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."PUR_COMPANY_ID" IS '采购商公司ID';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."PUR_COMPANY_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."PUR_COMPANY_NAME" IS '采购商名称';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."SUP_COMPANY_NAME" IS '供应商名称';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."FINISH_FLAG" IS '完成标识符(0=未完成，1=已完成)';
COMMENT ON COLUMN "T_BASE_COMPANY_QUALITY"."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';
COMMENT ON TABLE "T_BASE_COMPANY_QUALITY" IS '供应商准入--质量管理';
ALTER TABLE "T_BASE_COMPANY_QUALITY" ADD CONSTRAINT "SYS_C0034674" PRIMARY KEY ("ID");

-- ----------------------------
-- 供应商准入-证书到期提醒
-- ----------------------------
DROP TABLE "T_BASE_SUP_CERTIFICATE_EXPIRY";
CREATE TABLE "T_BASE_SUP_CERTIFICATE_EXPIRY" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "PUR_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) ,
  "PUR_USER_ID" VARCHAR2(255 BYTE) ,
  "PUR_COMPANY_NAME" VARCHAR2(255 BYTE) ,
  "CLASSIFICATION_CODE" VARCHAR2(255 BYTE) ,
  "CLASSIFICATION_NAME" VARCHAR2(255 BYTE) ,
  "IS_ENABLE_REMINDERS" VARCHAR2(255 BYTE) ,
  "ADVANCE_REMINDER_DAYS" NUMBER(10) ,
  "REMARK" VARCHAR2(255 BYTE) ,
  "FOUNDER" VARCHAR2(255 BYTE) ,
  "CREATE_TIME" DATE ,
  "UPDATE_TIME" DATE ,
  "IS_ENABLE" NUMBER(10) 
);
COMMENT ON COLUMN "T_BASE_SUP_CERTIFICATE_EXPIRY"."PUR_COMPANY_ID" IS '采购商ID';
COMMENT ON COLUMN "T_BASE_SUP_CERTIFICATE_EXPIRY"."PUR_COMPANY_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN "T_BASE_SUP_CERTIFICATE_EXPIRY"."PUR_USER_ID" IS '采购商用户ID';
COMMENT ON COLUMN "T_BASE_SUP_CERTIFICATE_EXPIRY"."PUR_COMPANY_NAME" IS '采购商名称';
COMMENT ON COLUMN "T_BASE_SUP_CERTIFICATE_EXPIRY"."CLASSIFICATION_CODE" IS '分类编码';
COMMENT ON COLUMN "T_BASE_SUP_CERTIFICATE_EXPIRY"."CLASSIFICATION_NAME" IS '分类名称';
COMMENT ON COLUMN "T_BASE_SUP_CERTIFICATE_EXPIRY"."IS_ENABLE_REMINDERS" IS '是否启用提醒（1启用，0未启用）';
COMMENT ON COLUMN "T_BASE_SUP_CERTIFICATE_EXPIRY"."ADVANCE_REMINDER_DAYS" IS '提前提醒天数';
COMMENT ON COLUMN "T_BASE_SUP_CERTIFICATE_EXPIRY"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_SUP_CERTIFICATE_EXPIRY"."FOUNDER" IS '创建人';
COMMENT ON COLUMN "T_BASE_SUP_CERTIFICATE_EXPIRY"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_SUP_CERTIFICATE_EXPIRY"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_BASE_SUP_CERTIFICATE_EXPIRY"."IS_ENABLE" IS '数据是否可用（1可用，0不可用）';
COMMENT ON TABLE "T_BASE_SUP_CERTIFICATE_EXPIRY" IS '供应商准入-证书到期提醒';
ALTER TABLE "T_BASE_SUP_CERTIFICATE_EXPIRY" ADD CONSTRAINT "SYS_C0043054" PRIMARY KEY ("ID");

-- ----------------------------
-- 供应商准入-准入流程
-- ----------------------------
DROP TABLE "T_BASE_SUP_CERTIFICATION_FLOW";
CREATE TABLE "T_BASE_SUP_CERTIFICATION_FLOW" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "COMPANY_ID" VARCHAR2(32 BYTE) ,
  "COMPANY_SRM_CODE" VARCHAR2(255 BYTE) ,
  "PROCESS_NAME" VARCHAR2(255 BYTE) ,
  "ACCESS_PROCESS" VARCHAR2(255 BYTE) ,
  "QUALIFICATION_AUDIT" VARCHAR2(255 BYTE) ,
  "SCENE_INVESTIGATE" VARCHAR2(255 BYTE) ,
  "IS_ENABLE" NUMBER(10) ,
  "UPDATE_TIME" DATE ,
  "CREATE_TIME" DATE ,
  "QUALIFICATION_AUDITTEMPLATE_ID" VARCHAR2(255 BYTE) ,
  "SITE_INSPECTION_TEMPLATE_ID" VARCHAR2(255 BYTE) ,
  "IS_SEND" NUMBER(10) ,
  "SUPPLIER_LEVEL_CODE" VARCHAR2(255 BYTE) ,
  "SUP_CLASSIFICATION_NAME" VARCHAR2(255 BYTE) ,
  "PROCESS_ID" VARCHAR2(32 BYTE) 
);
COMMENT ON COLUMN "T_BASE_SUP_CERTIFICATION_FLOW"."COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_BASE_SUP_CERTIFICATION_FLOW"."COMPANY_SRM_CODE" IS '供应商srm编码';
COMMENT ON COLUMN "T_BASE_SUP_CERTIFICATION_FLOW"."PROCESS_NAME" IS '准入流程名称';
COMMENT ON COLUMN "T_BASE_SUP_CERTIFICATION_FLOW"."ACCESS_PROCESS" IS '准入流程';
COMMENT ON COLUMN "T_BASE_SUP_CERTIFICATION_FLOW"."QUALIFICATION_AUDIT" IS '资质审核';
COMMENT ON COLUMN "T_BASE_SUP_CERTIFICATION_FLOW"."SCENE_INVESTIGATE" IS '现场考察';
COMMENT ON COLUMN "T_BASE_SUP_CERTIFICATION_FLOW"."IS_ENABLE" IS '是否可用(1为可用，0为不可用)';
COMMENT ON COLUMN "T_BASE_SUP_CERTIFICATION_FLOW"."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN "T_BASE_SUP_CERTIFICATION_FLOW"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_SUP_CERTIFICATION_FLOW"."QUALIFICATION_AUDITTEMPLATE_ID" IS '资质审核模版ID';
COMMENT ON COLUMN "T_BASE_SUP_CERTIFICATION_FLOW"."SITE_INSPECTION_TEMPLATE_ID" IS '现场考察模版ID';
COMMENT ON COLUMN "T_BASE_SUP_CERTIFICATION_FLOW"."IS_SEND" IS '是否已发送（1已发送，0未发送）';
COMMENT ON COLUMN "T_BASE_SUP_CERTIFICATION_FLOW"."SUPPLIER_LEVEL_CODE" IS '供应商分类编码';
COMMENT ON COLUMN "T_BASE_SUP_CERTIFICATION_FLOW"."SUP_CLASSIFICATION_NAME" IS '供应商分类名';
COMMENT ON COLUMN "T_BASE_SUP_CERTIFICATION_FLOW"."PROCESS_ID" IS '准入流程ID';
COMMENT ON TABLE "T_BASE_SUP_CERTIFICATION_FLOW" IS '供应商准入-准入流程';
ALTER TABLE "T_BASE_SUP_CERTIFICATION_FLOW" ADD CONSTRAINT "SYS_C0043062" PRIMARY KEY ("ID");

-- ----------------------------
-- 流程管理
-- ----------------------------
DROP TABLE "T_BASE_SUP_PROCESS_MANAGEMENT";
CREATE TABLE "T_BASE_SUP_PROCESS_MANAGEMENT" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "PUR_USER_ID" VARCHAR2(32 BYTE) ,
  "PUR_COMPANY_NAME" VARCHAR2(255 BYTE) ,
  "PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) ,
  "PROCESS_NUMBER" VARCHAR2(255 BYTE) ,
  "PROCESS_NAME" VARCHAR2(255 BYTE) ,
  "SUP_CLASSIFICATION_NAME" VARCHAR2(255 BYTE) ,
  "REMARK" VARCHAR2(255 BYTE) ,
  "ACCESS_PROCESS" VARCHAR2(255 BYTE) ,
  "QUALIFICATION_AUDIT_TEMPLATE" VARCHAR2(255 BYTE) ,
  "SITE_INSPECTION_TEMPLATE" VARCHAR2(255 BYTE) ,
  "SINGLE_PERSON" VARCHAR2(255 BYTE) ,
  "QUALIFICATION_AUDITTEMPLATE_ID" VARCHAR2(32 BYTE) ,
  "SITE_INSPECTION_TEMPLATE_ID" VARCHAR2(32 BYTE) ,
  "IS_ENABLE" NUMBER(10) ,
  "CREATE_TIME" DATE ,
  "UPDATE_TIME" DATE ,
  "SUPPLIER_LEVEL_CODE" VARCHAR2(255 BYTE) 
);
COMMENT ON COLUMN "T_BASE_SUP_PROCESS_MANAGEMENT"."PUR_USER_ID" IS '采购商用户ID';
COMMENT ON COLUMN "T_BASE_SUP_PROCESS_MANAGEMENT"."PUR_COMPANY_NAME" IS '采购商名称';
COMMENT ON COLUMN "T_BASE_SUP_PROCESS_MANAGEMENT"."PUR_COMPANY_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN "T_BASE_SUP_PROCESS_MANAGEMENT"."PROCESS_NUMBER" IS '流程编号';
COMMENT ON COLUMN "T_BASE_SUP_PROCESS_MANAGEMENT"."PROCESS_NAME" IS '流程名称';
COMMENT ON COLUMN "T_BASE_SUP_PROCESS_MANAGEMENT"."SUP_CLASSIFICATION_NAME" IS '供应商分类名';
COMMENT ON COLUMN "T_BASE_SUP_PROCESS_MANAGEMENT"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_SUP_PROCESS_MANAGEMENT"."ACCESS_PROCESS" IS '准入流程';
COMMENT ON COLUMN "T_BASE_SUP_PROCESS_MANAGEMENT"."QUALIFICATION_AUDIT_TEMPLATE" IS '资质审核模版名称';
COMMENT ON COLUMN "T_BASE_SUP_PROCESS_MANAGEMENT"."SITE_INSPECTION_TEMPLATE" IS '现场考察模版名称';
COMMENT ON COLUMN "T_BASE_SUP_PROCESS_MANAGEMENT"."SINGLE_PERSON" IS '创建人';
COMMENT ON COLUMN "T_BASE_SUP_PROCESS_MANAGEMENT"."QUALIFICATION_AUDITTEMPLATE_ID" IS '资质审核模版ID';
COMMENT ON COLUMN "T_BASE_SUP_PROCESS_MANAGEMENT"."SITE_INSPECTION_TEMPLATE_ID" IS '现场考察模版ID';
COMMENT ON COLUMN "T_BASE_SUP_PROCESS_MANAGEMENT"."IS_ENABLE" IS '是否可用(1为可用，0为不可用)';
COMMENT ON COLUMN "T_BASE_SUP_PROCESS_MANAGEMENT"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_SUP_PROCESS_MANAGEMENT"."UPDATE_TIME" IS '供应商分类编码';
COMMENT ON TABLE "T_BASE_SUP_PROCESS_MANAGEMENT" IS '流程管理';
ALTER TABLE "T_BASE_SUP_PROCESS_MANAGEMENT" ADD CONSTRAINT "SYS_C0043060" PRIMARY KEY ("ID");

-- ----------------------------
-- 供应商准入-资质审核单
-- ----------------------------
DROP TABLE "T_BASE_SUP_QUALIFICATION";
CREATE TABLE "T_BASE_SUP_QUALIFICATION" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "SUP_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_NAME" VARCHAR2(255 BYTE) ,
  "SUP_CONTACTS" VARCHAR2(255 BYTE) ,
  "ADDRESS" VARCHAR2(255 BYTE) ,
  "DOCUMENT_NO" VARCHAR2(32 BYTE) ,
  "DOCUMENT_STATUS" VARCHAR2(255 BYTE) ,
  "SINGLE_PERSON" VARCHAR2(255 BYTE) ,
  "REMARKS" VARCHAR2(255 BYTE) ,
  "CREATE_TIME" DATE ,
  "UPDATE_TIME" DATE ,
  "IS_ENABLE" NUMBER(10) ,
  "PUR_FILE_EXPLAIN" VARCHAR2(255 BYTE) ,
  "SUP_EXPLAIN" VARCHAR2(255 BYTE) ,
  "PUR_COMPANY_USER_ID" VARCHAR2(32 BYTE) ,
  "SUP_COMPANY_USER_ID" VARCHAR2(32 BYTE) ,
  "PUR_COMPANY_NAME" VARCHAR2(255 BYTE) ,
  "PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) 
);
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION"."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION"."SUP_COMPANY_SRM_CODE" IS '供应商srm编码';
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION"."SUP_COMPANY_NAME" IS '供应商名称';
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION"."SUP_CONTACTS" IS '供应商联系人';
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION"."ADDRESS" IS '地址';
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION"."DOCUMENT_NO" IS '单据号';
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION"."DOCUMENT_STATUS" IS '单据状态';
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION"."SINGLE_PERSON" IS '制单人';
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION"."REMARKS" IS '备注';
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION"."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION"."IS_ENABLE" IS '是否可用(1为可用，0为不可用)';
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION"."PUR_FILE_EXPLAIN" IS '采购方审核文件说明';
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION"."SUP_EXPLAIN" IS '供应商说明';
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION"."PUR_COMPANY_USER_ID" IS '采购商用户ID';
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION"."SUP_COMPANY_USER_ID" IS '供应商用户ID';
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION"."PUR_COMPANY_NAME" IS '采购公司简称';
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION"."PUR_COMPANY_SRM_CODE" IS '采购公司SRM编码';
COMMENT ON TABLE "T_BASE_SUP_QUALIFICATION" IS '供应商准入-资质审核单';
ALTER TABLE "T_BASE_SUP_QUALIFICATION" ADD CONSTRAINT "SYS_C0043066" PRIMARY KEY ("ID");

-- ----------------------------
-- 供应商准入-资质审核单附件
-- ----------------------------
DROP TABLE "T_BASE_SUP_QUALIFICATION_ITEM";
CREATE TABLE "T_BASE_SUP_QUALIFICATION_ITEM" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "QUALIFICATION_REVIEW_ID" VARCHAR2(32 BYTE) ,
  "PUR_FILE" VARCHAR2(4000 BYTE) ,
  "PUR_FILE_NAME" VARCHAR2(255 BYTE) ,
  "PUR_UPLOAD_TIME" DATE ,
  "PUR_REMARKS" VARCHAR2(255 BYTE) ,
  "PUR_FILE_EXPLAIN" VARCHAR2(255 BYTE) ,
  "SUP_FILE" VARCHAR2(4000 BYTE) ,
  "SUP_FILE_NAME" VARCHAR2(255 BYTE) ,
  "SUP_UPLOAD_TIME" DATE ,
  "SUP_REMARKS" VARCHAR2(255 BYTE) ,
  "SUP_EXPLAIN" VARCHAR2(255 BYTE) ,
  "SORT_NUMBER" NUMBER(10) ,
  "CREATE_TIME" DATE ,
  "UPDATE_TIME" DATE ,
  "COMPANY_TYPE" NUMBER(10) 
);
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION_ITEM"."QUALIFICATION_REVIEW_ID" IS '资质审核表ID';
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION_ITEM"."PUR_FILE" IS '采购方上传的文件';
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION_ITEM"."PUR_FILE_NAME" IS '采购方上传的文件名称';
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION_ITEM"."PUR_UPLOAD_TIME" IS '采购方上传文件的时间';
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION_ITEM"."PUR_REMARKS" IS '采购方备注';
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION_ITEM"."PUR_FILE_EXPLAIN" IS '采购方审核文件说明';
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION_ITEM"."SUP_FILE" IS '供应商上传的文件';
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION_ITEM"."SUP_FILE_NAME" IS '供应商上传的文件名称';
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION_ITEM"."SUP_UPLOAD_TIME" IS '供应商上传文件时间';
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION_ITEM"."SUP_REMARKS" IS '供应商备注';
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION_ITEM"."SUP_EXPLAIN" IS '供应商说明';
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION_ITEM"."SORT_NUMBER" IS '排序号';
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION_ITEM"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION_ITEM"."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN "T_BASE_SUP_QUALIFICATION_ITEM"."COMPANY_TYPE" IS '公司类型(0为采购商，1为供应商)';
COMMENT ON TABLE "T_BASE_SUP_QUALIFICATION_ITEM" IS '供应商准入-资质审核单附件';
ALTER TABLE "T_BASE_SUP_QUALIFICATION_ITEM" ADD CONSTRAINT "SYS_C0043064" PRIMARY KEY ("ID");

-- ----------------------------
-- 供应商准入-到期提醒供应商信息
-- ----------------------------
DROP TABLE "T_BASE_SUP_REMIND_INFO";
CREATE TABLE "T_BASE_SUP_REMIND_INFO" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "SUP_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "SUP_COMPANY_NAME" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) ,
  "CERTIFICATE_TYPE_CODE" VARCHAR2(255 BYTE) ,
  "CERTIFICATE_NAME" VARCHAR2(255 BYTE) ,
  "END_TIME" DATE ,
  "IS_ENABLE" NUMBER(10) DEFAULT 1   ,
  "CREATE_TIME" DATE ,
  "UPDATE_TIME" DATE ,
  "STATUS" NUMBER(10) 
);
COMMENT ON TABLE "T_BASE_SUP_REMIND_INFO" IS '供应商准入-到期提醒供应商信息';
ALTER TABLE "T_BASE_SUP_REMIND_INFO" ADD CONSTRAINT "SYS_C0043075" PRIMARY KEY ("ID");

-- ----------------------------
-- 供应商分类管理
-- ----------------------------
DROP TABLE "T_BASE_SUPPLIER_CATEGORY";
CREATE TABLE "T_BASE_SUPPLIER_CATEGORY" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 BYTE) ,
  "PUR_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "COMPANY_CATEGORY" VARCHAR2(255 BYTE) ,
  "CATEGORY_CODE" VARCHAR2(255 BYTE) ,
  "PARENT_ID" VARCHAR2(32 BYTE) ,
  "IS_ENABLE" NUMBER(10) ,
  "UPDATE_TIME" DATE ,
  "CREATE_TIME" DATE 
);
COMMENT ON COLUMN "T_BASE_SUPPLIER_CATEGORY"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_SUPPLIER_CATEGORY"."PUR_COMPANY_ID" IS '采购商id';
COMMENT ON COLUMN "T_BASE_SUPPLIER_CATEGORY"."COMPANY_CATEGORY" IS '分类名称';
COMMENT ON COLUMN "T_BASE_SUPPLIER_CATEGORY"."CATEGORY_CODE" IS '分类编码';
COMMENT ON COLUMN "T_BASE_SUPPLIER_CATEGORY"."PARENT_ID" IS '上级编号';
COMMENT ON COLUMN "T_BASE_SUPPLIER_CATEGORY"."IS_ENABLE" IS '软删除';
COMMENT ON TABLE "T_BASE_SUPPLIER_CATEGORY" IS '供应商分类管理';
ALTER TABLE "T_BASE_SUPPLIER_CATEGORY" ADD CONSTRAINT "SYS_C0043096" PRIMARY KEY ("ID");

-- ----------------------------
-- 资质审核与现场考察模版
-- ----------------------------
DROP TABLE "T_BASE_SUPPLIER_QCM";
CREATE TABLE "T_BASE_SUPPLIER_QCM" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 BYTE) ,
  "TEMPLAT_CODE" VARCHAR2(32 BYTE) ,
  "TEMPLAT_NAME" VARCHAR2(255 BYTE) ,
  "SUPPLIER_LEVEL" VARCHAR2(255 BYTE) ,
  "AUDIT_STATEMENT" VARCHAR2(255 BYTE) ,
  "TEMPLATE_REMARK" VARCHAR2(255 BYTE) ,
  "ESTABLISH_NAME" VARCHAR2(255 BYTE) ,
  "TEMPLATE_CATEGORY" VARCHAR2(255 BYTE) ,
  "UPDATE_TIME" DATE ,
  "CREATE_TIME" DATE ,
  "IS_ENABLE" NUMBER(10) ,
  "SUPPLIER_LEVEL_CODE" VARCHAR2(255 BYTE) ,
  "IS_USABLE" NUMBER(10) 
);
COMMENT ON COLUMN "T_BASE_SUPPLIER_QCM"."TEMPLAT_CODE" IS '模板编号';
COMMENT ON COLUMN "T_BASE_SUPPLIER_QCM"."TEMPLAT_NAME" IS '模板名字';
COMMENT ON COLUMN "T_BASE_SUPPLIER_QCM"."SUPPLIER_LEVEL" IS '供应商分类';
COMMENT ON COLUMN "T_BASE_SUPPLIER_QCM"."AUDIT_STATEMENT" IS '文件说明';
COMMENT ON COLUMN "T_BASE_SUPPLIER_QCM"."TEMPLATE_REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_SUPPLIER_QCM"."ESTABLISH_NAME" IS '创建模板人';
COMMENT ON COLUMN "T_BASE_SUPPLIER_QCM"."TEMPLATE_CATEGORY" IS '模板类别（区别资质审核模版或现场考察模版）';
COMMENT ON COLUMN "T_BASE_SUPPLIER_QCM"."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN "T_BASE_SUPPLIER_QCM"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_SUPPLIER_QCM"."IS_ENABLE" IS '是否可用';
COMMENT ON COLUMN "T_BASE_SUPPLIER_QCM"."SUPPLIER_LEVEL_CODE" IS '供应商分类编码';
COMMENT ON COLUMN "T_BASE_SUPPLIER_QCM"."IS_USABLE" IS '数据是否启用（0不启用，1启用）';
COMMENT ON TABLE "T_BASE_SUPPLIER_QCM" IS '资质审核与现场考察模版';
ALTER TABLE "T_BASE_SUPPLIER_QCM" ADD CONSTRAINT "SYS_C0043058" PRIMARY KEY ("ID");

-- ----------------------------
-- 资质审核与现场考察模版文件保存表
-- ----------------------------
DROP TABLE "T_BASE_SUPPLIER_QCM_F";
CREATE TABLE "T_BASE_SUPPLIER_QCM_F" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 BYTE) ,
  "TEMPLAT_ID" VARCHAR2(32 BYTE) ,
  "DOCUMENT_TEXT" VARCHAR2(2000 BYTE) ,
  "DOCUMENT_NAME" VARCHAR2(255 BYTE) ,
  "DOCUMENT_REMARK" VARCHAR2(255 BYTE) ,
  "UPDATE_TIME" DATE ,
  "CREATE_TIME" DATE ,
  "IS_ENABLE" NUMBER(10) 
);
COMMENT ON COLUMN "T_BASE_SUPPLIER_QCM_F"."TEMPLAT_ID" IS '模板ID';
COMMENT ON COLUMN "T_BASE_SUPPLIER_QCM_F"."DOCUMENT_TEXT" IS '储存文件字段';
COMMENT ON COLUMN "T_BASE_SUPPLIER_QCM_F"."DOCUMENT_NAME" IS '文件名称';
COMMENT ON COLUMN "T_BASE_SUPPLIER_QCM_F"."DOCUMENT_REMARK" IS '文件备注';
COMMENT ON COLUMN "T_BASE_SUPPLIER_QCM_F"."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN "T_BASE_SUPPLIER_QCM_F"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_SUPPLIER_QCM_F"."IS_ENABLE" IS '是否可用';
COMMENT ON TABLE "T_BASE_SUPPLIER_QCM_F" IS '资质审核与现场考察模版文件保存表';
ALTER TABLE "T_BASE_SUPPLIER_QCM_F" ADD CONSTRAINT "SYS_C0043056" PRIMARY KEY ("ID");

-- ----------------------------
-- 供应商准入-审核通知单
-- ----------------------------
DROP TABLE "T_BASE_COMPANY_AUDIT_NOTICE";
CREATE TABLE "T_BASE_COMPANY_AUDIT_NOTICE" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 BYTE) ,
  "PUR_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "PUR_COMPANY_NAME" VARCHAR2(255 BYTE) ,
  "PUR_COMPANY_FULL_NAME" VARCHAR2(255 BYTE) ,
  "PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) ,
  "PUR_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "SUP_COMPANY_NAME" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_FULL_NAME" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_ADDRESS" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_CONTACTS" VARCHAR2(255 BYTE) ,
  "SUP_MATERIAL_CODE" VARCHAR2(255 BYTE) ,
  "SUP_MATERIAL_DESC" VARCHAR2(255 BYTE) ,
  "AUDIT_NOTICE_NO" VARCHAR2(32 BYTE) ,
  "AUDIT_TIME" DATE ,
  "AUDIT_STATUS" NUMBER(10) DEFAULT '' ,
  "CREATE_BILL_NAME" VARCHAR2(255 BYTE) ,
  "COMPANY_TYPE" VARCHAR2(255 BYTE) ,
  "AUDIT_INFO" VARCHAR2(255 BYTE) ,
  "AUDIT_INFO_FILE" VARCHAR2(4000 BYTE) ,
  "BILL_TYPE" VARCHAR2(255 BYTE) ,
  "CONFIRM_STATUS" NUMBER(10) DEFAULT 1   ,
  "IS_ENABLE" NUMBER(10) DEFAULT 1   ,
  "CREATE_TIME" DATE ,
  "UPDATE_TIME" DATE ,
  "SEND_STATUS" NUMBER(10) DEFAULT 0   ,
  "INSPECTION_PROJECT_EXPLAIN" VARCHAR2(255 BYTE) ,
  "PUR_USER_ID" VARCHAR2(32 BYTE) ,
  "SUP_USER_ID" VARCHAR2(32 BYTE) ,
  "SUP_REPLY_INFORMATION" VARCHAR2(255 BYTE) 
);
COMMENT ON TABLE "T_BASE_COMPANY_AUDIT_NOTICE" IS '供应商准入-审核通知单';
ALTER TABLE "T_BASE_COMPANY_AUDIT_NOTICE" ADD CONSTRAINT "SYS_C0043068" PRIMARY KEY ("ID");

-- ----------------------------
-- T_BASE_COMPANY_AUTHENTICATION
-- ----------------------------
DROP TABLE "T_BASE_COMPANY_AUTHENTICATION";
CREATE TABLE "T_BASE_COMPANY_AUTHENTICATION" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "PROJECTID" VARCHAR2(32 BYTE) ,
  "CHANGBILLNO" VARCHAR2(255 BYTE) ,
  "CERTIFICATE_NAME" VARCHAR2(255 BYTE) ,
  "CERTIFICATE_BODY" VARCHAR2(255 BYTE) ,
  "APPLY_SCOPE" VARCHAR2(255 BYTE) ,
  "SIGN_DATE" DATE ,
  "EFFECTIVE_DATE" DATE ,
  "UPDATE_DATE" DATE ,
  "ATTACHMENT" VARCHAR2(255 BYTE) ,
  "IS_ENABLE" NUMBER(10) ,
  "MARK" VARCHAR2(255 BYTE) 
);
COMMENT ON COLUMN "T_BASE_COMPANY_AUTHENTICATION"."PROJECTID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTHENTICATION"."CHANGBILLNO" IS '变更单号';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTHENTICATION"."CERTIFICATE_NAME" IS '证书名称';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTHENTICATION"."CERTIFICATE_BODY" IS '认证机构';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTHENTICATION"."APPLY_SCOPE" IS '适用范围';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTHENTICATION"."SIGN_DATE" IS '签发日期';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTHENTICATION"."EFFECTIVE_DATE" IS '有效日期';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTHENTICATION"."UPDATE_DATE" IS '上传日期';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTHENTICATION"."ATTACHMENT" IS '附件上传';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTHENTICATION"."MARK" IS '备注';
ALTER TABLE "T_BASE_COMPANY_AUTHENTICATION" ADD CONSTRAINT "SYS_C0043090" PRIMARY KEY ("ID");

-- ----------------------------
-- T_BASE_COMPANY_CHANGE_DETAILE
-- ----------------------------
DROP TABLE "T_BASE_COMPANY_CHANGE_DETAILE";
CREATE TABLE "T_BASE_COMPANY_CHANGE_DETAILE" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 BYTE) ,
  "CREATE_TIME" DATE ,
  "UPDATE_TIME" DATE ,
  "CHANGE_BILL_NO" VARCHAR2(32 BYTE) ,
  "CHANGE_FIELD" VARCHAR2(255 BYTE) ,
  "CONTENT" VARCHAR2(255 BYTE) ,
  "CHANGE_CONTENT" VARCHAR2(255 BYTE) ,
  "IS_ENABLE" VARCHAR2(255 BYTE) DEFAULT 1   
);
COMMENT ON COLUMN "T_BASE_COMPANY_CHANGE_DETAILE"."CHANGE_BILL_NO" IS '变更单号';
COMMENT ON COLUMN "T_BASE_COMPANY_CHANGE_DETAILE"."CHANGE_FIELD" IS '变更字段';
COMMENT ON COLUMN "T_BASE_COMPANY_CHANGE_DETAILE"."CONTENT" IS '原内容';
COMMENT ON COLUMN "T_BASE_COMPANY_CHANGE_DETAILE"."CHANGE_CONTENT" IS '变更内容';
COMMENT ON COLUMN "T_BASE_COMPANY_CHANGE_DETAILE"."IS_ENABLE" IS '软删除';
ALTER TABLE "T_BASE_COMPANY_CHANGE_DETAILE" ADD CONSTRAINT "SYS_C0043092" PRIMARY KEY ("ID");

-- ----------------------------
-- T_BASE_COMPANY_DATA_CHANGE
-- ----------------------------
DROP TABLE "T_BASE_COMPANY_DATA_CHANGE";
CREATE TABLE "T_BASE_COMPANY_DATA_CHANGE" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 BYTE) ,
  "UPDATE_TIME" DATE ,
  "CHANGE_BILL_NO" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "SUPPLIER_SAP_CODE" VARCHAR2(255 BYTE) ,
  "SUPPLIER_NAME" VARCHAR2(255 BYTE) ,
  "CREATE_BILL_TIME" DATE ,
  "CONFIRM_TIME" DATE ,
  "CONFIRM_BILL_NAME" VARCHAR2(255 BYTE) ,
  "BILL_STATUS" NUMBER(10) ,
  "APPROVE_USER_NAME" VARCHAR2(255 BYTE) ,
  "APPROVE_STATUS" NUMBER(10) ,
  "APPROVE_TIME" DATE ,
  "APPROVE_RESULT" VARCHAR2(255 BYTE) ,
  "CHANG_TYPE" NUMBER(10) DEFAULT 1   ,
  "REMARK" VARCHAR2(255 BYTE) ,
  "IS_ENABLE" VARCHAR2(255 BYTE) DEFAULT 1   
);
COMMENT ON COLUMN "T_BASE_COMPANY_DATA_CHANGE"."CHANGE_BILL_NO" IS '单据编号';
COMMENT ON COLUMN "T_BASE_COMPANY_DATA_CHANGE"."SUP_COMPANY_ID" IS '供应商编号';
COMMENT ON COLUMN "T_BASE_COMPANY_DATA_CHANGE"."SUPPLIER_SAP_CODE" IS '供应商SAP码';
COMMENT ON COLUMN "T_BASE_COMPANY_DATA_CHANGE"."SUPPLIER_NAME" IS '供应商名称';
COMMENT ON COLUMN "T_BASE_COMPANY_DATA_CHANGE"."CREATE_BILL_TIME" IS '制单时间';
COMMENT ON COLUMN "T_BASE_COMPANY_DATA_CHANGE"."CONFIRM_TIME" IS '确认时间';
COMMENT ON COLUMN "T_BASE_COMPANY_DATA_CHANGE"."CONFIRM_BILL_NAME" IS '制单人';
COMMENT ON COLUMN "T_BASE_COMPANY_DATA_CHANGE"."BILL_STATUS" IS '单据状态(0：未回签1：已回签2：已审核3：以驳回4：已作废)';
COMMENT ON COLUMN "T_BASE_COMPANY_DATA_CHANGE"."APPROVE_USER_NAME" IS '审批人';
COMMENT ON COLUMN "T_BASE_COMPANY_DATA_CHANGE"."APPROVE_STATUS" IS '审批状态(0=审核中 1=待审核 2=已审核)';
COMMENT ON COLUMN "T_BASE_COMPANY_DATA_CHANGE"."APPROVE_TIME" IS '审批时间';
COMMENT ON COLUMN "T_BASE_COMPANY_DATA_CHANGE"."APPROVE_RESULT" IS '审批结果';
COMMENT ON COLUMN "T_BASE_COMPANY_DATA_CHANGE"."CHANG_TYPE" IS '审批状态(0=全部，1=基本信息 2=资质认证)';
COMMENT ON COLUMN "T_BASE_COMPANY_DATA_CHANGE"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_COMPANY_DATA_CHANGE"."IS_ENABLE" IS '软删除';
ALTER TABLE "T_BASE_COMPANY_DATA_CHANGE" ADD CONSTRAINT "SYS_C0043094" PRIMARY KEY ("ID");

-- ----------------------------
-- 供应商准入-主要产品/服务
-- ----------------------------
DROP TABLE "T_BASE_COMPANY_PRODUCT_SERVICE";
CREATE TABLE "T_BASE_COMPANY_PRODUCT_SERVICE" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 BYTE) ,
  "PUR_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) ,
  "PUR_COMPANY_NAME" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_NAME" VARCHAR2(255 BYTE) ,
  "PRODUCT_SERVICE_NAME" VARCHAR2(255 BYTE) ,
  "PRODUCT_QUANTITY" NUMBER(20,2) ,
  "SALE_AMOUNT" NUMBER(20,2) ,
  "SALE_PERCENT" NUMBER(20,2) ,
  "SURPLUS_CAPACITY_PERCENT" NUMBER(20,2) ,
  "MP_TIME" VARCHAR2(255 BYTE) ,
  "PURCHASE_CYCLE" VARCHAR2(255 BYTE) ,
  "EXPLAINATION" VARCHAR2(1000 BYTE) ,
  "IS_ENABLE" NUMBER(7) DEFAULT 1   ,
  "FINISH_FLAG" NUMBER(7) DEFAULT 0   ,
  "CREATE_TIME" DATE DEFAULT SYSDATE   ,
  "UPDATE_TIME" DATE ,
  "AGENT_BRAND" VARCHAR2(255 BYTE) ,
  "MONTHLY_CAPACITY" NUMBER(16,3) 
);
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_SERVICE"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_SERVICE"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_SERVICE"."PUR_COMPANY_ID" IS '采购商公司ID';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_SERVICE"."PUR_COMPANY_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_SERVICE"."PUR_COMPANY_NAME" IS '采购商名称';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_SERVICE"."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_SERVICE"."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_SERVICE"."SUP_COMPANY_NAME" IS '供应商名称';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_SERVICE"."PRODUCT_SERVICE_NAME" IS '主要产品/服务名称';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_SERVICE"."PRODUCT_QUANTITY" IS '年生产数量';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_SERVICE"."SALE_AMOUNT" IS '销售额';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_SERVICE"."SALE_PERCENT" IS '该产品/服务占企业总销售额的百分比';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_SERVICE"."SURPLUS_CAPACITY_PERCENT" IS '剩余产能百分比';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_SERVICE"."MP_TIME" IS '产品量产的时间';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_SERVICE"."PURCHASE_CYCLE" IS '正常采购周期';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_SERVICE"."EXPLAINATION" IS '说明';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_SERVICE"."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_SERVICE"."FINISH_FLAG" IS '完成标识符(0=未完成，1=已完成)';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_SERVICE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_SERVICE"."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_SERVICE"."AGENT_BRAND" IS '代理品牌';
COMMENT ON COLUMN "T_BASE_COMPANY_PRODUCT_SERVICE"."MONTHLY_CAPACITY" IS '月产能';
COMMENT ON TABLE "T_BASE_COMPANY_PRODUCT_SERVICE" IS '供应商准入-主要产品/服务';

-- ----------------------------
-- 供应商准入-审核结果通知单
-- ----------------------------
DROP TABLE "T_BASE_COMPANY_RESULT_NOTICE";
CREATE TABLE "T_BASE_COMPANY_RESULT_NOTICE" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 BYTE) ,
  "PUR_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "PUR_COMPANY_NAME" VARCHAR2(255 BYTE) ,
  "PUR_COMPANY_FULL_NAME" VARCHAR2(255 BYTE) ,
  "PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) ,
  "PUR_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "SUP_COMPANY_NAME" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_FULL_NAME" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_ADDRESS" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_CONTACTS" VARCHAR2(255 BYTE) ,
  "AUDIT_RESULT_NOTICE_NO" VARCHAR2(32 BYTE) ,
  "SUP_MATERIAL_CODE" VARCHAR2(255 BYTE) ,
  "SUP_MATERIAL_DESC" VARCHAR2(255 BYTE) ,
  "AUDIT_TIME" DATE ,
  "AUDIT_STATUS" NUMBER(10) DEFAULT 0   ,
  "SEND_STATUS" NUMBER(10) ,
  "CONFIRM_TIME" DATE ,
  "CONFIRM_STATUS" VARCHAR2(255 BYTE) ,
  "IS_ENABLE" NUMBER(10) DEFAULT 1   ,
  "CREATE_TIME" DATE ,
  "UPDATE_TIME" DATE ,
  "CREATE_BILL_NAME" VARCHAR2(255 BYTE) ,
  "COMPANY_TYPE" VARCHAR2(255 BYTE) ,
  "BILL_TYPE" VARCHAR2(255 BYTE) ,
  "RECTIFICATION_TIME" DATE ,
  "RECTIFICATION_FINISH_TIME" DATE ,
  "SCORE" NUMBER(10) ,
  "LEVELEV" VARCHAR2(255 BYTE) ,
  "SCORE_CONCLUSION" VARCHAR2(255 BYTE) ,
  "REMARK" VARCHAR2(255 BYTE) ,
  "PROBLEM_FILE" VARCHAR2(3500 BYTE) ,
  "RECTIFICATION_PLAN_FILE" VARCHAR2(3500 BYTE) ,
  "RED" NUMBER(10) DEFAULT 0   ,
  "YELLOW" NUMBER(10) DEFAULT 0   ,
  "GREEN" NUMBER(10) DEFAULT 0   ,
  "COLOUR_CONCLUSION" VARCHAR2(255 BYTE) ,
  "PUR_USER_ID" VARCHAR2(32 BYTE) ,
  "SUP_USER_ID" VARCHAR2(32 BYTE) ,
  "NOTE" VARCHAR2(255 BYTE) ,
  "SUP_REPLY_INFORMATION" VARCHAR2(255 BYTE) 
);
COMMENT ON TABLE "T_BASE_COMPANY_RESULT_NOTICE" IS '供应商准入-审核结果通知单';
ALTER TABLE "T_BASE_COMPANY_RESULT_NOTICE" ADD CONSTRAINT "SYS_C0043073" PRIMARY KEY ("ID");

