/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.company.command;

import com.alibaba.fastjson.JSON;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.certification.file.entity.CompanyFileExample;
import com.els.base.certification.file.service.CompanyFileService;
import com.els.base.company.entity.BankAccountExample;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.BankAccountService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.SupplierStatusEnum;
import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.file.entity.FileData;
import com.els.base.workflow.common.service.WorkFlowService;
import com.els.sinolifesdk.service.SinoLifeApiService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class CompanyApproveCmd
extends BaseCommand<String> {
    private static final long serialVersionUID = 1L;
    @Resource
    private CompanyService companyService;
    @Resource
    private WorkFlowService workFlowService;
    @Resource
    private SinoLifeApiService sinolifeApiService;
    private List<String> companyCodes;
    @Resource
    private BankAccountService bankAccountService;
    @Resource
    private CompanyFileService companyFileService;
    @Value(value="${sinolife.esb.api.enable:false}")
    private boolean esbApiEnabled;

    @Transactional
    public String execute(ICommandInvoker context) {
        List<Company> companyList = this.checkAndRetrieveCompanys();
        this.process(companyList);
        return null;
    }

    private List<Company> checkAndRetrieveCompanys() {
        if (CollectionUtils.isEmpty(this.companyCodes)) {
            throw new CommonException("companyCodes\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompanyExample example = new CompanyExample();
        example.createCriteria().andCompanyCodeIn(this.companyCodes);
        List tmpList = this.companyService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)tmpList)) {
            throw new CommonException("\u6240\u9009\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728");
        }
        tmpList.forEach(company -> {
            if (!SupplierStatusEnum.POTENIAL.code().equals(company.getSupplierStatusCode()) && !SupplierStatusEnum.NEW.code().equals(company.getSupplierStatusCode())) {
                throw new CommonException("\u53ea\u6709\u6f5c\u5728\u6216\u65b0\u589e\u4f9b\u5e94\u5546\u624d\u80fd\u63d0\u4ea4\u5ba1\u6838");
            }
        });
        return tmpList;
    }

    private void process(List<Company> companyList) {
        User currentUser = SpringSecurityUtils.getLoginUser();
        companyList.forEach(company -> {
            Map result;
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("seq", company.getId());
            paramMap.put("applySource", "3");
            paramMap.put("applyType", StringUtils.isBlank((CharSequence)company.getBepAuditNo()) ? "1" : "2");
            paramMap.put("applyUser", currentUser.getEmail());
            paramMap.put("applyPhone", currentUser.getMobilePhone());
            paramMap.put("applyDate", new Date());
            paramMap.put("applyReason", "");
            paramMap.put("applyUserBranch", company.getInstitutionCode());
            paramMap.put("businessBook", company.getBusinessBook());
            paramMap.put("payeeNo", company.getCompanyCode());
            paramMap.put("payeeName", company.getCompanyFullName());
            paramMap.put("province", company.getProvince());
            paramMap.put("city", company.getCity());
            paramMap.put("corporateCode", company.getCorporateCode());
            paramMap.put("corporateRepresentative", company.getCorporateRepresentative());
            paramMap.put("taxRegistration", company.getTaxCert());
            paramMap.put("contactPhone", company.getTelephone());
            paramMap.put("mobile", company.getMobilephone());
            paramMap.put("contactEmail", company.getEmail());
            paramMap.put("supplierType", Integer.valueOf(1).equals(company.getSupplierType()) ? "1" : "2");
            paramMap.put("industryClass", company.getIndustryCode());
            paramMap.put("supplierContacts", company.getContacts());
            paramMap.put("supplierAddress", company.getAddress());
            paramMap.put("isScan", "N");
            paramMap.put("idType", company.getIdType());
            paramMap.put("idNo", company.getIdNumber());
            paramMap.put("taxpayerType", company.getTaxpayerType());
            paramMap.put("invoiceType", company.getInvoiceType());
            BankAccountExample example1 = new BankAccountExample();
            example1.createCriteria().andCompanyIdEqualTo(company.getId()).andInvalidFlagEqualTo("N");
            Optional.ofNullable(this.bankAccountService.queryAllObjByExample((IExample)example1)).ifPresent(list -> {
                List bankAccountList = list.parallelStream().map(tmp -> {
                    HashMap<String, String> accountInfo = new HashMap<String, String>();
                    accountInfo.put("accountName", tmp.getAccountName());
                    accountInfo.put("accountNo", tmp.getAccountNo());
                    accountInfo.put("accountSeq", tmp.getId());
                    accountInfo.put("accountProvince", tmp.getAccountProvince());
                    accountInfo.put("accountCity", tmp.getAccountCity());
                    accountInfo.put("accountArea", tmp.getAccountArea());
                    accountInfo.put("accountBank", tmp.getAccountBank());
                    accountInfo.put("bankNet", tmp.getBankNet());
                    accountInfo.put("privateFlag", tmp.getPrivateFlag());
                    accountInfo.put("accountType", tmp.getAccountType());
                    accountInfo.put("invalidFlag", tmp.getInvalidFlag());
                    return accountInfo;
                }).collect(Collectors.toList());
                paramMap.put("accountList", bankAccountList);
            });
            LinkedList fileList = new LinkedList();
            CompanyFileExample example2 = new CompanyFileExample();
            example2.createCriteria().andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
            Optional.ofNullable(this.companyFileService.queryAllObjByExample((IExample)example2)).ifPresent(list -> list.stream().filter(tmp -> StringUtils.isNotBlank((CharSequence)tmp.getAttachment())).forEach(tmp -> JSON.parseArray((String)tmp.getAttachment(), FileData.class).forEach(fileData -> {
                HashMap<String, String> fileInfo = new HashMap<String, String>();
                fileInfo.put("fileurl", fileData.getFileUrl());
                fileInfo.put("fileName", fileData.getFileName());
                fileInfo.put("fileSize", Objects.toString(fileData.getFileSize(), null));
                fileList.add(fileInfo);
                Integer.toString(1);
            })));
            paramMap.put("fileList", fileList);
            if (!this.esbApiEnabled) {
                paramMap.put("companyId", company.getId());
                paramMap.put("companyCode", company.getCompanyCode());
                paramMap.put("listenerClass", CompanyService.class);
            }
            if (!"Y".equals((result = this.sinolifeApiService.payeeApprove(paramMap)).get("flag"))) {
                throw new CommonException((String)result.get("message"));
            }
            company.setBepAuditSn((String)result.get("applyNo"));
            company.setBepAuditNo((String)result.get("bepVoucherNo"));
            this.companyService.modifyObj((Serializable)company);
            this.companyService.updateSupplierStatus(company, SupplierStatusEnum.WAIT_FOR_AUDIT);
        });
    }

    public List<String> getCompanyCodes() {
        return this.companyCodes;
    }

    public void setCompanyCodes(List<String> companyCodes) {
        this.companyCodes = companyCodes;
    }
}

