/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.patents.web.controller;

import com.els.base.certification.common.CompanyFinishFlag;
import com.els.base.certification.patents.entity.CompanyPatents;
import com.els.base.certification.patents.entity.CompanyPatentsExample;
import com.els.base.certification.patents.service.CompanyPatentsService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u4f9b\u5e94\u5546\u51c6\u5165-\u4e13\u5229\uff0c\u4e13\u6709\u6280\u672f\uff0c\u8bb8\u53ef"})
@Controller
@RequestMapping(value={"companyPatents"})
public class CompanyPatentsController {
    @Resource
    private CompanyPatentsService companyPatentsService;
    @Resource
    private CompanyService companyService;

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u521b\u5efa\u4e13\u5229\uff0c\u4e13\u6709\u6280\u672f\uff0c\u8bb8\u53ef")
    @RequestMapping(value={"service/batchInsert"})
    @ResponseBody
    public ResponseResult<Map<String, Integer>> batchInsert(@RequestBody List<CompanyPatents> companyPatentsList) {
        Integer patentsStatus = this.companyPatentsService.batchInsert(ProjectUtils.getProjectId(), CompanyUtils.currentCompany(), companyPatentsList);
        CompanyFinishFlag companyFinishFlag = new CompanyFinishFlag();
        companyFinishFlag.setProprietaryTechnology(patentsStatus);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("proprietaryTechnology", patentsStatus);
        return ResponseResult.success(map);
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4e13\u5229\uff0c\u4e13\u6709\u6280\u672f\uff0c\u8bb8\u53ef")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody CompanyPatents companyPatents) {
        if (StringUtils.isBlank((String)companyPatents.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        this.companyPatentsService.modifyObj(companyPatents);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u4e13\u5229\uff0c\u4e13\u6709\u6280\u672f\uff0c\u8bb8\u53ef")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,ids\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.companyPatentsService.deleteObjByIds(ProjectUtils.getProjectId(), CompanyUtils.currentCompany(), ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4e13\u5229\uff0c\u4e13\u6709\u6280\u672f\uff0c\u8bb8\u53ef")
    @ApiImplicitParams(value={@ApiImplicitParam(name="supCompanySrmCode", required=false, value="\u4f9b\u5e94\u5546SRM\u7f16\u7801", paramType="query", dataType="String"), @ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanyPatents", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<CompanyPatents>> findByPage(@RequestParam(required=false) String supCompanySrmCode, @RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) throws IOException {
        CompanyPatentsExample example = new CompanyPatentsExample();
        example.setPageView((PageView<CompanyPatents>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        CompanyPatentsExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isBlank((String)supCompanySrmCode)) {
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andIsEnableEqualTo(Constant.YES_INT);
        } else {
            Company company = this.companyService.queryCompanyByCode(supCompanySrmCode);
            if (company == null) {
                throw new CommonException("\u516c\u53f8\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            }
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
        }
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView pageData = this.companyPatentsService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5168\u90e8\u4e13\u5229\uff0c\u4e13\u6709\u6280\u672f\uff0c\u8bb8\u53ef")
    @ApiImplicitParams(value={@ApiImplicitParam(name="supCompanySrmCode", required=false, value="\u4f9b\u5e94\u5546SRM\u7f16\u7801", paramType="query", dataType="String"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanyPatents", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findAll"})
    @ResponseBody
    public ResponseResult<List<CompanyPatents>> findAll(@RequestParam(required=false) String supCompanySrmCode, @RequestBody(required=false) QueryParamWapper wapper) throws IOException {
        CompanyPatentsExample example = new CompanyPatentsExample();
        example.setOrderByClause("CREATE_TIME DESC");
        CompanyPatentsExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isBlank((String)supCompanySrmCode)) {
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andIsEnableEqualTo(Constant.YES_INT);
        } else {
            Company company = this.companyService.queryCompanyByCode(supCompanySrmCode);
            if (company == null) {
                throw new CommonException("\u516c\u53f8\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            }
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
        }
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        List companyPatentsList = this.companyPatentsService.queryAllObjByExample((IExample)example);
        return ResponseResult.success((Object)companyPatentsList);
    }
}

