/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.production.service.impl;

import com.els.base.certification.production.dao.CompanyProductionMapper;
import com.els.base.certification.production.entity.CompanyProduction;
import com.els.base.certification.production.entity.CompanyProductionExample;
import com.els.base.certification.production.service.CompanyProductionService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCompanyProductionService")
public class CompanyProductionServiceImpl
implements CompanyProductionService {
    @Resource
    protected CompanyProductionMapper companyProductionMapper;

    @CacheEvict(value={"companyProduction"}, allEntries=true)
    public void addObj(CompanyProduction t) {
        this.companyProductionMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"companyProduction"}, allEntries=true)
    public void addAll(List<CompanyProduction> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.companyProductionMapper.insertBatch(list);
    }

    @CacheEvict(value={"companyProduction"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companyProductionMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyProduction"}, allEntries=true)
    public void deleteByExample(CompanyProductionExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.companyProductionMapper.deleteByExample(example);
    }

    @CacheEvict(value={"companyProduction"}, allEntries=true)
    public void modifyObj(CompanyProduction t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.companyProductionMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"companyProduction"}, keyGenerator="redisKeyGenerator")
    public CompanyProduction queryObjById(String id) {
        return this.companyProductionMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"companyProduction"}, keyGenerator="redisKeyGenerator")
    public List<CompanyProduction> queryAllObjByExample(CompanyProductionExample example) {
        return this.companyProductionMapper.selectByExample(example);
    }

    @Cacheable(value={"companyProduction"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanyProduction> queryObjByPage(CompanyProductionExample example) {
        PageView<CompanyProduction> pageView = example.getPageView();
        pageView.setQueryResult(this.companyProductionMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Transactional
    @CacheEvict(value={"companyProduction"}, allEntries=true)
    public Integer batchInsert(String projectId, Company company, List<CompanyProduction> companyProductionList) {
        if (CollectionUtils.isEmpty(companyProductionList)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e"});
        }
        CompanyProductionExample example = new CompanyProductionExample();
        example.createCriteria().andProjectIdEqualTo(projectId).andSupCompanyIdEqualTo(company.getId());
        this.companyProductionMapper.deleteByExample(example);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (CompanyProduction companyProduction : companyProductionList) {
            companyProduction.setId(null);
            companyProduction.setProjectId(projectId);
            companyProduction.setSupCompanyId(company.getId());
            companyProduction.setUpdateTime(new Date());
            if (companyProduction.getCreateTime() == null) {
                companyProduction.setCreateTime(new Date());
            }
            Integer finishFlag = companyProduction.getFinishFlag();
            companyProduction.setFinishFlag(finishFlag);
            this.companyProductionMapper.insertSelective(companyProduction);
            list.add(finishFlag);
        }
        if (list.contains(Constant.NO_INT)) {
            return 0;
        }
        return 1;
    }
}

