/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.quality.service.impl;

import com.els.base.certification.quality.dao.CompanyQualityMapper;
import com.els.base.certification.quality.entity.CompanyQuality;
import com.els.base.certification.quality.entity.CompanyQualityExample;
import com.els.base.certification.quality.service.CompanyQualityService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCompanyQualityService")
public class CompanyQualityServiceImpl
implements CompanyQualityService {
    @Resource
    protected CompanyQualityMapper companyQualityMapper;

    @CacheEvict(value={"companyQuality"}, allEntries=true)
    public void addObj(CompanyQuality t) {
        this.companyQualityMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"companyQuality"}, allEntries=true)
    public void addAll(List<CompanyQuality> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.companyQualityMapper.insertBatch(list);
    }

    @CacheEvict(value={"companyQuality"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companyQualityMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyQuality"}, allEntries=true)
    public void deleteByExample(CompanyQualityExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.companyQualityMapper.deleteByExample(example);
    }

    @CacheEvict(value={"companyQuality"}, allEntries=true)
    public void modifyObj(CompanyQuality t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.companyQualityMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"companyQuality"}, keyGenerator="redisKeyGenerator")
    public CompanyQuality queryObjById(String id) {
        return this.companyQualityMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"companyQuality"}, keyGenerator="redisKeyGenerator")
    public List<CompanyQuality> queryAllObjByExample(CompanyQualityExample example) {
        return this.companyQualityMapper.selectByExample(example);
    }

    @Cacheable(value={"companyQuality"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanyQuality> queryObjByPage(CompanyQualityExample example) {
        PageView<CompanyQuality> pageView = example.getPageView();
        pageView.setQueryResult(this.companyQualityMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"companyQuality"}, allEntries=true)
    @Transactional
    public Integer batchInsert(String projectId, Company currentCompany, List<CompanyQuality> companyQualityList) {
        CompanyQualityExample example = new CompanyQualityExample();
        example.createCriteria().andProjectIdEqualTo(projectId).andSupCompanyIdEqualTo(currentCompany.getId());
        this.companyQualityMapper.deleteByExample(example);
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (CollectionUtils.isNotEmpty(companyQualityList)) {
            for (CompanyQuality companyQuality : companyQualityList) {
                companyQuality.setId(null);
                companyQuality.setProjectId(projectId);
                companyQuality.setSupCompanyId(currentCompany.getId());
                companyQuality.setUpdateTime(new Date());
                if (companyQuality.getCreateTime() == null) {
                    companyQuality.setCreateTime(new Date());
                }
                Integer finishFlag = companyQuality.getFinishFlag();
                companyQuality.setFinishFlag(finishFlag);
                this.companyQualityMapper.insertSelective(companyQuality);
                list.add(finishFlag);
            }
        }
        return list.contains(Constant.NO_INT) || CollectionUtils.isEmpty(companyQualityList) ? 0 : 1;
    }
}

