/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.remind.web.controller;

import com.els.base.certification.remind.entity.RemindInfo;
import com.els.base.certification.remind.entity.RemindInfoExample;
import com.els.base.certification.remind.service.RemindInfoService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u4f9b\u5e94\u5546\u51c6\u5165-\u5230\u671f\u63d0\u9192\u4f9b\u5e94\u5546\u4fe1\u606f"})
@Controller
@RequestMapping(value={"remindInfo"})
public class RemindInfoController {
    @Resource
    protected RemindInfoService remindInfoService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f9b\u5e94\u5546\u51c6\u5165-\u5230\u671f\u63d0\u9192\u4f9b\u5e94\u5546\u4fe1\u606f")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody RemindInfo remindInfo) {
        this.remindInfoService.addObj(remindInfo);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4f9b\u5e94\u5546\u51c6\u5165-\u5230\u671f\u63d0\u9192\u4f9b\u5e94\u5546\u4fe1\u606f")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody RemindInfo remindInfo) {
        Assert.isNotBlank((String)remindInfo.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.remindInfoService.modifyObj(remindInfo);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u4f9b\u5e94\u5546\u51c6\u5165-\u5230\u671f\u63d0\u9192\u4f9b\u5e94\u5546\u4fe1\u606f")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.remindInfoService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u6279\u91cf\u786e\u8ba4\u5355\u636e\u4f9b\u5e94\u5546\u51c6\u5165-\u5230\u671f\u63d0\u9192\u4f9b\u5e94\u5546\u4fe1\u606f")
    @RequestMapping(value={"service/batchByIds"})
    @ResponseBody
    public ResponseResult<String> batchByIds(@RequestBody List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u786e\u8ba4\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.remindInfoService.batchObjByIds(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546\u67e5\u8be2\u4f9b\u5e94\u5546\u51c6\u5165-\u5230\u671f\u63d0\u9192\u4f9b\u5e94\u5546\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 RemindInfo", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/purFindByPage"})
    @ResponseBody
    public ResponseResult<PageView<RemindInfo>> purFindByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        RemindInfoExample example = new RemindInfoExample();
        example.setPageView((PageView<RemindInfo>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME");
        RemindInfoExample.Criteria criteria = example.createCriteria();
        criteria.andEndTimeGreaterThanOrEqualTo(new Date());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.remindInfoService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u67e5\u8be2\u4f9b\u5e94\u5546\u51c6\u5165-\u5230\u671f\u63d0\u9192\u4f9b\u5e94\u5546\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 RemindInfo", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/supFindByPage"})
    @ResponseBody
    public ResponseResult<PageView<RemindInfo>> supFindByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        RemindInfoExample example = new RemindInfoExample();
        example.setPageView((PageView<RemindInfo>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME");
        RemindInfoExample.Criteria criteria = example.createCriteria();
        criteria.andEndTimeGreaterThanOrEqualTo(new Date()).andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.remindInfoService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }
}

