/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.Dict;
import com.els.modules.system.mapper.DictMapper;
import com.els.modules.system.model.DuplicateCheckVo;
import com.els.modules.system.service.CheckService;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class CheckServiceImpl
implements CheckService {
    @Resource
    private DictMapper dictMapper;

    @Override
    public String checkExist(String dataId, String tableName, String fieldName, String fieldValue) {
        Long num;
        DuplicateCheckVo duplicateCheckVo = new DuplicateCheckVo();
        duplicateCheckVo.setDataId(dataId);
        duplicateCheckVo.setTableName(tableName);
        duplicateCheckVo.setFieldName(fieldName);
        duplicateCheckVo.setFieldVal(fieldValue);
        duplicateCheckVo.setElsAccount(TenantContext.getTenant());
        if (StringUtils.isNotBlank((String)dataId)) {
            if (fieldName.contains(",")) {
                duplicateCheckVo.setFieldNames(Arrays.asList(fieldName.split(",")));
                num = this.dictMapper.duplicateCheckCountSqlMultiField(duplicateCheckVo);
            } else {
                num = this.dictMapper.duplicateCheckCountSql(duplicateCheckVo);
            }
        } else if (fieldName.contains(",")) {
            duplicateCheckVo.setFieldNames(Arrays.asList(fieldName.split(",")));
            num = this.dictMapper.duplicateCheckCountSqlNoDataIdMultiField(duplicateCheckVo);
        } else {
            num = this.dictMapper.duplicateCheckCountSqlNoDataId(duplicateCheckVo);
        }
        if (num == null || num == 0L) {
            return "success";
        }
        return "\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u4fdd\u5b58\uff01";
    }

    @Override
    public String checkDelete(String tableNames, String fieldName, String fieldValue) {
        DuplicateCheckVo duplicateCheckVo = new DuplicateCheckVo();
        duplicateCheckVo.setTableNames(Arrays.asList(tableNames.split(",")));
        duplicateCheckVo.setFieldName(fieldName);
        duplicateCheckVo.setFieldVal(fieldValue);
        Long num = 0L;
        num = this.dictMapper.deleteCheckCountSql(duplicateCheckVo);
        if (num == null || num == 0L) {
            return "success";
        }
        return "\u7cfb\u7edf\u4e2d\u5b58\u5728\u5173\u8054\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01";
    }

    @Override
    public String checkDeleteBatch(String tableNames, String fieldName, List<String> fieldValue) {
        for (String val : fieldValue) {
            String result = this.checkDelete(tableNames, fieldName, val);
            if ("success".equals(result)) continue;
            return result;
        }
        return "success";
    }

    @Override
    public String checkExist(DuplicateCheckVo checkVo, String elsAccount) {
        Dict dict = this.dictMapper.queryDictByCode(checkVo.getFieldVal(), elsAccount);
        if (dict != null && (dict.getDeleted() != null && dict.getDeleted() == 0 || dict.getDeleted() == null)) {
            if (StringUtils.isNotBlank((String)checkVo.getDataId()) && checkVo.getDataId().equals(dict.getId())) {
                return "success";
            }
            return "\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u4fdd\u5b58\uff01";
        }
        if (dict != null && dict.getDeleted() != null && dict.getDeleted() == 1) {
            return "\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4e3a\u8f6f\u5220\u9664\u72b6\u6001\uff0c\u53ef\u524d\u5f80\u6062\u590d\uff01";
        }
        return "success";
    }
}

