/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.exception.ELSBootException;
import com.els.modules.system.entity.ElsSystemBusinessRule;
import com.els.modules.system.mapper.ElsSystemBusinessRuleMapper;
import com.els.modules.system.service.ElsSystemBusinessRuleService;
import com.els.modules.system.util.I18nUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class ElsSystemBusinessRuleServiceImpl
extends ServiceImpl<ElsSystemBusinessRuleMapper, ElsSystemBusinessRule>
implements ElsSystemBusinessRuleService {
    @Override
    public void saveElsSystemBusinessRule(ElsSystemBusinessRule elsSystemBusinessRule) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("business_type", elsSystemBusinessRule.getBusinessType());
        queryMap.put("item_code", elsSystemBusinessRule.getItemCode());
        List businessRules = ((ElsSystemBusinessRuleMapper)this.baseMapper).selectByMap(queryMap);
        if (!businessRules.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate("i18n_alert_same_elsSystemBusinessRule", "\u5df2\u7ecf\u5b58\u5728\u8be5\u4e1a\u52a1\u89c4\u5219\u7f16\u7801\uff01"));
        }
        ((ElsSystemBusinessRuleMapper)this.baseMapper).insert(elsSystemBusinessRule);
    }

    @Override
    public void updateElsSystemBusinessRule(ElsSystemBusinessRule elsSystemBusinessRule) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("business_type", elsSystemBusinessRule.getBusinessType());
        queryMap.put("item_code", elsSystemBusinessRule.getItemCode());
        List businessRules = ((ElsSystemBusinessRuleMapper)this.baseMapper).selectByMap(queryMap);
        ElsSystemBusinessRule businessRule = (ElsSystemBusinessRule)((ElsSystemBusinessRuleMapper)this.baseMapper).selectById((Serializable)((Object)elsSystemBusinessRule.getId()));
        List rules = businessRules.stream().filter(o -> o.getBusinessType().equals(businessRule.getBusinessType()) && o.getItemCode().equals(businessRule.getItemCode())).collect(Collectors.toList());
        if (!rules.isEmpty() && rules.size() == 1) {
            ((ElsSystemBusinessRuleMapper)this.baseMapper).updateById(elsSystemBusinessRule);
            return;
        }
        if (rules.isEmpty() && businessRules.isEmpty()) {
            ((ElsSystemBusinessRuleMapper)this.baseMapper).updateById(elsSystemBusinessRule);
            return;
        }
        throw new ELSBootException(I18nUtil.translate("i18n_alert_same_elsSystemBusinessRule", "\u5df2\u7ecf\u5b58\u5728\u8be5\u4e1a\u52a1\u89c4\u5219\u7f16\u7801\uff01"));
    }

    @Override
    public void delElsSystemBusinessRule(String id) {
        ((ElsSystemBusinessRuleMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchElsSystemBusinessRule(List<String> idList) {
        ((ElsSystemBusinessRuleMapper)this.baseMapper).deleteBatchIds(idList);
    }
}

