/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import com.alibaba.excel.write.handler.SheetWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.DictModel;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SqlInjectionUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ExcelDetail;
import com.els.modules.system.enums.ExcelDataTypeEnum;
import com.els.modules.system.service.DictService;
import com.els.modules.system.service.impl.DictServiceImpl;
import com.els.modules.system.util.I18nUtil;
import java.util.List;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;

public class ExcelDictWriteHandler
implements SheetWriteHandler {
    private List<ExcelDetail> detailList;
    private DictService sysDictService;

    public ExcelDictWriteHandler(List<ExcelDetail> detailList) {
        this.detailList = detailList;
        this.sysDictService = SpringContextUtils.getBean(DictServiceImpl.class);
    }

    public void beforeSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void afterSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
        Sheet sheet = writeSheetHolder.getSheet();
        DataValidationHelper helper = sheet.getDataValidationHelper();
        int hiddenIndex = 1;
        for (ExcelDetail detail : this.detailList) {
            int index = detail.getColumnIndex() - 1;
            if (!ExcelDataTypeEnum.DICT.getCode().equals(detail.getDataType())) continue;
            List<DictModel> dictList = null;
            String dictCode = detail.getDataFormat();
            if (dictCode.contains("#") || dictCode.contains(",")) {
                String[] params = null;
                params = dictCode.contains("#") ? dictCode.split("#") : dictCode.split(",");
                if (params.length < 3) {
                    throw new ELSBootException(I18nUtil.translate("", "\u5b57\u5178Code\u683c\u5f0f\u4e0d\u6b63\u786e"));
                }
                String[] sqlInjCheck = new String[]{params[0], params[1], params[2]};
                SqlInjectionUtil.filterContent(sqlInjCheck);
                if (params.length != 4) throw new ELSBootException(I18nUtil.translate("", "\u5b57\u5178\u4e0d\u5339\u914d"));
                String filterSql = params[3];
                SqlInjectionUtil.filterContent(filterSql);
                dictList = this.sysDictService.queryTableDictListByFilterSql(TenantContext.getTenant(), params[0], params[1], params[2], filterSql);
            } else {
                dictList = this.sysDictService.queryDictItemsByCode(detail.getDataFormat(), TenantContext.getTenant());
            }
            if (dictList.size() <= 0) continue;
            String[] values = new String[dictList.size()];
            for (int i = 0; i < dictList.size(); ++i) {
                values[i] = dictList.get(i).getText();
            }
            String hiddenSheet = "selectTypeList_" + hiddenIndex++;
            this.generateListSheet(writeWorkbookHolder, hiddenSheet, values, 2, index);
            DataValidation sheetDataValidation = this.buildSheetDataValidation(helper, hiddenSheet, 2, 10000, index, index);
            writeWorkbookHolder.getWorkbook().setSheetHidden(Integer.parseInt(hiddenSheet.split("_")[1]), true);
            sheet.addValidationData(sheetDataValidation);
        }
    }

    public DataValidation buildSheetDataValidation(DataValidationHelper helper, String sheetName, int firstRow, int endRow, int firstCol, int endCol) {
        CellRangeAddressList regions = new CellRangeAddressList(firstRow, endRow, firstCol, endCol);
        DataValidationConstraint formulaListConstraint = helper.createFormulaListConstraint(sheetName);
        return helper.createValidation(formulaListConstraint, regions);
    }

    public void generateListSheet(WriteWorkbookHolder holder, String sheetName, String[] typeList, int row, int cell) {
        Workbook wb = holder.getWorkbook();
        Sheet sheet = wb.getSheet(sheetName);
        if (null == sheet) {
            sheet = wb.createSheet(sheetName);
        }
        for (int i = 0; i < typeList.length; ++i) {
            sheet.createRow(row + i).createCell(cell).setCellValue(typeList[i]);
        }
        Name hiddenSheet = wb.getName(sheetName);
        if (null == hiddenSheet) {
            hiddenSheet = wb.createName();
            hiddenSheet.setNameName(sheetName);
        }
        String col = ExcelDictWriteHandler.getCellFormat(cell + 1);
        hiddenSheet.setRefersToFormula(sheetName + "!$" + col + "$2:$" + col + "$" + (typeList.length + 2));
    }

    public static String getCellFormat(int cell) {
        String result = "";
        int multiple = Math.floorDiv(cell, 26);
        result = (char)(cell % 26 + 65 - 1) + result;
        if (multiple == 0) {
            return result;
        }
        return ExcelDictWriteHandler.getCellFormat(multiple) + result;
    }
}

